/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvColumnSelectionListener;
import com.biotechvana.csveditor.model.CsvEditor.CSVEditorSupport;
import com.biotechvana.csveditor.model.CsvEditor.CSVLabelProvider;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnAdd;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CSVEditorCreateNewColumnRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private String[] headers;
    private int insertionIndex;
    private boolean fillColumn;
    private boolean addAction;
    private List<String> row;
    private TableViewerColumn col;
    private Shell shell;
    private Display display;
    private String[] previousColumnNames;
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private int stepSize = 1000;

    public CSVEditorCreateNewColumnRunnable(CSVEditor csvEditor, List<String> headers, int insertionIndex, boolean fillColumn, boolean addAction) {
        this.csvEditor = csvEditor;
        this.headers = headers.toArray(new String[headers.size()]);
        this.insertionIndex = insertionIndex;
        this.fillColumn = fillColumn;
        this.addAction = addAction;
        this.shell = csvEditor.getSite().getShell();
        this.display = this.shell.getDisplay();
    }

    public CSVEditorCreateNewColumnRunnable(CSVEditor csvEditor, String[] headers, int insertionIndex, boolean fillColumn, boolean addAction) {
        this.csvEditor = csvEditor;
        this.headers = headers;
        this.insertionIndex = insertionIndex;
        this.fillColumn = fillColumn;
        this.addAction = addAction;
        this.shell = csvEditor.getSite().getShell();
        this.display = this.shell.getDisplay();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            if (this.fillColumn) {
                ArrayList model = (ArrayList)this.csvEditor.getModel();
                monitor.beginTask("Create new column", this.headers.length * model.size());
            } else {
                monitor.beginTask("Create new column", this.headers.length);
            }
            int createdRows = 0;
            int i = 0;
            while (i < this.headers.length) {
                this.createColumn(this.headers[i], this.insertionIndex + i, monitor);
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CSVEditorCreateNewColumnRunnable.this.csvEditor.getTableViewer().setLabelProvider((IBaseLabelProvider)new CSVLabelProvider());
                    }
                });
                createdRows = this.fillColumn(this.insertionIndex + i, "", createdRows, monitor);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void createColumn(String header, final int index, IProgressMonitor monitor) throws InterruptedException {
        boolean exists = false;
        long timestamp = System.currentTimeMillis();
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                CSVEditorCreateNewColumnRunnable.this.col = new TableViewerColumn(CSVEditorCreateNewColumnRunnable.this.csvEditor.getTableViewer(), 0, index);
            }
        });
        monitor.subTask("Creating column '" + (String)header + "'");
        this.csvEditor.getListTableViewerColumns().add(this.col);
        if (((String)header).equalsIgnoreCase("Select")) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    CSVEditorCreateNewColumnRunnable.this.col.getColumn().setWidth(24);
                    CSVEditorCreateNewColumnRunnable.this.col.getColumn().setMoveable(false);
                    CSVEditorCreateNewColumnRunnable.this.col.getColumn().setResizable(false);
                    CSVEditorCreateNewColumnRunnable.this.col.getColumn().setImage(SharedImages.CHECKDISABLED);
                    CSVEditorCreateNewColumnRunnable.this.col.setEditingSupport((EditingSupport)new CSVEditorSupport(CSVEditorCreateNewColumnRunnable.this.csvEditor, 0));
                }
            });
        } else if (((String)header).equalsIgnoreCase("#")) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    CSVEditorCreateNewColumnRunnable.this.col.getColumn().setText("#");
                    CSVEditorCreateNewColumnRunnable.this.col.getColumn().setWidth(60);
                    CSVEditorCreateNewColumnRunnable.this.col.getColumn().setMoveable(false);
                }
            });
        } else {
            if (this.csvEditor.isHeadersOn()) {
                if (((String)header).isEmpty()) {
                    this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CSVEditorCreateNewColumnRunnable.this.col.getColumn().setText("");
                        }
                    });
                } else {
                    this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CSVEditorCreateNewColumnRunnable.this.previousColumnNames = CSVEditorCreateNewColumnRunnable.this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false);
                        }
                    });
                    String[] stringArray = this.previousColumnNames;
                    int n = this.previousColumnNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (s.equals(header)) {
                            exists = true;
                        }
                        ++n2;
                    }
                    if (exists) {
                        fHeader = header;
                        this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                CSVEditorCreateNewColumnRunnable.this.col.getColumn().setText(fHeader + "#");
                            }
                        });
                        header = (String)header + "#";
                    } else {
                        fHeader = header;
                        this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                CSVEditorCreateNewColumnRunnable.this.col.getColumn().setText(fHeader);
                            }
                        });
                    }
                }
            } else {
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CSVEditorCreateNewColumnRunnable.this.col.getColumn().setText(" ");
                    }
                });
            }
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    CSVEditorCreateNewColumnRunnable.this.col.getColumn().setImage(SharedImages.CHECKDISABLED);
                    CSVEditorCreateNewColumnRunnable.this.col.getColumn().setWidth(100);
                    CSVEditorCreateNewColumnRunnable.this.col.getColumn().setResizable(true);
                    CSVEditorCreateNewColumnRunnable.this.col.getColumn().setMoveable(true);
                    CSVEditorCreateNewColumnRunnable.this.csvEditor.getSite().setSelectionProvider((ISelectionProvider)CSVEditorCreateNewColumnRunnable.this.csvEditor.getTableViewer());
                    CSVEditorCreateNewColumnRunnable.this.col.setEditingSupport((EditingSupport)new CSVEditorSupport(CSVEditorCreateNewColumnRunnable.this.csvEditor, index));
                    CsvColumnSelectionListener columnSelectionListener = new CsvColumnSelectionListener(CSVEditorCreateNewColumnRunnable.this.csvEditor, CSVEditorCreateNewColumnRunnable.this.col, index);
                    CSVEditorCreateNewColumnRunnable.this.col.getColumn().addSelectionListener((SelectionListener)columnSelectionListener);
                    CSVEditorCreateNewColumnRunnable.this.csvEditor.getListColumnListeners().add(columnSelectionListener);
                }
            });
        }
        if (this.addAction) {
            this.csvEditor.getListActions().add(new CsvActionColumnAdd(index, timestamp));
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private int fillColumn(int index, String fillText, int createdRows, IProgressMonitor monitor) {
        ArrayList model = (ArrayList)this.csvEditor.getModel();
        return createdRows;
    }
}

