/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.goAnnotation;

import com.biotechvana.csveditor.goAnnotation.GOTerm;
import com.biotechvana.csveditor.goAnnotation.GOTermNode;
import com.biotechvana.csveditor.goAnnotation.GOTermNodeConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphModelContentProvider {
    private List<GOTermNodeConnection> connections;
    private List<GOTermNode> nodes = new ArrayList<GOTermNode>();
    private int level;
    private Set<GOTerm> termsSet;
    private Map<String, GOTermNode> termsNodesMap;
    private int sequenceMinimum;
    private double nodeScoreThreshold;

    public GraphModelContentProvider(int level, int sequenceMinimum, double nodeScoreThreshold, Set<GOTerm> termsSet) {
        this.connections = new ArrayList<GOTermNodeConnection>();
        this.level = level;
        this.termsSet = termsSet;
        this.sequenceMinimum = sequenceMinimum;
        this.nodeScoreThreshold = nodeScoreThreshold;
        this.termsNodesMap = new HashMap<String, GOTermNode>();
        for (GOTerm term : termsSet) {
            this.recursiveDepthNodeTraversal(term);
        }
        for (GOTermNodeConnection connection : this.connections) {
            connection.getDestination().getConnectedTo().add(connection.getSource());
        }
    }

    private void recursiveDepthNodeTraversal(GOTerm term) {
        if (this.termsNodesMap.containsKey(term.getAccession())) {
            return;
        }
        if (term.getCumulativeSequenceCount() >= this.sequenceMinimum && term.getNodeScore() >= this.nodeScoreThreshold && term.getDepth() > 0 && term.getDepth() <= this.level) {
            GOTermNode childNode = null;
            childNode = !this.termsSet.contains(term) ? new GOTermNode(term, true) : new GOTermNode(term, false);
            this.nodes.add(childNode);
            this.termsNodesMap.put(term.getAccession(), childNode);
            for (GOTerm parentTerm : term.getParentsSet()) {
                if (parentTerm.getDepth() > term.getDepth()) continue;
                GOTermNode parentNode = null;
                if (!this.termsNodesMap.containsKey(parentTerm.getAccession())) {
                    this.recursiveDepthNodeTraversal(parentTerm);
                }
                parentNode = this.termsNodesMap.get(parentTerm.getAccession());
                this.connections.add(new GOTermNodeConnection("", "", parentNode, childNode));
            }
        }
    }

    public List<GOTermNode> getNodes() {
        return this.nodes;
    }
}

