/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.editors;

import com.biotechvana.csveditor.actions.AddEnzymeCodesByGoAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvAnnotationColorsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvAppendWorksheetAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvAssociateDatabaseAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvCombineWorksheetAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvCurationAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvDeleteCheckedRowsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvDeleteRowColorsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvExportAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvExportCategoriesAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvGenBankDownloadAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvGoSearchAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvMetabolicAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvOpenAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSaveAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSaveAsAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvScoreFilteringAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSearchAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSelectByColorAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSelectByTermAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSelectByValueAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSelectMultipleAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSequenceMergeAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSequenceTrimmerAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvSortAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvUnassociateDatabaseAction;
import com.biotechvana.csveditor.actions.csvEditor.CsvUndoAction;
import com.biotechvana.csveditor.actions.goAnnotation.DisplayGraphAction;
import com.biotechvana.csveditor.actions.goAnnotation.StatisticsByDepthAction;
import com.biotechvana.csveditor.actions.statistics.StatisticsCategoriesAction;
import com.biotechvana.csveditor.actions.statistics.StatisticsNumericalAction;
import com.biotechvana.csveditor.dialogs.csvEditor.AnnotationDialog;
import com.biotechvana.csveditor.editors.CSVEditor;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class CSVEditorToolbar {
    private ToolBar toolBar;
    private ToolItem menuFile;
    private ToolItem menuEdit;
    private ToolItem menuSort;
    private ToolItem menuAnnotation;
    private ToolItem menuSelect;
    private ToolItem menuAssociate;
    private ToolItem menuStatistics;
    private ToolItem menuPostprocessing;
    private ToolItem menuMetrics;
    private ToolItem menuStats;
    private Menu menuFilePopup;
    private Menu menuEditPopup;
    private Menu menuSortPopup;
    private Menu menuAnnotationPopup;
    private Menu menuPopSelect;
    private Menu menuAssociatePopup;
    private Menu menuStatisticsPopup;
    private Menu menuPostprocessingPopup;
    private Menu menuMetricsPopup;
    private Menu menuStatsPopup;
    private final String MENU_FILE = "File";
    private final String MENU_EDIT = "Edit";
    private final String MENU_SORT = "Sorting/Filtering";
    private final String MENU_FILE_IMPORT = "Import";
    private final String MENU_FILE_EXPORT = "Export";
    private final String MENU_ANNOTATION = "Annotation";
    private final String MENU_ANNOTATION_GO_ANNOTATION = "GO analyses";
    private final String MENU_SELECT = "Select";
    private final String MENU_ASSOCIATE = "Associate database";
    private final String MENU_STATISTICS = "Plots";
    private final String MENU_METABOLIC = "Metabolic pathways";
    private final String MENU_POSTPROCESSING = "Postprocessing";
    private final String MENU_METRICS = "Metrics";
    private final String MENU_STATS = "Statistics";
    private Font sysFont;
    private Font fontForMac;
    private Font font;
    private FontData sysFontData;

    public void createCsvEditorToolbar(ToolBar toolbar, final CSVEditor csvEditor) {
        this.toolBar = toolbar;
        this.sysFont = csvEditor.getSite().getShell().getDisplay().getSystemFont();
        this.sysFontData = this.sysFont.getFontData()[0];
        this.fontForMac = new Font((Device)csvEditor.getSite().getShell().getDisplay(), this.sysFontData.getName(), this.sysFontData.getHeight() + 1, this.sysFontData.getStyle());
        this.font = new Font((Device)csvEditor.getSite().getShell().getDisplay(), "SansSerif", 9, 0);
        if (SWT.getPlatform().equals("carbon") || SWT.getPlatform().equals("cocoa")) {
            this.toolBar.setFont(this.fontForMac);
        } else {
            this.toolBar.setFont(this.font);
        }
        FontData[] fontList = csvEditor.getSite().getShell().getDisplay().getFontList(null, true);
        HashSet<String> fontSet = new HashSet<String>();
        FontData[] fontDataArray = fontList;
        int n = fontList.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fontSet.add(fd.getName());
            ++n2;
        }
        Object[] fontNames = fontSet.toArray(new String[fontSet.size()]);
        Arrays.sort(fontNames);
        this.menuFile = new ToolItem(toolbar, 4);
        this.menuFile.setText("File");
        this.menuEdit = new ToolItem(toolbar, 4);
        this.menuEdit.setText("Edit");
        this.menuSort = new ToolItem(toolbar, 4);
        this.menuSort.setText("Sorting/Filtering");
        this.menuAnnotation = new ToolItem(toolbar, 4);
        this.menuAnnotation.setText("Annotation");
        this.menuSelect = new ToolItem(toolbar, 4);
        this.menuSelect.setText("Select");
        this.menuAssociate = new ToolItem(toolbar, 4);
        this.menuAssociate.setText("Associate database");
        this.menuPostprocessing = new ToolItem(toolbar, 4);
        this.menuPostprocessing.setText("Postprocessing");
        this.menuStats = new ToolItem(toolbar, 4);
        this.menuStats.setText("Statistics");
        this.menuFilePopup = new Menu((Decorations)csvEditor.getSite().getShell(), 8);
        this.menuFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle r = CSVEditorToolbar.this.menuFile.getBounds();
                Point p = CSVEditorToolbar.this.toolBar.toDisplay(r.x, r.y + r.height);
                CSVEditorToolbar.this.menuFilePopup.setLocation(p);
                CSVEditorToolbar.this.menuFilePopup.setVisible(true);
            }
        });
        MenuItem menuFilePopupOpen = new MenuItem(this.menuFilePopup, 8);
        menuFilePopupOpen.setText("Open worksheet...");
        menuFilePopupOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvOpenAction(csvEditor).run();
            }
        });
        new MenuItem(this.menuFilePopup, 2);
        MenuItem menuFilePopupSave = new MenuItem(this.menuFilePopup, 8);
        menuFilePopupSave.setText("Save");
        menuFilePopupSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvSaveAction(csvEditor).run();
            }
        });
        MenuItem menuFilePopupSaveAs = new MenuItem(this.menuFilePopup, 8);
        menuFilePopupSaveAs.setText("Save as...");
        menuFilePopupSaveAs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvSaveAsAction(csvEditor).run();
            }
        });
        new MenuItem(this.menuFilePopup, 2);
        MenuItem menuFilePopupImport = new MenuItem(this.menuFilePopup, 64);
        menuFilePopupImport.setText("Import");
        Menu subMenuImport = new Menu(this.menuFilePopup);
        menuFilePopupImport.setMenu(subMenuImport);
        MenuItem menuAppendWorksheet = new MenuItem(subMenuImport, 8);
        menuAppendWorksheet.setText("Append worksheet...");
        menuAppendWorksheet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvAppendWorksheetAction(csvEditor).run();
            }
        });
        MenuItem menuImportCombine = new MenuItem(subMenuImport, 8);
        menuImportCombine.setText("Combine worksheet...");
        menuImportCombine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvCombineWorksheetAction(csvEditor).run();
            }
        });
        MenuItem menuFilePopupExport = new MenuItem(this.menuFilePopup, 64);
        menuFilePopupExport.setText("Export");
        Menu subMenuExport = new Menu(this.menuFilePopup);
        menuFilePopupExport.setMenu(subMenuExport);
        MenuItem menuFilePopupExportCsv = new MenuItem(subMenuExport, 8);
        menuFilePopupExportCsv.setText("Export worksheet and FASTA...");
        menuFilePopupExportCsv.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvExportAction(csvEditor).run();
            }
        });
        MenuItem menuExportCategories = new MenuItem(subMenuExport, 8);
        menuExportCategories.setText("Export categories and clusters...");
        menuExportCategories.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvExportCategoriesAction(csvEditor).run();
            }
        });
        new MenuItem(subMenuExport, 2);
        this.menuEditPopup = new Menu((Decorations)csvEditor.getSite().getShell(), 8);
        this.menuEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle r = CSVEditorToolbar.this.menuEdit.getBounds();
                Point p = CSVEditorToolbar.this.toolBar.toDisplay(r.x, r.y + r.height);
                CSVEditorToolbar.this.menuEditPopup.setLocation(p);
                CSVEditorToolbar.this.menuEditPopup.setVisible(true);
            }
        });
        MenuItem menuEditUndo = new MenuItem(this.menuEditPopup, 8);
        menuEditUndo.setText("Undo");
        menuEditUndo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvUndoAction(csvEditor).run();
            }
        });
        new MenuItem(this.menuEditPopup, 2);
        MenuItem menuEditPopupSearch = new MenuItem(this.menuEditPopup, 8);
        menuEditPopupSearch.setText("Search and replace...");
        menuEditPopupSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvSearchAction(csvEditor).run();
            }
        });
        this.menuSortPopup = new Menu((Decorations)csvEditor.getSite().getShell(), 8);
        this.menuSort.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle r = CSVEditorToolbar.this.menuSort.getBounds();
                Point p = CSVEditorToolbar.this.toolBar.toDisplay(r.x, r.y + r.height);
                CSVEditorToolbar.this.menuSortPopup.setLocation(p);
                CSVEditorToolbar.this.menuSortPopup.setVisible(true);
            }
        });
        MenuItem menuSortSort = new MenuItem(this.menuSortPopup, 8);
        menuSortSort.setText("Sort...");
        menuSortSort.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvSortAction(csvEditor).run();
            }
        });
        MenuItem menuScoreFiltering = new MenuItem(this.menuSortPopup, 8);
        menuScoreFiltering.setText("Filter best isoform or hit");
        menuScoreFiltering.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvScoreFilteringAction(csvEditor).run();
            }
        });
        this.menuAnnotationPopup = new Menu((Decorations)csvEditor.getSite().getShell(), 8);
        this.menuAnnotation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle r = CSVEditorToolbar.this.menuAnnotation.getBounds();
                Point p = CSVEditorToolbar.this.toolBar.toDisplay(r.x, r.y + r.height);
                CSVEditorToolbar.this.menuAnnotationPopup.setLocation(p);
                CSVEditorToolbar.this.menuAnnotationPopup.setVisible(true);
            }
        });
        MenuItem menuFilePopupGenbank = new MenuItem(this.menuAnnotationPopup, 8);
        menuFilePopupGenbank.setText("Download GenBank Accession files");
        menuFilePopupGenbank.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvGenBankDownloadAction(csvEditor).run();
            }
        });
        MenuItem menuAnnotationPopupGOAnnotation = new MenuItem(this.menuAnnotationPopup, 64);
        menuAnnotationPopupGOAnnotation.setText("GO analyses");
        Menu subMenuGOAnnotation = new Menu(this.menuFilePopup);
        menuAnnotationPopupGOAnnotation.setMenu(subMenuGOAnnotation);
        MenuItem menuCategoriesGO = new MenuItem(subMenuGOAnnotation, 8);
        menuCategoriesGO.setText("Add GO terms");
        menuCategoriesGO.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvGoSearchAction(csvEditor).run();
            }
        });
        MenuItem menuEnzymes = new MenuItem(this.menuAnnotationPopup, 8);
        menuEnzymes.setText("Add Enzymes Commission Number");
        menuEnzymes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new AddEnzymeCodesByGoAction(csvEditor).run();
            }
        });
        MenuItem menuTestInterpro = new MenuItem(this.menuAnnotationPopup, 8);
        menuTestInterpro.setText("Add annotations from knowledge databases");
        menuTestInterpro.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnnotationDialog dialog = new AnnotationDialog(csvEditor.getSite().getShell(), csvEditor);
                dialog.open();
                dialog.close();
            }
        });
        MenuItem menuMetabolic = new MenuItem(this.menuAnnotationPopup, 8);
        menuMetabolic.setText("Add Metabolic pathways");
        menuMetabolic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvMetabolicAction(csvEditor).run();
            }
        });
        new MenuItem(this.menuAnnotationPopup, 2);
        MenuItem menuAnnotationColors = new MenuItem(this.menuAnnotationPopup, 8);
        menuAnnotationColors.setText("Coloring annotations...");
        menuAnnotationColors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvAnnotationColorsAction(csvEditor).run();
            }
        });
        MenuItem menuRemoveBackgroundColors = new MenuItem(this.menuAnnotationPopup, 8);
        menuRemoveBackgroundColors.setText("Remove row colors...");
        menuRemoveBackgroundColors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvDeleteRowColorsAction(csvEditor).run();
            }
        });
        this.menuAssociatePopup = new Menu((Decorations)csvEditor.getSite().getShell(), 8);
        this.menuAssociate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle r = CSVEditorToolbar.this.menuAssociate.getBounds();
                Point p = CSVEditorToolbar.this.toolBar.toDisplay(r.x, r.y + r.height);
                CSVEditorToolbar.this.menuAssociatePopup.setLocation(p);
                CSVEditorToolbar.this.menuAssociatePopup.setVisible(true);
            }
        });
        MenuItem menuAssociateAssociate = new MenuItem(this.menuAssociatePopup, 8);
        menuAssociateAssociate.setText("Link sequence database");
        menuAssociateAssociate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvAssociateDatabaseAction(csvEditor).run();
            }
        });
        MenuItem menuAssociateUnassociate = new MenuItem(this.menuAssociatePopup, 8);
        menuAssociateUnassociate.setText("Unlink database");
        menuAssociateUnassociate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvUnassociateDatabaseAction(csvEditor).run();
            }
        });
        this.menuPopSelect = new Menu((Decorations)csvEditor.getSite().getShell(), 8);
        this.menuSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle r = CSVEditorToolbar.this.menuSelect.getBounds();
                Point p = CSVEditorToolbar.this.toolBar.toDisplay(r.x, r.y + r.height);
                CSVEditorToolbar.this.menuPopSelect.setLocation(p);
                CSVEditorToolbar.this.menuPopSelect.setVisible(true);
            }
        });
        MenuItem menuPopSelectTerms = new MenuItem(this.menuPopSelect, 8);
        menuPopSelectTerms.setText("Select by key terms...");
        menuPopSelectTerms.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvSelectByTermAction(csvEditor).run();
            }
        });
        MenuItem menuPopSelectExpect = new MenuItem(this.menuPopSelect, 8);
        menuPopSelectExpect.setText("Select by expect or statistics...");
        menuPopSelectExpect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvSelectByValueAction(csvEditor).run();
            }
        });
        MenuItem menuPopSelectColor = new MenuItem(this.menuPopSelect, 8);
        menuPopSelectColor.setText("Select by color...");
        menuPopSelectColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvSelectByColorAction(csvEditor).run();
            }
        });
        MenuItem menuPopSelectMultiple = new MenuItem(this.menuPopSelect, 8);
        menuPopSelectMultiple.setText("Select by multiple criteria...");
        menuPopSelectMultiple.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvSelectMultipleAction(csvEditor).run();
            }
        });
        new MenuItem(this.menuPopSelect, 2);
        MenuItem menuPopSelectRemove = new MenuItem(this.menuPopSelect, 8);
        menuPopSelectRemove.setText("Delete checked rows...");
        menuPopSelectRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvDeleteCheckedRowsAction(csvEditor).run();
            }
        });
        this.menuStatsPopup = new Menu((Decorations)csvEditor.getSite().getShell(), 8);
        this.menuStats.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle r = CSVEditorToolbar.this.menuStats.getBounds();
                Point p = CSVEditorToolbar.this.toolBar.toDisplay(r.x, r.y + r.height);
                CSVEditorToolbar.this.menuStatsPopup.setLocation(p);
                CSVEditorToolbar.this.menuStatsPopup.setVisible(true);
            }
        });
        MenuItem subMenuStatsPlots = new MenuItem(this.menuStatsPopup, 64);
        subMenuStatsPlots.setText("Plots");
        Menu menuStatsPlotsSubmenu = new Menu(subMenuStatsPlots);
        subMenuStatsPlots.setMenu(menuStatsPlotsSubmenu);
        MenuItem menuStatsPlotsSubmenuNumerical = new MenuItem(menuStatsPlotsSubmenu, 8);
        menuStatsPlotsSubmenuNumerical.setText("Numerical data plots");
        menuStatsPlotsSubmenuNumerical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new StatisticsNumericalAction(csvEditor).run();
            }
        });
        MenuItem menuStatsPlotsSubmenuCategorical = new MenuItem(menuStatsPlotsSubmenu, 8);
        menuStatsPlotsSubmenuCategorical.setText("Categorical data plots");
        menuStatsPlotsSubmenuCategorical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new StatisticsCategoriesAction(csvEditor).run();
            }
        });
        MenuItem subMenuStatsGo = new MenuItem(this.menuStatsPopup, 64);
        subMenuStatsGo.setText("GO analyses");
        Menu menuStatsGoSubmenu = new Menu(subMenuStatsGo);
        subMenuStatsGo.setMenu(menuStatsGoSubmenu);
        MenuItem menuStatsGoSubmenuGraph = new MenuItem(menuStatsGoSubmenu, 8);
        menuStatsGoSubmenuGraph.setText("Display graph");
        menuStatsGoSubmenuGraph.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new DisplayGraphAction(csvEditor).run();
            }
        });
        MenuItem menuStatsGoSubmenuDistribution = new MenuItem(menuStatsGoSubmenu, 8);
        menuStatsGoSubmenuDistribution.setText("GO distributions");
        menuStatsGoSubmenuDistribution.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new StatisticsByDepthAction(csvEditor).run();
            }
        });
        this.menuPostprocessingPopup = new Menu((Decorations)csvEditor.getSite().getShell(), 8);
        this.menuPostprocessing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle r = CSVEditorToolbar.this.menuPostprocessing.getBounds();
                Point p = CSVEditorToolbar.this.toolBar.toDisplay(r.x, r.y + r.height);
                CSVEditorToolbar.this.menuPostprocessingPopup.setLocation(p);
                CSVEditorToolbar.this.menuPostprocessingPopup.setVisible(true);
            }
        });
        MenuItem menuPosprocessingEdit = new MenuItem(this.menuPostprocessingPopup, 8);
        menuPosprocessingEdit.setText("Editing sequences...");
        menuPosprocessingEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvSequenceTrimmerAction(csvEditor).run();
            }
        });
        MenuItem menuPosprocessingMerge = new MenuItem(this.menuPostprocessingPopup, 8);
        menuPosprocessingMerge.setText("Merging sequences by common subject...");
        menuPosprocessingMerge.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvSequenceMergeAction(csvEditor).run();
            }
        });
        MenuItem menuPosprocessingCuration = new MenuItem(this.menuPostprocessingPopup, 8);
        menuPosprocessingCuration.setText("Curate Annotations");
        menuPosprocessingCuration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new CsvCurationAction(csvEditor).run();
            }
        });
    }
}

