/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.taxonomy;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.taxonomy.SearchGoHTTPRunnable2;
import com.biotechvana.e3utils.MultiFileInput;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TaxonomyGOSearchDialog
extends TitleAreaDialog {
    private final String TITLE = "Append GO terms";
    private CSVEditor csvEditor;
    private Combo comboAccession;
    private Combo comboDescription;
    private Button buttonAccession;
    private Button buttonDescription;
    private MultiFileInput inputBrowser;

    public TaxonomyGOSearchDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    public void create() {
        super.create();
        this.getShell().setText("Annotation");
        this.setTitle("Append GO terms");
        this.setMessage("Append GO terms to current worksheet");
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        this.inputBrowser = new MultiFileInput(composite, 0, this.csvEditor.getCsvFile());
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment(0, 0);
        layoutData.left = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        this.inputBrowser.setLayoutData((Object)layoutData);
        Group groupColumns = this.createInputColumnsComposite(composite);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.inputBrowser, 20);
        layoutData.left = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        groupColumns.setLayoutData((Object)layoutData);
        return compositeParent;
    }

    private Group createInputColumnsComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Data columns");
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        group.setLayout((Layout)layout);
        this.buttonAccession = new Button((Composite)group, 32);
        this.buttonAccession.setText("Accession:");
        this.buttonAccession.setSelection(false);
        this.buttonAccession.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboAccession = new Combo((Composite)group, 2056);
        this.comboAccession.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false));
        this.comboAccession.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        int[] index = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Accession"});
        if (index != null && index.length > 0) {
            this.comboAccession.select(index[0] - 2);
        }
        ((GridData)this.comboAccession.getLayoutData()).widthHint = 400;
        this.buttonDescription = new Button((Composite)group, 32);
        this.buttonDescription.setText("Description:");
        this.buttonDescription.setSelection(false);
        this.buttonDescription.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboDescription = new Combo((Composite)group, 2056);
        this.comboDescription.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false));
        this.comboDescription.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        index = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(new String[]{"Subject mapping"});
        if (index != null && index.length > 0) {
            this.comboDescription.select(index[0] - 2);
        }
        ((GridData)this.comboDescription.getLayoutData()).widthHint = 400;
        return group;
    }

    protected void okPressed() {
        if (!this.validate()) {
            return;
        }
        int columnCount = this.csvEditor.getColumnCount();
        int columnGi = -1;
        int columnAccession = -1;
        int columnSubject = -1;
        if (this.buttonAccession.getSelection()) {
            columnAccession = this.comboAccession.getSelectionIndex();
        }
        if (this.buttonDescription.getSelection()) {
            columnSubject = this.comboDescription.getSelectionIndex();
        }
        File[] inputFiles = this.inputBrowser.getInputFileList();
        SearchGoHTTPRunnable2 runnable = new SearchGoHTTPRunnable2(inputFiles, new File(this.inputBrowser.getOutputPath()), columnCount, columnGi, columnAccession, columnSubject, this.csvEditor.getRowCount());
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Append GO terms", (String)"Connection with server was lost. Please, try again.");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.okPressed();
    }

    private boolean validate() {
        this.setErrorMessage(null);
        if (!this.validateInput()) {
            return false;
        }
        if (!this.validateColumns()) {
            return false;
        }
        if (!this.validateOutput()) {
            return false;
        }
        this.getButton(0).setEnabled(true);
        return true;
    }

    private boolean validateInput() {
        if (this.inputBrowser.getInputPath() == null || this.inputBrowser.getInputPath().isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Append GO terms", (String)"Input file cannot be empty");
            return false;
        }
        return true;
    }

    private boolean validateOutput() {
        if (this.inputBrowser.getOutputPath() == null || this.inputBrowser.getOutputPath().isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Append GO terms", (String)"Output folder cannot be empty");
            return false;
        }
        return true;
    }

    private boolean validateColumns() {
        if (!this.buttonAccession.getSelection() && !this.buttonDescription.getSelection()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Append GO terms", (String)"Select one data column at least");
            return false;
        }
        return true;
    }
}

