/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.statistics;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.StatisticsModel;
import com.biotechvana.csveditor.views.StatsView;
import com.biotechvana.e3utils.WorkspaceUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;

public class StatisticsDistributionDialog
extends TitleAreaDialog {
    public static final String TITLE = "Append Statistics data to current worksheet";
    public static String[] SMOOTHFACTOR = new String[]{"Auto", "1", "2", "5", "10", "15", "20"};
    private org.eclipse.swt.widgets.List listColumns;
    private Button buttonLogEvalue;
    private Button buttonSimpleDistribution;
    private Button buttonColor;
    private CSVEditor csvEditor;
    private RGB rgbRow;
    private Label labelColor;
    private double smooth = 2.0;
    private StatsView statsView;
    private Button buttonTypePie;
    private Button buttonTypeBarplot;
    private Button buttonLayoutHorizontal;
    private Button buttonLayoutVertical;
    private Button buttonDimensions2D;
    private Button buttonDimensions3D;

    public StatisticsDistributionDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    public void create() {
        super.create();
        this.setTitle(TITLE);
        this.setMessage(TITLE);
        this.getButton(0).setEnabled(true);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Statistics");
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText("Select data columns.");
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment(0, 0);
        layoutData.left = new FormAttachment(0, 0);
        label.setLayoutData((Object)layoutData);
        Label labelName = new Label(composite, 0);
        labelName.setText("Data columns: ");
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)label, 10);
        layoutData.left = new FormAttachment(0, 0);
        labelName.setLayoutData((Object)layoutData);
        this.listColumns = new org.eclipse.swt.widgets.List(composite, 2570);
        this.listColumns.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true));
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)labelName, 0, 128);
        layoutData.left = new FormAttachment((Control)labelName, 4);
        layoutData.height = 300;
        layoutData.width = 300;
        this.listColumns.setLayoutData((Object)layoutData);
        Label labelMultiple = new Label(composite, 0);
        labelMultiple.setText("Multiple column selection by Ctrl+click or Cmd+click");
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.listColumns, 4);
        layoutData.left = new FormAttachment((Control)this.listColumns, 0, 16384);
        labelMultiple.setLayoutData((Object)layoutData);
        Group groupShow = this.createShowGroup(composite, 0);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)labelMultiple, 20);
        layoutData.left = new FormAttachment(0, 0);
        layoutData.width = 320;
        groupShow.setLayoutData((Object)layoutData);
        Group compositeColor = this.createContents(composite, 0);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)groupShow, 0, 128);
        layoutData.left = new FormAttachment((Control)groupShow, 20);
        layoutData.bottom = new FormAttachment((Control)groupShow, 0, 1024);
        layoutData.width = 320;
        compositeColor.setLayoutData((Object)layoutData);
        Group compositeType = this.createTypeGroup(composite, 0);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)groupShow, 10);
        layoutData.left = new FormAttachment((Control)groupShow, 0, 16384);
        layoutData.width = 320;
        compositeType.setLayoutData((Object)layoutData);
        Group compositeLayout = this.createLayoutGroup(composite, 0);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)compositeType, 0, 128);
        layoutData.left = new FormAttachment((Control)compositeType, 10);
        layoutData.width = 320;
        compositeLayout.setLayoutData((Object)layoutData);
        Group compositeDimensions = this.createDimensionsGroup(composite, 0);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)compositeType, 10);
        layoutData.left = new FormAttachment((Control)compositeType, 0, 16384);
        layoutData.width = 320;
        compositeDimensions.setLayoutData((Object)layoutData);
        if (this.csvEditor.getColumnIndexForName("e-value") >= 0) {
            String[] comboStrs = this.listColumns.getItems();
            int comboSel = 0;
            int i = 0;
            while (i < comboStrs.length) {
                if (comboStrs[i].contentEquals("Similarity")) {
                    comboSel = i;
                }
                ++i;
            }
            this.listColumns.select(comboSel);
        } else {
            this.buttonSimpleDistribution.setText("Simple distribution");
        }
        this.addListeners();
        return compositeParent;
    }

    private Group createDimensionsGroup(Composite parent, int style) {
        Group group = new Group(parent, style);
        group.setText("Graphic type:");
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        this.buttonDimensions2D = new Button((Composite)group, 16);
        this.buttonDimensions2D.setText("2D");
        this.buttonDimensions2D.setSelection(true);
        this.buttonDimensions2D.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonDimensions3D = new Button((Composite)group, 16);
        this.buttonDimensions3D.setText("3D");
        this.buttonDimensions3D.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        return group;
    }

    private Group createTypeGroup(Composite parent, int style) {
        Group group = new Group(parent, style);
        group.setText("Plot type:");
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        this.buttonTypeBarplot = new Button((Composite)group, 16);
        this.buttonTypeBarplot.setText("Bar");
        this.buttonTypeBarplot.setSelection(true);
        this.buttonTypeBarplot.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonTypePie = new Button((Composite)group, 16);
        this.buttonTypePie.setText("Pie");
        this.buttonTypePie.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        return group;
    }

    private Group createLayoutGroup(Composite parent, int style) {
        Group group = new Group(parent, style);
        group.setText("Layout:");
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        this.buttonLayoutVertical = new Button((Composite)group, 16);
        this.buttonLayoutVertical.setText("Vertical");
        this.buttonLayoutVertical.setSelection(true);
        this.buttonLayoutVertical.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonLayoutHorizontal = new Button((Composite)group, 16);
        this.buttonLayoutHorizontal.setText("Horizontal");
        this.buttonLayoutHorizontal.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        return group;
    }

    private Group createShowGroup(Composite parent, int style) {
        Group group = new Group(parent, style);
        group.setText("Options");
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        this.buttonSimpleDistribution = new Button((Composite)group, 16);
        this.buttonSimpleDistribution.setText("Simple distribution");
        this.buttonSimpleDistribution.setSelection(true);
        this.buttonLogEvalue = new Button((Composite)group, 16);
        this.buttonLogEvalue.setText("Log eValue Distribution");
        this.buttonLogEvalue.setSelection(false);
        return group;
    }

    private Group createContents(Composite parent, int style) {
        final Group composite = new Group(parent, style);
        composite.setText("Graph color");
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        this.buttonColor = new Button((Composite)composite, 8);
        this.buttonColor.setText("Select");
        Color barColor = new Color((Device)composite.getDisplay(), 255, 80, 80);
        this.labelColor = new Label((Composite)composite, 0);
        this.labelColor.setBackground(barColor);
        GridData layoutData = new GridData();
        layoutData.heightHint = 20;
        layoutData.widthHint = 20;
        this.labelColor.setLayoutData((Object)layoutData);
        barColor.dispose();
        this.buttonColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(composite.getShell());
                dlg.setRGB(StatisticsDistributionDialog.this.labelColor.getBackground().getRGB());
                dlg.setText("Graph Color");
                RGB rgb = dlg.open();
                if (rgb != null) {
                    StatisticsDistributionDialog.this.rgbRow = rgb;
                    Color colorImage = new Color((Device)composite.getDisplay(), StatisticsDistributionDialog.this.rgbRow);
                    StatisticsDistributionDialog.this.labelColor.setBackground(colorImage);
                    colorImage.dispose();
                }
            }
        });
        return composite;
    }

    protected void okPressed() {
        IViewPart viewPart = null;
        try {
            viewPart = WorkspaceUtils.showView((String)"com.biotechvana.gydbpro.views.StatsView");
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Statistics", (String)"Cannot find any active worksheet");
            return;
        }
        if (viewPart == null) {
            return;
        }
        this.statsView = (StatsView)viewPart;
        String[] stringArray = this.listColumns.getSelection();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            int alphaIndex = this.csvEditor.getEditorUtils2().hasAlphabeticalValuesInColumn(this.csvEditor.getColumnIndexForName(columnName));
            if (alphaIndex != -1) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Statistics", (String)("Invalid numerical value in row: " + alphaIndex + ". Please, check this value."));
                try {
                    this.csvEditor.getTable().select(alphaIndex);
                    this.csvEditor.getTable().showSelection();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.okPressed();
            }
            if (this.buttonLogEvalue.getSelection()) {
                this.createGraphLog(columnName);
            } else if (this.buttonSimpleDistribution.getSelection()) {
                this.createGraphSimple(columnName);
            }
            ++n2;
        }
        super.okPressed();
    }

    private void createGraphSimple(final String columnName) {
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    StatisticsModel statsModel = new StatisticsModel();
                    int columnStats = StatisticsDistributionDialog.this.csvEditor.getColumnIndexForName(columnName);
                    System.out.println("entra en simple");
                    try {
                        PlotOrientation orientation = PlotOrientation.VERTICAL;
                        if (StatisticsDistributionDialog.this.buttonLayoutHorizontal.getSelection()) {
                            orientation = PlotOrientation.HORIZONTAL;
                        }
                        if (StatisticsDistributionDialog.this.buttonTypeBarplot.getSelection()) {
                            System.out.println("barras");
                            XYDataset xyDataset = statsModel.generateSimpleDistributionDataset((List)StatisticsDistributionDialog.this.csvEditor.getModel(), StatisticsDistributionDialog.this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false)[columnStats - 2], columnStats, StatisticsDistributionDialog.this.smooth, columnName, monitor);
                            StatisticsDistributionDialog.this.statsView.addXYGraph(columnName + " distribution", columnName + " distribution", xyDataset, columnName, "Sequences", orientation, false, true, false, StatisticsDistributionDialog.this.rgbRow);
                        } else {
                            System.out.println("pastel");
                            PieDataset pieDataset = statsModel.generatePieDataset((List)StatisticsDistributionDialog.this.csvEditor.getModel(), columnStats, 10, 0, monitor);
                            StatisticsDistributionDialog.this.statsView.addPieGraph(columnName + " distribution", pieDataset, columnName, true, true, false, StatisticsDistributionDialog.this.buttonDimensions3D.getSelection());
                        }
                    }
                    catch (NumberFormatException ex) {
                        MessageDialog.openWarning((Shell)StatisticsDistributionDialog.this.getShell(), (String)"Numerical statistics", (String)("Number format error in selected column:" + ex.getMessage()));
                        return;
                    }
                    catch (NullPointerException ex) {
                        MessageDialog.openWarning((Shell)StatisticsDistributionDialog.this.getShell(), (String)"Numerical statistics", (String)("Cannot not create statistics tab: " + ex.getMessage()));
                        return;
                    }
                    catch (StatisticsModel.StatisticsTooSmallNumberException e) {
                        MessageDialog.openWarning((Shell)StatisticsDistributionDialog.this.getShell(), (String)"Numerical statistics", (String)"Sorry. You should use log distribution function for these values");
                        return;
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            return;
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void createGraphLog(final String columnName) {
        try {
            try {
                new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        StatisticsModel statsModel = new StatisticsModel();
                        int columnStats = StatisticsDistributionDialog.this.csvEditor.getColumnIndexForName(columnName);
                        System.out.println("Entra en log");
                        XYDataset xyDataset = statsModel.generateEValueDataset((List)StatisticsDistributionDialog.this.csvEditor.getModel(), columnStats, StatisticsDistributionDialog.this.smooth, monitor);
                        if (xyDataset == null) {
                            MessageDialog.openWarning((Shell)StatisticsDistributionDialog.this.getShell(), (String)"Numerical statistics", (String)"Cannot not create dataset for selected column");
                            return;
                        }
                        StatisticsDistributionDialog.this.statsView.addXYGraph(columnName + " distribution", columnName + " distribution", xyDataset, columnName, "Sequences", PlotOrientation.VERTICAL, false, true, false, StatisticsDistributionDialog.this.rgbRow);
                    }
                });
            }
            catch (InvocationTargetException e) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Evalue statistics", (String)"Invalid arguments");
                e.printStackTrace();
                return;
            }
            catch (InterruptedException e) {
                return;
            }
        }
        catch (NumberFormatException ex) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Numerical statistics", (String)("Number format error in selected column:" + ex.getMessage()));
            return;
        }
        catch (NullPointerException ex) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Numerical statistics", (String)"Cannot not create dataset for selected column");
            return;
        }
    }

    private void addListeners() {
        this.listColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsDistributionDialog.this.validate();
            }
        });
    }

    private boolean validate() {
        this.getButton(0).setEnabled(false);
        this.setErrorMessage(null);
        if (this.listColumns.getSelectionIndex() == -1) {
            this.setErrorMessage("Select data column");
            return false;
        }
        this.getButton(0).setEnabled(true);
        return true;
    }

    private String[] getNumericalColumns(CSVEditor csvEditor) {
        String[] columnsMat = csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true);
        if (columnsMat == null) {
            return null;
        }
        ArrayList<String> numericColumnList = new ArrayList<String>();
        int i = 0;
        while (i < columnsMat.length) {
            int columnType;
            int columnModelIndex = csvEditor.getColumnIndexForName(columnsMat[i]);
            if (columnModelIndex != -1 && (columnType = csvEditor.detectDataTypeForColumn(columnModelIndex)) == 1) {
                numericColumnList.add(columnsMat[i]);
            }
            ++i;
        }
        String[] numericalColumns = numericColumnList.toArray(new String[numericColumnList.size()]);
        return numericalColumns;
    }
}

