/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.statistics;

import com.biotechvana.csveditor.dialogs.CustomColorDialog;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.StatisticsModel;
import com.biotechvana.csveditor.views.StatsView;
import com.biotechvana.e3utils.WorkspaceUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;

public class StatisticsCategoryDialog
extends TitleAreaDialog {
    private static final String TITLE = "Categorical statistics";
    public static final String[] CATEGORIES_VALUES = new String[]{"50", "40", "30", "20", "15", "10"};
    public static final String[] GO_CHARTS_OPTIONS = new String[]{"domDistrChart", "splitDomsChart", "annotDistrChart"};
    private Image[] imageArray = CustomColorDialog.imageArray;
    private org.eclipse.swt.widgets.List listColumns;
    private Text textMaxCategories;
    private Button buttonOrientationHorizontal;
    private Button buttonOrientationVertical;
    private Button buttonTypeBar;
    private Button buttonTypePie;
    private Button button2d;
    private Button button3d;
    private Button buttonColor;
    private CSVEditor csvEditor;
    private StatsView statsView;
    private PlotOrientation plotOrientation = PlotOrientation.HORIZONTAL;
    private RGB rgbRow;
    private RGB[] rgbArray = CustomColorDialog.rgbArray;
    private Label labelColor;
    private Label labelSelected;
    private Spinner spinerPercent;

    public StatisticsCategoryDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    public void create() {
        super.create();
        this.setTitle(TITLE);
        this.setMessage("Generate a categorical chart from worksheet data.");
        this.getButton(0).setEnabled(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        this.getShell().setText("Statistics");
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText("Select category column:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        Composite compositeInput = new Composite(composite, 0);
        compositeInput.setLayout((Layout)new GridLayout(2, false));
        Label labelName = new Label(compositeInput, 0);
        labelName.setText("Column: ");
        labelName.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.listColumns = new org.eclipse.swt.widgets.List(compositeInput, 2570);
        this.listColumns.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true));
        this.listColumns.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.listColumns.getLayoutData()).widthHint = 200;
        ((GridData)this.listColumns.getLayoutData()).heightHint = 300;
        Label label2 = new Label(compositeInput, 0);
        label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label2 = new Label(compositeInput, 0);
        label2.setText("Multiple column selection by Ctrl+click or Cmd+click");
        Label labelType = new Label(compositeInput, 0);
        labelType.setText("Max. Categories:");
        labelType.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textMaxCategories = new Text(compositeInput, 2052);
        this.textMaxCategories.setText("10");
        this.textMaxCategories.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.textMaxCategories.getLayoutData()).widthHint = 100;
        Label labelPercent = new Label(compositeInput, 0);
        labelPercent.setText("Top hits or features(%):");
        labelPercent.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.spinerPercent = new Spinner(compositeInput, 2048);
        this.spinerPercent.setValues(0, 0, 100, 0, 1, 10);
        this.spinerPercent.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.spinerPercent.getLayoutData()).widthHint = 100;
        compositeInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Group groupType = this.createTypeGroup(composite, 0);
        groupType.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Group selectTypeGroup = this.selectTypeGroup(composite, 0);
        selectTypeGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Group groupLayout = this.createLayoutGroup(composite, 0);
        groupLayout.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Group compositeColor = this.createContents(composite, 0);
        compositeColor.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addListeners();
        return compositeParent;
    }

    private Group createContents(Composite parent, int style) {
        final Group composite = new Group(parent, style);
        composite.setText("Graph color");
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        this.buttonColor = new Button((Composite)composite, 8);
        this.buttonColor.setText("Select");
        Color barColor = new Color((Device)composite.getDisplay(), 255, 80, 80);
        this.labelColor = new Label((Composite)composite, 0);
        this.labelColor.setBackground(barColor);
        GridData layoutData = new GridData();
        layoutData.heightHint = 20;
        layoutData.widthHint = 20;
        this.labelColor.setLayoutData((Object)layoutData);
        barColor.dispose();
        this.buttonColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(composite.getShell());
                dlg.setRGB(StatisticsCategoryDialog.this.labelColor.getBackground().getRGB());
                dlg.setText("Graph Color");
                RGB rgb = dlg.open();
                if (rgb != null) {
                    StatisticsCategoryDialog.this.rgbRow = rgb;
                    Color colorImage = new Color((Device)composite.getDisplay(), StatisticsCategoryDialog.this.rgbRow);
                    StatisticsCategoryDialog.this.labelColor.setBackground(colorImage);
                    colorImage.dispose();
                }
            }
        });
        return composite;
    }

    private Group createTypeGroup(Composite parent, int style) {
        Group group = new Group(parent, style);
        group.setText("Chart type");
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        this.buttonTypeBar = new Button((Composite)group, 16);
        this.buttonTypeBar.setText("Bar chart");
        this.buttonTypeBar.setSelection(true);
        this.buttonTypePie = new Button((Composite)group, 16);
        this.buttonTypePie.setText("Pie chart");
        return group;
    }

    private Group selectTypeGroup(Composite parent, int style) {
        Group group = new Group(parent, style);
        group.setText("Graphic type");
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        this.button2d = new Button((Composite)group, 16);
        this.button2d.setText("2D graphic");
        this.button2d.setSelection(true);
        this.button3d = new Button((Composite)group, 16);
        this.button3d.setText("3D graphic");
        return group;
    }

    private Group createLayoutGroup(Composite parent, int style) {
        Group group = new Group(parent, style);
        group.setText("Bar chart options");
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        this.buttonOrientationVertical = new Button((Composite)group, 16);
        this.buttonOrientationVertical.setText("Vertical layout");
        this.buttonOrientationVertical.setSelection(false);
        this.buttonOrientationHorizontal = new Button((Composite)group, 16);
        this.buttonOrientationHorizontal.setText("Horizontal layout");
        this.buttonOrientationHorizontal.setSelection(true);
        return group;
    }

    protected void okPressed() {
        String[] outputColumns;
        IViewPart viewPart = null;
        try {
            viewPart = WorkspaceUtils.showView((String)"com.biotechvana.gydbpro.views.StatsView");
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return;
        }
        if (viewPart == null) {
            return;
        }
        this.statsView = (StatsView)viewPart;
        String[] stringArray = outputColumns = this.listColumns.getSelection();
        int n = outputColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String col = stringArray[n2];
            if (col.equals("GO")) {
                try {
                    this.generateGoChart(col);
                }
                catch (NullPointerException ex) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"GO statistics", (String)"Null data");
                    return;
                }
                catch (IndexOutOfBoundsException ex) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"GO statistics", (String)"Error parsing GO values");
                    return;
                }
                catch (InvocationTargetException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"GO statistics", (String)"Error parsing GO values");
                    return;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (col.equals("EC")) {
                try {
                    this.generateEcChart(col);
                }
                catch (NullPointerException ex) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"EC statistics", (String)"Null data");
                    return;
                }
                catch (IndexOutOfBoundsException ex) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"EC statistics", (String)"Error parsing EC values");
                    return;
                }
                catch (PatternSyntaxException ex) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"EC statistics", (String)"Error parsing EC values");
                    return;
                }
                catch (InvocationTargetException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"EC statistics", (String)"Error parsing EC values");
                    return;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (col.indexOf("InterPro") != -1) {
                try {
                    this.generateInterproChart(col);
                }
                catch (NullPointerException ex) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"InterPro statistics", (String)"Null data");
                    return;
                }
                catch (IndexOutOfBoundsException ex) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"InterPro statistics", (String)"Error parsing InterPro values");
                    return;
                }
                catch (PatternSyntaxException ex) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"InterPro statistics", (String)"Error parsing InterPro values");
                    return;
                }
                catch (InvocationTargetException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"InterPro statistics", (String)"Error parsing InterPro values");
                    return;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            try {
                this.generateCategoryChart(col);
            }
            catch (NullPointerException ex) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)"Null data");
                return;
            }
            catch (IndexOutOfBoundsException ex) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)"Error parsing category values");
                return;
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)"Error parsing category values");
                return;
            }
            catch (InterruptedException e) {
                return;
            }
            ++n2;
        }
        super.okPressed();
    }

    private void generateGoChart(final String columnName) throws InvocationTargetException, InterruptedException {
        final StatisticsModel statsModel = new StatisticsModel();
        if (this.buttonTypeBar.getSelection()) {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CategoryDataset[] categoryDataset = statsModel.generateGoBarDataset((List)StatisticsCategoryDialog.this.csvEditor.getModel(), StatisticsCategoryDialog.this.csvEditor.getColumnIndexForName(columnName), Integer.parseInt(StatisticsCategoryDialog.this.textMaxCategories.getText()), Integer.parseInt(StatisticsCategoryDialog.this.spinerPercent.getText()), monitor);
                        if (categoryDataset[0].getColumnCount() == 1 || categoryDataset[1].getColumnCount() == 1 || categoryDataset[2].getColumnCount() == 1) {
                            MessageDialog.openInformation((Shell)StatisticsCategoryDialog.this.getShell(), (String)"Statistics", (String)"Non significant top hits or features are detected");
                        } else {
                            StatisticsCategoryDialog.this.statsView.addBarGraph("GO domains distribution [MF]", "GO domains distribution [MF]", categoryDataset[0], "GO terms", "Sequences", StatisticsCategoryDialog.this.plotOrientation, false, true, false, StatisticsCategoryDialog.this.button3d.getSelection(), StatisticsCategoryDialog.this.rgbRow);
                            StatisticsCategoryDialog.this.statsView.addBarGraph("GO domains distribution [CC]", "GO domains distribution [CC]", categoryDataset[1], "GO terms", "Sequences", StatisticsCategoryDialog.this.plotOrientation, false, true, false, StatisticsCategoryDialog.this.button3d.getSelection(), StatisticsCategoryDialog.this.rgbRow);
                            StatisticsCategoryDialog.this.statsView.addBarGraph("GO domains distribution [BP]", "GO domains distribution [BP]", categoryDataset[2], "GO terms", "Sequences", StatisticsCategoryDialog.this.plotOrientation, false, true, false, StatisticsCategoryDialog.this.button3d.getSelection(), StatisticsCategoryDialog.this.rgbRow);
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CategoryDataset overallDataset = statsModel.generateGoTotalBarDataset((List)StatisticsCategoryDialog.this.csvEditor.getModel(), StatisticsCategoryDialog.this.csvEditor.getColumnIndexForName(columnName), monitor);
                        StatisticsCategoryDialog.this.statsView.addBarGraph("GO domains", "GO domains", overallDataset, "GO terms", "Sequences", StatisticsCategoryDialog.this.plotOrientation, false, true, false, StatisticsCategoryDialog.this.button3d.getSelection(), StatisticsCategoryDialog.this.rgbRow);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        } else {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        PieDataset[] pieDataset = statsModel.generateGoPieDataset((List)StatisticsCategoryDialog.this.csvEditor.getModel(), StatisticsCategoryDialog.this.csvEditor.getColumnIndexForName(columnName), Integer.parseInt(StatisticsCategoryDialog.this.textMaxCategories.getText()), Integer.parseInt(StatisticsCategoryDialog.this.spinerPercent.getText()), monitor);
                        if (pieDataset[0].getItemCount() == 1 || pieDataset[1].getItemCount() == 1 || pieDataset[2].getItemCount() == 1) {
                            MessageDialog.openInformation((Shell)StatisticsCategoryDialog.this.getShell(), (String)"Statistics", (String)"Non significant top hits or features are detected");
                        } else {
                            StatisticsCategoryDialog.this.statsView.addPieGraph("GO domains distribution [MF]", pieDataset[0], "GO domains distribution [MF]", true, true, false, StatisticsCategoryDialog.this.button3d.getSelection());
                            StatisticsCategoryDialog.this.statsView.addPieGraph("GO domains distribution [CC]", pieDataset[1], "GO domains distribution [CC]", true, true, false, StatisticsCategoryDialog.this.button3d.getSelection());
                            StatisticsCategoryDialog.this.statsView.addPieGraph("GO domains distribution [BP]", pieDataset[2], "GO domains distribution [BP]", true, true, false, StatisticsCategoryDialog.this.button3d.getSelection());
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        PieDataset pieOverallDataset = statsModel.generateGoTotalPieDataset((List)StatisticsCategoryDialog.this.csvEditor.getModel(), StatisticsCategoryDialog.this.csvEditor.getColumnIndexForName(columnName), monitor);
                        StatisticsCategoryDialog.this.statsView.addPieGraph("GO domains", pieOverallDataset, "GO domains", true, true, false, StatisticsCategoryDialog.this.button3d.getSelection());
                    }
                    catch (Exception e) {
                        new InvocationTargetException(e);
                    }
                }
            });
        }
    }

    private void generateEcChart(final String columnName) throws InvocationTargetException, InterruptedException {
        final StatisticsModel statsModel = new StatisticsModel();
        if (this.buttonTypeBar.getSelection()) {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CategoryDataset categoryDataset = statsModel.generateECBarDataset((List)StatisticsCategoryDialog.this.csvEditor.getModel(), StatisticsCategoryDialog.this.csvEditor.getColumnIndexForName(columnName), Integer.parseInt(StatisticsCategoryDialog.this.textMaxCategories.getText()), Integer.parseInt(StatisticsCategoryDialog.this.spinerPercent.getText()), monitor);
                    if (categoryDataset.getColumnCount() > 1) {
                        StatisticsCategoryDialog.this.statsView.addBarGraph("Category", "EC distribution", categoryDataset, columnName, "Sequences", StatisticsCategoryDialog.this.plotOrientation, false, true, false, StatisticsCategoryDialog.this.button3d.getSelection(), StatisticsCategoryDialog.this.rgbRow);
                    } else {
                        MessageDialog.openInformation((Shell)StatisticsCategoryDialog.this.getShell(), (String)"Statistics", (String)"Non significant top hits or features are detected");
                    }
                }
            });
        } else {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    PieDataset pieDataset = statsModel.generateECPieDataset((List)StatisticsCategoryDialog.this.csvEditor.getModel(), StatisticsCategoryDialog.this.csvEditor.getColumnIndexForName(columnName), Integer.parseInt(StatisticsCategoryDialog.this.textMaxCategories.getText()), Integer.parseInt(StatisticsCategoryDialog.this.spinerPercent.getText()), monitor);
                    if (pieDataset.getItemCount() > 1) {
                        StatisticsCategoryDialog.this.statsView.addPieGraph("Category", pieDataset, "EC distribution", false, true, false, StatisticsCategoryDialog.this.button3d.getSelection());
                    } else {
                        MessageDialog.openInformation((Shell)StatisticsCategoryDialog.this.getShell(), (String)"Statistics", (String)"Non significant top hits or features are detected");
                    }
                }
            });
        }
    }

    private void generateInterproChart(final String columnName) throws InvocationTargetException, InterruptedException {
        final StatisticsModel statsModel = new StatisticsModel();
        if (this.buttonTypeBar.getSelection()) {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CategoryDataset categoryDataset = statsModel.generateInterproBarDataset((List)StatisticsCategoryDialog.this.csvEditor.getModel(), StatisticsCategoryDialog.this.csvEditor.getColumnIndexForName(columnName), Integer.parseInt(StatisticsCategoryDialog.this.textMaxCategories.getText()), Integer.parseInt(StatisticsCategoryDialog.this.spinerPercent.getText()), monitor);
                        if (categoryDataset.getColumnCount() > 1) {
                            StatisticsCategoryDialog.this.statsView.addBarGraph("Category", "InterPro distribution", categoryDataset, columnName, "Sequences", StatisticsCategoryDialog.this.plotOrientation, false, true, false, StatisticsCategoryDialog.this.button3d.getSelection(), StatisticsCategoryDialog.this.rgbRow);
                        } else {
                            MessageDialog.openInformation((Shell)StatisticsCategoryDialog.this.getShell(), (String)"Statistics", (String)"Non significant top hits or features are detected");
                        }
                    }
                    catch (Exception ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
            });
        } else {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    PieDataset pieDataset = statsModel.generateInterproPieDataset((List)StatisticsCategoryDialog.this.csvEditor.getModel(), StatisticsCategoryDialog.this.csvEditor.getColumnIndexForName(columnName), Integer.parseInt(StatisticsCategoryDialog.this.textMaxCategories.getText()), Integer.parseInt(StatisticsCategoryDialog.this.spinerPercent.getText()), monitor);
                    if (pieDataset.getItemCount() > 1) {
                        StatisticsCategoryDialog.this.statsView.addPieGraph("Category", pieDataset, "InterPro distribution", true, true, false, StatisticsCategoryDialog.this.button3d.getSelection());
                    } else {
                        MessageDialog.openInformation((Shell)StatisticsCategoryDialog.this.getShell(), (String)"Statistics", (String)"Non significant top hits or features are detected");
                    }
                }
            });
        }
    }

    private void generateCategoryChart(final String columnName) throws InvocationTargetException, InterruptedException {
        final StatisticsModel statsModel = new StatisticsModel();
        if (this.buttonTypeBar.getSelection()) {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CategoryDataset categoryDataset = statsModel.generateCategoryDataset((List)StatisticsCategoryDialog.this.csvEditor.getModel(), StatisticsCategoryDialog.this.csvEditor.getColumnIndexForName(columnName), Integer.parseInt(StatisticsCategoryDialog.this.textMaxCategories.getText()), Integer.parseInt(StatisticsCategoryDialog.this.spinerPercent.getText()), monitor);
                    if (categoryDataset.getColumnCount() > 1) {
                        StatisticsCategoryDialog.this.statsView.addBarGraph("Category", columnName + " distribution", categoryDataset, columnName, "Sequences", StatisticsCategoryDialog.this.plotOrientation, false, true, false, StatisticsCategoryDialog.this.button3d.getSelection(), StatisticsCategoryDialog.this.rgbRow);
                    } else {
                        MessageDialog.openInformation((Shell)StatisticsCategoryDialog.this.getShell(), (String)"Statistics", (String)"Non significant top hits or features are detected");
                    }
                }
            });
        } else {
            new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    PieDataset pieDataset = statsModel.generatePieDataset((List)StatisticsCategoryDialog.this.csvEditor.getModel(), StatisticsCategoryDialog.this.csvEditor.getColumnIndexForName(columnName), Integer.parseInt(StatisticsCategoryDialog.this.textMaxCategories.getText()), Integer.parseInt(StatisticsCategoryDialog.this.spinerPercent.getText()), monitor);
                    if (pieDataset.getItemCount() > 1) {
                        StatisticsCategoryDialog.this.statsView.addPieGraph("Category", pieDataset, columnName + " distribution", true, true, false, StatisticsCategoryDialog.this.button3d.getSelection());
                    } else {
                        MessageDialog.openInformation((Shell)StatisticsCategoryDialog.this.getShell(), (String)"Statistics", (String)"Non significant top hits or features are detected");
                    }
                }
            });
        }
    }

    private void addListeners() {
        this.listColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsCategoryDialog.this.validate();
            }
        });
        this.buttonOrientationHorizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsCategoryDialog.this.switchOrientation();
            }
        });
        this.buttonOrientationVertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsCategoryDialog.this.switchOrientation();
            }
        });
        this.buttonTypeBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsCategoryDialog.this.switchType();
            }
        });
        this.buttonTypePie.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsCategoryDialog.this.switchType();
            }
        });
    }

    private boolean validate() {
        this.getButton(0).setEnabled(false);
        this.setErrorMessage(null);
        if (this.listColumns.getSelectionCount() == 0) {
            this.setErrorMessage("Select data column at least");
            return false;
        }
        if (!this.textMaxCategories.getText().isEmpty()) {
            try {
                Integer.parseInt(this.textMaxCategories.getText());
            }
            catch (Exception ex) {
                this.setErrorMessage("Invalid number for max. categories");
                return false;
            }
        }
        this.getButton(0).setEnabled(true);
        return true;
    }

    private void switchOrientation() {
        this.plotOrientation = PlotOrientation.VERTICAL;
        if (this.buttonOrientationHorizontal.getSelection()) {
            this.plotOrientation = PlotOrientation.HORIZONTAL;
        }
    }

    private void switchType() {
        this.buttonOrientationHorizontal.setEnabled(true);
        this.buttonOrientationVertical.setEnabled(true);
        this.buttonColor.setEnabled(true);
        if (this.buttonTypePie.getSelection()) {
            this.buttonOrientationHorizontal.setEnabled(false);
            this.buttonOrientationVertical.setEnabled(false);
            this.buttonColor.setEnabled(false);
            this.labelColor.setBackground(null);
        }
    }

    class ColorMouseListener
    implements MouseListener {
        private int index;

        public ColorMouseListener(int index) {
            this.index = index;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            StatisticsCategoryDialog.this.labelSelected.setImage(StatisticsCategoryDialog.this.imageArray[this.index]);
            StatisticsCategoryDialog.this.labelSelected.pack();
            StatisticsCategoryDialog.this.rgbRow = StatisticsCategoryDialog.this.rgbArray[this.index];
        }
    }
}

