/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.goAnnotation;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.goAnnotation.GOGraphComposite;
import com.biotechvana.csveditor.goAnnotation.GOGraphModel;
import com.biotechvana.csveditor.goAnnotation.GOTerm;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class DisplayGraphDialog
extends TitleAreaDialog {
    private static final int TEXT_LIMIT = 20;
    private final String TITLE = "Display graph";
    private CSVEditor csvEditor;
    private static final NumberFormat numberFormat = NumberFormat.getInstance();
    private static final int TABLE_BUTTON_ID = 2;
    private Label domainLabel;
    private Combo domainCombo;
    private Label goColumnLabel;
    private Combo goColumnCombo;
    private Label sequenceMinimumFilterLabel;
    private Text sequenceMinimumFilterText;
    private Label alphaLabel;
    private Spinner alphaSpinner;
    private Label nodeScoreThresholdLabel;
    private Text nodeScoreThresholdText;
    private Label depthLabel;
    private Spinner depthSpinner;
    private GOTerm.GODomain termType;
    private String columnName;
    private int sequenceMinimum;
    private double alpha;
    private double nodeScoreThreshold;
    private int maximumDepth;

    public DisplayGraphDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    public void create() {
        super.create();
        this.getShell().setText("Display Gene Ontology graph");
        this.setTitle("Display graph");
        this.setMessage("Set the values to display the graph associated to the current worksheet.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        composite.setLayout((Layout)layout);
        this.domainLabel = new Label(composite, 0);
        this.domainLabel.setText("Gene Ontology domain: ");
        GridData domainLabelData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.domainLabel.setLayoutData((Object)domainLabelData);
        this.domainCombo = new Combo(composite, 12);
        GOTerm.GODomain[] gODomainArray = GOTerm.GODomain.values();
        int n = gODomainArray.length;
        int n2 = 0;
        while (n2 < n) {
            GOTerm.GODomain termType = gODomainArray[n2];
            this.domainCombo.add(termType.getPrettyName());
            ++n2;
        }
        this.domainCombo.setText(this.domainCombo.getItem(0));
        GridData domainComboData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.domainCombo.setLayoutData((Object)domainComboData);
        this.goColumnLabel = new Label(composite, 0);
        this.goColumnLabel.setText("Gene Ontology terms column: ");
        GridData goColumnLabelData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.goColumnLabel.setLayoutData((Object)goColumnLabelData);
        this.goColumnCombo = new Combo(composite, 12);
        this.goColumnCombo.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true));
        this.goColumnCombo.setText(this.goColumnCombo.getItem(0));
        String[] stringArray = this.goColumnCombo.getItems();
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String comboItemString = stringArray[n4];
            if (comboItemString.startsWith("GO") && !comboItemString.endsWith("#")) {
                this.goColumnCombo.setText(comboItemString);
                break;
            }
            ++n4;
        }
        GridData goColumnComboData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.goColumnCombo.setLayoutData((Object)goColumnComboData);
        this.sequenceMinimumFilterLabel = new Label(composite, 0);
        this.sequenceMinimumFilterLabel.setText("Sequence filter: ");
        GridData sequenceMinimumFilterLabelData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.sequenceMinimumFilterLabel.setLayoutData((Object)sequenceMinimumFilterLabelData);
        this.sequenceMinimumFilterText = new Text(composite, 2048);
        this.sequenceMinimumFilterText.setTextLimit(20);
        this.sequenceMinimumFilterText.setText("");
        this.sequenceMinimumFilterText.setToolTipText("Terms that do not appear in at least this many sequences will be discarded for the graph representation");
        GridData sequenceMinimumFilterTextData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.sequenceMinimumFilterText.setLayoutData((Object)sequenceMinimumFilterTextData);
        this.alphaLabel = new Label(composite, 0);
        this.alphaLabel.setText("Distance decay value (\u03b1): ");
        GridData alphaLabelData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.alphaLabel.setLayoutData((Object)alphaLabelData);
        this.alphaSpinner = new Spinner(composite, 2048);
        this.alphaSpinner.setDigits(4);
        this.alphaSpinner.setMinimum(1);
        this.alphaSpinner.setMaximum(10000);
        this.alphaSpinner.setIncrement(1);
        this.alphaSpinner.setSelection(6000);
        this.alphaSpinner.setToolTipText("A low value will make nodes with many distant leaves have a lower score than a node with fewer, closer leaves");
        GridData alphaSpinnerData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.alphaSpinner.setLayoutData((Object)alphaSpinnerData);
        this.nodeScoreThresholdLabel = new Label(composite, 0);
        this.nodeScoreThresholdLabel.setText("Node score threshold: ");
        GridData nodeScoreThresholdLabelData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.nodeScoreThresholdLabel.setLayoutData((Object)nodeScoreThresholdLabelData);
        this.nodeScoreThresholdText = new Text(composite, 2048);
        this.nodeScoreThresholdText.setTextLimit(20);
        this.nodeScoreThresholdText.setText("");
        this.nodeScoreThresholdText.setToolTipText("Minimum score a node needs to be displayed on the graph");
        GridData nodeScoreThresholdTextData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.nodeScoreThresholdText.setLayoutData((Object)nodeScoreThresholdTextData);
        this.depthLabel = new Label(composite, 0);
        this.depthLabel.setText("Maximum depth: ");
        GridData depthLabelData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.depthLabel.setLayoutData((Object)depthLabelData);
        this.depthSpinner = new Spinner(composite, 2048);
        this.depthSpinner.setDigits(0);
        this.depthSpinner.setMinimum(0);
        this.depthSpinner.setMaximum(15);
        this.depthSpinner.setIncrement(1);
        this.depthSpinner.setSelection(0);
        this.depthSpinner.setToolTipText("The maximum distance between the Gene Ontology domain root node and the annotated leaf terms. Use the default value (0) to view the whole graph.");
        GridData depthSpinnerData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.depthSpinner.setLayoutData((Object)depthSpinnerData);
        this.addListeners();
        return compositeParent;
    }

    private void addListeners() {
        VerifyListener positiveFloatingPointVerifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (DisplayGraphDialog.this.nodeScoreThresholdText.getText().indexOf(46) == -1) {
                    if (!event.text.matches("[0-9\\.]*")) {
                        event.doit = false;
                    }
                } else if (!event.text.matches("[0-9]*")) {
                    event.doit = false;
                }
            }
        };
        VerifyListener naturalPointVerifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (!event.text.matches("[0-9]*")) {
                    event.doit = false;
                }
            }
        };
        this.sequenceMinimumFilterText.addVerifyListener(naturalPointVerifyListener);
        this.nodeScoreThresholdText.addVerifyListener(positiveFloatingPointVerifyListener);
    }

    /*
     * Unable to fully structure code
     */
    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.cancelPressed();
            return;
        }
        this.termType = GOTerm.GODomain.getInstance(this.domainCombo.getText());
        this.columnName = this.goColumnCombo.getText();
        try {
            this.sequenceMinimum = Integer.parseInt(this.sequenceMinimumFilterText.getText());
        }
        catch (NumberFormatException exception) {
            this.sequenceMinimum = 0;
        }
        try {
            this.alpha = Double.parseDouble(this.alphaSpinner.getText());
        }
        catch (NumberFormatException exception) {
            this.alpha = 0.6;
        }
        try {
            this.nodeScoreThreshold = Double.parseDouble(this.nodeScoreThresholdText.getText());
        }
        catch (NumberFormatException exception) {
            this.nodeScoreThreshold = 0.0;
        }
        tempMaximumDepth = GOTerm.MAX_DEPTH;
        try {
            tempMaximumDepth = Integer.parseInt(this.depthSpinner.getText());
            this.maximumDepth = tempMaximumDepth == 0 ? GOTerm.MAX_DEPTH : tempMaximumDepth;
        }
        catch (NumberFormatException exception) {
            this.maximumDepth = GOTerm.MAX_DEPTH;
        }
        graphModel = new GOGraphModel((List)this.csvEditor.getModel(), this.csvEditor.getColumnIndexForName(this.columnName), this.termType, this.alpha);
        displayGOGraphRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("Building GO graph. Please wait...", 9);
                    graphModel.buildGraphModel(monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(false, true, displayGOGraphRunnable);
        }
        catch (InvocationTargetException exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)("Error: " + exception.getClass().getName()), (String)("An unexpected error happened while building the graph model.\n" + exception.getMessage()));
            exception.printStackTrace(System.err);
        }
        catch (InterruptedException exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)("Error: " + exception.getClass().getName()), (String)("An unexpected error happened while building the graph model.\n" + exception.getMessage()));
            exception.printStackTrace(System.err);
        }
        depthToGOTermListMap = this.createNodesByDepthMap(graphModel, this.maximumDepth, this.nodeScoreThreshold, this.sequenceMinimum);
        graphTableHTML = this.createGraphHTML(graphModel, depthToGOTermListMap);
        d = Display.getCurrent();
        shell = new Shell(d);
        shell.setText("Gene Ontology graph");
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(1000, 800);
        if (buttonId == 0) {
            new GOGraphComposite((Composite)shell, 2048, graphModel, this.maximumDepth, this.sequenceMinimum, this.nodeScoreThreshold);
        } else {
            browser = new Browser((Composite)shell, 0);
            browser.setText(graphTableHTML.toString());
        }
        this.close();
        shell.open();
        if (buttonId != 0 || SharedImages.HIDE_GO_GRAPH_USAGE) ** GOTO lbl67
        messageDialog = new MessageDialogWithToggle(shell, "About Gene Ontology graphs", null, "Click on any node or edge to higlight it.\nNodes can be dragged from their original position to any place on the graph window.\nDouble-click on a node to open a browser at AmiGO for more detailed information.\n\nHover the pointer over a node to obtain detailed information about the term (name, number of sequences annotated and node score).\n\nNodes with light background and dark text represent terms in the worksheet (i.e. annotated terms), whereas nodes with dark background and light text represent terms that do not appear in the worksheet but are necessary to link annotated terms to the root of the tree.", 2, new String[]{"Close"}, 0, "Do not display this message again", false);
        messageDialog.open();
        SharedImages.HIDE_GO_GRAPH_USAGE = messageDialog.getToggleState();
        ** GOTO lbl67
        {
            d.sleep();
            do {
                if (!d.readAndDispatch()) continue block11;
lbl67:
                // 3 sources

            } while (!shell.isDisposed());
        }
    }

    private StringBuilder createGraphHTML(GOGraphModel graphModel, Map<Integer, List<GOTerm>> depthNodesMap) {
        StringBuilder graphHTMLTableSB = new StringBuilder();
        graphHTMLTableSB.append("<!DOCTYPE html>\n");
        graphHTMLTableSB.append("<html>\n");
        graphHTMLTableSB.append("<head>\n");
        graphHTMLTableSB.append("<meta charset=\"UTF-8\">\n");
        graphHTMLTableSB.append("<title>" + this.termType.getPrettyName() + "</title>\n");
        graphHTMLTableSB.append("<style type=\"text/css\">\n");
        graphHTMLTableSB.append("th {\n");
        graphHTMLTableSB.append("border-width: 1px;\n");
        graphHTMLTableSB.append("border-style: solid;\n");
        graphHTMLTableSB.append("border-color: black;\n");
        graphHTMLTableSB.append("border-collapse: collapse;\n");
        graphHTMLTableSB.append("padding: 4px;\n");
        graphHTMLTableSB.append("font-family: serif;\n");
        graphHTMLTableSB.append("}\n");
        graphHTMLTableSB.append("td {\n");
        graphHTMLTableSB.append("border-width: 1px;\n");
        graphHTMLTableSB.append("border-style: solid;\n");
        graphHTMLTableSB.append("border-color: black;\n");
        graphHTMLTableSB.append("border-collapse: collapse;\n");
        graphHTMLTableSB.append("padding: 6px;\n");
        graphHTMLTableSB.append("}\n");
        graphHTMLTableSB.append("td.number {\n");
        graphHTMLTableSB.append("text-align: right;\n");
        graphHTMLTableSB.append("}\n");
        graphHTMLTableSB.append("tr.inferred {\n");
        graphHTMLTableSB.append("background-color: #dadada;\n");
        graphHTMLTableSB.append("}\n");
        graphHTMLTableSB.append("table {\n");
        graphHTMLTableSB.append("border-width: 1px;\n");
        graphHTMLTableSB.append("border-style: solid;\n");
        graphHTMLTableSB.append("border-color: black;\n");
        graphHTMLTableSB.append("border-collapse: collapse;\n");
        graphHTMLTableSB.append("background-color: white;\n");
        graphHTMLTableSB.append("font-family: sans;\n");
        graphHTMLTableSB.append("}\n");
        graphHTMLTableSB.append("h3 {\n");
        graphHTMLTableSB.append("padding-top: 1em;\n");
        graphHTMLTableSB.append("}\n");
        graphHTMLTableSB.append("</style>\n");
        graphHTMLTableSB.append("</head>\n");
        graphHTMLTableSB.append("<body>\n");
        graphHTMLTableSB.append("<h2>" + this.termType.getPrettyName() + "</h2>\n");
        graphHTMLTableSB.append("<p>Gene Ontology terms grouped by levels. The rows with grey background are terms which do not appear in the worksheet but which have been inferred from the leaves of the graph.</p>");
        ArrayList<Integer> depthList = new ArrayList<Integer>(depthNodesMap.keySet().size());
        for (Integer i : depthNodesMap.keySet()) {
            depthList.add(i);
        }
        Collections.sort(depthList);
        for (Integer i : depthList) {
            if (depthNodesMap.get(i).size() <= 0) continue;
            graphHTMLTableSB.append("<h3>Level " + Integer.toString(i) + "</h3>\n");
            graphHTMLTableSB.append("<table style=\"border:1px solid black\">\n");
            graphHTMLTableSB.append("<tr>\n");
            graphHTMLTableSB.append("<th>Term description</th>\n");
            graphHTMLTableSB.append("<th>Accession</th>\n");
            graphHTMLTableSB.append("<th>Score</th>\n");
            graphHTMLTableSB.append("<th>Annotation count</th>\n");
            graphHTMLTableSB.append("</tr>\n");
            for (GOTerm term : depthNodesMap.get(i)) {
                if (graphModel.getAuxiliaryTerms().contains(term)) {
                    graphHTMLTableSB.append("<tr class=\"inferred\">\n");
                } else {
                    graphHTMLTableSB.append("<tr>\n");
                }
                graphHTMLTableSB.append("<td>");
                graphHTMLTableSB.append(term.getName());
                graphHTMLTableSB.append("</td>\n");
                graphHTMLTableSB.append("<td>");
                graphHTMLTableSB.append(term.getAccession());
                graphHTMLTableSB.append("</td>");
                graphHTMLTableSB.append("<td class=\"number\">");
                graphHTMLTableSB.append(numberFormat.format(term.getNodeScore()));
                graphHTMLTableSB.append("</td>\n");
                graphHTMLTableSB.append("<td class=\"number\">");
                graphHTMLTableSB.append(numberFormat.format(term.getCumulativeSequenceCount()));
                graphHTMLTableSB.append("</td>\n");
                graphHTMLTableSB.append("</tr>\n");
            }
            graphHTMLTableSB.append("</table>\n");
        }
        graphHTMLTableSB.append("</body>\n");
        graphHTMLTableSB.append("</html>\n");
        return graphHTMLTableSB;
    }

    private Map<Integer, List<GOTerm>> createNodesByDepthMap(GOGraphModel graphModel, int maximumDepth, double nodeScoreThreshold, int sequenceMinimum) {
        HashMap<Integer, List<GOTerm>> depthNodesMap = new HashMap<Integer, List<GOTerm>>();
        int i = 0;
        while (i <= maximumDepth) {
            depthNodesMap.put(i, new ArrayList());
            ++i;
        }
        for (GOTerm term : graphModel.getAllTerms()) {
            if (!(term.getNodeScore() >= nodeScoreThreshold) || term.getCumulativeSequenceCount() < sequenceMinimum) continue;
            List depthList = (List)depthNodesMap.get(term.getDepth());
            depthList.add(term);
        }
        return depthNodesMap;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 2, "Display table...", false);
        this.getButton(0).setText("Display graph...");
    }
}

