/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvApplyColorMapRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvCalculateColorMapRunnable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CsvSortDialog
extends TitleAreaDialog {
    private final int COMBO_WIDTH = 200;
    private final String TITLE = "Sort worksheet";
    private CSVEditor csvEditor;
    private Combo comboColumn;
    private Combo comboType;
    private Button buttonAscending;
    private Button buttonDescending;

    public CsvSortDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        GridData layoutData = new GridData();
        Label labelColumn = new Label(composite, 0);
        labelColumn.setText("Column: ");
        layoutData = new GridData();
        labelColumn.setLayoutData((Object)layoutData);
        this.comboColumn = new Combo(composite, 2060);
        this.comboColumn.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true));
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.comboColumn.setLayoutData((Object)layoutData);
        Label labelType = new Label(composite, 0);
        labelType.setText("Data type: ");
        layoutData = new GridData();
        labelType.setLayoutData((Object)layoutData);
        this.comboType = new Combo(composite, 2060);
        this.comboType.setItems(CSVEditor.DATA_TYPES);
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.comboType.setLayoutData((Object)layoutData);
        Label labelOrder = new Label(composite, 0);
        labelOrder.setText("Order: ");
        layoutData = new GridData();
        labelOrder.setLayoutData((Object)layoutData);
        Composite compositeOrder = this.createOrderComposite(composite, 0);
        layoutData = new GridData();
        compositeOrder.setLayoutData((Object)layoutData);
        this.initDialog();
        this.addListeners();
        return compositeParent;
    }

    private Composite createOrderComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        this.buttonAscending = new Button(composite, 16);
        this.buttonAscending.setText("Ascending");
        this.buttonAscending.setLayoutData((Object)layoutData);
        this.buttonAscending.setSelection(true);
        layoutData = new GridData();
        this.buttonDescending = new Button(composite, 16);
        this.buttonDescending.setText("Descending");
        this.buttonDescending.setLayoutData((Object)layoutData);
        return composite;
    }

    private void initDialog() {
        this.getShell().setText("Sorting");
        this.setTitle("Sort worksheet");
        this.setMessage("Sort worksheet by column values");
    }

    protected void okPressed() {
        block5: {
            try {
                try {
                    this.run();
                }
                catch (Exception e) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Sort worksheet", (String)e.getMessage());
                    this.csvEditor.setModified(true);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.csvEditor.setModified(true);
                throw throwable;
            }
            this.csvEditor.setModified(true);
        }
        super.okPressed();
    }

    private void run() throws Exception {
        CsvCalculateColorMapRunnable calculateColorRunnable = new CsvCalculateColorMapRunnable(this.csvEditor);
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)calculateColorRunnable);
        }
        catch (Exception e) {
            throw new Exception("Error generating color association", e);
        }
        Map<String, Color> mapColor = calculateColorRunnable.getMapColors();
        String columnName = this.comboColumn.getItem(this.comboColumn.getSelectionIndex());
        int columnModelIndex = this.csvEditor.getColumnIndexForName(columnName);
        try {
            this.sortColumn(columnModelIndex, this.comboType.getSelectionIndex(), this.buttonAscending.getSelection(), true, this.comboColumn.getText());
        }
        catch (NumberFormatException e) {
            throw new Exception("Alphanumeric data must be sorted as text data", e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new Exception("Failed sorting rows", e);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.csvEditor.resetModelIndices(true, false);
        }
        catch (InvocationTargetException e) {
            throw new Exception("Failed resetting row indices", e);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        CsvApplyColorMapRunnable applyColorMapRunnable = new CsvApplyColorMapRunnable(this.csvEditor, mapColor);
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)applyColorMapRunnable);
        }
        catch (Exception e) {
            throw new Exception("Failed applying row colors", e);
        }
    }

    private void addListeners() {
        this.comboColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvSortDialog.this.updateDataTypeCombo();
                CsvSortDialog.this.validate();
            }
        });
        this.comboType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvSortDialog.this.validate();
            }
        });
    }

    private void validate() {
        this.getButton(0).setEnabled(false);
        if (this.comboColumn.getSelectionIndex() == -1) {
            this.setErrorMessage("Column required");
            return;
        }
        if (this.comboType.getSelectionIndex() == -1) {
            this.setErrorMessage("Data type required");
            return;
        }
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
    }

    private void updateDataTypeCombo() {
        String columnName = this.comboColumn.getItem(this.comboColumn.getSelectionIndex());
        int columnModelIndex = this.csvEditor.getColumnIndexForName(columnName);
        this.comboType.select(this.csvEditor.detectDataTypeForColumn(columnModelIndex));
    }

    private void sortColumn(int columnIndex, int dataType, boolean ascending, boolean registerAction, String columnName) throws NumberFormatException, InvocationTargetException, InterruptedException {
        switch (dataType) {
            case 0: {
                this.csvEditor.sortAsAlphaNum(columnIndex, ascending, registerAction);
                break;
            }
            case 1: {
                this.csvEditor.sortAsScientific(columnIndex, ascending, registerAction, columnName);
                break;
            }
            default: {
                this.csvEditor.sortAsAlphaNum(columnIndex, ascending, registerAction);
            }
        }
    }
}

