/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csvUtils.WorksheetUtils;
import com.biotechvana.csveditor.dialogs.CustomColorDialog;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvCheckRowsMultipleRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvColorRowsMultipleRunnable;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CsvSelectValueDialog
extends Dialog {
    public static final String TITLE = "Select by expect or statistics";
    private final int BUTTON_WIDTH = 20;
    private Text textValue;
    private Label buttonLower;
    private Label buttonHigher;
    private Label buttonNohit;
    private int[] searchIndices = null;
    private Combo comboColumns;
    private RGB rgbLower;
    private RGB rgbHigher;
    private RGB rgbNohit;
    private RGB[] rgbArray = CustomColorDialog.rgbArray;
    private Image[] imageArray = CustomColorDialog.imageArray;
    private CSVEditor csvEditor;
    private Button buttonSelectLower;
    private Button buttonSelectHigher;
    private Button buttonSelectNohit;
    private List<List<Integer>> listMatches;
    private NumberFormat numberFormat = NumberFormat.getInstance();

    public CsvSelectValueDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        this.getShell().setText(TITLE);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label labelValue = new Label(composite, 0);
        labelValue.setText("Value cutoff:");
        GridData layoutData = new GridData(32);
        labelValue.setLayoutData((Object)layoutData);
        this.textValue = new Text(composite, 2052);
        layoutData = new GridData();
        layoutData.widthHint = 100;
        this.textValue.setLayoutData((Object)layoutData);
        this.textValue.setFocus();
        Label separator = new Label(composite, 258);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        separator.setLayoutData((Object)layoutData);
        Label labelColumn = new Label(composite, 0);
        labelColumn.setText("In column:");
        layoutData = new GridData();
        labelColumn.setLayoutData((Object)layoutData);
        this.comboColumns = new Combo(composite, 12);
        this.comboColumns.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true));
        int evalColumn = this.csvEditor.getEvalueColumn();
        if (evalColumn != -1) {
            this.comboColumns.select(evalColumn);
        }
        layoutData = new GridData();
        this.comboColumns.setLayoutData((Object)layoutData);
        Group groupColors = this.createColorsGroup(composite, 0);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        groupColors.setLayoutData((Object)layoutData);
        composite.pack();
        this.addListeners();
        return composite;
    }

    private Group createColorsGroup(Composite parent, int style) {
        Group group = new Group(parent, style);
        group.setText("Select row colors:");
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        Label labelLower = new Label((Composite)group, 0);
        labelLower.setText("Lower values:");
        GridData layoutData = new GridData(128);
        labelLower.setLayoutData((Object)layoutData);
        this.buttonLower = new Label((Composite)group, 2048);
        this.buttonLower.setImage(this.imageArray[0]);
        this.rgbLower = this.rgbArray[0];
        layoutData = new GridData();
        layoutData.widthHint = 20;
        this.buttonLower.setLayoutData((Object)layoutData);
        this.buttonSelectLower = new Button((Composite)group, 32);
        this.buttonSelectLower.setText("Check rows");
        this.buttonSelectLower.setSelection(false);
        this.buttonSelectLower.setToolTipText("Click here to select color");
        layoutData = new GridData();
        layoutData.horizontalIndent = 20;
        this.buttonSelectLower.setLayoutData((Object)layoutData);
        Label labelHigher = new Label((Composite)group, 0);
        labelHigher.setText("Higher values:");
        layoutData = new GridData(128);
        labelHigher.setLayoutData((Object)layoutData);
        this.buttonHigher = new Label((Composite)group, 2048);
        this.buttonHigher.setImage(this.imageArray[0]);
        this.rgbHigher = this.rgbArray[0];
        layoutData = new GridData();
        layoutData.widthHint = 20;
        this.buttonHigher.setLayoutData((Object)layoutData);
        this.buttonSelectHigher = new Button((Composite)group, 32);
        this.buttonSelectHigher.setSelection(false);
        this.buttonSelectHigher.setText("Check rows");
        this.buttonSelectHigher.setToolTipText("Click here to select color");
        layoutData = new GridData();
        layoutData.horizontalIndent = 20;
        this.buttonSelectHigher.setLayoutData((Object)layoutData);
        Label labelNohit = new Label((Composite)group, 0);
        labelNohit.setText("No hit:");
        layoutData = new GridData(128);
        labelNohit.setLayoutData((Object)layoutData);
        this.buttonNohit = new Label((Composite)group, 2048);
        this.buttonNohit.setImage(this.imageArray[0]);
        this.rgbNohit = this.rgbArray[0];
        layoutData = new GridData();
        layoutData.widthHint = 20;
        this.buttonNohit.setLayoutData((Object)layoutData);
        this.buttonSelectNohit = new Button((Composite)group, 32);
        this.buttonSelectNohit.setSelection(false);
        this.buttonSelectNohit.setText("Check rows");
        this.buttonSelectNohit.setToolTipText("Click here to select color");
        layoutData = new GridData();
        layoutData.horizontalIndent = 20;
        this.buttonSelectNohit.setLayoutData((Object)layoutData);
        return group;
    }

    private void addListeners() {
        this.buttonLower.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CustomColorDialog dialog = new CustomColorDialog(CsvSelectValueDialog.this.getShell());
                int res = dialog.open();
                if (res == 1) {
                    return;
                }
                int selection = dialog.getSelectedRGB();
                CsvSelectValueDialog.this.buttonLower.setImage(CsvSelectValueDialog.this.imageArray[selection]);
                CsvSelectValueDialog.this.rgbLower = CsvSelectValueDialog.this.rgbArray[selection];
                dialog.close();
            }
        });
        this.buttonHigher.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CustomColorDialog dialog = new CustomColorDialog(CsvSelectValueDialog.this.getShell());
                int res = dialog.open();
                if (res == 1) {
                    return;
                }
                int selection = dialog.getSelectedRGB();
                CsvSelectValueDialog.this.buttonHigher.setImage(CsvSelectValueDialog.this.imageArray[selection]);
                CsvSelectValueDialog.this.rgbHigher = CsvSelectValueDialog.this.rgbArray[selection];
                dialog.close();
            }
        });
        this.buttonNohit.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CustomColorDialog dialog = new CustomColorDialog(CsvSelectValueDialog.this.getShell());
                int res = dialog.open();
                if (res == 1) {
                    return;
                }
                int selection = dialog.getSelectedRGB();
                CsvSelectValueDialog.this.buttonNohit.setImage(CsvSelectValueDialog.this.imageArray[selection]);
                CsvSelectValueDialog.this.rgbNohit = CsvSelectValueDialog.this.rgbArray[selection];
                dialog.close();
            }
        });
    }

    private boolean validateValue() {
        this.textValue.setText(this.textValue.getText().replace(",", "."));
        try {
            Double.parseDouble(this.textValue.getText());
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private boolean validate() {
        boolean valid = true;
        if (!this.validateValue()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Select by value", (String)"Not valid number format");
            valid = false;
        }
        return valid;
    }

    protected void okPressed() {
        if (!this.validate()) {
            return;
        }
        try {
            this.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    private void run() throws InvocationTargetException, InterruptedException, NumberFormatException {
        long timestamp = System.currentTimeMillis();
        this.listMatches = new ArrayList<List<Integer>>();
        new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                String columnName = CsvSelectValueDialog.this.comboColumns.getText();
                int columnModelIndex = CsvSelectValueDialog.this.csvEditor.getColumnIndexForName(columnName);
                CsvSelectValueDialog.this.listMatches = CsvSelectValueDialog.this.filterByValue(columnModelIndex, Double.parseDouble(CsvSelectValueDialog.this.textValue.getText()), CsvSelectValueDialog.this.comboColumns.getText(), monitor);
            }
        });
        Color[] arrayColor = new Color[]{new Color((Device)this.getShell().getDisplay(), this.rgbHigher), new Color((Device)this.getShell().getDisplay(), this.rgbLower), new Color((Device)this.getShell().getDisplay(), this.rgbNohit)};
        CsvColorRowsMultipleRunnable colorRunnable = new CsvColorRowsMultipleRunnable(this.csvEditor, this.listMatches, arrayColor, timestamp);
        new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)colorRunnable);
        CsvCheckRowsMultipleRunnable checkMultipleRunnable = new CsvCheckRowsMultipleRunnable(this.csvEditor, this.listMatches, new String[]{"Higher values", "Lower values", "No hit"}, new boolean[]{this.buttonSelectHigher.getSelection(), this.buttonSelectLower.getSelection(), this.buttonSelectNohit.getSelection()}, timestamp);
        new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)checkMultipleRunnable);
    }

    public int open() {
        return super.open();
    }

    public int[] getSearchIndices() {
        return this.searchIndices;
    }

    public List<List<Integer>> filterByValue(int column, double threshold, String columnName, IProgressMonitor monitor) {
        try {
            int rowCount = this.csvEditor.getTable().getItemCount();
            ArrayList<List<Integer>> listMatches = new ArrayList<List<Integer>>();
            ArrayList<Integer> listHigher = new ArrayList<Integer>();
            ArrayList<Integer> listLower = new ArrayList<Integer>();
            ArrayList<Integer> listNoHit = new ArrayList<Integer>();
            listMatches.add(listHigher);
            listMatches.add(listLower);
            listMatches.add(listNoHit);
            int stepSize = 1;
            if (rowCount > 100) {
                stepSize = rowCount / 100;
            }
            int counterParsed = 0;
            monitor.beginTask("Select by value", 100);
            int i = 0;
            while (i < rowCount) {
                int counter = i;
                String cellValue = this.csvEditor.getTable().getItem(counter).getText(column);
                if (cellValue == null || cellValue.isEmpty()) {
                    listNoHit.add(counter);
                } else {
                    try {
                        double value = Double.parseDouble(WorksheetUtils.parseColValueAuto((String)columnName, (String)cellValue));
                        if (value <= threshold) {
                            listLower.add(counter);
                        } else {
                            listHigher.add(counter);
                        }
                    }
                    catch (NumberFormatException e) {
                        listNoHit.add(counter);
                        e.printStackTrace();
                    }
                }
                if (++counterParsed % stepSize == 0) {
                    monitor.worked(1);
                    monitor.subTask("Reading row " + this.numberFormat.format(i + 1) + " of " + this.numberFormat.format(rowCount));
                }
                ++i;
            }
            ArrayList<List<Integer>> arrayList = listMatches;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }
}

