/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.dialogs.CustomColorDialog;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvCheckRowsMultipleRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvColorRowsMultipleRunnable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class CsvSelectTermDialog
extends Dialog {
    private final String TITLE = "Select by key terms";
    private CSVEditor csvEditor;
    private TableViewer tableTermViewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonDelete;
    private Combo comboColumns;
    private List<Term> listTerm;
    private List<List<Integer>> listMatches;
    private List<Integer> listCheckedRows;
    private Button buttonExact;
    private Button buttonCase;
    private Button buttonRegexp;

    public CsvSelectTermDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
        this.listTerm = new ArrayList<Term>();
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Select by key terms");
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label labelSearch = new Label(composite, 0);
        labelSearch.setText("Key terms:");
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment(0, 20);
        layoutData.left = new FormAttachment(0, 0);
        labelSearch.setLayoutData((Object)layoutData);
        Composite compositeTable = this.createTableComposite(composite, 0);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)labelSearch, 20);
        layoutData.left = new FormAttachment(0, 0);
        compositeTable.setLayoutData((Object)layoutData);
        this.buttonAdd = new Button(composite, 8);
        this.buttonAdd.setText("Add");
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)compositeTable, 0, 128);
        layoutData.left = new FormAttachment((Control)compositeTable, 10);
        this.buttonAdd.setLayoutData((Object)layoutData);
        this.buttonEdit = new Button(composite, 8);
        this.buttonEdit.setText("Edit");
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.buttonAdd, 4);
        layoutData.left = new FormAttachment((Control)compositeTable, 10);
        this.buttonEdit.setLayoutData((Object)layoutData);
        this.buttonDelete = new Button(composite, 8);
        this.buttonDelete.setText("Delete");
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.buttonEdit, 4);
        layoutData.left = new FormAttachment((Control)compositeTable, 10);
        this.buttonDelete.setLayoutData((Object)layoutData);
        Label labelColumn = new Label(composite, 0);
        labelColumn.setText("In column:");
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)compositeTable, 20);
        layoutData.left = new FormAttachment(0, 0);
        labelColumn.setLayoutData((Object)layoutData);
        this.comboColumns = new Combo(composite, 8);
        this.comboColumns.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true));
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)labelColumn, 0, 0x1000000);
        layoutData.left = new FormAttachment((Control)labelColumn, 4);
        this.comboColumns.setLayoutData((Object)layoutData);
        Group groupOptions = new Group(composite, 0);
        groupOptions.setText("Search options");
        GridLayout layoutOptions = new GridLayout(2, false);
        layoutOptions.marginHeight = 6;
        layoutOptions.marginWidth = 6;
        groupOptions.setLayout((Layout)layoutOptions);
        this.buttonExact = new Button((Composite)groupOptions, 32);
        this.buttonExact.setText("Exact match");
        this.buttonExact.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonExact.setSelection(false);
        this.buttonCase = new Button((Composite)groupOptions, 32);
        this.buttonCase.setText("Ignore case");
        this.buttonCase.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonCase.setSelection(false);
        this.buttonRegexp = new Button((Composite)groupOptions, 32);
        this.buttonRegexp.setText("Regular expression");
        this.buttonRegexp.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonRegexp.setSelection(false);
        this.buttonRegexp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CsvSelectTermDialog.this.buttonRegexp.getSelection()) {
                    CsvSelectTermDialog.this.buttonExact.setSelection(false);
                    CsvSelectTermDialog.this.buttonCase.setSelection(false);
                    CsvSelectTermDialog.this.buttonExact.setEnabled(false);
                    CsvSelectTermDialog.this.buttonCase.setEnabled(false);
                } else {
                    CsvSelectTermDialog.this.buttonExact.setEnabled(true);
                    CsvSelectTermDialog.this.buttonCase.setEnabled(true);
                }
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)labelColumn, 20);
        layoutData.left = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        groupOptions.setLayoutData((Object)layoutData);
        Link buttonImport = new Link(composite, 0);
        buttonImport.setText("<a href=\"#\">Click here to import a list of terms from file</a>");
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)groupOptions, 30);
        layoutData.left = new FormAttachment((Control)groupOptions, 0, 16384);
        buttonImport.setLayoutData((Object)layoutData);
        buttonImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(CsvSelectTermDialog.this.getShell(), 4);
                dialog.setText("Select terms file");
                String selectedFile = dialog.open();
                if (selectedFile != null) {
                    try {
                        CsvSelectTermDialog.this.readTermFile(selectedFile);
                        CsvSelectTermDialog.this.tableTermViewer.setInput(CsvSelectTermDialog.this.listTerm);
                        CsvSelectTermDialog.this.tableTermViewer.refresh();
                    }
                    catch (IOException e2) {
                        MessageBox box = new MessageBox(CsvSelectTermDialog.this.getShell(), 8);
                        box.setText("Warning");
                        box.setMessage("Cannot parse file");
                        box.open();
                    }
                }
            }
        });
        Label labelImport2 = new Label(composite, 0);
        labelImport2.setText("A CSV file with one term and color code in each line following this format:\nterm_1;#FF0000\nterm_2;#00FF00\n...\n\nUse #FFFFFF for not using background colors");
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)buttonImport, 10);
        layoutData.left = new FormAttachment((Control)buttonImport, 0, 16384);
        labelImport2.setLayoutData((Object)layoutData);
        this.addListeners();
        return composite;
    }

    private void readTermFile(String filePath) throws IOException {
        File inputFile = new File(filePath);
        MessageBox box = new MessageBox(this.getShell(), 8);
        box.setText("Warning");
        this.listTerm = new ArrayList<Term>();
        if (inputFile == null || !inputFile.exists()) {
            box.setMessage("Cannot open file");
            box.open();
        } else {
            try (BufferedReader reader = new BufferedReader(new FileReader(inputFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts;
                    if (line == "" || (parts = (line = line.replace("\"", "")).split(";")).length != 2) continue;
                    parts[1] = parts[1].replace("#", "");
                    String r = parts[1].substring(0, 2);
                    String g = parts[1].substring(2, 4);
                    String b = parts[1].substring(4, 6);
                    int r_int = Integer.parseInt(r, 16);
                    int g_int = Integer.parseInt(g, 16);
                    int b_int = Integer.parseInt(b, 16);
                    System.out.println("term: " + parts[0]);
                    System.out.println("r: " + r + "--" + r_int);
                    System.out.println("g: " + g + "--" + g_int);
                    System.out.println("b: " + b + "--" + b_int);
                    this.listTerm.add(new Term(parts[0], new RGB(r_int, g_int, b_int)));
                }
            }
        }
    }

    public Composite createTableComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(1808);
        Table table = new Table(composite, 268503810);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        layoutData.heightHint = 240;
        table.setLayoutData((Object)layoutData);
        this.tableTermViewer = new TableViewer(table);
        TableViewerColumn columnTerm = new TableViewerColumn(this.tableTermViewer, 0);
        columnTerm.getColumn().setText("Term");
        columnTerm.getColumn().setWidth(300);
        TableViewerColumn columnColor = new TableViewerColumn(this.tableTermViewer, 0);
        columnColor.getColumn().setText("Color");
        columnColor.getColumn().setWidth(50);
        this.tableTermViewer.setContentProvider((IContentProvider)new TermTableContentProvider());
        this.tableTermViewer.setLabelProvider((IBaseLabelProvider)new TermTableLabelProvider());
        this.tableTermViewer.setInput(this.listTerm);
        return composite;
    }

    private void addListeners() {
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvSelectTermDialog.this.addTerm();
            }
        });
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvSelectTermDialog.this.editTerm();
            }
        });
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvSelectTermDialog.this.deleteTerm();
            }
        });
    }

    protected void okPressed() {
        try {
            this.run();
        }
        catch (InvocationTargetException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Select by key terms", (String)("Failed selecting terms: " + e.getMessage()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.okPressed();
    }

    public Term[] getTerms() {
        return this.listTerm.toArray(new Term[this.listTerm.size()]);
    }

    private void run() throws InvocationTargetException, InterruptedException {
        Term t;
        int n;
        int n2;
        Term[] termArray;
        Term[] arrayTerms = this.getTerms();
        long timestamp = System.currentTimeMillis();
        String columnName = this.comboColumns.getText();
        int columnModelIndex = this.csvEditor.getColumnIndexForName(columnName);
        this.listMatches = this.csvEditor.selectByTerms(this.getTerms(), columnModelIndex, this.buttonExact.getSelection(), this.buttonCase.getSelection(), this.buttonRegexp.getSelection(), true, true);
        if (this.listMatches != null) {
            ArrayList<Color> listColors = new ArrayList<Color>();
            termArray = arrayTerms;
            n2 = arrayTerms.length;
            n = 0;
            while (n < n2) {
                t = termArray[n];
                listColors.add(new Color((Device)this.getShell().getDisplay(), t.getRgb()));
                ++n;
            }
            CsvColorRowsMultipleRunnable colorRunnable = new CsvColorRowsMultipleRunnable(this.csvEditor, this.listMatches, listColors.toArray(new Color[listColors.size()]), timestamp);
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)colorRunnable);
        }
        ArrayList<String> lt = new ArrayList<String>();
        termArray = this.getTerms();
        n2 = termArray.length;
        n = 0;
        while (n < n2) {
            t = termArray[n];
            lt.add(t.getTerm());
            ++n;
        }
        CsvCheckRowsMultipleRunnable checkRowsMultipleRunnable = new CsvCheckRowsMultipleRunnable(this.csvEditor, this.listMatches, lt.toArray(new String[lt.size()]), true, timestamp);
        new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)checkRowsMultipleRunnable);
        this.listCheckedRows = this.csvEditor.getCheckedRowIndices(true, true);
        if (this.listCheckedRows != null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Select by term", (String)(new DecimalFormat("###,###").format(this.listCheckedRows.size()) + " rows matched terms"));
        }
    }

    private void addTerm() {
        TermDialog dialog = new TermDialog(this.getShell());
        if (dialog.open() == 1) {
            return;
        }
        if (dialog.getTerm() == null || dialog.getRgb() == null) {
            return;
        }
        Term term = new Term(dialog.getTerm(), dialog.getRgb());
        this.listTerm.add(term);
        this.tableTermViewer.refresh();
        dialog.close();
    }

    private void editTerm() {
        IStructuredSelection selection = (IStructuredSelection)this.tableTermViewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return;
        }
        Term selectedTerm = (Term)selection.getFirstElement();
        TermDialog dialog = new TermDialog(this.getShell(), selectedTerm);
        if (dialog.open() == 1) {
            return;
        }
        if (dialog.getTerm() == null || dialog.getRgb() == null) {
            return;
        }
        selectedTerm.setTerm(dialog.getTerm());
        selectedTerm.setRgb(dialog.getRgb());
        this.tableTermViewer.refresh();
        dialog.close();
    }

    private void deleteTerm() {
        int selectedIndex = this.tableTermViewer.getTable().getSelectionIndex();
        if (selectedIndex == -1) {
            return;
        }
        ((ArrayList)this.tableTermViewer.getInput()).remove(selectedIndex);
        this.tableTermViewer.refresh();
        if (selectedIndex > 0) {
            this.tableTermViewer.getTable().setSelection(selectedIndex - 1);
        }
    }

    public class Term {
        private String term;
        private RGB rgb;

        public Term() {
        }

        public Term(String term, RGB rgb) {
            this.term = term;
            this.rgb = rgb;
        }

        public String getTerm() {
            return this.term;
        }

        public void setTerm(String term) {
            this.term = term;
        }

        public RGB getRgb() {
            return this.rgb;
        }

        public void setRgb(RGB rgb) {
            this.rgb = rgb;
        }
    }

    class TermDialog
    extends Dialog {
        private Text textTerm;
        private Label labelColorSelection;
        private String termValue;
        private RGB rgb;

        protected TermDialog(Shell parentShell) {
            super(parentShell);
            this.textTerm = null;
            this.termValue = null;
            this.rgb = CustomColorDialog.rgbArray[0];
        }

        protected TermDialog(Shell parentShell, Term term) {
            super(parentShell);
            this.textTerm = null;
            this.termValue = null;
            this.rgb = CustomColorDialog.rgbArray[0];
            this.termValue = term.getTerm();
            this.rgb = term.getRgb();
        }

        protected Control createDialogArea(Composite parent) {
            int rgbIndex;
            Composite compositeParent = (Composite)super.createDialogArea(parent);
            this.getShell().setText("Add key terms");
            compositeParent.setLayoutData((Object)new GridData(1808));
            Composite composite = new Composite(compositeParent, 0);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            Label labelTerm = new Label(composite, 0);
            labelTerm.setText("Search term:");
            FormData layoutData = new FormData();
            layoutData.top = new FormAttachment(0, 10);
            layoutData.left = new FormAttachment(0, 0);
            labelTerm.setLayoutData((Object)layoutData);
            this.textTerm = new Text(composite, 2052);
            layoutData = new FormData();
            layoutData.top = new FormAttachment((Control)labelTerm, 0, 0x1000000);
            layoutData.left = new FormAttachment((Control)labelTerm, 10);
            layoutData.width = 100;
            this.textTerm.setLayoutData((Object)layoutData);
            if (this.termValue != null) {
                this.textTerm.setText(this.termValue);
            }
            Label labelColor = new Label(composite, 0);
            labelColor.setText("Color");
            layoutData = new FormData();
            layoutData.top = new FormAttachment((Control)labelTerm, 10);
            layoutData.left = new FormAttachment(0, 0);
            labelColor.setLayoutData((Object)layoutData);
            this.labelColorSelection = new Label(composite, 2048);
            layoutData = new FormData();
            layoutData.width = 20;
            layoutData.top = new FormAttachment((Control)labelColor, 0, 0x1000000);
            layoutData.left = new FormAttachment((Control)labelTerm, 10);
            this.labelColorSelection.setLayoutData((Object)layoutData);
            this.labelColorSelection.setImage(CustomColorDialog.imageArray[0]);
            if (this.rgb != null && (rgbIndex = CustomColorDialog.getRgbReference(this.rgb)) >= 0) {
                this.labelColorSelection.setImage(CustomColorDialog.imageArray[rgbIndex]);
            }
            this.addListeners();
            return composite;
        }

        public void addListeners() {
            this.labelColorSelection.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    CustomColorDialog dialog = new CustomColorDialog(TermDialog.this.getShell());
                    int res = dialog.open();
                    if (res == 1) {
                        return;
                    }
                    TermDialog.this.labelColorSelection.setImage(CustomColorDialog.imageArray[dialog.getSelectedRGB()]);
                    TermDialog.this.rgb = CustomColorDialog.rgbArray[dialog.getSelectedRGB()];
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
        }

        public String getTerm() {
            return this.termValue;
        }

        public void setTerm(String term) {
            this.termValue = term;
        }

        public RGB getRgb() {
            return this.rgb;
        }

        public void setRgb(RGB rgb) {
            this.rgb = rgb;
        }

        protected void okPressed() {
            this.termValue = this.textTerm.getText();
            this.close();
        }
    }

    class TermTableContentProvider
    implements IStructuredContentProvider {
        TermTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList tableRow = (ArrayList)inputElement;
            return tableRow.toArray(new Object[tableRow.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TermTableLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        TermTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1) {
                Term term = (Term)element;
                Image image = new Image((Device)CsvSelectTermDialog.this.getShell().getDisplay(), 20, 20);
                GC gc = new GC((Drawable)image);
                gc.setForeground(new Color((Device)CsvSelectTermDialog.this.getShell().getDisplay(), term.getRgb()));
                gc.setBackground(new Color((Device)CsvSelectTermDialog.this.getShell().getDisplay(), term.getRgb()));
                gc.fillRectangle(0, 0, 20, 20);
                gc.dispose();
                return image;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                Term term = (Term)element;
                return term.getTerm();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }
    }
}

