/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.dialogs.CustomColorDialog;
import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CsvSelectColorDialog
extends Dialog {
    private CSVEditor csvEditor;
    private Button buttonSelect;
    private Label labelSelected;
    private RGB rgbRow;
    private RGB[] rgbArray = CustomColorDialog.rgbArray;
    private Image[] imageArray = CustomColorDialog.imageArray;

    public CsvSelectColorDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Select by color");
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Group colorGrid = this.createColorGrid(composite, 0);
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment(0, 0);
        layoutData.left = new FormAttachment(0, 0);
        colorGrid.setLayoutData((Object)layoutData);
        Label labelSearch = new Label(composite, 0);
        labelSearch.setText("Selected color:");
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)colorGrid, 20);
        layoutData.left = new FormAttachment(0, 0);
        labelSearch.setLayoutData((Object)layoutData);
        this.labelSelected = new Label(composite, 2056);
        this.labelSelected.setImage(this.imageArray[0]);
        this.rgbRow = this.rgbArray[0];
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)labelSearch, 0, 0x1000000);
        layoutData.left = new FormAttachment((Control)labelSearch, 4);
        layoutData.width = 20;
        layoutData.height = 20;
        this.labelSelected.setLayoutData((Object)layoutData);
        this.buttonSelect = new Button(composite, 32);
        this.buttonSelect.setSelection(true);
        this.buttonSelect.setText("Set matches as selected");
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.labelSelected, 10);
        layoutData.left = new FormAttachment(0, 0);
        this.buttonSelect.setLayoutData((Object)layoutData);
        this.addListeners();
        return composite;
    }

    private Group createColorGrid(Composite parent, int style) {
        Group composite = new Group(parent, style);
        composite.setText("Select row color:");
        composite.setLayout((Layout)new GridLayout(4, true));
        Label[] labelColorArray = CustomColorDialog.labelArray;
        int i = 0;
        while (i < labelColorArray.length) {
            labelColorArray[i] = new Label((Composite)composite, 2048);
            labelColorArray[i].setImage(this.imageArray[i]);
            labelColorArray[i].addMouseListener((MouseListener)new ColorMouseListener(i));
            ++i;
        }
        return composite;
    }

    private void addListeners() {
    }

    protected void okPressed() {
        try {
            this.run();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.okPressed();
    }

    private void run() throws InvocationTargetException, InterruptedException {
        this.csvEditor.selectByColor(this.rgbRow, this.buttonSelect.getSelection());
    }

    public int open() {
        return super.open();
    }

    class ColorListener
    implements SelectionListener {
        int index;

        public ColorListener(int index) {
            this.index = index;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CsvSelectColorDialog.this.labelSelected.setImage(CsvSelectColorDialog.this.imageArray[this.index]);
            CsvSelectColorDialog.this.rgbRow = CsvSelectColorDialog.this.rgbArray[this.index];
        }
    }

    class ColorMouseListener
    implements MouseListener {
        private int index;

        public ColorMouseListener(int index) {
            this.index = index;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            CsvSelectColorDialog.this.labelSelected.setImage(CsvSelectColorDialog.this.imageArray[this.index]);
            CsvSelectColorDialog.this.labelSelected.pack();
            CsvSelectColorDialog.this.rgbRow = CsvSelectColorDialog.this.rgbArray[this.index];
        }
    }
}

