/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CsvSearchComposite
extends Composite {
    private CSVEditor csvEditor;
    private Text textSearch;
    private int[] searchIndices = null;
    private int currentSearchIndex = 0;
    private int currentColumnIndex = -1;
    private String currentSearchTerm = null;
    private Combo comboColumns;
    private Button buttonCase;
    private Button buttonExact;
    private Button buttonRegexp;
    private Button buttonNext;
    private Button buttonPrevious;
    private Button buttonCount;
    private boolean textExactField;
    private boolean textCaseField;
    private boolean textRegexpField;

    public CsvSearchComposite(Composite parent, int style, CSVEditor csvEditor) {
        super(parent, style);
        this.csvEditor = csvEditor;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        this.setLayout((Layout)layout);
        Label labelSearch = new Label((Composite)this, 0);
        labelSearch.setText("Search term:");
        GridData layoutData = new GridData();
        labelSearch.setLayoutData((Object)layoutData);
        this.textSearch = new Text((Composite)this, 2052);
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.textSearch.setLayoutData((Object)layoutData);
        Label labelColumn = new Label((Composite)this, 0);
        labelColumn.setText("In column:");
        layoutData = new GridData();
        labelColumn.setLayoutData((Object)layoutData);
        this.comboColumns = new Combo((Composite)this, 2060);
        this.comboColumns.setItems(csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true));
        layoutData = new GridData();
        this.comboColumns.setLayoutData((Object)layoutData);
        this.comboColumns.select(0);
        Group groupOptions = this.createOptionsGroup(this, 0);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = 20;
        groupOptions.setLayoutData((Object)layoutData);
        this.buttonPrevious = new Button((Composite)this, 8);
        this.buttonPrevious.setText("Find previous");
        layoutData = new GridData();
        layoutData.verticalIndent = 20;
        this.buttonPrevious.setLayoutData((Object)layoutData);
        this.buttonNext = new Button((Composite)this, 8);
        this.buttonNext.setText("Find next");
        layoutData = new GridData();
        layoutData.verticalIndent = 20;
        this.buttonNext.setLayoutData((Object)layoutData);
        this.buttonCount = new Button((Composite)this, 8);
        this.buttonCount.setText("Count");
        layoutData = new GridData();
        this.buttonCount.setLayoutData((Object)layoutData);
        this.addListeners();
    }

    public void setTextFocus() {
        this.textSearch.setFocus();
        this.textSearch.setSelection(0);
    }

    private Group createOptionsGroup(Composite parent, int style) {
        Group composite = new Group(parent, style);
        composite.setText("Search options");
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.buttonCase = new Button((Composite)composite, 32);
        this.buttonCase.setText("Case sensitive");
        this.buttonCase.setSelection(false);
        GridData layoutData = new GridData();
        this.buttonCase.setLayoutData((Object)layoutData);
        this.buttonExact = new Button((Composite)composite, 32);
        this.buttonExact.setText("Exact match");
        this.buttonExact.setSelection(false);
        layoutData = new GridData();
        this.buttonExact.setLayoutData((Object)layoutData);
        this.buttonRegexp = new Button((Composite)composite, 32);
        this.buttonRegexp.setText("Regular expression");
        this.buttonRegexp.setSelection(false);
        layoutData = new GridData();
        this.buttonRegexp.setLayoutData((Object)layoutData);
        return composite;
    }

    private void validate() {
    }

    private void addListeners() {
        this.textSearch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CsvSearchComposite.this.validate();
            }
        });
        this.buttonRegexp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvSearchComposite.this.buttonExact.setEnabled(true);
                if (CsvSearchComposite.this.buttonRegexp.getSelection()) {
                    CsvSearchComposite.this.buttonExact.setEnabled(false);
                }
            }
        });
        this.buttonPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CsvSearchComposite.this.textSearch.getText().isEmpty()) {
                    MessageDialog.openWarning((Shell)CsvSearchComposite.this.getShell(), (String)"Search and replace", (String)"Search term cannot be null");
                    return;
                }
                try {
                    CsvSearchComposite.this.findPrevious();
                }
                catch (PatternSyntaxException e1) {
                    MessageDialog.openWarning((Shell)CsvSearchComposite.this.getShell(), (String)"Search", (String)"Invalid search term");
                    return;
                }
                catch (InvocationTargetException e1) {
                    MessageDialog.openWarning((Shell)CsvSearchComposite.this.getShell(), (String)"Search", (String)"Invalid search term");
                    return;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.buttonNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CsvSearchComposite.this.textSearch.getText().isEmpty()) {
                    MessageDialog.openWarning((Shell)CsvSearchComposite.this.getShell(), (String)"Search and replace", (String)"Search term cannot be null");
                    return;
                }
                try {
                    CsvSearchComposite.this.findNext();
                }
                catch (PatternSyntaxException e1) {
                    MessageDialog.openWarning((Shell)CsvSearchComposite.this.getShell(), (String)"Search", (String)"Invalid search term");
                    return;
                }
                catch (InvocationTargetException e1) {
                    MessageDialog.openWarning((Shell)CsvSearchComposite.this.getShell(), (String)"Search", (String)"Invalid search term");
                    return;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.buttonCount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CsvSearchComposite.this.textSearch.getText().isEmpty()) {
                    MessageDialog.openWarning((Shell)CsvSearchComposite.this.getShell(), (String)"Search and replace", (String)"Search term cannot be null");
                    return;
                }
                try {
                    CsvSearchComposite.this.countMatches();
                }
                catch (PatternSyntaxException e1) {
                    MessageDialog.openWarning((Shell)CsvSearchComposite.this.getShell(), (String)"Search", (String)"Invalid search term");
                    return;
                }
                catch (InvocationTargetException e1) {
                    MessageDialog.openWarning((Shell)CsvSearchComposite.this.getShell(), (String)"Search", (String)"Invalid search term");
                    return;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    public int[] getSearchIndices() {
        return this.searchIndices;
    }

    private void countMatches() throws PatternSyntaxException, InvocationTargetException, InterruptedException {
        this.csvEditor.deselectAll();
        this.verifyRefreshIndices();
        this.currentSearchIndex = -1;
        if (this.searchIndices.length < 1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Search and count", (String)"Term not found");
            return;
        }
        this.csvEditor.selectRows(this.searchIndices);
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Search and count", (String)(new DecimalFormat("###,###").format(this.searchIndices.length) + " matches found."));
    }

    private void findNext() throws PatternSyntaxException, InvocationTargetException, InterruptedException {
        this.csvEditor.deselectAll();
        this.verifyRefreshIndices();
        if (this.currentSearchIndex >= this.searchIndices.length - 1) {
            this.currentSearchIndex = -1;
        }
        if (this.searchIndices.length < 1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Search", (String)"Term not found");
            return;
        }
        this.csvEditor.selectRows(new int[]{this.searchIndices[++this.currentSearchIndex]});
    }

    private void findPrevious() throws PatternSyntaxException, InvocationTargetException, InterruptedException {
        this.csvEditor.deselectAll();
        this.verifyRefreshIndices();
        if (this.currentSearchIndex <= 0) {
            this.currentSearchIndex = this.searchIndices.length;
        }
        if (this.searchIndices.length < 1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Search", (String)"Term not found");
            return;
        }
        this.csvEditor.selectRows(new int[]{this.searchIndices[--this.currentSearchIndex]});
    }

    private void verifyRefreshIndices() throws PatternSyntaxException, InvocationTargetException, InterruptedException {
        if (this.currentSearchTerm == null || !this.currentSearchTerm.equals(this.textSearch.getText()) || this.currentColumnIndex != this.comboColumns.getSelectionIndex() || this.textExactField != this.buttonExact.getSelection() || this.textCaseField != this.buttonCase.getSelection() || this.textRegexpField != this.buttonRegexp.getSelection()) {
            this.currentSearchTerm = this.textSearch.getText();
            this.textExactField = this.buttonExact.getSelection();
            this.textCaseField = this.buttonCase.getSelection();
            this.textRegexpField = this.buttonRegexp.getSelection();
            this.currentColumnIndex = this.comboColumns.getSelectionIndex();
            this.updateSearchIndices();
            this.currentSearchIndex = this.searchIndices.length;
        }
    }

    private void updateSearchIndices() throws PatternSyntaxException, InvocationTargetException, InterruptedException {
        String columnName = this.comboColumns.getItem(this.comboColumns.getSelectionIndex());
        final int columnModelIndex = this.csvEditor.getColumnIndexForName(columnName);
        new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                CsvSearchComposite.this.searchIndices = CsvSearchComposite.this.csvEditor.searchTerm(CsvSearchComposite.this.textSearch.getText(), columnModelIndex, CsvSearchComposite.this.buttonExact.getSelection(), CsvSearchComposite.this.buttonCase.getSelection(), CsvSearchComposite.this.buttonRegexp.getSelection());
            }
        });
    }

    public boolean forceFocus() {
        this.textSearch.setSelection(0);
        return this.textSearch.setFocus();
    }
}

