/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csvUtils.WorksheetUtils;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import com.biotechvana.fileExplorerBasic.actions.FileExplorerRefreshAction;
import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;

public class CsvScoreFilteringDialog
extends TitleAreaDialog {
    private static final String SHELL_TEXT = "Transcriptome post-processing";
    public static final String TITLE = "Filter best isoform";
    public static final String MESSAGE = "Select required columns for score computation and position filtering for statistically discerning the isoform closest to the reference";
    private final String labelColumnIdString = "Sequence/Hit identifier column:";
    private final String labelColumnHSPQueryString = "HSP query column:";
    private final String buttonCheckUseHSPQueryString = "Use HSP query";
    private final String labelColumnHSPHitString = "HSP hit column:";
    private final String buttonCheckUseHSPHitString = "Use HSP hit";
    private final String labelColumnSimilarityString = "Similarity column:";
    private final String buttonCheckUseSimilarityString = "Use similarity";
    private final String labelColumnEValueString = "E-value column:";
    private final String buttonCheckUseEValueString = "Use E-value";
    private final String labelColumnDepthString = "Depth column:";
    private final String buttonCheckUseDepthString = "Use depth";
    private final String labelCaseSensitiveString = "Case sensitive";
    private final String labelSelectAll = "Select all filters";
    private final String labelParametersExplanationTextString = "Choose which parameters you want to use to score\nand filter sequences. Unchecked fields will not be\nused and will be given the value 1 in the formula below:";
    private final String groupPositionRedundancyFilterString = "Position redundancy filtering";
    private final String labelColumnSubjectFromString = "Subject from column:";
    private final String labelColumnSubjectToString = "Subject to column:";
    private final String buttonCheckUsePositionsString = "Filter by region overlap";
    private final String labelPositionRedundancyExplanationTextString = "By applying this filter you can detect all non-overlapping (by position) \nregions of a cDNA and select the best isoform within each one of \nthese regions.";
    private final String errorMessageNothingChecked = "Please, select at least one criterion to use for score filtering.";
    private final String errorMessageHSPQueryColumnUnselected = "Please, choose a column for \u201cHSP query\u201d or uncheck it.";
    private final String errorMessageHSPHitColumnUnselected = "Please, choose a column for \u201cHSP hit\u201d or uncheck it.";
    private final String errorMessageSimilarityColumnUnselected = "Please, choose a column for \u201cSimilarity\u201d or uncheck it.";
    private final String errorMessageEValueColumnUnselected = "Please, choose a column for \u201cE-value\u201d or uncheck it.";
    private final String errorMessageDepthColumnUnselected = "Please, choose a column for \u201cDepth\u201d or uncheck it.";
    private final String errorMessageSubjectFromColumnUnselected = "Please, choose a column for \u201cSubject from\u201d or uncheck it.";
    private final String errorMessageSubjectToColumnUnselected = "Please, choose a column for \u201cSubject to\u201d or uncheck it.";
    private final String errorMessageHSPQueryColumnData = "The column for \u201cHSP query\u201d contains non-numerical data.Please, choose another column or correct the affected rows.";
    private final String errorMessageHSPHitColumnData = "The column for \u201cHSP hit\u201d contains non-numerical data.Please, choose another column or correct the affected rows.";
    private final String errorMessageSimilarityColumnData = "The column for \u201cSimilarity\u201d contains non-numerical data.Please, choose another column or correct the affected rows.";
    private final String errorMessageEValueColumnData = "The column for \u201cE-value\u201d contains non-numerical data.Please, choose another column or correct the affected rows.";
    private final String errorMessageDepthColumnData = "The column for \u201cDepth\u201d contains non-integer data.Please, choose another column or correct the affected rows.";
    private final String errorMessageSubjectFromColumnData = "The column for \u201cSubject from\u201d contains non-integer data.Please, choose another column or correct the affected rows.";
    private final String errorMessageSubjectToColumnData = "The column for \u201cSubject from\u201d contains non-integer data.Please, choose another column or correct the affected rows.";
    private Composite compositeParameterColumns;
    private Label labelColumnId;
    private Combo comboColumnId;
    private Button buttonCaseSensitive;
    private Label labelColumnHSPQuery;
    private Combo comboColumnHSPQuery;
    private Button buttonCheckUseHSPQuery;
    private Label labelColumnHSPHit;
    private Combo comboColumnHSPHit;
    private Button buttonCheckUseHSPHit;
    private Label labelColumnSimilarity;
    private Combo comboColumnSimilarity;
    private Button buttonCheckUseSimilarity;
    private Label labelColumnEValue;
    private Combo comboColumnEValue;
    private Button buttonCheckUseEValue;
    private Label labelColumnDepth;
    private Combo comboColumnDepth;
    private Button buttonCheckUseDepth;
    private Button buttonCheckAll;
    private Composite compositeParameterColumnsExplanation;
    private Label labelParametersExplanationText;
    private Label labelParametersFormulaImage;
    private Image imageFormula;
    private Composite compositePositionRedundancyFilter;
    private Group groupPositionRedundancyFilter;
    private Label labelColumnSubjectFrom;
    private Combo comboColumnSubjectFrom;
    private Label labelColumnSubjectTo;
    private Combo comboColumnSubjectTo;
    private Button buttonCheckUsePositions;
    private Composite compositePositionRedundancyExplanation;
    private Label labelPositionRedundancyExplanationText;
    private CSVEditor csvEditor;
    private int hspQueryColumnIndex;
    private int hspHitColumnIndex;
    private int similarityColumnIndex;
    private int eValueColumnIndex;
    private int depthColumnIndex;
    private int subjectFromColumnIndex;
    private int subjectToColumnIndex;
    private String scoreColumnName = "Post-processing score";
    private String[] allColumnNames;
    private boolean caseSensitive;

    public CsvScoreFilteringDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
        this.allColumnNames = csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        composite.setLayout((Layout)layout);
        GridData layoutData = null;
        this.compositeParameterColumns = new Composite(composite, 0);
        GridLayout layoutComposite = new GridLayout(3, false);
        this.compositeParameterColumns.setLayout((Layout)layoutComposite);
        layoutData = new GridData(16384, 128, false, false);
        this.compositeParameterColumns.setLayoutData((Object)layoutData);
        this.labelColumnId = new Label(this.compositeParameterColumns, 0);
        this.labelColumnId.setText("Sequence/Hit identifier column:");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.labelColumnId.setLayoutData((Object)layoutData);
        this.comboColumnId = new Combo(this.compositeParameterColumns, 2056);
        this.comboColumnId.setItems(this.allColumnNames);
        this.comboColumnId.setText(this.allColumnNames[0]);
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.comboColumnId.setLayoutData((Object)layoutData);
        this.buttonCaseSensitive = new Button(this.compositeParameterColumns, 32);
        this.buttonCaseSensitive.setText("Case sensitive");
        this.buttonCaseSensitive.setSelection(false);
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.buttonCaseSensitive.setLayoutData((Object)layoutData);
        this.labelColumnHSPQuery = new Label(this.compositeParameterColumns, 0);
        this.labelColumnHSPQuery.setText("HSP query column:");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        layoutData.verticalIndent = 20;
        this.labelColumnHSPQuery.setLayoutData((Object)layoutData);
        this.comboColumnHSPQuery = new Combo(this.compositeParameterColumns, 2056);
        this.comboColumnHSPQuery.setItems(this.allColumnNames);
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        layoutData.verticalIndent = 20;
        this.comboColumnHSPQuery.setLayoutData((Object)layoutData);
        this.comboColumnHSPQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CsvScoreFilteringDialog.this.hspQueryColumnIndex = CsvScoreFilteringDialog.this.comboColumnHSPQuery.getSelectionIndex();
            }
        });
        this.buttonCheckUseHSPQuery = new Button(this.compositeParameterColumns, 32);
        this.buttonCheckUseHSPQuery.setText("Use HSP query");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        layoutData.verticalIndent = 20;
        this.buttonCheckUseHSPQuery.setLayoutData((Object)layoutData);
        this.labelColumnHSPHit = new Label(this.compositeParameterColumns, 0);
        this.labelColumnHSPHit.setText("HSP hit column:");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.labelColumnHSPHit.setLayoutData((Object)layoutData);
        this.comboColumnHSPHit = new Combo(this.compositeParameterColumns, 2056);
        this.comboColumnHSPHit.setItems(this.allColumnNames);
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.comboColumnHSPHit.setLayoutData((Object)layoutData);
        this.comboColumnHSPHit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CsvScoreFilteringDialog.this.hspHitColumnIndex = CsvScoreFilteringDialog.this.comboColumnHSPHit.getSelectionIndex();
            }
        });
        this.buttonCheckUseHSPHit = new Button(this.compositeParameterColumns, 32);
        this.buttonCheckUseHSPHit.setText("Use HSP hit");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.buttonCheckUseHSPHit.setLayoutData((Object)layoutData);
        this.labelColumnSimilarity = new Label(this.compositeParameterColumns, 0);
        this.labelColumnSimilarity.setText("Similarity column:");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.labelColumnSimilarity.setLayoutData((Object)layoutData);
        this.comboColumnSimilarity = new Combo(this.compositeParameterColumns, 2056);
        this.comboColumnSimilarity.setItems(this.allColumnNames);
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.comboColumnSimilarity.setLayoutData((Object)layoutData);
        this.comboColumnSimilarity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CsvScoreFilteringDialog.this.similarityColumnIndex = CsvScoreFilteringDialog.this.comboColumnSimilarity.getSelectionIndex();
            }
        });
        this.buttonCheckUseSimilarity = new Button(this.compositeParameterColumns, 32);
        this.buttonCheckUseSimilarity.setText("Use similarity");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.buttonCheckUseSimilarity.setLayoutData((Object)layoutData);
        this.labelColumnEValue = new Label(this.compositeParameterColumns, 0);
        this.labelColumnEValue.setText("E-value column:");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.labelColumnEValue.setLayoutData((Object)layoutData);
        this.comboColumnEValue = new Combo(this.compositeParameterColumns, 2056);
        this.comboColumnEValue.setItems(this.allColumnNames);
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.comboColumnEValue.setLayoutData((Object)layoutData);
        this.comboColumnEValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CsvScoreFilteringDialog.this.eValueColumnIndex = CsvScoreFilteringDialog.this.comboColumnEValue.getSelectionIndex();
            }
        });
        this.buttonCheckUseEValue = new Button(this.compositeParameterColumns, 32);
        this.buttonCheckUseEValue.setText("Use E-value");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.buttonCheckUseEValue.setLayoutData((Object)layoutData);
        this.labelColumnDepth = new Label(this.compositeParameterColumns, 0);
        this.labelColumnDepth.setText("Depth column:");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.labelColumnDepth.setLayoutData((Object)layoutData);
        this.comboColumnDepth = new Combo(this.compositeParameterColumns, 2056);
        this.comboColumnDepth.setItems(this.allColumnNames);
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.comboColumnDepth.setLayoutData((Object)layoutData);
        this.comboColumnDepth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CsvScoreFilteringDialog.this.depthColumnIndex = CsvScoreFilteringDialog.this.comboColumnDepth.getSelectionIndex();
            }
        });
        this.buttonCheckUseDepth = new Button(this.compositeParameterColumns, 32);
        this.buttonCheckUseDepth.setText("Use depth");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.buttonCheckUseDepth.setLayoutData((Object)layoutData);
        new Label(this.compositeParameterColumns, 0);
        new Label(this.compositeParameterColumns, 0);
        this.buttonCheckAll = new Button(this.compositeParameterColumns, 32);
        this.buttonCheckAll.setText("Select all filters");
        this.buttonCheckAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = false;
                if (CsvScoreFilteringDialog.this.buttonCheckAll.getSelection()) {
                    selected = true;
                }
                CsvScoreFilteringDialog.this.buttonCheckUseHSPQuery.setSelection(selected);
                CsvScoreFilteringDialog.this.buttonCheckUseHSPHit.setSelection(selected);
                CsvScoreFilteringDialog.this.buttonCheckUseSimilarity.setSelection(selected);
                CsvScoreFilteringDialog.this.buttonCheckUseEValue.setSelection(selected);
                CsvScoreFilteringDialog.this.buttonCheckUseDepth.setSelection(selected);
            }
        });
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        layoutData.verticalIndent = 10;
        this.buttonCheckAll.setLayoutData((Object)layoutData);
        this.compositeParameterColumnsExplanation = new Composite(composite, 0);
        layoutComposite = new GridLayout(1, false);
        this.compositeParameterColumnsExplanation.setLayout((Layout)layoutComposite);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalIndent = 20;
        this.compositeParameterColumnsExplanation.setLayoutData((Object)layoutData);
        this.labelParametersExplanationText = new Label(this.compositeParameterColumnsExplanation, 0);
        this.labelParametersExplanationText.setText("Choose which parameters you want to use to score\nand filter sequences. Unchecked fields will not be\nused and will be given the value 1 in the formula below:");
        layoutData = new GridData();
        this.labelParametersExplanationText.setLayoutData((Object)layoutData);
        this.imageFormula = new Image((Device)parent.getDisplay(), Thread.currentThread().getContextClassLoader().getResourceAsStream("isoforms_score_formula.png"));
        this.labelParametersFormulaImage = new Label(this.compositeParameterColumnsExplanation, 0);
        this.labelParametersFormulaImage.setImage(this.imageFormula);
        layoutData = new GridData();
        layoutData.verticalIndent = 10;
        this.labelParametersFormulaImage.setLayoutData((Object)layoutData);
        this.labelParametersFormulaImage.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                CsvScoreFilteringDialog.this.labelParametersFormulaImage.dispose();
            }
        });
        this.compositePositionRedundancyFilter = new Composite(composite, 0);
        layoutComposite = new GridLayout(3, false);
        this.compositePositionRedundancyFilter.setLayout((Layout)layoutComposite);
        layoutData = new GridData(16384, 128, false, false);
        layoutData.verticalIndent = 20;
        this.compositePositionRedundancyFilter.setLayoutData((Object)layoutData);
        this.groupPositionRedundancyFilter = new Group(this.compositePositionRedundancyFilter, 2048);
        this.groupPositionRedundancyFilter.setText("Position redundancy filtering");
        GridLayout layoutGroup = new GridLayout(2, false);
        layoutGroup.marginHeight = 10;
        layoutGroup.marginWidth = 10;
        this.groupPositionRedundancyFilter.setLayout((Layout)layoutGroup);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        this.groupPositionRedundancyFilter.setLayoutData((Object)layoutData);
        this.labelColumnSubjectFrom = new Label((Composite)this.groupPositionRedundancyFilter, 0);
        this.labelColumnSubjectFrom.setText("Subject from column:");
        this.labelColumnSubjectFrom.setEnabled(false);
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.labelColumnSubjectFrom.setLayoutData((Object)layoutData);
        this.comboColumnSubjectFrom = new Combo((Composite)this.groupPositionRedundancyFilter, 2056);
        this.comboColumnSubjectFrom.setItems(this.allColumnNames);
        this.comboColumnSubjectFrom.setEnabled(false);
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.comboColumnSubjectFrom.setLayoutData((Object)layoutData);
        this.comboColumnSubjectFrom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CsvScoreFilteringDialog.this.subjectFromColumnIndex = CsvScoreFilteringDialog.this.comboColumnSubjectFrom.getSelectionIndex();
            }
        });
        this.labelColumnSubjectTo = new Label((Composite)this.groupPositionRedundancyFilter, 0);
        this.labelColumnSubjectTo.setText("Subject to column:");
        this.labelColumnSubjectTo.setEnabled(false);
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.labelColumnSubjectTo.setLayoutData((Object)layoutData);
        this.comboColumnSubjectTo = new Combo((Composite)this.groupPositionRedundancyFilter, 2056);
        this.comboColumnSubjectTo.setItems(this.allColumnNames);
        this.comboColumnSubjectTo.setEnabled(false);
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.comboColumnSubjectTo.setLayoutData((Object)layoutData);
        this.comboColumnSubjectTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CsvScoreFilteringDialog.this.subjectToColumnIndex = CsvScoreFilteringDialog.this.comboColumnSubjectTo.getSelectionIndex();
            }
        });
        this.buttonCheckUsePositions = new Button(this.compositePositionRedundancyFilter, 32);
        this.buttonCheckUsePositions.setText("Filter by region overlap");
        layoutData = new GridData(768);
        layoutData.verticalAlignment = 0x1000000;
        layoutData.horizontalAlignment = 131072;
        layoutData.horizontalSpan = 1;
        layoutData.verticalIndent = 20;
        this.buttonCheckUsePositions.setLayoutData((Object)layoutData);
        this.buttonCheckUsePositions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (CsvScoreFilteringDialog.this.buttonCheckUsePositions.getSelection()) {
                    CsvScoreFilteringDialog.this.labelColumnSubjectFrom.setEnabled(true);
                    CsvScoreFilteringDialog.this.comboColumnSubjectFrom.setEnabled(true);
                    CsvScoreFilteringDialog.this.labelColumnSubjectTo.setEnabled(true);
                    CsvScoreFilteringDialog.this.comboColumnSubjectTo.setEnabled(true);
                } else {
                    CsvScoreFilteringDialog.this.labelColumnSubjectFrom.setEnabled(false);
                    CsvScoreFilteringDialog.this.comboColumnSubjectFrom.setEnabled(false);
                    CsvScoreFilteringDialog.this.labelColumnSubjectTo.setEnabled(false);
                    CsvScoreFilteringDialog.this.comboColumnSubjectTo.setEnabled(false);
                }
            }
        });
        this.compositePositionRedundancyExplanation = new Composite(composite, 0);
        layoutComposite = new GridLayout(1, false);
        this.compositePositionRedundancyExplanation.setLayout((Layout)layoutComposite);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalIndent = 20;
        layoutData.verticalIndent = 20;
        this.compositePositionRedundancyExplanation.setLayoutData((Object)layoutData);
        this.labelPositionRedundancyExplanationText = new Label(this.compositePositionRedundancyExplanation, 0);
        this.labelPositionRedundancyExplanationText.setText("By applying this filter you can detect all non-overlapping (by position) \nregions of a cDNA and select the best isoform within each one of \nthese regions.");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        this.labelPositionRedundancyExplanationText.setLayoutData((Object)layoutData);
        this.initDialog();
        return compositeParent;
    }

    private void initDialog() {
        this.getShell().setText(SHELL_TEXT);
        this.setTitle(TITLE);
        this.setMessage(MESSAGE);
        this.init();
    }

    public int open() {
        return super.open();
    }

    public void create() {
        super.create();
    }

    public boolean validate() {
        this.setErrorMessage(null);
        this.hspQueryColumnIndex = this.getComboSelectedColumnIndex(this.comboColumnHSPQuery);
        this.hspHitColumnIndex = this.getComboSelectedColumnIndex(this.comboColumnHSPHit);
        this.similarityColumnIndex = this.getComboSelectedColumnIndex(this.comboColumnSimilarity);
        this.eValueColumnIndex = this.getComboSelectedColumnIndex(this.comboColumnEValue);
        this.depthColumnIndex = this.getComboSelectedColumnIndex(this.comboColumnDepth);
        this.subjectFromColumnIndex = this.getComboSelectedColumnIndex(this.comboColumnSubjectFrom);
        this.subjectToColumnIndex = this.getComboSelectedColumnIndex(this.comboColumnSubjectTo);
        if (!(this.buttonCheckUseHSPQuery.getSelection() || this.buttonCheckUseHSPHit.getSelection() || this.buttonCheckUseSimilarity.getSelection() || this.buttonCheckUseEValue.getSelection() || this.buttonCheckUseDepth.getSelection())) {
            this.setErrorMessage("Please, select at least one criterion to use for score filtering.");
            return false;
        }
        if (this.buttonCheckUseHSPQuery.getSelection()) {
            if (this.hspQueryColumnIndex == -1) {
                this.setErrorMessage("Please, choose a column for \u201cHSP query\u201d or uncheck it.");
                return false;
            }
            if (this.csvEditor.getEditorUtils2().hasAlphabeticalValuesInColumn(this.hspQueryColumnIndex) >= 0) {
                this.setErrorMessage("The column for \u201cHSP query\u201d contains non-numerical data.Please, choose another column or correct the affected rows.");
                return false;
            }
        }
        if (this.buttonCheckUseHSPHit.getSelection()) {
            if (this.hspHitColumnIndex == -1) {
                this.setErrorMessage("Please, choose a column for \u201cHSP hit\u201d or uncheck it.");
                return false;
            }
            if (this.csvEditor.getEditorUtils2().hasAlphabeticalValuesInColumn(this.hspHitColumnIndex) >= 0) {
                this.setErrorMessage("The column for \u201cHSP hit\u201d contains non-numerical data.Please, choose another column or correct the affected rows.");
                return false;
            }
        }
        if (this.buttonCheckUseSimilarity.getSelection()) {
            if (this.similarityColumnIndex == -1) {
                this.setErrorMessage("Please, choose a column for \u201cSimilarity\u201d or uncheck it.");
                return false;
            }
            if (this.csvEditor.getEditorUtils2().hasAlphabeticalValuesInColumn(this.similarityColumnIndex) >= 0) {
                this.setErrorMessage("The column for \u201cSimilarity\u201d contains non-numerical data.Please, choose another column or correct the affected rows.");
                return false;
            }
        }
        if (this.buttonCheckUseEValue.getSelection()) {
            if (this.eValueColumnIndex == -1) {
                this.setErrorMessage("Please, choose a column for \u201cE-value\u201d or uncheck it.");
                return false;
            }
            if (this.csvEditor.getEditorUtils2().hasAlphabeticalValuesInColumn(this.eValueColumnIndex) >= 0) {
                this.setErrorMessage("The column for \u201cE-value\u201d contains non-numerical data.Please, choose another column or correct the affected rows.");
                return false;
            }
        }
        if (this.buttonCheckUseDepth.getSelection()) {
            if (this.depthColumnIndex == -1) {
                this.setErrorMessage("Please, choose a column for \u201cDepth\u201d or uncheck it.");
                return false;
            }
            if (this.csvEditor.getEditorUtils2().hasAlphabeticalValuesInColumn(this.depthColumnIndex) >= 0) {
                this.setErrorMessage("The column for \u201cDepth\u201d contains non-integer data.Please, choose another column or correct the affected rows.");
                return false;
            }
        }
        if (this.buttonCheckUsePositions.getSelection()) {
            if (this.subjectFromColumnIndex == -1) {
                this.setErrorMessage("Please, choose a column for \u201cSubject from\u201d or uncheck it.");
                return false;
            }
            if (this.csvEditor.getEditorUtils2().hasAlphabeticalValuesInColumn(this.subjectFromColumnIndex) >= 0) {
                this.setErrorMessage("The column for \u201cSubject from\u201d contains non-integer data.Please, choose another column or correct the affected rows.");
                return false;
            }
            if (this.subjectToColumnIndex == -1) {
                this.setErrorMessage("Please, choose a column for \u201cSubject to\u201d or uncheck it.");
                return false;
            }
            if (this.csvEditor.getEditorUtils2().hasAlphabeticalValuesInColumn(this.subjectToColumnIndex) >= 0) {
                this.setErrorMessage("The column for \u201cSubject from\u201d contains non-integer data.Please, choose another column or correct the affected rows.");
                return false;
            }
        }
        this.caseSensitive = this.buttonCaseSensitive.getSelection();
        return true;
    }

    protected void okPressed() {
        block47: {
            CsvReader csvReaderTemp;
            CsvWriter csvWriterScoreFiltered;
            block48: {
                File tmpCSVFile;
                CsvWriter copyCSVWriter;
                List<String> columnNames;
                block45: {
                    block46: {
                        if (!this.validate()) {
                            return;
                        }
                        int rowCount = ((List)this.csvEditor.getModel()).size();
                        ArrayList<Integer> rowIndices = new ArrayList<Integer>(rowCount);
                        int i = 0;
                        while (i < rowCount) {
                            rowIndices.add(i);
                            ++i;
                        }
                        columnNames = this.csvEditor.getEditorUtils2().getColumnNamesAsList(true, false, false);
                        copyCSVWriter = null;
                        csvWriterScoreFiltered = null;
                        csvReaderTemp = null;
                        tmpCSVFile = File.createTempFile("gpro_", null);
                        copyCSVWriter = new CsvWriter(tmpCSVFile.getAbsolutePath(), ';', Charset.defaultCharset());
                        columnNames.add(this.scoreColumnName);
                        copyCSVWriter.writeRecord(columnNames.toArray(new String[0]));
                        for (List originalCSVLineList : (List)this.csvEditor.getModel()) {
                            double hspQuery = 100.0;
                            double hspHit = 100.0;
                            double similarity = 100.0;
                            double eValue = 1.0;
                            int depth = 1;
                            if (this.hspQueryColumnIndex != -1 && !((String)originalCSVLineList.get(this.hspQueryColumnIndex)).trim().isEmpty()) {
                                hspQuery = Double.parseDouble(WorksheetUtils.parseHspQueryColValue((String)((String)originalCSVLineList.get(this.hspQueryColumnIndex))));
                            }
                            if (this.hspHitColumnIndex != -1 && !((String)originalCSVLineList.get(this.hspHitColumnIndex)).trim().isEmpty()) {
                                hspHit = Double.parseDouble(WorksheetUtils.parseHspHitColValue((String)((String)originalCSVLineList.get(this.hspHitColumnIndex))));
                            }
                            if (this.similarityColumnIndex != -1 && !((String)originalCSVLineList.get(this.similarityColumnIndex)).trim().isEmpty()) {
                                similarity = Double.parseDouble(WorksheetUtils.parseSimilarityColValue((String)((String)originalCSVLineList.get(this.similarityColumnIndex))));
                            }
                            if (this.eValueColumnIndex != -1 && !((String)originalCSVLineList.get(this.eValueColumnIndex)).trim().isEmpty()) {
                                eValue = Double.parseDouble(WorksheetUtils.parseEvalueColValue((String)((String)originalCSVLineList.get(this.eValueColumnIndex))));
                            }
                            originalCSVLineList.add(Double.toString(this.computeScore(hspQuery, hspHit, similarity, eValue, depth)));
                            copyCSVWriter.writeRecord(originalCSVLineList.subList(2, originalCSVLineList.size()).toArray(new String[0]));
                        }
                        copyCSVWriter.flush();
                        csvReaderTemp = new CsvReader(tmpCSVFile.getAbsolutePath(), ';', Charset.defaultCharset());
                        if (csvReaderTemp.readHeaders()) break block45;
                        if (copyCSVWriter == null) break block46;
                        copyCSVWriter.close();
                    }
                    if (csvWriterScoreFiltered != null) {
                        csvWriterScoreFiltered.close();
                    }
                    if (csvReaderTemp != null) {
                        csvReaderTemp.close();
                    }
                    return;
                }
                try {
                    int intCSVScoreBlastColumnIndex = csvReaderTemp.getIndex("Score");
                    if (intCSVScoreBlastColumnIndex == -1) {
                        intCSVScoreBlastColumnIndex = csvReaderTemp.getIndex("score");
                    }
                    int intCSVSubjectFromColumnIndex = -1;
                    int intCSVSubjectToColumnIndex = -1;
                    if (this.buttonCheckUsePositions.getSelection()) {
                        intCSVSubjectFromColumnIndex = csvReaderTemp.getIndex(this.comboColumnSubjectFrom.getText());
                        intCSVSubjectToColumnIndex = csvReaderTemp.getIndex(this.comboColumnSubjectTo.getText());
                    }
                    Map<String, List<String[]>> idToSortedCSVRowsMap = this.sortColumnScore(tmpCSVFile, this.comboColumnId.getText(), this.scoreColumnName);
                    int columnIdIndex = 0;
                    int i = 0;
                    while (i < columnNames.size()) {
                        if (columnNames.get(i).equals(this.comboColumnId.getText())) {
                            columnIdIndex = i;
                        }
                        ++i;
                    }
                    File originalCsvFile = this.csvEditor.getCsvFile();
                    String csvFilePath = FilenameUtils.getFullPath((String)this.csvEditor.getCsvFile().getAbsolutePath());
                    String csvFileNameWithoutExtension = FilenameUtils.removeExtension((String)originalCsvFile.getName());
                    String csvFileNameExtension = FilenameUtils.getExtension((String)originalCsvFile.getName());
                    File copyCSVFile = null;
                    copyCSVFile = csvFileNameExtension.trim().isEmpty() ? new File(csvFilePath + csvFileNameWithoutExtension + ".scored") : new File(csvFilePath + csvFileNameWithoutExtension + ".scored." + csvFileNameExtension);
                    csvWriterScoreFiltered = new CsvWriter(copyCSVFile.getAbsolutePath(), ';', Charset.defaultCharset());
                    Map<String, String> comments = this.csvEditor.getCommentsAsMap(false);
                    if (comments != null) {
                        String topIsoformFile = this.csvEditor.getCsvFile().getAbsolutePath();
                        String topIsoformColumns = "";
                        if (topIsoformFile != null && topIsoformFile.length() > 0) {
                            csvWriterScoreFiltered.writeComment("isoformFile=" + topIsoformFile);
                        } else {
                            csvWriterScoreFiltered.writeComment("isoformFile=" + originalCsvFile.getAbsolutePath());
                        }
                        if (topIsoformColumns != null && topIsoformColumns.length() > 0) {
                            csvWriterScoreFiltered.writeComment("isoformColumns=" + topIsoformColumns + columnIdIndex + ",");
                        } else {
                            csvWriterScoreFiltered.writeComment("isoformColumns=" + columnIdIndex + ",");
                        }
                    } else {
                        csvWriterScoreFiltered.writeComment("isoformFile=" + originalCsvFile.getAbsolutePath());
                        csvWriterScoreFiltered.writeComment("isoformColumns=" + columnIdIndex + ",");
                    }
                    csvWriterScoreFiltered.writeComment("isoformFilterOverlapping=" + String.valueOf(this.buttonCheckUsePositions.getSelection()));
                    if (this.buttonCheckUseHSPQuery.getSelection() && this.comboColumnHSPQuery.getSelectionIndex() != -1) {
                        csvWriterScoreFiltered.writeComment("isoformHspQueryColumn=" + this.comboColumnHSPQuery.getSelectionIndex());
                    }
                    if (this.buttonCheckUseHSPHit.getSelection() && this.comboColumnHSPHit.getSelectionIndex() != -1) {
                        csvWriterScoreFiltered.writeComment("isoformHspHitColumn=" + this.comboColumnHSPHit.getSelectionIndex());
                    }
                    if (this.buttonCheckUseSimilarity.getSelection() && this.comboColumnSimilarity.getSelectionIndex() != -1) {
                        csvWriterScoreFiltered.writeComment("isoformSimilarityColumn=" + this.comboColumnSimilarity.getSelectionIndex());
                    }
                    if (this.buttonCheckUseEValue.getSelection() && this.comboColumnEValue.getSelectionIndex() != -1) {
                        csvWriterScoreFiltered.writeComment("isoformEvalueColumn=" + this.comboColumnEValue.getSelectionIndex());
                    }
                    if (this.buttonCheckUseDepth.getSelection() && this.comboColumnDepth.getSelectionIndex() != -1) {
                        csvWriterScoreFiltered.writeComment("isoformDepthColumn=" + this.comboColumnDepth.getSelectionIndex());
                    }
                    csvWriterScoreFiltered.writeRecord(columnNames.toArray(new String[0]));
                    if (idToSortedCSVRowsMap.get("") != null) {
                        for (String[] emptyIdCSVRow : idToSortedCSVRowsMap.get("")) {
                            csvWriterScoreFiltered.writeRecord(emptyIdCSVRow);
                        }
                    }
                    for (String id : idToSortedCSVRowsMap.keySet()) {
                        if (id.equals("")) continue;
                        if (this.buttonCheckUsePositions.getSelection()) {
                            List<String[]> refiltered = this.filterOverlap4(id, idToSortedCSVRowsMap.get(id), 0.0, intCSVScoreBlastColumnIndex, intCSVSubjectFromColumnIndex, intCSVSubjectToColumnIndex);
                            for (String[] refilteredLine : refiltered) {
                                csvWriterScoreFiltered.writeRecord(refilteredLine);
                            }
                            continue;
                        }
                        List<String[]> currentIdRows = idToSortedCSVRowsMap.get(id);
                        csvWriterScoreFiltered.writeRecord(currentIdRows.get(currentIdRows.size() - 1));
                    }
                    csvWriterScoreFiltered.flush();
                }
                catch (FileNotFoundException exception) {
                    exception.printStackTrace();
                    if (copyCSVWriter != null) {
                        copyCSVWriter.close();
                    }
                    if (csvWriterScoreFiltered != null) {
                        csvWriterScoreFiltered.close();
                    }
                    if (csvReaderTemp != null) {
                        csvReaderTemp.close();
                    }
                    break block47;
                }
                catch (IOException exception) {
                    try {
                        exception.printStackTrace();
                        break block47;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (copyCSVWriter != null) {
                            copyCSVWriter.close();
                        }
                        if (csvWriterScoreFiltered != null) {
                            csvWriterScoreFiltered.close();
                        }
                        if (csvReaderTemp != null) {
                            csvReaderTemp.close();
                        }
                    }
                }
                if (copyCSVWriter == null) break block48;
                copyCSVWriter.close();
            }
            if (csvWriterScoreFiltered != null) {
                csvWriterScoreFiltered.close();
            }
            if (csvReaderTemp != null) {
                csvReaderTemp.close();
            }
        }
        IViewPart iViewPartFileExplorer = WorkspaceUtils.findView((String)FileExplorerBasic.ID);
        FileExplorerBasic fileExplorer = (FileExplorerBasic)iViewPartFileExplorer;
        new FileExplorerRefreshAction(fileExplorer).run();
        super.okPressed();
    }

    private int getComboSelectedColumnIndex(Combo combo) {
        if (combo.getSelectionIndex() == -1) {
            return -1;
        }
        return combo.getSelectionIndex() + 2;
    }

    private double computeScore(double hspQuery, double hspHit, double similarity, double eValue, int depth) {
        if (eValue == 0.0) {
            eValue = 1.0E-299;
        }
        return hspQuery * hspHit * similarity / 1000000.0 * (1.0 / eValue) * (double)depth;
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, List<String[]>> sortColumnScore(File file, String idColumnName, String scoreColumnName) throws IOException {
        csvReader = new CsvReader(file.getAbsolutePath(), ';', Charset.defaultCharset());
        if (csvReader.readHeaders()) {
            csvReader.getHeaders();
        }
        idColumnIndex = csvReader.getIndex(idColumnName);
        scoreColumnIndex = csvReader.getIndex(scoreColumnName);
        idColumnComparator = new Comparator<List<String>>(){

            @Override
            public int compare(List<String> o1, List<String> o2) {
                if (CsvScoreFilteringDialog.this.caseSensitive) {
                    return o1.get(idColumnIndex).compareTo(o2.get(idColumnIndex));
                }
                return o1.get(idColumnIndex).compareToIgnoreCase(o2.get(idColumnIndex));
            }
        };
        scoreColumnComparator = new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                double o2Score;
                if (o1[scoreColumnIndex].isEmpty() && o2[scoreColumnIndex].isEmpty()) {
                    return 0;
                }
                if (o1[scoreColumnIndex].isEmpty()) {
                    return -1;
                }
                if (o2[scoreColumnIndex].isEmpty()) {
                    return 1;
                }
                double o1Score = Double.parseDouble(WorksheetUtils.sanitizeDecimalNumberString((String)o1[scoreColumnIndex]));
                if (o1Score < (o2Score = Double.parseDouble(WorksheetUtils.sanitizeDecimalNumberString((String)o2[scoreColumnIndex])))) {
                    return -1;
                }
                if (o2Score < o1Score) {
                    return 1;
                }
                return 0;
            }
        };
        csvFileContents = new ArrayList<ArrayList<E>>();
        while (csvReader.readRecord()) {
            csvRowList = new ArrayList<String>(csvReader.getColumnCount());
            i = 0;
            while (i < csvReader.getColumnCount()) {
                csvRowList.add(csvReader.get(i));
                ++i;
            }
            csvFileContents.add(csvRowList);
        }
        Collections.sort(csvFileContents, idColumnComparator);
        idToLineListMap = new HashMap<String, List<String[]>>(csvFileContents.size());
        i = 0;
        while (i < csvFileContents.size()) {
            block7: {
                currentId = (String)((List)csvFileContents.get(i)).get(idColumnIndex);
                if (i > 0 && currentId.compareToIgnoreCase((String)((List)csvFileContents.get(i - 1)).get(idColumnIndex)) == 0) {
                    currentId = (String)((List)csvFileContents.get(i - 1)).get(idColumnIndex);
                }
                currentIdLines = new ArrayList<String[]>();
                j = i;
                if (!this.caseSensitive) ** GOTO lbl40
                while (j < csvFileContents.size() && ((String)((List)csvFileContents.get(j)).get(idColumnIndex)).equals(currentId)) {
                    currentIdLines.add(((List)csvFileContents.get(j)).toArray(new String[0]));
                    ++j;
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    currentIdLines.add(((List)csvFileContents.get(j)).toArray(new String[0]));
                    ++j;
lbl40:
                    // 2 sources

                    ** while (j < csvFileContents.size() && ((String)((List)csvFileContents.get((int)j)).get((int)idColumnIndex)).equalsIgnoreCase((String)currentId))
                }
            }
            i = j - 1;
            Collections.sort(currentIdLines, scoreColumnComparator);
            idToLineListMap.put(currentId.trim(), currentIdLines);
            ++i;
        }
        csvReader.close();
        return idToLineListMap;
    }

    @Deprecated
    private List<String[]> filterOverlap3(String groupName, List<String[]> rows, double overlapRatio, int scoreColumnIndex, final int subjectFromColumnIndex, final int subjectToColumnIndex) {
        ArrayList<String[]> filteredByOverlap = new ArrayList<String[]>();
        if (rows.size() == 1) {
            return rows;
        }
        boolean nonEmptyFound = false;
        for (String[] row : rows) {
            try {
                Double.parseDouble(WorksheetUtils.sanitizeDecimalNumberString((String)row[scoreColumnIndex]));
                nonEmptyFound = true;
            }
            catch (Exception ex) {
                System.out.println("bad value: " + row[scoreColumnIndex]);
            }
        }
        if (!nonEmptyFound) {
            filteredByOverlap.add(rows.get(0));
            return filteredByOverlap;
        }
        Collections.sort(rows, new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                Point point1 = WorksheetUtils.parseHitCoordinatesValue((String)o1[subjectFromColumnIndex], (String)o1[subjectToColumnIndex]);
                Point point2 = WorksheetUtils.parseHitCoordinatesValue((String)o2[subjectFromColumnIndex], (String)o2[subjectToColumnIndex]);
                if (point1 == null && point2 == null) {
                    return 0;
                }
                if (point1 == null) {
                    return -1;
                }
                if (point2 == null) {
                    return 1;
                }
                int start1 = point1.x;
                int start2 = point2.x;
                int end1 = point1.y;
                int end2 = point2.y;
                if (start1 > end1) {
                    start1 = end1;
                }
                if (start2 > end2) {
                    start2 = end2;
                }
                return start1 - start2;
            }
        });
        int currentIndex = 0;
        String[] currentRow = rows.get(currentIndex++);
        Point currentPoint = WorksheetUtils.parseHitCoordinatesValue((String)currentRow[subjectFromColumnIndex], (String)currentRow[subjectToColumnIndex]);
        double currentScore = 0.0;
        try {
            currentScore = Double.parseDouble(WorksheetUtils.parseScoreColValue((String)currentRow[scoreColumnIndex]));
        }
        catch (Exception exception) {}
        while (currentPoint == null) {
            currentRow = rows.get(currentIndex++);
            currentPoint = WorksheetUtils.parseHitCoordinatesValue((String)currentRow[subjectFromColumnIndex], (String)currentRow[subjectToColumnIndex]);
        }
        int currentEnd = currentPoint.y;
        currentScore = Double.parseDouble(WorksheetUtils.parseScoreColValue((String)currentRow[scoreColumnIndex]));
        while (currentIndex < rows.size()) {
            String[] row = rows.get(currentIndex++);
            Point pointRow = WorksheetUtils.parseHitCoordinatesValue((String)row[subjectFromColumnIndex], (String)row[subjectToColumnIndex]);
            int start = pointRow.x;
            int end = pointRow.y;
            double score = Double.parseDouble(WorksheetUtils.parseScoreColValue((String)row[scoreColumnIndex]));
            if (start <= currentEnd) {
                if (!(score > currentScore)) continue;
                currentRow = row;
                currentEnd = end;
                currentScore = score;
                continue;
            }
            filteredByOverlap.add(currentRow);
            currentRow = row;
            currentEnd = end;
            currentScore = score;
        }
        if (filteredByOverlap.add(currentRow)) {
            // empty if block
        }
        return filteredByOverlap;
    }

    /*
     * WARNING - void declaration
     */
    private List<String[]> filterOverlap4(String groupName, List<String[]> rows, double overlapRatio, int scoreColumnIndex, final int subjectFromColumnIndex, final int subjectToColumnIndex) {
        void var11_11;
        ArrayList<String[]> filteredByOverlap = new ArrayList<String[]>();
        if (rows.size() == 1) {
            return rows;
        }
        boolean nonEmptyFound = false;
        for (String[] row : rows) {
            try {
                Double.parseDouble(WorksheetUtils.sanitizeDecimalNumberString((String)row[scoreColumnIndex]));
                nonEmptyFound = true;
            }
            catch (Exception ex) {
                System.out.println("bad value: " + row[scoreColumnIndex]);
            }
        }
        if (!nonEmptyFound) {
            filteredByOverlap.add(rows.get(0));
            return filteredByOverlap;
        }
        Collections.sort(rows, new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                Point point1 = WorksheetUtils.parseHitCoordinatesValue((String)o1[subjectFromColumnIndex], (String)o1[subjectToColumnIndex]);
                Point point2 = WorksheetUtils.parseHitCoordinatesValue((String)o2[subjectFromColumnIndex], (String)o2[subjectToColumnIndex]);
                if (point1 == null && point2 == null) {
                    return 0;
                }
                if (point1 == null) {
                    return -1;
                }
                if (point2 == null) {
                    return 1;
                }
                int start1 = point1.x;
                int start2 = point2.x;
                int end1 = point1.y;
                int end2 = point2.y;
                if (start1 > end1) {
                    start1 = end1;
                }
                if (start2 > end2) {
                    start2 = end2;
                }
                return start1 - start2;
            }
        });
        ArrayList rowSubLists = new ArrayList();
        boolean bl = false;
        while (var11_11 < rows.size()) {
            boolean matches = false;
            String[] currentRow = rows.get((int)var11_11);
            if (rowSubLists.size() > 0) {
                int j = 0;
                while (j < rowSubLists.size() && !matches) {
                    List sublist = (List)rowSubLists.get(j);
                    if (this.matchesSublist(currentRow, sublist, subjectFromColumnIndex, subjectToColumnIndex)) {
                        matches = true;
                        ((List)rowSubLists.get(j)).add(currentRow);
                    }
                    ++j;
                }
                if (!matches) {
                    ArrayList<String[]> newList = new ArrayList<String[]>();
                    newList.add(currentRow);
                    rowSubLists.add(newList);
                }
            } else {
                ArrayList<String[]> newList = new ArrayList<String[]>();
                newList.add(currentRow);
                rowSubLists.add(newList);
            }
            ++var11_11;
        }
        for (List list : rowSubLists) {
            filteredByOverlap.add(this.getMaxScoreFromRowList(list, scoreColumnIndex));
        }
        return filteredByOverlap;
    }

    private String[] getMaxScoreFromRowList(List<String[]> rowList, int scoreColumnIndex) {
        String[] bestRow = null;
        double bestScore = 0.0;
        for (String[] row : rowList) {
            double currentScore = 0.0;
            try {
                currentScore = Double.parseDouble(WorksheetUtils.parseScoreColValue((String)row[scoreColumnIndex]));
                if (bestRow != null && !(currentScore > bestScore)) continue;
                bestRow = row;
                bestScore = currentScore;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return bestRow;
    }

    private boolean matchesSublist(String[] row, List<String[]> sublist, int subjectFromColumnIndex, int subjectToColumnIndex) {
        for (String[] subrow : sublist) {
            Point rowPoint = WorksheetUtils.parseHitCoordinatesValue((String)row[subjectFromColumnIndex], (String)row[subjectToColumnIndex]);
            Point subrowPoint = WorksheetUtils.parseHitCoordinatesValue((String)subrow[subjectFromColumnIndex], (String)subrow[subjectToColumnIndex]);
            if (!this.coordsOverlap(rowPoint.x, rowPoint.y, subrowPoint.x, subrowPoint.y)) continue;
            return true;
        }
        return false;
    }

    private boolean coordsOverlap(int start1, int end1, int start2, int end2) {
        int aux;
        if (end1 < start1) {
            aux = start1;
            start1 = end1;
            end1 = aux;
        }
        if (end2 < start2) {
            aux = start2;
            start2 = end2;
            end2 = aux;
        }
        if (end1 >= start2 && end1 <= end2) {
            return true;
        }
        return end2 >= start1 && end2 <= end1;
    }

    private void autodetectComboItem(Combo combo, String[] searchStrings) {
        int i = 0;
        while (i < combo.getItemCount()) {
            String is = combo.getItem(i);
            String[] stringArray = searchStrings;
            int n = searchStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String ss = stringArray[n2];
                if (is.compareToIgnoreCase(ss) == 0) {
                    combo.select(i);
                    return;
                }
                ++n2;
            }
            ++i;
        }
        combo.deselectAll();
    }

    private void init() {
        this.comboColumnId.setItems(this.allColumnNames);
        this.comboColumnHSPQuery.setItems(this.allColumnNames);
        this.comboColumnHSPHit.setItems(this.allColumnNames);
        this.comboColumnSimilarity.setItems(this.allColumnNames);
        this.comboColumnEValue.setItems(this.allColumnNames);
        this.comboColumnDepth.setItems(this.allColumnNames);
        this.comboColumnSubjectFrom.setItems(this.allColumnNames);
        this.comboColumnSubjectTo.setItems(this.allColumnNames);
        this.autodetectComboItem(this.comboColumnId, new String[]{"Query", "name", "query name", "Sequence"});
        this.autodetectComboItem(this.comboColumnHSPQuery, new String[]{"hsp/query", "hsp_query", "hsp-query"});
        this.autodetectComboItem(this.comboColumnHSPHit, new String[]{"hsp/subject", "hsp_subject", "hsp-subject", "hsp/hit", "hsp_hit", "hsp-hit"});
        this.autodetectComboItem(this.comboColumnSimilarity, new String[]{"Similarity", "Sim", "Sim."});
        this.autodetectComboItem(this.comboColumnEValue, new String[]{"evalue", "e-value", "e value", "e"});
        this.autodetectComboItem(this.comboColumnDepth, new String[]{"depth"});
        this.autodetectComboItem(this.comboColumnSubjectFrom, new String[]{"Hit from", "hit-from", "hit_from", "hit start", "hit-start", "hit_start", "subject from", "subject-from", "subject_from", "subject start", "subject-start", "subject_start"});
        this.autodetectComboItem(this.comboColumnSubjectTo, new String[]{"Hit to", "hit-to", "hit_to", "hit end", "hit-end", "hit_end", "subject to", "subject-to", "subject_to", "subject end", "subject-end", "subject_end"});
    }

    private String sanitizeDecimals(String inputNumber) {
        return inputNumber.replaceAll(",", ".");
    }
}

