/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.utils.TermMatcher;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CsvReplaceComposite
extends Composite {
    private CSVEditor csvEditor;
    private Text textSearch;
    private Text textReplace;
    private Combo comboColumns;
    private Button buttonCase;
    private Button buttonExact;
    private Button buttonRegexp;
    private Button buttonReplaceAll;
    private Button buttonFindPrevious;
    private Button buttonFindNext;
    private Button buttonReplace;
    private int[] searchIndices = null;
    private int length;
    private int cont;
    private int indice;
    private int columnModelIndex;
    private Object textSearchField;
    private boolean textExactField;
    private boolean textCaseField;
    private boolean textRegexpField;

    public CsvReplaceComposite(Composite parent, int style, CSVEditor csvEditor) {
        super(parent, style);
        this.csvEditor = csvEditor;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        this.setLayout((Layout)layout);
        Label labelSearch = new Label((Composite)this, 0);
        labelSearch.setText("Search term:");
        GridData layoutData = new GridData();
        labelSearch.setLayoutData((Object)layoutData);
        this.textSearch = new Text((Composite)this, 2052);
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.textSearch.setLayoutData((Object)layoutData);
        this.textSearch.setFocus();
        Label labelReplace = new Label((Composite)this, 0);
        labelReplace.setText("Replace with:");
        layoutData = new GridData();
        labelReplace.setLayoutData((Object)layoutData);
        this.textReplace = new Text((Composite)this, 2052);
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.textReplace.setLayoutData((Object)layoutData);
        Label labelColumn = new Label((Composite)this, 0);
        labelColumn.setText("In column:");
        layoutData = new GridData();
        labelColumn.setLayoutData((Object)layoutData);
        this.comboColumns = new Combo((Composite)this, 2060);
        this.comboColumns.setItems(csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true));
        layoutData = new GridData();
        this.comboColumns.setLayoutData((Object)layoutData);
        this.comboColumns.select(0);
        Group groupOptions = this.createOptionsGroup(this, 0);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = 20;
        groupOptions.setLayoutData((Object)layoutData);
        Composite compositeActions = this.createCompositeActions(this, 0);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = 10;
        compositeActions.setLayoutData((Object)layoutData);
        this.addListeners();
    }

    private Group createOptionsGroup(Composite parent, int style) {
        Group composite = new Group(parent, style);
        composite.setText("Search options");
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.buttonCase = new Button((Composite)composite, 32);
        this.buttonCase.setText("Case sensitive");
        this.buttonCase.setSelection(false);
        GridData layoutData = new GridData();
        this.buttonCase.setLayoutData((Object)layoutData);
        this.buttonExact = new Button((Composite)composite, 32);
        this.buttonExact.setText("Exact match");
        this.buttonExact.setSelection(false);
        layoutData = new GridData();
        this.buttonExact.setLayoutData((Object)layoutData);
        this.buttonRegexp = new Button((Composite)composite, 32);
        this.buttonRegexp.setText("Regular expression");
        this.buttonRegexp.setSelection(false);
        layoutData = new GridData();
        this.buttonRegexp.setLayoutData((Object)layoutData);
        return composite;
    }

    private Composite createCompositeActions(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.buttonFindPrevious = new Button(composite, 8);
        this.buttonFindPrevious.setText("Find previuos");
        GridData layoutData = new GridData(768);
        this.buttonFindPrevious.setLayoutData((Object)layoutData);
        this.buttonFindNext = new Button(composite, 8);
        this.buttonFindNext.setText("Find next");
        layoutData = new GridData(768);
        this.buttonFindNext.setLayoutData((Object)layoutData);
        this.buttonReplace = new Button(composite, 8);
        this.buttonReplace.setText("Replace");
        layoutData = new GridData(768);
        this.buttonReplace.setLayoutData((Object)layoutData);
        this.buttonReplaceAll = new Button(composite, 8);
        this.buttonReplaceAll.setText("Replace all");
        layoutData = new GridData(768);
        this.buttonReplaceAll.setLayoutData((Object)layoutData);
        return composite;
    }

    private void addListeners() {
        this.textSearch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CsvReplaceComposite.this.validate();
            }
        });
        this.buttonRegexp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvReplaceComposite.this.buttonExact.setEnabled(true);
                if (CsvReplaceComposite.this.buttonRegexp.getSelection()) {
                    CsvReplaceComposite.this.buttonExact.setEnabled(false);
                }
            }
        });
        this.buttonReplaceAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CsvReplaceComposite.this.replaceAll();
                }
                catch (PatternSyntaxException e1) {
                    MessageDialog.openWarning((Shell)CsvReplaceComposite.this.getShell(), (String)"Replace all", (String)"Invalid search term");
                    if (CsvReplaceComposite.this.csvEditor.getDebug()) {
                        e1.printStackTrace();
                    }
                    return;
                }
                catch (InvocationTargetException e1) {
                    MessageDialog.openWarning((Shell)CsvReplaceComposite.this.getShell(), (String)"Replace all", (String)"Invalid replace arguments");
                    if (CsvReplaceComposite.this.csvEditor.getDebug()) {
                        e1.printStackTrace();
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.buttonReplace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CsvReplaceComposite.this.replaceNext();
                }
                catch (PatternSyntaxException e1) {
                    MessageDialog.openWarning((Shell)CsvReplaceComposite.this.getShell(), (String)"Replace", (String)"Invalid search term");
                    return;
                }
            }
        });
        this.buttonFindNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvReplaceComposite.this.findNext();
            }
        });
        this.buttonFindPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvReplaceComposite.this.findPrevious();
            }
        });
    }

    private void findNext() {
        try {
            this.updateSearchIndices();
        }
        catch (PatternSyntaxException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Replace", (String)"Ivalid search term");
            return;
        }
        this.csvEditor.deselectAll();
        if (this.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Replace", (String)"No matches found");
            return;
        }
        ++this.cont;
        if (this.cont == -2 || this.cont >= this.length) {
            this.cont = 0;
            this.indice = this.searchIndices[this.cont];
        } else {
            this.indice = this.searchIndices[this.cont];
        }
        this.csvEditor.selectColumn(this.indice);
    }

    private void findPrevious() {
        try {
            this.updateSearchIndices();
        }
        catch (PatternSyntaxException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Replace", (String)"Ivalid search term");
            return;
        }
        this.csvEditor.deselectAll();
        if (this.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Replace", (String)"No matches found");
            return;
        }
        --this.cont;
        if (this.cont == -4 || this.cont == -1) {
            this.cont = this.searchIndices.length - 1;
            this.indice = this.searchIndices[this.cont];
        } else if (this.cont < this.length && this.cont >= 0) {
            this.indice = this.searchIndices[this.cont];
        }
        this.csvEditor.selectColumn(this.indice);
    }

    public void replaceNext() throws PatternSyntaxException {
        if (this.length == 0) {
            this.findNext();
            return;
        }
        String columnName = this.comboColumns.getItem(this.comboColumns.getSelectionIndex());
        int columnModelIndex = this.csvEditor.getColumnIndexForName(columnName);
        String replaceRegexp = TermMatcher.escapeTermForReplace((String)this.textSearch.getText(), (boolean)this.buttonExact.getSelection(), (boolean)this.buttonCase.getSelection(), (boolean)this.buttonRegexp.getSelection());
        this.csvEditor.replace(replaceRegexp, this.textReplace.getText(), columnModelIndex, this.indice);
        --this.length;
        this.findNext();
    }

    private int replaceAll() throws PatternSyntaxException, InvocationTargetException, InterruptedException {
        if (this.comboColumns.getSelectionIndex() == -1) {
            return 0;
        }
        String columnName = this.comboColumns.getItem(this.comboColumns.getSelectionIndex());
        int columnModelIndex = this.csvEditor.getColumnIndexForName(columnName);
        String replaceRegexp = TermMatcher.escapeTermForReplace((String)this.textSearch.getText(), (boolean)this.buttonExact.getSelection(), (boolean)this.buttonCase.getSelection(), (boolean)this.buttonRegexp.getSelection());
        this.updateSearchIndices();
        this.csvEditor.replaceAll(replaceRegexp, this.textReplace.getText(), columnModelIndex, this.searchIndices);
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Replace all", (String)(new DecimalFormat("###,###").format(this.searchIndices.length) + " rows affected"));
        this.textSearchField = null;
        return this.searchIndices.length;
    }

    private void updateSearchIndices() throws PatternSyntaxException {
        String columnName = this.comboColumns.getItem(this.comboColumns.getSelectionIndex());
        if (!this.textSearch.getText().equals(this.textSearchField) || this.buttonExact.getSelection() != this.textExactField || this.buttonCase.getSelection() != this.textCaseField || this.buttonRegexp.getSelection() != this.textRegexpField || this.length != this.searchIndices.length || this.columnModelIndex != this.csvEditor.getColumnIndexForName(columnName)) {
            this.textSearchField = this.textSearch.getText();
            this.textExactField = this.buttonExact.getSelection();
            this.textCaseField = this.buttonCase.getSelection();
            this.textRegexpField = this.buttonRegexp.getSelection();
            this.columnModelIndex = this.csvEditor.getColumnIndexForName(columnName);
            try {
                new ProgressMonitorDialog(this.getShell()).run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        CsvReplaceComposite.this.searchIndices = CsvReplaceComposite.this.csvEditor.searchTerm(CsvReplaceComposite.this.textSearch.getText(), CsvReplaceComposite.this.columnModelIndex, CsvReplaceComposite.this.buttonExact.getSelection(), CsvReplaceComposite.this.buttonCase.getSelection(), CsvReplaceComposite.this.buttonRegexp.getSelection());
                        CsvReplaceComposite.this.csvEditor.deselectAll();
                        CsvReplaceComposite.this.length = CsvReplaceComposite.this.searchIndices.length;
                        CsvReplaceComposite.this.cont = -3;
                    }
                });
            }
            catch (InvocationTargetException e) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Replace", (String)"Ivalid search term");
                if (this.csvEditor.getDebug()) {
                    e.printStackTrace();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void validate() {
    }

    public boolean forceFocus() {
        this.textSearch.setSelection(0);
        return this.textSearch.setFocus();
    }
}

