/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class CsvRenameColumnDialog
extends TitleAreaDialog {
    private final String TITLE = "Rename columns";
    private CSVEditor csvEditor;
    private Table table;
    private TableViewer tableViewer;
    private List<RenameRecord> listRecords;

    public CsvRenameColumnDialog(CSVEditor csvEditor) {
        super(csvEditor.getSite().getShell());
        this.csvEditor = csvEditor;
        String[] checkedColumnNames = csvEditor.getEditorUtils2().getColumnNamesAsArray(true, true, true);
        int[] checkedColumnIndices = csvEditor.getEditorUtils2().getColumnIndicesAsArray(checkedColumnNames);
        this.listRecords = new ArrayList<RenameRecord>();
        int i = 0;
        while (i < checkedColumnNames.length) {
            this.listRecords.add(new RenameRecord(checkedColumnIndices[i], checkedColumnNames[i], checkedColumnNames[i]));
            ++i;
        }
        this.getParentShell().setText("Rename columns");
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.table = new Table(composite, 68100);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        TableViewerColumn columnOld = new TableViewerColumn(this.tableViewer, 0);
        columnOld.getColumn().setText("Current name");
        columnOld.getColumn().setResizable(false);
        columnOld.getColumn().setMoveable(false);
        columnOld.getColumn().setWidth(200);
        TableViewerColumn columnNew = new TableViewerColumn(this.tableViewer, 0);
        columnNew.getColumn().setText("New name");
        columnNew.getColumn().setResizable(false);
        columnNew.getColumn().setMoveable(false);
        columnNew.getColumn().setWidth(200);
        try {
            columnNew.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

                protected void setValue(Object element, Object value) {
                    ((RenameRecord)element).setNewName(value.toString());
                    CsvRenameColumnDialog.this.tableViewer.update(element, null);
                }

                protected Object getValue(Object element) {
                    return ((RenameRecord)element).getNewName();
                }

                protected CellEditor getCellEditor(Object element) {
                    return new TextCellEditor((Composite)CsvRenameColumnDialog.this.tableViewer.getTable());
                }

                protected boolean canEdit(Object element) {
                    return true;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((RenameRecord)element).getOldName();
                    }
                    case 1: {
                        return ((RenameRecord)element).getNewName();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((ArrayList)inputElement).toArray();
            }
        });
        this.tableViewer.setInput(this.listRecords);
        this.initDialog();
        return compositeParent;
    }

    private void initDialog() {
        this.setTitle("Rename columns");
        this.setMessage("Set new names for selected columns");
    }

    protected void okPressed() {
        List<String> allColumnNames = this.csvEditor.getEditorUtils2().getColumnNamesAsList(false, false, false);
        Collections.sort(allColumnNames);
        for (RenameRecord rr : this.listRecords) {
            int res = Collections.binarySearch(allColumnNames, rr.getNewName());
            if (res < 0) continue;
            this.setErrorMessage("Name '" + rr.getNewName() + "' already exists");
            return;
        }
        try {
            for (RenameRecord rr : this.listRecords) {
                if (rr.getOldName().equals(rr.getNewName())) continue;
                this.csvEditor.renameColumn(rr.getOldName(), rr.getNewName());
            }
        }
        catch (Exception ex) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Rename columns", (String)("Failed renaming column:" + ex.getMessage()));
        }
        super.okPressed();
    }

    class RenameRecord {
        private int index;
        private String oldName;
        private String newName;

        RenameRecord(int index, String oldName, String newName) {
            this.setIndex(index);
            this.setOldName(oldName);
            this.setNewName(newName);
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setOldName(String oldName) {
            this.oldName = oldName;
        }

        public String getOldName() {
            return this.oldName;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }

        public String getNewName() {
            return this.newName;
        }
    }
}

