/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csvUtils.CSVUtils2;
import com.biotechvana.csveditor.dialogs.MemoryDialog;
import com.biotechvana.csveditor.dialogs.csvEditor.DialogUtils;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.editors.CSVEditorInput;
import com.biotechvana.csveditor.model.DetectAppParameters;
import com.biotechvana.csveditor.model.FileCopierRunnable;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.utils.PreferenceManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class CsvOpenDialog
extends TitleAreaDialog {
    private final String SHELL_TITLE = "Open worksheet";
    private final String TITLE = "Open worksheet file";
    private final String MESSAGE = "Open annotation files with data delimited in columns";
    private final String[] FILTER_NAMES = new String[]{".csv, .gff and .gtf files", ".csv (Comma Separated Value)", ".gff (General Feature Format v3)", ".gtf (General Transfer Format)", "*.* (All files)"};
    private final String[] FILTER_EXTS = new String[]{"*.csv;*.gff;*.gtf", "*.csv", "*.gff", "*.gtf", "*.*"};
    private Label labelInput;
    private Label labelSeparator;
    private Label labelSeparatorOther;
    private Label labelRowDelimiter;
    private Text textInput;
    private Text textSeparatorOther;
    private Text textPreview;
    private Button buttonInput;
    private Button buttonHeaders;
    private Button buttonFilter;
    private Combo comboFieldSeparator;
    private Combo comboFieldDelimiter;
    private Combo comboQueryColumn;
    private Combo comboSubjectColumn;
    private Combo comboScoreColumn;
    private Combo comboEvalueColumn;
    private String csvFile;
    private boolean debug = true;
    private CSVUtils2 csvUtils;
    private Group groupMultihit;
    private List<String> listHeaders;
    private int columnQueryIndex = 0;
    private int columnSubjectIndex = 1;
    private int columnScoreIndex = 5;
    private int columnEvalueIndex = 6;

    public CsvOpenDialog(Shell parentShell, String csvFile) {
        super(parentShell);
        this.csvFile = csvFile;
    }

    protected Control createDialogArea(Composite parent) {
        block3: {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            Composite compositeArea = new Composite(composite, 0);
            GridLayout layoutArea = new GridLayout(3, false);
            compositeArea.setLayout((Layout)layoutArea);
            compositeArea.setLayoutData((Object)new GridData(768));
            this.labelInput = new Label(compositeArea, 0);
            this.labelInput.setText("Input file: ");
            GridData layoutData = new GridData();
            this.labelInput.setLayoutData((Object)layoutData);
            this.textInput = new Text(compositeArea, 2052);
            if (this.csvFile != null) {
                this.textInput.setText(this.csvFile);
            }
            layoutData = new GridData(768);
            this.textInput.setLayoutData((Object)layoutData);
            this.buttonInput = new Button(compositeArea, 8);
            this.buttonInput.setText("Browse");
            layoutData = new GridData();
            this.buttonInput.setLayoutData((Object)layoutData);
            this.labelSeparator = new Label(compositeArea, 0);
            this.labelSeparator.setText("Field separator: ");
            layoutData = new GridData();
            this.labelSeparator.setLayoutData((Object)layoutData);
            this.createFieldSeparatorComposite(compositeArea);
            this.labelRowDelimiter = new Label(compositeArea, 0);
            this.labelRowDelimiter.setText("Field delimiter: ");
            layoutData = new GridData();
            this.labelRowDelimiter.setLayoutData((Object)layoutData);
            this.comboFieldDelimiter = new Combo(compositeArea, 12);
            this.comboFieldDelimiter.setItems(DialogUtils.ARRAY_DELIMITERS);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            this.comboFieldDelimiter.setLayoutData((Object)layoutData);
            Group groupPreview = this.createGroupPreview(compositeArea);
            layoutData = new GridData(768);
            layoutData.horizontalSpan = 3;
            layoutData.verticalIndent = 10;
            groupPreview.setLayoutData((Object)layoutData);
            Group groupOptions = this.createGroupOptions(compositeArea);
            layoutData = new GridData(768);
            layoutData.horizontalSpan = 3;
            layoutData.verticalIndent = 10;
            groupOptions.setLayoutData((Object)layoutData);
            try {
                this.updatePreview();
            }
            catch (Exception ex) {
                if (!this.debug) break block3;
                ex.printStackTrace();
            }
        }
        this.buttonInput.addSelectionListener((SelectionListener)new BrowseInputListener());
        return super.createDialogArea(parent);
    }

    private void createFieldSeparatorComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)layoutData);
        this.comboFieldSeparator = new Combo(composite, 12);
        this.comboFieldSeparator.setItems(DialogUtils.ARRAY_SEPARATORS);
        this.comboFieldSeparator.select(1);
        layoutData = new GridData();
        this.comboFieldSeparator.setLayoutData((Object)layoutData);
        this.labelSeparatorOther = new Label(composite, 0);
        this.labelSeparatorOther.setText("Other: ");
        layoutData = new GridData();
        this.labelSeparatorOther.setLayoutData((Object)layoutData);
        this.textSeparatorOther = new Text(composite, 2052);
        layoutData = new GridData(768);
        this.textSeparatorOther.setLayoutData((Object)layoutData);
    }

    private Group createGroupPreview(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Worksheet preview");
        group.setLayout((Layout)new GridLayout(1, false));
        this.textPreview = new Text((Composite)group, 2818);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 100;
        layoutData.widthHint = 500;
        this.textPreview.setLayoutData((Object)layoutData);
        return group;
    }

    private Group createGroupOptions(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Options");
        group.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData();
        this.buttonHeaders = new Button((Composite)group, 32);
        this.buttonHeaders.setText("Take first line as header names");
        this.buttonHeaders.setSelection(true);
        this.buttonFilter = new Button((Composite)group, 32);
        this.buttonFilter.setText("Worksheet contains multiple HSPs for each match");
        this.buttonFilter.setSelection(false);
        this.buttonFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvOpenDialog.this.activateGroupMultihit(CsvOpenDialog.this.buttonFilter.getSelection());
            }
        });
        layoutData = new GridData(768);
        layoutData.horizontalIndent = 40;
        this.groupMultihit = this.createGroupMultihit((Composite)group);
        this.groupMultihit.setLayoutData((Object)layoutData);
        this.activateGroupMultihit(this.buttonFilter.getSelection());
        return group;
    }

    private void activateGroupMultihit(boolean activate) {
        Control[] controlArray = this.groupMultihit.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(activate);
            ++n2;
        }
    }

    private Group createGroupMultihit(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Select required columns for filtering multiple HSPs:");
        group.setLayout((Layout)new GridLayout(4, false));
        GridData layoutData = null;
        Label labelQuery = new Label((Composite)group, 0);
        labelQuery.setText("Query: ");
        this.comboQueryColumn = new Combo((Composite)group, 2060);
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.comboQueryColumn.setLayoutData((Object)layoutData);
        Label labelSubject = new Label((Composite)group, 0);
        labelSubject.setText("Subject: ");
        this.comboSubjectColumn = new Combo((Composite)group, 2060);
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.comboSubjectColumn.setLayoutData((Object)layoutData);
        Label labelScore = new Label((Composite)group, 0);
        labelScore.setText("Score: ");
        this.comboScoreColumn = new Combo((Composite)group, 2060);
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.comboScoreColumn.setLayoutData((Object)layoutData);
        Label labelEvalue = new Label((Composite)group, 0);
        labelEvalue.setText("E-value: ");
        this.comboEvalueColumn = new Combo((Composite)group, 2060);
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.comboEvalueColumn.setLayoutData((Object)layoutData);
        return group;
    }

    public void create() {
        super.create();
        this.setTitle("Open worksheet file");
        this.setMessage("Open annotation files with data delimited in columns");
        this.getButton(0).setEnabled(true);
        this.getShell().setText("Open worksheet");
    }

    protected void okPressed() {
        char separator = this.comboFieldSeparator.getItem(this.comboFieldSeparator.getSelectionIndex()).charAt(0);
        char delimiter = this.comboFieldDelimiter.getItem(this.comboFieldDelimiter.getSelectionIndex()).charAt(0);
        this.columnQueryIndex = DialogUtils.getComboSelectedColumnIndex(this.comboQueryColumn);
        this.columnSubjectIndex = DialogUtils.getComboSelectedColumnIndex(this.comboSubjectColumn);
        this.columnScoreIndex = DialogUtils.getComboSelectedColumnIndex(this.comboScoreColumn);
        this.columnEvalueIndex = DialogUtils.getComboSelectedColumnIndex(this.comboEvalueColumn);
        if (separator == ' ' || separator == 'S') {
            block23: {
                CSVEditorInput input = new CSVEditorInput(new File(this.textInput.getText()), separator, delimiter, this.buttonHeaders.getSelection(), false);
                input.setMultiHit(false);
                input.setMultiHitFile(null);
                try {
                    IEditorPart part = WorkspaceUtils.openEditor((IEditorInput)input, (String)"com.biotechvana.csveditor.editors.CSVEditor");
                    if (part instanceof CSVEditor) {
                        ((CSVEditor)part).setDebug(this.debug);
                    }
                }
                catch (PartInitException e) {
                    if (!this.debug) break block23;
                    e.printStackTrace();
                }
            }
            super.okPressed();
            return;
        }
        if (this.textInput.getText().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Open worksheet", (String)"Please, select a valid file.");
            return;
        }
        try {
            IEditorPart editorPart;
            File inputFile = new File(this.textInput.getText());
            String initialName = inputFile.getAbsolutePath();
            String inputExtension = FilenameUtils.getExtension((String)this.textInput.getText());
            if (!inputFile.exists() || !inputFile.canRead()) {
                return;
            }
            CSVEditorInput input = null;
            String multiHitPath = this.csvUtils.getMultiHitComment();
            String newMultiHitName = inputFile.getParent() + File.separator + FilenameUtils.getBaseName((String)inputFile.getAbsolutePath()) + "_multiHit.csv";
            if (this.debug) {
                System.out.println("Multihit path: " + multiHitPath);
                System.out.println("Multihit new name: " + newMultiHitName);
            }
            if (multiHitPath != null && multiHitPath.length() > 0) {
                input = this.openMultiHitFileWithComment(multiHitPath, inputFile, separator, delimiter, this.buttonHeaders.getSelection(), false);
            } else if (this.csvUtils.hasRepeatedQueries(0) && this.buttonFilter.getSelection()) {
                input = this.openMultiHitFileNew(inputFile, newMultiHitName, initialName, separator, delimiter, this.buttonHeaders.getSelection());
            } else {
                input = new CSVEditorInput(inputFile, separator, delimiter, this.buttonHeaders.getSelection(), false);
                input.setMultiHit(false);
                input.setMultiHitFile(null);
            }
            int lineCount = this.csvUtils.getLineCount();
            DetectAppParameters dap = new DetectAppParameters();
            boolean showMemoryDialog = false;
            if (lineCount > 80000 && dap.getXms() < 3000) {
                showMemoryDialog = true;
            } else if (lineCount > 50000 && dap.getXms() < 2000) {
                showMemoryDialog = true;
            } else if (lineCount > 30000 && dap.getXms() < 1000) {
                showMemoryDialog = true;
            } else if (lineCount > 10000 && dap.getXms() < 512) {
                showMemoryDialog = true;
            }
            if (showMemoryDialog) {
                MemoryDialog dialog = new MemoryDialog(this.getShell(), dap.getXms(), lineCount);
                if (dialog.open() == 1) {
                    return;
                }
                dialog.close();
            }
            if ((editorPart = WorkspaceUtils.openEditor((IEditorInput)input, (String)"com.biotechvana.csveditor.editors.CSVEditor")) instanceof CSVEditor) {
                ((CSVEditor)editorPart).setDebug(this.debug);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Open worksheet", (String)("Failed opening worksheet:\n" + e.getMessage()));
        }
        super.okPressed();
    }

    private void browseInput() {
        FileDialog dialog = new FileDialog(this.getShell(), 4);
        dialog.setFilterExtensions(this.FILTER_EXTS);
        dialog.setFilterNames(this.FILTER_NAMES);
        dialog.setFilterPath(PreferenceManager.getInstance().get("workspace", ""));
        String res = dialog.open();
        if (res == null) {
            return;
        }
        this.textInput.setText(res);
    }

    private void updatePreview() throws IOException, InvocationTargetException, InterruptedException, CSVUtils2.LineCountNotDoneException, CSVUtils2.ColumnCountNotDoneException, CSVUtils2.SeparatorNotParsedException, CSVUtils2.DelimiterNotParsedException, CSVUtils2.CannotOpenFileException, CSVUtils2.HeadersNotParsedException, CSVUtils2.CommentsNotParsedException {
        if (!this.textInput.getText().isEmpty()) {
            if (!new File(this.textInput.getText()).exists()) {
                return;
            }
            String preview = this.getPreview(this.textInput.getText());
            if (preview != null) {
                this.textPreview.setText(preview);
            }
            boolean isGFF = false;
            if (FilenameUtils.getExtension((String)this.textInput.getText()).equalsIgnoreCase("gff")) {
                isGFF = true;
                this.buttonHeaders.setSelection(false);
                this.buttonHeaders.setEnabled(false);
                this.comboFieldSeparator.setEnabled(false);
            }
            this.csvUtils = CSVUtils2.createNewUtils((String)this.textInput.getText(), (boolean)this.buttonHeaders.getSelection(), (boolean)isGFF);
            this.csvUtils.parse();
            switch (this.csvUtils.getSeparator()) {
                case ';': {
                    this.comboFieldSeparator.select(1);
                    break;
                }
                case ':': {
                    this.comboFieldSeparator.select(2);
                    break;
                }
                case ',': {
                    this.comboFieldSeparator.select(3);
                    break;
                }
                case '\t': {
                    this.comboFieldSeparator.select(4);
                    break;
                }
                case ' ': {
                    this.comboFieldSeparator.select(5);
                    break;
                }
                default: {
                    this.comboFieldSeparator.select(1);
                }
            }
            switch (this.csvUtils.getDelimiter()) {
                case 'N': {
                    this.comboFieldDelimiter.select(0);
                    break;
                }
                case '\"': {
                    this.comboFieldDelimiter.select(1);
                    break;
                }
                case '\'': {
                    this.comboFieldDelimiter.select(2);
                    break;
                }
                default: {
                    this.comboFieldDelimiter.select(1);
                }
            }
            if (this.debug) {
                System.out.println("Autodetected separator: " + this.csvUtils.getSeparator());
                System.out.println("Autodetected delimiter: " + this.csvUtils.getDelimiter());
            }
            this.listHeaders = this.csvUtils.getHeaders();
            String[] arrayHeaders = this.listHeaders.toArray(new String[this.listHeaders.size()]);
            this.comboQueryColumn.setItems(arrayHeaders);
            this.comboSubjectColumn.setItems(arrayHeaders);
            this.comboScoreColumn.setItems(arrayHeaders);
            this.comboEvalueColumn.setItems(arrayHeaders);
            DialogUtils.autodetectComboQuery(this.comboQueryColumn);
            DialogUtils.autodetectComboSubject(this.comboSubjectColumn);
            DialogUtils.autodetectComboScore(this.comboScoreColumn);
            DialogUtils.autodetectComboEvalue(this.comboEvalueColumn);
        }
    }

    private String getPreview(String fileName) {
        StringBuilder sBuilder = new StringBuilder();
        int MAX_LINES = 10;
        File csvFile = new File(fileName);
        try (BufferedReader bReader = new BufferedReader(new FileReader(csvFile));){
            String line;
            int counter = 0;
            while ((line = bReader.readLine()) != null && counter < 10) {
                if (line.indexOf("#") == 0) continue;
                sBuilder.append(line);
                sBuilder.append("\n");
                ++counter;
            }
            if (counter > 0) {
                sBuilder.append("...");
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return null;
        }
        return sBuilder.toString();
    }

    private CSVEditorInput openMultiHitFileWithComment(String multiHitPath, File inputFile, char separator, char delimiter, boolean hasHeaders, boolean isTemporary) {
        if (this.debug) {
            System.out.println("Singlehit file with associated multihit file in comment: " + multiHitPath);
        }
        CSVEditorInput input = new CSVEditorInput(inputFile, separator, delimiter, hasHeaders, isTemporary);
        File multiHitFile = new File(multiHitPath);
        if (multiHitFile.exists() && multiHitFile.canRead()) {
            input.setMultiHit(true);
            input.setMultiHitFile(multiHitFile);
        } else {
            input.setMultiHit(false);
            input.setMultiHitFile(null);
        }
        return input;
    }

    private CSVEditorInput openMultiHitFileNew(File inputFile, String newMultiHitName, final String initialName, char separator, char delimiter, boolean hasHeaders) throws IOException, InvocationTargetException, InterruptedException {
        if (this.debug) {
            System.out.println("Multihit file with repeated queries");
        }
        File newMultiHitFile = new File(newMultiHitName);
        try {
            FileCopierRunnable copyRunnable = new FileCopierRunnable(inputFile, newMultiHitFile);
            new ProgressMonitorDialog(this.getShell()).run(true, false, (IRunnableWithProgress)copyRunnable);
        }
        catch (Exception e1) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Multi Hit file", (String)"Error renaming multihit worksheet file");
            e1.printStackTrace();
        }
        inputFile = new File(newMultiHitName);
        this.csvUtils = CSVUtils2.createNewUtils((File)inputFile, (boolean)this.buttonHeaders.getSelection());
        if (this.debug) {
            System.out.println("Updating input files");
            System.out.println("Query index: " + this.columnQueryIndex);
            System.out.println("Subject index: " + this.columnSubjectIndex);
            System.out.println("Score index: " + this.columnScoreIndex);
            System.out.println("Evalue index: " + this.columnEvalueIndex);
        }
        new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("Parsing multihit file", -1);
                    try {
                        CsvOpenDialog.this.csvUtils.parse();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    System.out.println("Entra aqu\u00ed ----------------------------------------");
                    try {
                        CsvOpenDialog.this.csvUtils.filterMultiHitBufferedBestDescription(CsvOpenDialog.this.columnQueryIndex, CsvOpenDialog.this.columnSubjectIndex, CsvOpenDialog.this.columnScoreIndex, CsvOpenDialog.this.columnEvalueIndex, initialName);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
        CSVEditorInput input = new CSVEditorInput(new File(initialName), separator, delimiter, this.buttonHeaders.getSelection(), false);
        input.setMultiHit(true);
        input.setMultiHitFile(inputFile);
        return input;
    }

    class BrowseInputListener
    implements SelectionListener {
        BrowseInputListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            block2: {
                CsvOpenDialog.this.browseInput();
                try {
                    CsvOpenDialog.this.updatePreview();
                }
                catch (Exception e1) {
                    MessageDialog.openInformation((Shell)CsvOpenDialog.this.getShell(), (String)"Worksheet preview", (String)"Cannot generate worksheet preview");
                    if (!CsvOpenDialog.this.debug) break block2;
                    e1.printStackTrace();
                }
            }
        }
    }
}

