/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.CsvEditorGenbankDownloadJob;
import com.biotechvana.utils.PreferenceManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CsvGenBankDownloadDialog
extends TitleAreaDialog {
    public static final String TITLE = "Download associated GenBank files";
    private CSVEditor csvEditor;
    private Combo comboColumns;
    private Text textOutput;
    private Button buttonOutput;
    private Button buttonAccession;
    private Button buttonFasta;
    private List<Integer> listSelectedRows;
    private Button buttonDatabaseProtein;
    private Button buttonDatabaseNucleotide;

    public CsvGenBankDownloadDialog(Shell parentShell, CSVEditor csvEditor) {
        super(parentShell);
        this.csvEditor = csvEditor;
    }

    public void create() {
        super.create();
        this.setTitle(TITLE);
        this.setMessage("Download GenBank Accession by accessions contained in a worksheet's column");
        this.getButton(0).setEnabled(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        this.getShell().setText(TITLE);
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label labelColumn = new Label(composite, 0);
        labelColumn.setText("GenBank Accession column:");
        GridData layoutData = new GridData();
        labelColumn.setLayoutData((Object)layoutData);
        this.comboColumns = new Combo(composite, 8);
        this.comboColumns.setItems(this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true));
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.comboColumns.setLayoutData((Object)layoutData);
        Label labelType = new Label(composite, 0);
        labelType.setText("Download as:");
        Composite compositeOptions = new Composite(composite, 0);
        compositeOptions.setLayout((Layout)new FillLayout());
        compositeOptions.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.buttonAccession = new Button(compositeOptions, 16);
        this.buttonAccession.setText("GeneBank Accession file");
        this.buttonAccession.setSelection(true);
        this.buttonFasta = new Button(compositeOptions, 16);
        this.buttonFasta.setText("FASTA sequence file");
        Label labelDatabase = new Label(composite, 0);
        labelDatabase.setText("Accession type:");
        Composite compositeDatabase = new Composite(composite, 0);
        compositeDatabase.setLayout((Layout)new FillLayout());
        compositeDatabase.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.buttonDatabaseNucleotide = new Button(compositeDatabase, 16);
        this.buttonDatabaseNucleotide.setText("Nucleotide");
        this.buttonDatabaseProtein = new Button(compositeDatabase, 16);
        this.buttonDatabaseProtein.setText("Protein");
        this.buttonDatabaseProtein.setSelection(true);
        Label labelOutput = new Label(composite, 0);
        labelOutput.setText("Output directory:");
        layoutData = new GridData();
        labelOutput.setLayoutData((Object)layoutData);
        this.textOutput = new Text(composite, 2060);
        layoutData = new GridData(768);
        this.textOutput.setLayoutData((Object)layoutData);
        this.buttonOutput = new Button(composite, 8);
        this.buttonOutput.setText("Browse");
        layoutData = new GridData();
        this.buttonOutput.setLayoutData((Object)layoutData);
        this.buttonOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvGenBankDownloadDialog.this.selectOutput();
            }
        });
        int accessionIndex = -1;
        int i = 0;
        while (i < this.comboColumns.getItemCount() && accessionIndex == -1) {
            String item = this.comboColumns.getItem(i);
            if (item.toLowerCase().indexOf("accession") != -1) {
                accessionIndex = i;
            }
            ++i;
        }
        if (accessionIndex != -1) {
            this.comboColumns.select(accessionIndex);
        }
        this.addListeners();
        return composite;
    }

    private void addListeners() {
    }

    protected void okPressed() {
        try {
            this.run();
        }
        catch (InvocationTargetException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)("Failed downloading:" + e.getMessage()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.okPressed();
    }

    private void run() throws InvocationTargetException, InterruptedException {
        if (!this.validate()) {
            return;
        }
        this.listSelectedRows = this.csvEditor.getCheckedRowIndices(true, false);
        if (this.listSelectedRows.size() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)"Must select one row at least");
            return;
        }
        String columnName = this.comboColumns.getItem(this.comboColumns.getSelectionIndex());
        int columnModelIndex = this.csvEditor.getColumnIndexForName(columnName);
        String rettype = "gb";
        if (this.buttonFasta.getSelection()) {
            rettype = "fasta";
        }
        CsvEditorGenbankDownloadJob job = new CsvEditorGenbankDownloadJob(TITLE, (List)this.csvEditor.getModel(), columnModelIndex, this.csvEditor.getCheckedRowIndices(false, false), rettype, this.textOutput.getText());
        job.setUser(true);
        job.schedule(30L);
    }

    private boolean validate() {
        if (!this.validateOutput()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)"Cannot find output directory");
            return false;
        }
        return true;
    }

    private boolean validateOutput() {
        if (this.textOutput.getText() == null || this.textOutput.getText().length() == 0) {
            return false;
        }
        File fileOutput = new File(this.textOutput.getText());
        return fileOutput.exists() && fileOutput.isDirectory();
    }

    private void selectOutput() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText("Select output directory");
        String initialPath = this.csvEditor.getCsvFile().getParent();
        if (initialPath == null || initialPath.length() == 0) {
            initialPath = PreferenceManager.getInstance().get("workspace", "");
        }
        dialog.setFilterPath(initialPath);
        String res = dialog.open();
        if (res == null) {
            return;
        }
        this.textOutput.setText(res);
    }
}

