/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import com.biotechvana.csveditor.csvEditor.runnables.CsvEditorLinkSequencesRunnable;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvExportRelatedFastaRunnable;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;

public class CsvExportDialog
extends Dialog {
    private static final String TITLE = "Export";
    private CSVEditor csvEditor;
    private Text textFile;
    private Text textName;
    private Text textSequence;
    private Button buttonFile;
    private Combo comboOptions;
    private String defaultOutputDirectory;
    private List<Integer> listSelectedRows;
    private boolean exportCsv = false;
    private boolean exportFasta = false;
    private Button buttonTrim;
    private Combo comboStart;
    private Combo comboEnd;
    private Composite compositeTrim;
    private List<String> listMatchingNames = null;

    public CsvExportDialog(CSVEditor csvEditor, String defaultOutputDirectory) {
        super(csvEditor.getSite().getShell());
        this.csvEditor = csvEditor;
        this.defaultOutputDirectory = defaultOutputDirectory;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayoutData((Object)new GridData(1808));
        this.getShell().setText(TITLE);
        Composite composite = new Composite(compositeParent, 0);
        RowLayout layout = new RowLayout(512);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        this.createOutputComposite(composite, 0);
        return compositeParent;
    }

    private Composite createOutputComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        composite.setLayout((Layout)layout);
        Label labelFile = new Label(composite, 0);
        labelFile.setText("Select destination folder:");
        this.textFile = new Text(composite, 2060);
        this.textFile.setLayoutData((Object)new GridData(4, 1, true, false));
        if (this.defaultOutputDirectory != null) {
            this.textFile.setText(this.defaultOutputDirectory);
            this.textFile.setSelection(this.textFile.getText().length());
        }
        this.buttonFile = new Button(composite, 8);
        this.buttonFile.setText("Browse");
        this.buttonFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(CsvExportDialog.this.getShell(), 8192);
                dialog.setFilterPath(CsvExportDialog.this.csvEditor.getCsvFile().getParent());
                String res = dialog.open();
                if (res != null) {
                    CsvExportDialog.this.textFile.setText(res);
                    CsvExportDialog.this.textFile.setSelection(res.length());
                }
            }
        });
        Label labelName = new Label(composite, 0);
        labelName.setText("Exported file name:");
        this.textName = new Text(composite, 2052);
        this.textName.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        Label label = new Label(composite, 0);
        label.setText("");
        Label labelOptions = new Label(composite, 0);
        labelOptions.setText("Export mode:");
        this.comboOptions = new Combo(composite, 2060);
        this.comboOptions.setItems(new String[]{"Worksheet & Sequences", "Worksheet only", "Sequences only"});
        this.comboOptions.select(1);
        this.comboOptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CsvExportDialog.this.enableSequenceControls(CsvExportDialog.this.comboOptions.getSelectionIndex() != 1);
            }
        });
        label = new Label(composite, 0);
        label.setText("");
        Label labelSequence = new Label(composite, 0);
        labelSequence.setText("Sequence database:");
        this.textSequence = new Text(composite, 2060);
        this.textSequence.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        if (this.csvEditor.getAssociationFile() != null) {
            this.textSequence.setText(this.csvEditor.getAssociationFile().getAbsolutePath());
        }
        label = new Label(composite, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.enableSequenceControls(false);
        Label label2 = new Label(composite, 0);
        label2.setText("");
        this.compositeTrim = new Composite(composite, 0);
        this.compositeTrim.setLayout((Layout)new GridLayout(2, false));
        String[] columnNames = this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false);
        this.buttonTrim = new Button(this.compositeTrim, 32);
        this.buttonTrim.setText("Trim sequences");
        Composite compositePositions = new Composite(this.compositeTrim, 0);
        compositePositions.setLayout((Layout)new GridLayout(2, false));
        Label labelStart = new Label(compositePositions, 0);
        labelStart.setText("Start column: ");
        this.comboStart = new Combo(compositePositions, 2060);
        this.comboStart.setItems(columnNames);
        Label labelEnd = new Label(compositePositions, 0);
        labelEnd.setText("End column: ");
        this.comboEnd = new Combo(compositePositions, 2060);
        this.comboEnd.setItems(columnNames);
        return composite;
    }

    private void enableSequenceControls(boolean enabled) {
        this.textSequence.setEnabled(enabled);
    }

    private boolean validation() {
        if (this.textFile.getText().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)"Invalid output file name");
            return false;
        }
        if (this.comboOptions.getSelectionIndex() != 1 && this.textSequence.getText().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)"Invalid sequence file. Associate a sequence file first.");
            return false;
        }
        return true;
    }

    protected void okPressed() {
        if (!this.validation()) {
            return;
        }
        try {
            this.export();
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)("Error exporting worksheet: " + e.getMessage()));
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        IViewPart viewPart = WorkspaceUtils.findView((String)FileExplorerBasic.ID);
        if (viewPart != null) {
            FileExplorerBasic fileExplorer = (FileExplorerBasic)viewPart;
            fileExplorer.getFileViewer().refresh((Object)new File(this.textFile.getText()));
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"Export finished");
        super.okPressed();
    }

    private void export() throws InvocationTargetException, InterruptedException {
        this.exportCsv = false;
        this.exportFasta = false;
        switch (this.comboOptions.getSelectionIndex()) {
            case 0: {
                this.exportCsv = true;
                this.exportFasta = true;
                break;
            }
            case 1: {
                this.exportCsv = true;
                break;
            }
            case 2: {
                this.exportFasta = true;
                break;
            }
            default: {
                this.exportCsv = true;
            }
        }
        if (this.exportFasta) {
            CsvEditorLinkSequencesRunnable linkRunnable = new CsvEditorLinkSequencesRunnable(this.csvEditor, new File(this.textSequence.getText()), this.csvEditor.getAssociationColumnIndices(), this.csvEditor.getAssociationSeparator());
            new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)linkRunnable);
            this.listMatchingNames = linkRunnable.getListMatchingNames();
        }
        final int associationReferenceType = this.csvEditor.getAssociationReferenceType();
        if (this.exportCsv) {
            final String outputPathCSV = this.textFile.getText() + File.separator + this.textName.getText() + ".csv";
            this.listSelectedRows = this.csvEditor.getCheckedRowIndices(false, false);
            new ProgressMonitorDialog(this.csvEditor.getSite().getShell()).run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        if (associationReferenceType == 1) {
                            CsvExportDialog.this.csvEditor.getEditorUtils2().exportModel(CsvExportDialog.this.listSelectedRows, CsvExportDialog.this.csvEditor.getEditorUtils2().getColumnIndicesAsList(true, true, true), CsvExportDialog.this.csvEditor.getEditorUtils2().getColumnNamesAsList(true, true, true), CsvExportDialog.this.csvEditor.getAssociationColumnIndices(), CsvExportDialog.this.csvEditor.getAssociationSeparator(), CsvExportDialog.this.listMatchingNames, new File(outputPathCSV));
                        } else {
                            CsvExportDialog.this.csvEditor.getEditorUtils2().exportModel(CsvExportDialog.this.listSelectedRows, CsvExportDialog.this.csvEditor.getEditorUtils2().getColumnIndicesAsList(true, true, true), CsvExportDialog.this.csvEditor.getEditorUtils2().getColumnNamesAsList(true, true, true), new File(outputPathCSV));
                        }
                    }
                    catch (Exception e) {
                        MessageDialog.openWarning((Shell)CsvExportDialog.this.getShell(), (String)"Export worksheet", (String)("Failed exporting worksheet:" + e.getMessage()));
                        e.printStackTrace();
                    }
                }
            });
        }
        if (this.exportFasta) {
            String outputPathSequence = this.textFile.getText() + File.separator + this.textName.getText() + "." + FilenameUtils.getExtension((String)this.textSequence.getText());
            String sequenceFile = this.textSequence.getText();
            CsvExportRelatedFastaRunnable runnable = this.csvEditor.getAssociationReferenceType() == 0 ? new CsvExportRelatedFastaRunnable(this.csvEditor, new File(sequenceFile), this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(true, true, true), "|", this.csvEditor.getAssociationColumnIndices(), this.csvEditor.getAssociationSeparator(), this.listMatchingNames, new File(outputPathSequence)) : new CsvExportRelatedFastaRunnable(this.csvEditor, new File(sequenceFile), this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(true, true, true), "|", this.csvEditor.getAssociationColumnIndices(), this.csvEditor.getAssociationSeparator(), new File(outputPathSequence));
            if (this.buttonTrim.getSelection()) {
                int startColIndex = this.comboStart.getSelectionIndex() + 2;
                int endColIndex = this.comboEnd.getSelectionIndex() + 2;
                runnable.trimSequences(startColIndex, endColIndex);
            }
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)runnable);
        }
    }

    public int open() {
        return super.open();
    }

    public void create() {
        super.create();
        this.textName.setFocus();
    }

    private class CsvGetNamesRunnable
    implements IRunnableWithProgress {
        private CsvGetNamesRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        }
    }

    private class FastaGetNamesRunnable
    implements IRunnableWithProgress {
        private File fileInput;

        private FastaGetNamesRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        }
    }
}

