/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.dialogs.csvEditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class ColumnTableComposite
extends Composite {
    private Button buttonSelectAll;
    private TableViewer tableViewer;

    public ColumnTableComposite(Composite parent, int style, List<String> columnNames, List<String> checkedNames) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        this.tableViewer = new TableViewer((Composite)this, 2848);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 200;
        this.tableViewer.getTable().setLayoutData((Object)layoutData);
        this.tableViewer.getTable().setLinesVisible(true);
        this.addProviders();
        this.tableViewer.setInput(columnNames);
        Collections.sort(checkedNames);
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            int res = Collections.binarySearch(checkedNames, this.tableViewer.getTable().getItem(i).getText());
            if (res >= 0) {
                this.tableViewer.getTable().getItem(i).setChecked(true);
            } else {
                this.tableViewer.getTable().getItem(i).setChecked(false);
            }
            ++i;
        }
        this.buttonSelectAll = new Button((Composite)this, 32);
        this.buttonSelectAll.setText("Select all");
        layoutData = new GridData();
        this.buttonSelectAll.setLayoutData((Object)layoutData);
        this.buttonSelectAll.setSelection(this.checkSelectAllState());
        this.addListeners();
    }

    private void addProviders() {
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray(new String[((List)inputElement).size()]);
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                return element.toString();
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
    }

    private void addListeners() {
        this.buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnTableComposite.this.checkAll(ColumnTableComposite.this.buttonSelectAll.getSelection());
                ColumnTableComposite.this.checkSelectAllState();
            }
        });
        this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnTableComposite.this.buttonSelectAll.setSelection(ColumnTableComposite.this.checkSelectAllState());
            }
        });
    }

    private void checkAll(boolean option) {
        int itemCount = this.tableViewer.getTable().getItemCount();
        int i = 0;
        while (i < itemCount) {
            this.tableViewer.getTable().getItem(i).setChecked(option);
            ++i;
        }
    }

    private boolean checkSelectAllState() {
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (!item.getChecked()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int getItemCount() {
        return this.tableViewer.getTable().getItemCount();
    }

    public String getItem(int index) {
        return this.tableViewer.getTable().getItem(index).getText();
    }

    public List<String> getNamesByState(boolean checked) {
        ArrayList<String> listCheckedNames = new ArrayList<String>();
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (ti.getChecked() == checked) {
                listCheckedNames.add(ti.getText());
            }
            ++n2;
        }
        return listCheckedNames;
    }
}

