/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.csvEditor.runnables;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.utils.SequenceFileInfo;
import com.biotechvana.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvEditorLinkSequencesRunnable
implements IRunnableWithProgress {
    private final String TITLE = "Associate sequence database";
    private int itemCount;
    private int stepSize;
    private int stepCounter = 0;
    private int taskSteps = 100;
    private int matchesCount = 0;
    private CSVEditor csvEditor;
    private File sequenceFile;
    private int[] csvColumns;
    private String csvSeparator;
    private List<String> listSequenceNames = null;
    private List<List<String>> model;
    private List<String> listMatchingNames = new ArrayList<String>();

    public CsvEditorLinkSequencesRunnable(CSVEditor csvEditor, File sequenceFile, int[] csvColumns, String csvSeparator) {
        this.csvEditor = csvEditor;
        this.sequenceFile = sequenceFile;
        this.csvColumns = csvColumns;
        this.csvSeparator = csvSeparator;
        this.model = (List)csvEditor.getModel();
        this.itemCount = this.model.size();
        this.stepSize = this.itemCount / this.taskSteps;
        if (this.stepSize < 1) {
            this.stepSize = 1;
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Associate sequence database", this.taskSteps);
        try {
            this.associate(monitor);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e, "Cannot parse csv of sequence file: " + e.getMessage());
        }
        monitor.done();
    }

    private void associate(IProgressMonitor monitor) throws IOException, InterruptedException {
        this.scanSequenceFile(monitor);
        this.scanCsvFile(monitor);
    }

    private void scanCsvFile(IProgressMonitor monitor) throws IOException, InterruptedException {
        for (List row : (List)this.csvEditor.getModel()) {
            ArrayList<String> parts = new ArrayList<String>();
            int[] nArray = this.csvColumns;
            int n = this.csvColumns.length;
            int n2 = 0;
            while (n2 < n) {
                int c = nArray[n2];
                parts.add((String)row.get(c + 2));
                ++n2;
            }
            String csvSequence = StringUtils.join(parts, (String)this.csvSeparator);
            int res = Collections.binarySearch(this.listSequenceNames, csvSequence);
            if (res >= 0) {
                int indexMatching = Collections.binarySearch(this.listMatchingNames, csvSequence);
                if (indexMatching < 0) {
                    this.listMatchingNames.add(-indexMatching - 1, csvSequence);
                }
                ++this.matchesCount;
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ++this.stepCounter;
            if (this.stepCounter % this.stepSize != 0) continue;
            monitor.worked(1);
        }
    }

    private void scanSequenceFile(IProgressMonitor monitor) throws IOException {
        SequenceFileInfo fileInfo = new SequenceFileInfo(this.sequenceFile);
        this.listSequenceNames = fileInfo.isFASTQ() ? fileInfo.getSequenceNamesFastqSorted(true) : fileInfo.getSequenceNamesFastaSorted(true);
    }

    public int getMatchesCount() {
        return this.matchesCount;
    }

    public List<String> getListMatchingNames() {
        return this.listMatchingNames;
    }
}

