/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.csvEditor.dialogs;

import com.biotechvana.csveditor.csvEditor.dialogs.CsvAssociateSequenceDatabaseComposite;
import com.biotechvana.csveditor.csvEditor.runnables.CsvEditorLinkSequencesRunnable;
import com.biotechvana.csveditor.editors.CSVEditor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CsvAssociateSequenceDatabaseDialog
extends TitleAreaDialog {
    private final String TITLE = "Link sequence database";
    private final String MESSAGE = "Associate worksheet with external sequence database in FASTA format.";
    private String[] columnNames;
    private String defaultPath = null;
    private CSVEditor csvEditor;
    private CsvAssociateSequenceDatabaseComposite composite;

    public CsvAssociateSequenceDatabaseDialog(Shell parentShell, CSVEditor csvEditor, String[] columnNames, String defaultPath) {
        super(parentShell);
        this.columnNames = columnNames;
        this.defaultPath = defaultPath;
        this.csvEditor = csvEditor;
    }

    public CsvAssociateSequenceDatabaseDialog(Shell parentShell, CSVEditor csvEditor, String[] columnNames) {
        this(parentShell, csvEditor, columnNames, null);
    }

    public void create() {
        super.create();
        this.setTitle("Link sequence database");
        this.setMessage("Associate worksheet with external sequence database in FASTA format.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Link sequence database");
        compositeParent.setLayoutData((Object)new GridData(1808));
        List model = (List)this.csvEditor.getModel();
        this.composite = new CsvAssociateSequenceDatabaseComposite(compositeParent, 0, (List)model.get(0), this.columnNames, this.defaultPath);
        return compositeParent;
    }

    private boolean validate() {
        String separator = this.composite.getSeparator();
        int[] selectedColumns = this.composite.getSelectedColumns();
        String selectedFile = this.composite.getSelectedFile();
        if (selectedColumns.length == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Link sequence database", (String)"Select at least one worksheet column.");
            return false;
        }
        if (selectedColumns.length > 1 && separator.isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Link sequence database", (String)"Column separator is required.");
        }
        if (selectedFile.isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Link sequence database", (String)"Sequence file is required.");
            return false;
        }
        if (!new File(selectedFile).exists()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Link sequence database", (String)"Invalid sequence file.");
            return false;
        }
        return true;
    }

    protected void okPressed() {
        if (!this.validate()) {
            return;
        }
        this.run();
        super.okPressed();
    }

    private void run() {
        String separator = this.composite.getSeparator();
        int[] selectedColumns = this.composite.getSelectedColumns();
        String selectedFile = this.composite.getSelectedFile();
        CsvEditorLinkSequencesRunnable runnable = new CsvEditorLinkSequencesRunnable(this.csvEditor, new File(selectedFile), selectedColumns, separator);
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)runnable);
            this.csvEditor.setAssociationFile(new File(selectedFile));
            this.csvEditor.setAssociationColumnIndices(selectedColumns);
            this.csvEditor.setAssociationSeparator(separator);
            this.csvEditor.setAssociationReference(this.composite.getSelectedReference());
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Link sequence database", (String)(NumberFormat.getInstance().format(runnable.getMatchesCount()) + " matching sequences."));
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Link sequence database", (String)("Error with association: " + e.getMessage()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

