/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.csvEditor.dialogs;

import com.biotechvana.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CsvAssociateSequenceDatabaseComposite
extends Composite {
    private final int COL2_OFFSET = 160;
    private final int PREVIEW_HEIGHT = 60;
    private String separator = "";
    private int[] selectedColumns;
    private String databaseFile;
    private final String TITLE = "Link sequence database";
    private final List<String> firstRowWorksheet;
    private org.eclipse.swt.widgets.List comboWorksheet;
    private Text textSeparator;
    private Label labelPreviewWorksheet;
    private Text textFile;
    private Label labelPreview;
    private Button buttonReferenceCsv;
    private Button buttonReferenceFasta;

    public static void main(String[] args) {
    }

    public CsvAssociateSequenceDatabaseComposite(Composite parent, int style, List<String> firstRowWorksheet, String[] columnNames, String initialPath) {
        super(parent, style);
        this.firstRowWorksheet = firstRowWorksheet;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        this.setLayout((Layout)layout);
        Group compositeWorksheet = this.createWorksheetGroup(this, columnNames);
        compositeWorksheet.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group compositeDatabase = this.createDatabaseGroup(this, initialPath);
        compositeDatabase.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group compositeOptions = this.createAssociationtypeGroup(this);
        compositeOptions.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private Group createWorksheetGroup(Composite parent, String[] columnNames) {
        Group composite = new Group(parent, 0);
        composite.setText("Worksheet");
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        Label label = new Label((Composite)composite, 0);
        label.setText("Worksheet columns:");
        label.setLayoutData((Object)new GridData(1, 128, false, false));
        this.comboWorksheet = new org.eclipse.swt.widgets.List((Composite)composite, 2818);
        this.comboWorksheet.setItems(columnNames);
        this.comboWorksheet.setLayoutData((Object)new GridData(4, 128, true, false));
        ((GridData)this.comboWorksheet.getLayoutData()).heightHint = 140;
        this.comboWorksheet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CsvAssociateSequenceDatabaseComposite.this.updateWorksheetPreview(CsvAssociateSequenceDatabaseComposite.this.comboWorksheet.getSelection(), CsvAssociateSequenceDatabaseComposite.this.comboWorksheet.getSelectionIndices(), CsvAssociateSequenceDatabaseComposite.this.textSeparator.getText(), CsvAssociateSequenceDatabaseComposite.this.labelPreviewWorksheet);
                }
                catch (IOException e1) {
                    MessageDialog.openError((Shell)CsvAssociateSequenceDatabaseComposite.this.getShell(), (String)"Link sequence database", (String)e1.getMessage());
                    e1.printStackTrace();
                }
                CsvAssociateSequenceDatabaseComposite.this.selectedColumns = CsvAssociateSequenceDatabaseComposite.this.comboWorksheet.getSelectionIndices();
            }
        });
        label = new Label((Composite)composite, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Label labelMultiple = new Label((Composite)composite, 0);
        labelMultiple.setText("Select multiple columns by Ctrl+Click (Win) or Cmd+Click(Mac)");
        labelMultiple.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label((Composite)composite, 0);
        label.setText("Separator:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textSeparator = new Text((Composite)composite, 2052);
        this.textSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textSeparator.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    CsvAssociateSequenceDatabaseComposite.this.updateWorksheetPreview(CsvAssociateSequenceDatabaseComposite.this.comboWorksheet.getSelection(), CsvAssociateSequenceDatabaseComposite.this.comboWorksheet.getSelectionIndices(), CsvAssociateSequenceDatabaseComposite.this.textSeparator.getText(), CsvAssociateSequenceDatabaseComposite.this.labelPreviewWorksheet);
                }
                catch (IOException e1) {
                    MessageDialog.openError((Shell)CsvAssociateSequenceDatabaseComposite.this.getShell(), (String)"Link sequence database", (String)e1.getMessage());
                    e1.printStackTrace();
                }
                CsvAssociateSequenceDatabaseComposite.this.separator = CsvAssociateSequenceDatabaseComposite.this.textSeparator.getText();
            }
        });
        label = new Label((Composite)composite, 0);
        label.setText("Preview:");
        label.setLayoutData((Object)new GridData(1, 128, false, false));
        this.labelPreviewWorksheet = new Label((Composite)composite, 2112);
        this.labelPreviewWorksheet.setText("");
        this.labelPreviewWorksheet.setLayoutData((Object)new GridData(4, 128, true, false));
        ((GridData)this.labelPreviewWorksheet.getLayoutData()).heightHint = 60;
        return composite;
    }

    private Group createDatabaseGroup(Composite parent, final String initialPath) {
        Group composite = new Group(parent, 0);
        composite.setText("Database");
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        Label label = new Label((Composite)composite, 0);
        label.setText("Sequence file: ");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textFile = new Text((Composite)composite, 2060);
        this.textFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button buttonFile = new Button((Composite)composite, 8);
        buttonFile.setText("Browse");
        buttonFile.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        buttonFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedFile;
                FileDialog dialog = new FileDialog(CsvAssociateSequenceDatabaseComposite.this.getShell(), 4096);
                if (initialPath != null && !initialPath.isEmpty()) {
                    dialog.setFilterPath(initialPath);
                }
                if ((selectedFile = dialog.open()) != null) {
                    try {
                        CsvAssociateSequenceDatabaseComposite.this.labelPreview.setText(CsvAssociateSequenceDatabaseComposite.this.getSequencePreview(selectedFile));
                        CsvAssociateSequenceDatabaseComposite.this.textFile.setText(selectedFile);
                        CsvAssociateSequenceDatabaseComposite.this.textFile.setSelection(selectedFile.length());
                        CsvAssociateSequenceDatabaseComposite.this.databaseFile = selectedFile;
                    }
                    catch (IOException e1) {
                        MessageDialog.openWarning((Shell)CsvAssociateSequenceDatabaseComposite.this.getShell(), (String)"Open database", (String)("Cannot read database file: " + e1.getMessage()));
                    }
                }
            }
        });
        label = new Label((Composite)composite, 0);
        label.setText("Preview:");
        label.setLayoutData((Object)new GridData(1, 128, false, false));
        this.labelPreview = new Label((Composite)composite, 2112);
        this.labelPreview.setText("");
        this.labelPreview.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        ((GridData)this.labelPreview.getLayoutData()).heightHint = 60;
        return composite;
    }

    private Group createAssociationtypeGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Reference file");
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.buttonReferenceCsv = new Button(composite, 16);
        this.buttonReferenceCsv.setText("Use CSV file as reference");
        this.buttonReferenceCsv.setSelection(true);
        this.buttonReferenceFasta = new Button(composite, 16);
        this.buttonReferenceFasta.setText("Use FASTA file as reference");
        Label label = new Label((Composite)group, 0);
        label.setText("All sequences present in reference file will be exported when requested");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)label.getLayoutData()).verticalIndent = 10;
        return group;
    }

    private void updateWorksheetPreview(String[] worksheetSelection, int[] columnIndices, String separator, Label labelPreviewWorksheet) throws IOException {
        if (worksheetSelection == null || worksheetSelection.length == 0) {
            labelPreviewWorksheet.setText("");
        }
        if (separator == null) {
            separator = "";
        }
        labelPreviewWorksheet.setText(StringUtils.join(this.getWorksheetSelectedColumns(columnIndices), (String)separator));
    }

    private List<String> getWorksheetSelectedColumns(int[] columnIndices) {
        ArrayList<String> selectedColumns = new ArrayList<String>();
        int[] nArray = columnIndices;
        int n = columnIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            selectedColumns.add(this.firstRowWorksheet.get(i + 2));
            ++n2;
        }
        return selectedColumns;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSequencePreview(String path) throws IOException {
        String preview = "";
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(path)));){
            block7: {
                String line;
                block6: {
                    if (!true) break block6;
                    line = reader.readLine();
                    if (line == null) return preview;
                    if (!preview.isEmpty()) break block7;
                }
                do {
                    if (!line.isEmpty()) {
                        preview = line;
                    }
                    line = reader.readLine();
                    if (line == null) return preview;
                } while (preview.isEmpty());
            }
            return preview;
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public int[] getSelectedColumns() {
        return this.selectedColumns;
    }

    public String getSelectedFile() {
        return this.databaseFile;
    }

    public int getSelectedReference() {
        if (this.buttonReferenceCsv.getSelection()) {
            return 0;
        }
        return 1;
    }
}

