/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions.metabolic;

import com.biotechvana.metabolicPathEditor.data.EnzymePathway;
import com.biotechvana.metabolicPathEditor.data.MetabolicExportDataRunnable;
import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import com.biotechvana.metabolicPathEditor.main.MetabolicPathMainComposite;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

public class MetabolicExportAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private MetabolicPathMainComposite metabolicView;

    public MetabolicExportAction(MetabolicPathMainComposite metabolicView) {
        this.metabolicView = metabolicView;
    }

    public void run() {
        List<SequenceEnzyme> listEnzymes = this.metabolicView.getListEnzymes();
        Collection<EnzymePathway> listNames = this.metabolicView.getMapNameList();
        File outputDirectory = new File(this.metabolicView.getProjectPath());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        FileDialog fileDialog = new FileDialog(this.metabolicView.getShell(), 8192);
        fileDialog.setFilterPath(outputDirectory.getAbsolutePath());
        fileDialog.setFileName("pathways_" + sdf.format(new Date()) + ".csv");
        Object res = fileDialog.open();
        if (res == null || ((String)res).length() == 0) {
            return;
        }
        if (!((String)res).endsWith(".csv")) {
            res = (String)res + ".csv";
        }
        MetabolicExportDataRunnable exportRunnable = new MetabolicExportDataRunnable(listEnzymes, listNames, outputDirectory, (String)res, this.metabolicView.getSpeciesColumnIndex() != -1);
        try {
            new ProgressMonitorDialog(this.metabolicView.getShell()).run(true, true, (IRunnableWithProgress)exportRunnable);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openWarning((Shell)this.metabolicView.getShell(), (String)"Metabolic Paths", (String)"Cannot export pathway data");
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void dispose() {
    }
}

