/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions.csvEditor;

import com.biotechvana.csveditor.dialogs.csvEditor.CsvExportDialog;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class CsvExportAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String TITLE = "Export worksheet and FASTA...";
    private CSVEditor csvEditor;

    public CsvExportAction(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.setText(TITLE);
    }

    public void run() {
        boolean res;
        if (this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false).length != this.csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true).length && !(res = MessageDialog.openQuestion((Shell)this.csvEditor.getSite().getShell(), (String)"Export", (String)"Hidden columns will be lost in exported file.\nContinue?"))) {
            return;
        }
        try {
            this.openExportDialog();
        }
        catch (InvocationTargetException e1) {
            MessageDialog.openError((Shell)this.csvEditor.getSite().getShell(), (String)TITLE, (String)("Error exporting: " + e1.getMessage()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void openExportDialog() throws InvocationTargetException, InterruptedException {
        CsvExportDialog dia;
        block9: {
            File selectedFile;
            block8: {
                this.csvEditor.setSelectedIndices(this.csvEditor.getCheckedRowIndices(true, true));
                if (this.csvEditor.getSelectedIndices().size() == 0) {
                    MessageDialog.openError((Shell)this.csvEditor.getSite().getShell(), (String)"Export", (String)"Please, select rows to export");
                    return;
                }
                int[] checkedColumnIndices = this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(true, true, false);
                if (checkedColumnIndices.length == 0) {
                    MessageDialog.openError((Shell)this.csvEditor.getSite().getShell(), (String)"Export", (String)"Select columns to export");
                    return;
                }
                try {
                    WorkspaceUtils.showView((String)FileExplorerBasic.ID);
                }
                catch (PartInitException e) {
                    if (!this.csvEditor.getDebug()) break block8;
                    e.printStackTrace();
                }
            }
            String defaultExportDirectory = null;
            IViewReference viewRef = WorkspaceUtils.findViewReference((String)FileExplorerBasic.ID);
            if (viewRef == null) {
                return;
            }
            FileExplorerBasic explorer = (FileExplorerBasic)viewRef.getPart(false);
            IStructuredSelection selection = explorer.getSelection();
            defaultExportDirectory = selection.size() > 0 ? ((selectedFile = (File)selection.getFirstElement()).isDirectory() ? selectedFile.getAbsolutePath() : selectedFile.getParent()) : this.csvEditor.getCsvFile().getParent();
            dia = new CsvExportDialog(this.csvEditor, defaultExportDirectory);
            try {
                int res = dia.open();
                if (res == 1) {
                    return;
                }
            }
            catch (Exception ex) {
                if (!this.csvEditor.getDebug()) break block9;
                ex.printStackTrace();
            }
        }
        dia.close();
    }

    public void dispose() {
    }
}

