/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.actions.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvRemoveColorRowsRunnable;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

public class CsvDeleteRowColorsAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final String TITLE = "Remove row colors...";
    private CSVEditor csvEditor;
    private List<Integer> listSelectedRows;

    public CsvDeleteRowColorsAction(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.setText(TITLE);
    }

    public void run() {
        if (this.csvEditor.isDirty()) {
            MessageDialog.openInformation((Shell)this.csvEditor.getSite().getShell(), (String)TITLE, (String)"Please, save document before operation");
            return;
        }
        try {
            this.listSelectedRows = this.csvEditor.getCheckedRowIndices(true, false);
            CsvRemoveColorRowsRunnable removeBackgroundColorsRunnable = this.listSelectedRows.size() == 0 ? new CsvRemoveColorRowsRunnable(this.csvEditor) : new CsvRemoveColorRowsRunnable(this.csvEditor, this.listSelectedRows);
            new ProgressMonitorDialog(this.csvEditor.getSite().getShell()).run(false, true, (IRunnableWithProgress)removeBackgroundColorsRunnable);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return;
        }
    }

    public void dispose() {
    }
}

