/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor;

import com.biotechvana.commons.model.RemoteServerInfo;
import com.biotechvana.commons.model.UserLoginInfo;
import com.biotechvana.csveditor.LocalUserManager;
import com.biotechvana.users.IUsersService;
import com.biotechvana.users.InvalidLoginInfoException;
import com.biotechvana.users.UserManager;
import java.io.IOException;
import java.util.List;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class LocalUsersServiceImplE3
implements IUsersService {
    private static String PREF_STORE_PATH = "com.biotechvana.userservice.local.UsersServiceImpl";
    ISecurePreferences prefs;
    UserManager currentUserManager;
    private List<UserLoginInfo> users;
    private List<RemoteServerInfo> hostsInfo;
    private UserLoginInfo activeLogin = null;

    public LocalUsersServiceImplE3() {
        this.init();
    }

    public List<UserLoginInfo> getLoginInfoList() {
        return this.users;
    }

    public List<RemoteServerInfo> getHostsInfoList() {
        return this.hostsInfo;
    }

    public void addLoginInfo(UserLoginInfo newInfo) {
        this.users.add(newInfo);
    }

    public void init() {
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        this.prefs = preferences.node(PREF_STORE_PATH);
        this.currentUserManager = new LocalUserManager();
        String activeUserNode = null;
        try {
            activeUserNode = this.prefs.get("ACTIVE_LOGIN", null);
            if (this.prefs.nodeExists(activeUserNode)) {
                ISecurePreferences userPrefs = this.prefs.node(activeUserNode);
                String preferenceEmail = userPrefs.get("email", "");
                String preferenceHost = userPrefs.get("ssh_host", "");
                String preferencePort = userPrefs.get("ssh_port", "22");
                String preferenceUser = userPrefs.get("ssh_user", "");
                String preferencePassword = userPrefs.get("ssh_password", "");
                UserLoginInfo user = new UserLoginInfo();
                user.setHostInfo(new RemoteServerInfo(preferenceHost, preferenceHost, 80, Integer.parseInt(preferencePort), 21));
                user.setUserName(preferenceUser);
                user.setPassword(preferencePassword);
                user.setEmailAddress(preferenceEmail);
                this.activeLogin = user;
                if (this.currentUserManager.setLogin(this.activeLogin)) {
                    this.setActiveLoginInCntx();
                }
            }
        }
        catch (InvalidLoginInfoException | IOException | StorageException e1) {
            e1.printStackTrace();
        }
    }

    public boolean changeLogin(UserLoginInfo newInfo) {
        String activeUserNode = newInfo.getUserName() + "#" + newInfo.hashCode();
        try {
            if (this.currentUserManager.setLogin(newInfo)) {
                this.activeLogin = newInfo;
                this.prefs.put("ACTIVE_LOGIN", activeUserNode, true);
                ISecurePreferences userPrefs = this.prefs.node(activeUserNode);
                userPrefs.put("email", this.activeLogin.getEmailAddress(), false);
                userPrefs.put("ssh_host", this.activeLogin.getHostInfo().getServerURL(), false);
                userPrefs.put("ssh_port", String.valueOf(this.activeLogin.getHostInfo().getSshPort()), false);
                userPrefs.put("ssh_user", this.activeLogin.getUserName(), true);
                userPrefs.put("ssh_password", this.activeLogin.getPassword(), true);
                this.setActiveLoginInCntx();
                return true;
            }
        }
        catch (StorageException e) {
            e.printStackTrace();
        }
        catch (InvalidLoginInfoException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public UserLoginInfo getActiveLogin() {
        return this.activeLogin;
    }

    private void setActiveLoginInCntx() {
    }

    public UserManager getUserManager() {
        return this.currentUserManager;
    }

    public boolean canLogin(UserLoginInfo newUser) {
        return this.currentUserManager.testConnection(newUser);
    }

    public boolean initLogin() throws Exception {
        return true;
    }
}

