/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.FileExplorer;

import com.biotechvana.csveditor.actions.fileExplorer.FastaWorksheetOpenAction;
import com.biotechvana.csveditor.actions.fileExplorer.WorksheetOpenAction;
import com.biotechvana.csveditor.dialogs.csvEditor.CsvOpenDialog;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;

public class CsvFileExplorer
extends FileExplorerBasic {
    public CsvFileExplorer() {
        ID = "com.biotechvana.csveditor.views.CsvFileExplorer";
    }

    protected void createContextMenu() {
        super.createContextMenu();
        this.menuNew.add((IAction)new FastaWorksheetOpenAction(this));
    }

    protected void insertItemIntoContextMenu() {
        this.popup.add((IAction)new WorksheetOpenAction(this));
    }

    public boolean openSystemEditor(File selectedFile) throws InvocationTargetException, IllegalArgumentException, FileNotFoundException, IOException, InterruptedException, PartInitException {
        if (super.openSystemEditor(selectedFile)) {
            return true;
        }
        String extension = FilenameUtils.getExtension((String)selectedFile.getName());
        if (extension.equalsIgnoreCase("csv") || extension.equalsIgnoreCase("gff")) {
            IEditorReference[] refs = WorkspaceUtils.getEditorReference((String)"com.biotechvana.csveditor.editors.CSVEditor");
            if (refs != null) {
                IEditorReference[] iEditorReferenceArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference r = iEditorReferenceArray[n2];
                    if (r.getPartName().equals(selectedFile.getName())) {
                        WorkspaceUtils.activateEditor((IEditorReference)r);
                        return true;
                    }
                    ++n2;
                }
            }
            CsvOpenDialog dialog = new CsvOpenDialog(this.getSite().getShell(), selectedFile.getAbsolutePath());
            dialog.open();
            return true;
        }
        return false;
    }
}

