/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.NestingTree;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.NodePair;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.RankList;
import org.eclipse.draw2d.graph.Subgraph;

class SortSubgraphs
extends GraphVisitor {
    CompoundDirectedGraph g;
    NestingTree[] nestingTrees;
    Set orderingGraphEdges = new HashSet();
    Set orderingGraphNodes = new HashSet();
    NodePair pair = new NodePair();

    SortSubgraphs() {
    }

    private void breakSubgraphCycles() {
        ArrayList<Node> noLefts = new ArrayList<Node>();
        int index = 1;
        for (Object orderingGraphNode : this.orderingGraphNodes) {
            Node node = (Node)orderingGraphNode;
            if (node.x != 0) continue;
            SortSubgraphs.sortedInsert(noLefts, node);
        }
        block1: while (true) {
            if (noLefts.size() > 0) {
                Node node = (Node)noLefts.remove(noLefts.size() - 1);
                node.sortValue = index;
                ++index;
                this.orderingGraphNodes.remove(node);
                NodeList rightOf = SortSubgraphs.rightOf(node);
                if (rightOf == null) continue;
                Iterator iterator = rightOf.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block1;
                    Node right = (Node)iterator.next();
                    --right.x;
                    if (right.x != 0) continue;
                    SortSubgraphs.sortedInsert(noLefts, right);
                }
            }
            Node cycleRoot = null;
            double min = Double.MAX_VALUE;
            for (Object orderingGraphNode : this.orderingGraphNodes) {
                Node node = (Node)orderingGraphNode;
                if (!(node.sortValue < min)) continue;
                cycleRoot = node;
                min = node.sortValue;
            }
            if (cycleRoot != null) {
                SortSubgraphs.sortedInsert(noLefts, cycleRoot);
                cycleRoot.x = -1;
            }
            if (cycleRoot == null) break;
        }
    }

    private void buildSubgraphOrderingGraph() {
        RankList ranks = this.g.ranks;
        this.nestingTrees = new NestingTree[ranks.size()];
        int r = 0;
        while (r < ranks.size()) {
            NestingTree entry;
            this.nestingTrees[r] = entry = NestingTree.buildNestingTreeForRank(ranks.getRank(r));
            entry.calculateSortValues();
            entry.recursiveSort(false);
            ++r;
        }
        NestingTree[] nestingTreeArray = this.nestingTrees;
        int n = this.nestingTrees.length;
        int n2 = 0;
        while (n2 < n) {
            NestingTree entry = nestingTreeArray[n2];
            this.buildSubgraphOrderingGraph(entry);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildSubgraphOrderingGraph(NestingTree entry) {
        NodePair pair = new NodePair();
        if (entry.isLeaf) {
            return;
        }
        for (Object right : entry.contents) {
            Object e = right;
            if (e instanceof Node) {
                void n;
                Node cfr_ignored_0 = (Node)e;
                Node cfr_ignored_1 = (Node)e;
                pair.n2 = n;
            } else {
                pair.n2 = ((NestingTree)right).subgraph;
                this.buildSubgraphOrderingGraph((NestingTree)right);
            }
            if (pair.n1 != null && !this.orderingGraphEdges.contains(pair)) {
                this.orderingGraphEdges.add(pair);
                SortSubgraphs.leftToRight(pair.n1, pair.n2);
                this.orderingGraphNodes.add(pair.n1);
                this.orderingGraphNodes.add(pair.n2);
                ++pair.n2.x;
                pair = new NodePair(pair.n2, null);
                continue;
            }
            pair.n1 = pair.n2;
        }
    }

    private void calculateSortValues() {
        RankList ranks = this.g.ranks;
        this.g.subgraphs.resetSortValues();
        this.g.subgraphs.resetIndices();
        ranks.forEach(rank -> rank.forEach(node -> {
            node.sortValue = node.index;
            Subgraph parent = node.getParent();
            while (parent != null) {
                parent.sortValue += node.sortValue;
                parent.index = parent.index + 1;
                parent = parent.getParent();
            }
        }));
        for (Node element : this.g.subgraphs) {
            Subgraph subgraph = (Subgraph)element;
            subgraph.sortValue /= (double)subgraph.index;
        }
    }

    private void repopulateRanks() {
        int i = 0;
        while (i < this.nestingTrees.length) {
            Rank rank = this.g.ranks.getRank(i);
            rank.clear();
            this.nestingTrees[i].repopulateRank(rank);
            ++i;
        }
    }

    private static NodeList rightOf(Node left) {
        return (NodeList)left.workingData[0];
    }

    private static void leftToRight(Node left, Node right) {
        SortSubgraphs.rightOf(left).add(right);
    }

    static void sortedInsert(List<Node> list, Node node) {
        int insert = 0;
        while (insert < list.size() && list.get((int)insert).sortValue > node.sortValue) {
            ++insert;
        }
        list.add(insert, node);
    }

    private void topologicalSort() {
        NestingTree[] nestingTreeArray = this.nestingTrees;
        int n = this.nestingTrees.length;
        int n2 = 0;
        while (n2 < n) {
            NestingTree nestingTree = nestingTreeArray[n2];
            nestingTree.getSortValueFromSubgraph();
            nestingTree.recursiveSort(false);
            ++n2;
        }
    }

    void init() {
        this.g.ranks.forEach(rank -> rank.forEach(n -> {
            NodeList nodeList = new NodeList();
        }));
        for (Node element : this.g.subgraphs) {
            Subgraph s = (Subgraph)element;
            s.workingData[0] = new NodeList();
        }
    }

    @Override
    public void visit(DirectedGraph dg) {
        this.g = (CompoundDirectedGraph)dg;
        this.init();
        this.buildSubgraphOrderingGraph();
        this.calculateSortValues();
        this.breakSubgraphCycles();
        this.topologicalSort();
        this.repopulateRanks();
    }
}

