/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.servercommons.dialogs.preferences;

import com.biotechvana.servercommons.dialogs.preferences.StreamGrapper;
import com.biotechvana.users.UserManager;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DockerHelper {
    public boolean dockerInstalled = false;
    String username;
    String password;
    String localDir;
    String ip;
    String containerName = "gpro_server";
    boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    ExecutorService v;

    public DockerHelper() {
        this.localDir = System.getProperty("user.home");
        this.v = Executors.newSingleThreadExecutor();
        this.dockerInstalled = this.checkDocker();
    }

    public boolean startGpro() {
        if (this.dockerInstalled) {
            try {
                this.removeContainer();
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                builder.command("docker", "run", "-d", "-p", "80:80", "-p", "20-22:20-22", "-p", "65500-65515:65500-65515", "-v", String.format("%s/:/data", this.localDir), "--name", this.containerName, "biotechvana/gpro");
                builder.directory(new File(System.getProperty("user.home")));
                Process process = builder.start();
                StreamGrapper streamGobbler = new StreamGrapper(process.getInputStream(), System.out::println);
                this.v.submit(streamGobbler);
                int exitCode = process.waitFor();
                System.out.println("Exit Code : " + exitCode);
                Thread.sleep(5000L);
                if (exitCode == 0) {
                    return true;
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean isRunning() throws NTryRestartEx {
        return this.isRunning(0);
    }

    public boolean isRunning(int nTry) throws NTryRestartEx {
        if (nTry > 10) {
            throw new NTryRestartEx();
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command("docker", "container", "inspect", this.containerName);
            Process process = builder.start();
            StringBuilder strBuilder = new StringBuilder();
            StreamGrapper streamGobbler = new StreamGrapper(process.getInputStream(), strBuilder::append);
            this.v.submit(streamGobbler);
            int exitCode = process.waitFor();
            System.out.println("Exit Code : " + exitCode + strBuilder.toString());
            if (exitCode == 0) {
                String result = strBuilder.toString();
                return this.checkStatus(result, nTry);
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean checkStatus(String resultStr, int nTry) throws NTryRestartEx {
        block7: {
            Gson gson = new Gson();
            try {
                Map map;
                ArrayList resArr = (ArrayList)gson.fromJson(resultStr, ArrayList.class);
                if (resArr.size() <= 0 || !(map = (Map)resArr.get(0)).containsKey("State") || (map = (Map)map.get("State")) == null || !map.containsKey("Status")) break block7;
                String status = (String)map.get("Status");
                if ("restarting".equals(status)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return this.isRunning(nTry + 1);
                }
                if ("running".equals(status)) {
                    return true;
                }
            }
            catch (NTryRestartEx ex) {
                throw ex;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return false;
    }

    public boolean removeContainer() {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("docker", "rm", "--force", this.containerName);
        try {
            Process process = builder.start();
            StreamGrapper streamGobbler = new StreamGrapper(process.getInputStream(), System.out::println);
            this.v.submit(streamGobbler);
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                return true;
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean checkDocker() {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("docker", "-v");
        builder.directory(new File(System.getProperty("user.home")));
        try {
            Process process = builder.start();
            StreamGrapper streamGobbler = new StreamGrapper(process.getInputStream(), System.out::println);
            this.v.submit(streamGobbler);
            int exitCode = process.waitFor();
            return true;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        DockerHelper dh = new DockerHelper();
        try {
            if (!dh.isRunning()) {
                dh.startGpro();
            }
        }
        catch (NTryRestartEx e) {
            e.printStackTrace();
        }
        dh.v.shutdown();
    }

    public static boolean checkStart(Display display, UserManager userManager) {
        if (userManager.get("USE_LOCAL_GPRO_PROP", "false").equals("true")) {
            return DockerHelper.checkStart(display, false);
        }
        return false;
    }

    public static boolean checkStart(Display display, boolean forceCheck) {
        DockerHelper helper = new DockerHelper();
        try {
            if (!helper.isRunning()) {
                helper.startGpro();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return helper.isRunning();
        }
        catch (NTryRestartEx e) {
            e.printStackTrace();
            if (display != null) {
                Shell activeShell = new Shell(display);
                MessageDialog.openError((Shell)activeShell, (String)"Error", (String)"can not start docker container");
            }
            return false;
        }
    }

    public class NTryRestartEx
    extends Exception {
        static final int maxNtry = 10;
    }
}

