/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.fileExplorerBasic.actions;

import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import jakarta.inject.Inject;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class FileExplorerDeleteAction {
    private FileExplorerBasic fileExplorer;

    @Inject
    public FileExplorerDeleteAction(FileExplorerBasic fileExplorer) {
        this.fileExplorer = fileExplorer;
    }

    @Execute
    public void run(UISynchronize sync) {
        boolean res = MessageDialog.openConfirm((Shell)this.fileExplorer.getShell(), (String)"Delete files", (String)"Delete selected files?");
        if (!res) {
            return;
        }
        final File[] selectedFiles = this.fileExplorer.getSelectedFiles();
        if (selectedFiles != null) {
            sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileExplorerDeleteAction.this.fileExplorer.deleteNodes(selectedFiles, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void run() {
        UISynchronize sync = (UISynchronize)this.fileExplorer.getMPart().getContext().get(UISynchronize.class);
        this.run(sync);
    }
}

