/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.fileExplorerBasic;

import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import com.biotechvana.javabiotoolkit.exceptions.FastaReaderNotParsedException;
import com.biotechvana.javabiotoolkit.io.FASTAReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileExplorerUtils {
    private FileExplorerBasic fileExplorer;
    private List<String> listExtension = Arrays.asList("txt", "text", "fa", "fna", "fasta", "");
    private File destination;

    public FileExplorerUtils(FileExplorerBasic fileExplorer) {
        this.fileExplorer = fileExplorer;
    }

    public void createReport(File fInput, String output, IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("Project properties", FileUtils.listFiles((File)fInput, null, (boolean)true).size());
        }
        List<File> listFiles = this.getFileChildren(fInput);
        StringBuilder exportText = new StringBuilder();
        List listParent = (List)FileUtils.listFiles((File)fInput, null, (boolean)false);
        exportText.append(fInput.getAbsolutePath() + " (" + listParent.size() + " files) \n");
        for (File f : listParent) {
            exportText.append(this.informationFasta(f));
            if (monitor == null) continue;
            monitor.worked(1);
        }
        exportText.append("\n");
        for (File f : listFiles) {
            if (monitor != null && monitor.isCanceled()) {
                this.exportReport(fInput, output, exportText.toString());
            }
            if (f.isDirectory()) {
                List listParent1 = (List)FileUtils.listFiles((File)f, null, (boolean)false);
                exportText.append(f.getAbsolutePath() + " (" + listParent1.size() + " files) \n");
                for (File f1 : listParent1) {
                    exportText.append(this.informationFasta(f1));
                    if (monitor == null) continue;
                    monitor.subTask(f1.getAbsolutePath());
                }
                exportText.append("\n");
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        this.exportReport(fInput, output, exportText.toString());
    }

    private String informationFasta(File file) {
        StringBuilder exportText = new StringBuilder();
        if (this.isExtensionValid(file)) {
            try {
                FASTAReader fastaReader = new FASTAReader(file);
                fastaReader.parse();
                int numSequences = fastaReader.getFastaRecords().size();
                if (numSequences == 0) {
                    exportText.append("\t + " + file.getName() + "\n");
                } else if (fastaReader.isProteinFile(0.15, 0.85)) {
                    exportText.append("\t + " + file.getName() + " (fasta)\n");
                    exportText.append("\t\t\t- Type: protein\n");
                    exportText.append("\t\t\t- Number of sequences: " + numSequences + "\n");
                } else if (fastaReader.isDnaFile(0.15, 0.85)) {
                    exportText.append("\t + " + file.getName() + " (fasta)\n");
                    exportText.append("\t\t\tType: nucleotide\n");
                    exportText.append("\t\t\tNumber of sequences: " + numSequences + "\n");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (FastaReaderNotParsedException e) {
                e.printStackTrace();
            }
        } else {
            exportText.append("\t + " + file.getName() + "\n");
        }
        return exportText.toString();
    }

    private void exportReport(File fInput, String output, String exportText) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(output));
            out.write(exportText);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isExtensionValid(File f) {
        for (String extension : this.listExtension) {
            if (!FilenameUtils.getExtension((String)f.getName()).equals(extension)) continue;
            return true;
        }
        return false;
    }

    public List<File> getFileChildren(File parent) {
        File[] arrayFiles;
        ArrayList<File> listFiles = new ArrayList<File>();
        File[] fileArray = arrayFiles = parent.listFiles();
        int n = arrayFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            listFiles.add(f);
            if (f.isDirectory()) {
                for (File c : this.getFileChildren(f)) {
                    listFiles.add(c);
                }
            }
            ++n2;
        }
        return listFiles;
    }

    public void paste(String name, IProgressMonitor monitor) {
        if (this.fileExplorer.copyItems == null || this.fileExplorer.copyItems.size() == 0) {
            return;
        }
        monitor.beginTask(name, -1);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IStructuredSelection selection = FileExplorerUtils.this.fileExplorer.getSelection();
                if (selection == null | selection.size() == 0) {
                    return;
                }
                FileExplorerUtils.this.destination = (File)selection.getFirstElement();
                if (FileExplorerUtils.this.destination.isFile()) {
                    FileExplorerUtils.this.destination = FileExplorerUtils.this.destination.getParentFile();
                }
            }
        });
        for (File item : this.fileExplorer.copyItems) {
            monitor.subTask(item.getName());
            if (item.isFile()) {
                try {
                    String destinationAbsolutePath = this.destination.getAbsolutePath() + File.separator + FilenameUtils.getName((String)item.getAbsolutePath());
                    if (!FilenameUtils.equals((String)item.getAbsolutePath(), (String)destinationAbsolutePath)) {
                        FileUtils.copyFileToDirectory((File)item, (File)this.destination);
                        continue;
                    }
                    final String itemName = FilenameUtils.getName((String)item.getAbsolutePath());
                    InputDialog inputDialog = new InputDialog(this.fileExplorer.getShell(), "Name confict", "Destination file name already exists", "Copy of " + FilenameUtils.getName((String)item.getAbsolutePath()), new IInputValidator(){

                        public String isValid(String newText) {
                            if (FilenameUtils.equals((String)itemName, (String)newText)) {
                                return "Destination file name already exists";
                            }
                            return null;
                        }
                    });
                    if (inputDialog.open() != 0) continue;
                    File file = new File(this.destination.getAbsolutePath() + File.separator + inputDialog.getValue());
                    FileUtils.copyFile((File)item, (File)file);
                    monitor.subTask("Copying: " + String.valueOf(item));
                    monitor.worked(1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                if (item.getAbsolutePath().equalsIgnoreCase(this.destination.getAbsolutePath())) {
                    return;
                }
                if (item.getAbsolutePath().equals(this.destination.getAbsolutePath() + File.separator + item.getName())) {
                    MessageDialog.openWarning((Shell)this.fileExplorer.getShell(), (String)"Name conflict", (String)"Folder name already exists");
                    return;
                }
                FileUtils.copyDirectoryToDirectory((File)item, (File)this.destination);
                monitor.subTask("Copying: " + String.valueOf(item));
                monitor.worked(1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FileExplorerUtils.this.fileExplorer.getFileViewer().refresh((Object)FileExplorerUtils.this.destination);
            }
        });
    }
}

