/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.fileExplorerBasic;

import com.biotechvana.commons.IFileTransferService;
import com.biotechvana.commons.IGproApp;
import com.biotechvana.commons.viewers.IFileBrowser;
import com.biotechvana.fileExplorerBasic.FileExplorerContentProvider;
import com.biotechvana.fileExplorerBasic.FileExplorerExcludeSystemFiles;
import com.biotechvana.fileExplorerBasic.FileExplorerLabelProvider;
import com.biotechvana.fileExplorerBasic.FileExplorerUtils;
import com.biotechvana.fileExplorerBasic.actions.FileExplorerCopyAction;
import com.biotechvana.fileExplorerBasic.actions.FileExplorerCutAction;
import com.biotechvana.fileExplorerBasic.actions.FileExplorerDeleteAction;
import com.biotechvana.fileExplorerBasic.actions.FileExplorerNewFileAction;
import com.biotechvana.fileExplorerBasic.actions.FileExplorerNewFolderAction;
import com.biotechvana.fileExplorerBasic.actions.FileExplorerPasteAction;
import com.biotechvana.fileExplorerBasic.actions.FileExplorerRenameAction;
import com.biotechvana.users.UserManager;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class FileExplorerBasic
implements IFileBrowser {
    public static String ID = "com.biotechvana.ui.fileexplorer";
    public static String BUNDLE_ID = "com.biotechvana.ui.fileexplorer";
    public static String CONTEXT_MENU_ID = "fileExplorer.context.menu";
    protected boolean debug = false;
    protected TreeViewer fileViewer;
    private FileExplorerUtils fileExplorerUtils = new FileExplorerUtils(this);
    protected File workspace;
    private boolean showColumns = true;
    private TreeViewerColumn fileColumn;
    private TreeViewerColumn sizeColumn;
    private TreeViewerColumn dateColumn;
    private boolean cut;
    private static File[] selectedFilesCut;
    public IStructuredSelection copyItems;
    UserManager userManager;
    @Inject
    @Optional
    IFileTransferService fileTransferService;
    @Inject
    private MPart part;
    @Inject
    @Named(value="activeShell")
    private Shell activeShell;
    @Inject
    UISynchronize sync;
    @Optional
    @Inject
    IStatusLineManager statusLine;

    @PostConstruct
    public void createPartControl(Composite parent, EMenuService menuService, MApplication app) {
        block9: {
            long timeStart;
            block8: {
                app.getContext().set(FileExplorerBasic.class, (Object)this);
                app.getContext().set(IFileBrowser.class, (Object)this);
                Composite composite = new Composite(parent, 0);
                FormLayout layout = new FormLayout();
                composite.setLayout((Layout)layout);
                FormData layoutData = new FormData();
                layoutData.top = new FormAttachment(0, 0);
                layoutData.left = new FormAttachment(0, 0);
                layoutData.bottom = new FormAttachment(100, 0);
                layoutData.right = new FormAttachment(100, 0);
                this.checkWorkspace();
                this.fileViewer = new TreeViewer(composite, 2818);
                this.fileViewer.getTree().setLayoutData((Object)layoutData);
                if (this.workspace != null) {
                    this.fillFileViewer();
                }
                timeStart = System.currentTimeMillis();
                if (this.workspace != null) {
                    try {
                        this.fileViewer.setInput((Object)this.workspace.getParentFile());
                    }
                    catch (Exception ex) {
                        if (!this.debug) break block8;
                        ex.printStackTrace();
                    }
                }
            }
            long timeEnd = System.currentTimeMillis();
            if (this.debug) {
                System.out.println("Filetree created in (ms): " + (timeEnd - timeStart));
            }
            this.fileViewer.addFilter((ViewerFilter)new FileExplorerExcludeSystemFiles());
            this.fileViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    FileExplorerBasic.this.explorerSelectionChanged();
                }
            });
            this.addDragCapability();
            this.addDropCapability();
            this.createContextMenu();
            menuService.registerContextMenu((Object)this.fileViewer.getControl(), CONTEXT_MENU_ID);
            this.hookDoubleClickCommand();
            try {
                this.createToolBar();
            }
            catch (Exception ex) {
                if (!this.debug) break block9;
                ex.printStackTrace();
            }
        }
        if (this.workspace != null) {
            this.fileViewer.setExpandedElements((Object[])new File[]{this.workspace});
        }
        this.addListeners();
    }

    public void setShowColumns(boolean showColumns) {
        this.showColumns = showColumns;
        this.updateColumnVisibility();
    }

    public void updateColumnVisibility() {
        this.fileViewer.getTree().setHeaderVisible(this.showColumns);
        this.sizeColumn.getColumn().setWidth(this.showColumns ? 100 : 0);
        this.dateColumn.getColumn().setWidth(this.showColumns ? 100 : 0);
    }

    public void fillFileViewer() {
        this.fileViewer.setContentProvider((IContentProvider)new FileExplorerContentProvider(this.workspace, this.fileViewer));
        this.fileViewer.setUseHashlookup(true);
        this.fileViewer.getTree().setHeaderVisible(this.showColumns);
        this.fileViewer.getTree().setLinesVisible(true);
        this.fileColumn = new TreeViewerColumn(this.fileViewer, 0);
        this.fileColumn.getColumn().setWidth(500);
        this.fileColumn.getColumn().setText("File");
        this.fileColumn.setLabelProvider((CellLabelProvider)new FileExplorerLabelProvider(this.workspace));
        this.sizeColumn = new TreeViewerColumn(this.fileViewer, 0x1000000);
        this.sizeColumn.getColumn().setWidth(this.showColumns ? 100 : 0);
        this.sizeColumn.getColumn().setText("Size");
        this.sizeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                File file = (File)element;
                if (file.isDirectory()) {
                    return "";
                }
                return FileUtils.byteCountToDisplaySize((long)file.length());
            }
        });
        this.dateColumn = new TreeViewerColumn(this.fileViewer, 0x1000000);
        this.dateColumn.getColumn().setWidth(this.showColumns ? 100 : 0);
        this.dateColumn.getColumn().setText("Date");
        this.dateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                File file = (File)element;
                if (file.isDirectory()) {
                    return "";
                }
                return DateFormatUtils.format((long)file.lastModified(), (String)"dd/MM/YYYY");
            }
        });
    }

    private void addListeners() {
        final FileExplorerBasic fe = this;
        this.fileViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                char c = (char)e.keyCode;
                if ((e.stateMask & 0x40000) != 0) {
                    switch (c) {
                        case 'c': {
                            new FileExplorerCopyAction(fe).run();
                            break;
                        }
                        case 'x': {
                            new FileExplorerCutAction(fe).run();
                            break;
                        }
                        case 'v': {
                            new FileExplorerPasteAction(fe).run();
                        }
                    }
                } else {
                    switch (e.keyCode) {
                        case 127: {
                            new FileExplorerDeleteAction(fe).run();
                            break;
                        }
                        case 0x100000B: {
                            new FileExplorerRenameAction(fe).run();
                        }
                    }
                }
            }
        });
    }

    private void addDragCapability() {
        int operations = 7;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        DragSource source = new DragSource((Control)this.fileViewer.getTree(), operations);
        source.setTransfer(transfers);
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)FileExplorerBasic.this.fileViewer.getSelection();
                String[] arraySel = new String[selection.size()];
                Iterator it = selection.iterator();
                int counter = 0;
                while (it.hasNext()) {
                    arraySel[counter++] = ((File)it.next()).getAbsolutePath();
                }
                event.data = arraySel;
            }

            public void dragFinished(DragSourceEvent event) {
                if (event.detail == 8) {
                    FileExplorerBasic.this.updateInput();
                }
            }
        });
    }

    private void addDropCapability() {
        int operations = 7;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)this.fileViewer.getTree(), operations);
        target.setTransfer(transfers);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                if (event.data instanceof String[]) {
                    FileExplorerBasic.this.performDrop((String[])event.data, (TreeItem)event.item);
                } else if (event.data instanceof String) {
                    FileExplorerBasic.this.performFtpDrop((String)event.data, (TreeItem)event.item);
                } else {
                    if (FileExplorerBasic.this.debug) {
                        System.out.println("Undefined data source");
                    }
                    return;
                }
            }

            public void dragOver(DropTargetEvent event) {
            }
        });
    }

    protected void performFtpDrop(String ftpFiles, TreeItem treeItem) {
        File destination;
        if (treeItem == null) {
            destination = this.workspace;
        } else {
            destination = (File)treeItem.getData();
            if (!destination.isDirectory()) {
                destination = destination.getParentFile();
            }
        }
        ArrayList<String> ftpFileList = new ArrayList<String>();
        StringTokenizer sTokenizer = new StringTokenizer(ftpFiles, "|");
        while (sTokenizer.hasMoreTokens()) {
            String s = sTokenizer.nextToken().trim();
            if ((s = s.replace("ftp:", "").trim()).isEmpty()) continue;
            ftpFileList.add(s);
        }
        File destinationFolder = destination;
        this.fileTransferService.downloadFiles(ftpFileList, (Object)destination.getAbsolutePath());
    }

    private void performDrop(String[] dropFiles, TreeItem treeItem) {
        File destination;
        if (treeItem == null) {
            destination = this.workspace;
        } else {
            destination = (File)treeItem.getData();
            if (!destination.isDirectory()) {
                destination = destination.getParentFile();
            }
        }
        String[] stringArray = dropFiles;
        int n = dropFiles.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                String cp = stringArray[n2];
                try {
                    File copyFile = new File(cp);
                    if (copyFile.getAbsolutePath().equalsIgnoreCase(destination.getAbsolutePath())) {
                        MessageDialog.openError((Shell)this.activeShell, (String)"Copy files", (String)"Warning: destination file already exists.");
                        return;
                    }
                    String destinationFileName = destination.getAbsolutePath() + File.separator + cp;
                    if (copyFile.getAbsolutePath().equalsIgnoreCase(destinationFileName)) {
                        MessageDialog.openError((Shell)this.activeShell, (String)"Copy files", (String)"Warning: destination file already exists.");
                        return;
                    }
                    if (copyFile.isFile()) {
                        FileUtils.copyFileToDirectory((File)copyFile, (File)destination);
                    } else {
                        FileUtils.copyDirectoryToDirectory((File)copyFile, (File)destination);
                    }
                }
                catch (IOException e) {
                    MessageDialog.openWarning((Shell)this.activeShell, (String)"File copy", (String)("Error copying file: " + cp));
                    if (!this.debug) break block10;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        this.fileViewer.refresh((Object)destination);
    }

    @Inject
    @Optional
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    private void checkWorkspace() {
        String defaultWorkspace = null;
        if (this.userManager != null) {
            defaultWorkspace = this.userManager.get("workspace", "");
        }
        this.workspace = defaultWorkspace == null || defaultWorkspace.isEmpty() ? null : new File(defaultWorkspace);
    }

    public void paste(String name, IProgressMonitor monitor) {
        this.fileExplorerUtils.paste(name, monitor);
    }

    public TreeViewer getFileViewer() {
        return this.fileViewer;
    }

    public File getWorkspace() {
        return this.workspace;
    }

    public List<File> getFileChildren(File parent) {
        List<File> listFiles = this.fileExplorerUtils.getFileChildren(parent);
        return listFiles;
    }

    public void createReport(File fInput, String output, IProgressMonitor monitor) {
        this.fileExplorerUtils.createReport(fInput, output, monitor);
    }

    public void setWorkspace(File workspace) {
        this.workspace = workspace;
        if (!this.fileViewer.getControl().isDisposed()) {
            this.fillFileViewer();
            this.fileViewer.setInput((Object)workspace.getParentFile());
            this.fileViewer.setExpandedElements((Object[])new File[]{workspace});
        }
    }

    public void deleteNodes(File[] nodes, IProgressMonitor monitor) throws InterruptedException {
        try {
            ArrayList<File> listParents = new ArrayList<File>();
            monitor.beginTask("Delete files", nodes.length);
            File[] fileArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                File node = fileArray[n2];
                listParents.add(node.getParentFile());
                FileUtils.deleteQuietly((File)node);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                monitor.subTask("Deleting: " + node.getAbsolutePath());
                monitor.worked(1);
                ++n2;
            }
            for (File parent : listParents) {
                this.fileViewer.refresh((Object)parent);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void createToolBar() {
    }

    public boolean createNewFile(String parent, String name) {
        boolean res;
        name = name.replaceAll("\\s+", "_");
        final File fileNew = new File(parent + File.separator + (name = name.replaceAll("\\(|\\)|\\[|\\|\\\\|/", "")));
        if (fileNew.exists() && !(res = MessageDialog.openConfirm((Shell)this.activeShell, (String)"New file", (String)"File already exists. Overwrite?"))) {
            return false;
        }
        try {
            fileNew.createNewFile();
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.activeShell, (String)"New file", (String)"Cannot create new file");
            if (this.debug) {
                e.printStackTrace();
            }
            return false;
        }
        try {
            new ProgressMonitorDialog(this.activeShell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Update directory", -1);
                    monitor.subTask("Scanning filesystem");
                    try {
                        FileExplorerBasic.this.activeShell.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                (this).FileExplorerBasic.this.fileViewer.refresh((Object)fileNew.getParentFile());
                            }
                        });
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public boolean createNewFolder(String parent, String name) {
        name = name.replaceAll("\\s+", "_");
        final File fileNew = new File(parent + File.separator + (name = name.replaceAll("\\(|\\)|\\[|\\|\\\\|/", "")));
        if (fileNew.exists()) {
            MessageDialog.openWarning((Shell)this.activeShell, (String)"Create new folder", (String)"Folder already exists");
            return false;
        }
        boolean res = fileNew.mkdir();
        if (!res) {
            MessageDialog.openError((Shell)this.activeShell, (String)"New folder", (String)"Cannot create new folder");
        }
        try {
            new ProgressMonitorDialog(this.activeShell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Update directory", -1);
                    monitor.subTask("Scanning filesystem");
                    try {
                        FileExplorerBasic.this.activeShell.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                (this).FileExplorerBasic.this.fileViewer.refresh((Object)fileNew.getParentFile());
                            }
                        });
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return res;
    }

    public boolean renameFile(File selectedFile, String newName) {
        boolean res = selectedFile.renameTo(new File(selectedFile.getParent() + File.separator + newName));
        this.fileViewer.refresh((Object)selectedFile.getParentFile());
        return res;
    }

    private void hookDoubleClickCommand() {
        this.fileViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                block5: {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    File file = (File)selection.getFirstElement();
                    if (file.isDirectory()) {
                        FileExplorerBasic.this.expandNodes(file);
                    } else {
                        try {
                            IStructuredSelection selectionFile = (IStructuredSelection)FileExplorerBasic.this.fileViewer.getSelection();
                            if (selectionFile != null) {
                                File selectedFile = (File)selectionFile.getFirstElement();
                                FileExplorerBasic.this.openSystemEditor(selectedFile);
                            }
                        }
                        catch (Exception e) {
                            if (!FileExplorerBasic.this.debug) break block5;
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    private void expandNodes(File selectedFile) {
        Object[] selection = this.fileViewer.getExpandedElements();
        boolean newSelection = true;
        ArrayList<File> listSelection = new ArrayList<File>();
        if (selection.length > 0) {
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                File f = (File)o;
                if (f.getAbsolutePath().equals(selectedFile.getAbsolutePath())) {
                    newSelection = false;
                } else {
                    listSelection.add(f);
                }
                ++n2;
            }
        } else {
            listSelection.add(selectedFile);
        }
        if (newSelection) {
            listSelection.add(selectedFile);
        }
        this.fileViewer.setExpandedElements((Object[])listSelection.toArray(new File[listSelection.size()]));
    }

    public Object[] getExpandedNodes() {
        return this.fileViewer.getExpandedElements();
    }

    private void expandNodes(File[] openNodes) {
        this.fileViewer.setExpandedElements((Object[])openNodes);
    }

    private void expandNodes(IStructuredSelection selection) {
        ArrayList<File> expandedElements = new ArrayList<File>();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            expandedElements.add((File)it.next());
        }
        this.expandNodes(expandedElements.toArray(new File[expandedElements.size()]));
    }

    private Object getInput() {
        return this.fileViewer.getInput();
    }

    private void setInput(Object input) {
        this.fileViewer.setInput(input);
    }

    public void updateInput() {
        if (this.workspace == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fileViewer.getSelection();
        Object[] expandedElements = this.fileViewer.getExpandedElements();
        this.fileViewer.setInput(this.fileViewer.getInput());
        ArrayList<File> exp = new ArrayList<File>();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            exp.add((File)it.next());
        }
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            exp.add((File)o);
            ++n2;
        }
        this.expandNodes(exp.toArray(new File[exp.size()]));
    }

    public void updateInput(File newInput) {
        this.fileViewer.setInput((Object)newInput);
    }

    @Focus
    public void setFocus() {
    }

    public void explorerSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.fileViewer.getSelection();
        Object[] sel = selection.toArray();
        if (this.statusLine != null) {
            this.statusLine.setMessage(sel.length + " files selected");
        }
    }

    public IStructuredSelection getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.fileViewer.getSelection();
        return selection;
    }

    public File[] getSelectedFiles() {
        ArrayList<File> listFiles = new ArrayList<File>();
        IStructuredSelection selection = this.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            listFiles.add((File)it.next());
        }
        return listFiles.toArray(new File[listFiles.size()]);
    }

    protected void insertItemIntoContextMenu() {
    }

    protected void createContextMenu() {
        MPopupMenu popupMenu = MMenuFactory.INSTANCE.createPopupMenu();
        popupMenu.setElementId(CONTEXT_MENU_ID);
        this.part.getMenus().add(popupMenu);
        MMenu newMenu = MMenuFactory.INSTANCE.createMenu();
        newMenu.setElementId("fileViewer.menu.new");
        newMenu.setLabel("New");
        popupMenu.getChildren().add(newMenu);
        MDirectMenuItem menuItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        menuItem.setElementId("fileViewer.menu.new.file");
        menuItem.setLabel("File");
        menuItem.setContributionURI(IGproApp.getClassURI((String)BUNDLE_ID, FileExplorerNewFileAction.class));
        newMenu.getChildren().add(menuItem);
        menuItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        menuItem.setElementId("fileViewer.menu.new.folder");
        menuItem.setLabel("Folder");
        menuItem.setContributionURI(IGproApp.getClassURI((String)BUNDLE_ID, FileExplorerNewFolderAction.class));
        newMenu.getChildren().add(menuItem);
        MMenuSeparator menuItemSep = MMenuFactory.INSTANCE.createMenuSeparator();
        menuItemSep.setElementId("sep.file");
        popupMenu.getChildren().add(menuItemSep);
        menuItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        menuItem.setElementId("fileViewer.menu.cut");
        menuItem.setLabel("Cut");
        menuItem.setContributionURI(IGproApp.getClassURI((String)BUNDLE_ID, FileExplorerCutAction.class));
        popupMenu.getChildren().add(menuItem);
        menuItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        menuItem.setElementId("fileViewer.menu.copy");
        menuItem.setLabel("Copy");
        menuItem.setContributionURI(IGproApp.getClassURI((String)BUNDLE_ID, FileExplorerCopyAction.class));
        popupMenu.getChildren().add(menuItem);
        menuItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        menuItem.setElementId("fileViewer.menu.paste");
        menuItem.setLabel("Paste");
        menuItem.setContributionURI(IGproApp.getClassURI((String)BUNDLE_ID, FileExplorerPasteAction.class));
        popupMenu.getChildren().add(menuItem);
        menuItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        menuItem.setElementId("fileViewer.menu.delete");
        menuItem.setLabel("Delete");
        menuItem.setContributionURI(IGproApp.getClassURI((String)BUNDLE_ID, FileExplorerDeleteAction.class));
        popupMenu.getChildren().add(menuItem);
        menuItemSep = MMenuFactory.INSTANCE.createMenuSeparator();
        menuItemSep.setElementId("sep.opt");
        popupMenu.getChildren().add(menuItemSep);
        menuItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        menuItem.setElementId("fileViewer.menu.rename");
        menuItem.setLabel("Rename");
        menuItem.setContributionURI(IGproApp.getClassURI((String)BUNDLE_ID, FileExplorerRenameAction.class));
        popupMenu.getChildren().add(menuItem);
    }

    public boolean openSystemEditor(File selectedFile) throws InvocationTargetException, IllegalArgumentException, FileNotFoundException, IOException, InterruptedException {
        String extension = FilenameUtils.getExtension((String)selectedFile.getName());
        if (extension.equalsIgnoreCase("rtf") || extension.equalsIgnoreCase("doc") || extension.equalsIgnoreCase("docx") || extension.equalsIgnoreCase("pdf") || extension.equalsIgnoreCase("zip") || extension.equalsIgnoreCase("rar") || extension.equalsIgnoreCase("xls") || extension.equalsIgnoreCase("xlsx") || extension.equalsIgnoreCase("html") || extension.equalsIgnoreCase("htm") || extension.equalsIgnoreCase("exe") || extension.equalsIgnoreCase("ps") || extension.equalsIgnoreCase("ai") || extension.equalsIgnoreCase("ppt") || extension.equalsIgnoreCase("png") || extension.equalsIgnoreCase("gif") || extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg")) {
            Program.launch((String)selectedFile.getAbsolutePath());
            return true;
        }
        return false;
    }

    public void setSelection(StructuredSelection selection) {
        Iterator it = selection.iterator();
        ArrayList<File> openFolders = new ArrayList<File>();
        while (it.hasNext()) {
            File f = (File)it.next();
            openFolders.add(f.getParentFile());
        }
        Object[] arrayFolders = openFolders.toArray(new File[openFolders.size()]);
        this.fileViewer.setExpandedElements(arrayFolders);
        this.fileViewer.setSelection((ISelection)selection, true);
    }

    public IStructuredSelection getCopyItems() {
        return this.copyItems;
    }

    public void setCopyItems(IStructuredSelection copyItems) {
        this.copyItems = copyItems;
    }

    public void setCut(boolean cut) {
        this.cut = cut;
    }

    public boolean getCut() {
        return this.cut;
    }

    public File[] getSelectedFilesCut() {
        return selectedFilesCut;
    }

    public void setSelectedFilesCut(File[] selectedFilesCut) {
        FileExplorerBasic.selectedFilesCut = selectedFilesCut;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Shell getShell() {
        return this.activeShell;
    }

    public MPart getMPart() {
        return this.part;
    }

    public String getSelectedPath() {
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return this.workspace.getAbsolutePath();
        }
        File selectedFile = (File)selection.getFirstElement();
        if (selectedFile.isFile()) {
            selectedFile = selectedFile.getParentFile();
        }
        return selectedFile.getAbsolutePath();
    }

    public boolean isInitialized() {
        return this.workspace != null;
    }
}

