/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.workflow.manager;

import com.biotechvana.shared.jobs.MappingPipelineStarter;
import com.biotechvana.shared.jobs.PreprocessingPipelineStarter;
import com.biotechvana.shared.jobs.SharedCatalog;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingCUTADAPTJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingFASTAQCJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingFastqIntersectJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingPRINSEQJob;
import com.biotechvana.variantseq.jobs.calling.gatk.GATKHaplotypeCallerJob;
import com.biotechvana.variantseq.jobs.calling.varscan2.Varscan2GermlineVariantsJob;
import com.biotechvana.variantseq.jobs.postprocessing.gatk.BaseScoreQualityRecalibrationJob;
import com.biotechvana.variantseq.jobs.postprocessing.gatk.GATKSplitNCigarReadsJob;
import com.biotechvana.variantseq.jobs.postprocessing.picard.PicardAddReplaceReadGroupsJob;
import com.biotechvana.variantseq.jobs.postprocessing.picard.PicardMarkDuplicatesJob;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.variantseq.workflow.starters.PipelineGSVCStarter;
import com.biotechvana.variantseq.workflow.starters.PipelineVariantStarter;
import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.WorkflowMetadata;
import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.template.WorkflowTemplate;
import java.util.HashMap;

public class VariantPipelinesCreatorHelper
extends SharedCatalog {
    static String TAG_Exome = "exome";
    static String TAG_Genome = "genome";
    static String TAG_Transcriptome = "transcriptome";
    static String TAG_germline = "germline";
    static String TAG_GATK = "gatk";
    static String TAG_VARSCAN = "varscan";
    static String TAG_genotyping = "genotyping";
    static String TAG_cancer = "cancer";
    static String TAG_somatic = "somatic";
    static String TAG_pedrigree = "pedrigree";
    static HashMap<String, Integer> mapperToId = new HashMap();
    static final String sharedAuthor = "Biotechvana";
    static final String sharedRef = "http://biotechvana.com/";

    static {
        mapperToId.put("Bowtie2", 1);
        mapperToId.put("Tophat", 2);
        mapperToId.put("hisat2", 3);
        mapperToId.put("STAR", 4);
        mapperToId.put("bwa", 5);
    }

    private static String createPreprocessing_Cutadapt_Prinseq(WorkflowTemplate template, boolean paired) {
        template.addStarterTask(PreprocessingPipelineStarter.JOB_ID, new Object[]{paired});
        String fastqc_post = SharedCatalog.createSharedPreprocessingModules((WorkflowTemplate)template, (String[])new String[]{"CUTADAPT", "PRINSEQ"}, (boolean)paired);
        return fastqc_post;
    }

    private static String createPreprocessing_Trimmomatic(WorkflowTemplate template, boolean paired) {
        template.addStarterTask(PreprocessingPipelineStarter.JOB_ID, new Object[]{paired});
        String fastqc_post = SharedCatalog.createSharedPreprocessingModules((WorkflowTemplate)template, (String[])new String[]{"trimmomatic"}, (boolean)paired);
        return fastqc_post;
    }

    public static WorkflowTemplate createWorkflow_Preprocessing_CPO(boolean paired) {
        int pipelineID = 60010;
        if (paired) {
            pipelineID += 10;
        }
        WorkflowTemplate template = new WorkflowTemplate();
        template.setTemplateId(Integer.toString(pipelineID));
        if (paired) {
            template.setDefaultWorkflowName("PCPO_PE");
        } else {
            template.setDefaultWorkflowName("PCPO_SE");
        }
        WorkflowMetadata metaData = template.getMetadata();
        metaData.setDesc("Preprocessing Only");
        if (paired) {
            metaData.setName("Preprocessing - PE");
        } else {
            metaData.setName("Preprocessing - SE");
        }
        metaData.setAuthor(sharedAuthor);
        metaData.setRef(sharedRef);
        metaData.addCategory(TAG_All);
        String fastqc_post = VariantPipelinesCreatorHelper.createPreprocessing_Cutadapt_Prinseq(template, paired);
        return template;
    }

    public static WorkflowTemplate createWorkflow_Preprocessing_TO(boolean paired) {
        int pipelineID = 60110;
        if (paired) {
            pipelineID += 10;
        }
        WorkflowTemplate template = new WorkflowTemplate();
        template.setTemplateId(Integer.toString(pipelineID));
        if (paired) {
            template.setDefaultWorkflowName("PTO_PE");
        } else {
            template.setDefaultWorkflowName("PTO_SE");
        }
        WorkflowMetadata metaData = template.getMetadata();
        metaData.setDesc("Preprocessing Only");
        if (paired) {
            metaData.setName("Preprocessing - PE");
        } else {
            metaData.setName("Preprocessing - SE");
        }
        metaData.setAuthor(sharedAuthor);
        metaData.setRef(sharedRef);
        metaData.addCategory(TAG_All);
        String fastqc_post = VariantPipelinesCreatorHelper.createPreprocessing_Trimmomatic(template, paired);
        return template;
    }

    private static String createPreprocessing_Mapping(WorkflowTemplate template, boolean paired) {
        String fastqc_post = SharedCatalog.createSharedPreprocessingModules((WorkflowTemplate)template, (String[])new String[]{"trimmomatic"}, (boolean)paired);
        return fastqc_post;
    }

    public static WorkflowTemplate createWorkflow_Preprocessing_Mapping(String[] prepocessingModules, int mapperIndex, boolean paired) {
        int pipelineID = 7000000;
        if (paired) {
            ++pipelineID;
        }
        if (SharedCatalog.PrePocessingModules_T.equals(prepocessingModules)) {
            pipelineID += 10000;
        }
        pipelineID += mapperIndex * 100;
        if (--mapperIndex < 0) {
            mapperIndex = 0;
        }
        if (mapperIndex >= mappersId.length) {
            mapperIndex = 1;
        }
        String mapperJobId = mappersId[mapperIndex];
        String[] mapperKeys = VariantPipelinesCreatorHelper.getMapperInputOutputKeys((String)mapperJobId);
        String inputFastqVarKey = mapperKeys[0];
        String outputBAMVarKey = mapperKeys[1];
        WorkflowTemplate template = new WorkflowTemplate();
        template.setTemplateId(Integer.toString(pipelineID));
        if (paired) {
            template.setDefaultWorkflowName("PM_PE");
        } else {
            template.setDefaultWorkflowName("PM_SE");
        }
        WorkflowMetadata metaData = template.getMetadata();
        String desc = "Preprocessing and Mapping (" + mapperJobId + ")";
        if (paired) {
            metaData.setName("Preprocessing & Mapping");
            desc = desc + " - PE";
        } else {
            metaData.setName("Preprocessing & Mapping");
            desc = desc + " - SE";
        }
        metaData.setDesc(desc);
        metaData.setAuthor(sharedAuthor);
        metaData.setRef(sharedRef);
        metaData.addCategory(TAG_All);
        template.addStarterTask(MappingPipelineStarter.JOB_ID, new Object[]{paired});
        String mapper_jobid = VariantPipelinesCreatorHelper.get_PM_Module((WorkflowTemplate)template, (String[])prepocessingModules, (String)mapperJobId, (boolean)paired);
        return template;
    }

    public static WorkflowTemplate createWorkflow_Preprocessing_Mapping_GermlineSomaticVariants(String[] prepocessingModules, int mapperIndex, boolean paired) {
        int pipelineID = VariantPipelinesCreatorHelper.getNXZero((int)12, (int)6);
        if (paired) {
            ++pipelineID;
        }
        pipelineID += mapperIndex * 100;
        if (--mapperIndex < 0) {
            mapperIndex = 0;
        }
        if (mapperIndex >= mappersId.length) {
            mapperIndex = 1;
        }
        String mapperJobId = mappersId[mapperIndex];
        String[] mapperKeys = VariantPipelinesCreatorHelper.getMapperInputOutputKeys((String)mapperJobId);
        String inputFastqVarKey = mapperKeys[0];
        String outputBAMVarKey = mapperKeys[1];
        WorkflowTemplate template = new WorkflowTemplate();
        template.setTemplateId(Integer.toString(pipelineID));
        WorkflowMetadata metaData = template.getMetadata();
        Object defaultWN = "PMP";
        if (mapperJobId.equals("hisat2") || mapperJobId.equals("Tophat") || mapperJobId.equals("STAR")) {
            defaultWN = (String)defaultWN + "GATKT";
            metaData.setName("Variant Calling - Transcriptome");
        } else {
            defaultWN = (String)defaultWN + "GATKGE";
            metaData.setName("Variant Calling - Genome/exome");
        }
        defaultWN = (String)defaultWN + Integer.toString(mapperIndex + 1);
        defaultWN = paired ? (String)defaultWN + "_PE" : (String)defaultWN + "_SE";
        template.setDefaultWorkflowName((String)defaultWN);
        String desc = "Preprocessing, Mapping, Postprocessing, GATK calling of both germline and somatic variants (" + mapperJobId + ")";
        desc = paired ? desc + " - Pair-End" : desc + " - Single-End";
        metaData.setDesc(desc);
        metaData.setAuthor(sharedAuthor);
        metaData.setRef("GATK Best Practices, https://software.broadinstitute.org/gatk/best-practices/");
        metaData.addCategory(TAG_somatic);
        metaData.addCategory(TAG_germline);
        metaData.addTag(TAG_somatic);
        metaData.addTag(TAG_germline);
        metaData.addTag(TAG_GATK);
        template.addStarterTask(PipelineVariantStarter.JOB_ID, new Object[]{paired});
        String fastqc_post = SharedCatalog.createSharedPreprocessingModules((WorkflowTemplate)template, (String[])prepocessingModules, (boolean)paired);
        String mapper_jobid = VariantPipelinesCreatorHelper.addMapper((WorkflowTemplate)template, (String)mapperJobId, (String)fastqc_post, (String)inputFastqVarKey, (boolean)paired);
        template.addTask("picardAddReplaceReadGroups");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"picardAddReplaceReadGroups");
        template.addMapping(mapper_jobid, outputBAMVarKey, "picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.INPUT_BAM_FILES);
        template.addTask("picardMarkDuplicates");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"picardMarkDuplicates");
        template.addMapping("picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.OUTPUT_BAM_FILES, "picardMarkDuplicates", PicardMarkDuplicatesJob.INPUT_BAM_FILES);
        String lastJobId = "picardMarkDuplicates";
        String lastJobVarKey = PicardMarkDuplicatesJob.OUTPUT_BAM_FILES;
        if (mapperJobId.equals("hisat2") || mapperJobId.equals("Tophat") || mapperJobId.equals("STAR")) {
            template.addTask("splitNCigarReads");
            VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"splitNCigarReads");
            template.addMapping(lastJobId, lastJobVarKey, "splitNCigarReads", GATKSplitNCigarReadsJob.INPUT_BAM_FILES);
            lastJobId = "splitNCigarReads";
            lastJobVarKey = GATKSplitNCigarReadsJob.OUTPUT_BAM_FILES;
        }
        template.addTask("BQSR");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"BQSR");
        template.addMapping(lastJobId, lastJobVarKey, "BQSR", BaseScoreQualityRecalibrationJob.INPUT_BAM_FILES);
        if (mapperJobId.equals("hisat2") || mapperJobId.equals("Tophat") || mapperJobId.equals("STAR")) {
            template.addMapping("splitNCigarReads", VariantAnaylsisVariableBag.INPUT_REF_FASTA, "BQSR", VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        }
        template.addTask("haplotypeCaller");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"haplotypeCaller");
        template.addMapping("BQSR", BaseScoreQualityRecalibrationJob.OUTPUT_BAM_FILES, "haplotypeCaller", GATKHaplotypeCallerJob.INPUT_BAM_FILES);
        template.addMapping("BQSR", VariantAnaylsisVariableBag.INPUT_REF_FASTA, "haplotypeCaller", VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        template.addTask("VQSR");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"VQSR");
        template.addMapping("haplotypeCaller", "OUTPUT_VARIANTS_VCF", "VQSR", "INPUT_VARIANTS_VCF");
        template.addMapping("haplotypeCaller", VariantAnaylsisVariableBag.INPUT_REF_FASTA, "VQSR", VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        return template;
    }

    public static WorkflowTemplate createWorkflow_GermlineSomaticVariantsGATK(boolean rnaseq) {
        int pipelineID = VariantPipelinesCreatorHelper.getNXZero((int)121, (int)5);
        if (rnaseq) {
            pipelineID = VariantPipelinesCreatorHelper.getNXZero((int)122, (int)5);
        }
        WorkflowTemplate template = new WorkflowTemplate();
        template.setTemplateId(Integer.toString(pipelineID));
        WorkflowMetadata metaData = template.getMetadata();
        String defaultWN = "GATK_GSVC";
        if (rnaseq) {
            defaultWN = "GATK_GSVCT";
            metaData.setName("Variant Calling - Transcriptome");
        } else {
            defaultWN = "GATK_GSVC";
            metaData.setName("Variant Calling - Genome/exome");
        }
        template.setDefaultWorkflowName(defaultWN);
        String desc = "GATK calling of both germline and somatic variants";
        metaData.setDesc(desc);
        metaData.setAuthor(sharedAuthor);
        metaData.setRef("GATK Best Practices, https://software.broadinstitute.org/gatk/best-practices/");
        metaData.addCategory(TAG_somatic);
        metaData.addCategory(TAG_germline);
        metaData.addTag(TAG_somatic);
        metaData.addTag(TAG_germline);
        metaData.addTag(TAG_GATK);
        template.addStarterTask(PipelineGSVCStarter.JOB_ID, new Object[]{false});
        template.addTask("picardAddReplaceReadGroups");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"picardAddReplaceReadGroups");
        template.addMapping(PipelineGSVCStarter.JOB_ID, "OUTPUT_FILES", "picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.INPUT_BAM_FILES);
        template.addTask("picardMarkDuplicates");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"picardMarkDuplicates");
        template.addMapping("picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.OUTPUT_BAM_FILES, "picardMarkDuplicates", PicardMarkDuplicatesJob.INPUT_BAM_FILES);
        String lastJobId = "picardMarkDuplicates";
        String lastJobVarKey = PicardMarkDuplicatesJob.OUTPUT_BAM_FILES;
        if (rnaseq) {
            template.addTask("splitNCigarReads");
            VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"splitNCigarReads");
            template.addMapping(lastJobId, lastJobVarKey, "splitNCigarReads", GATKSplitNCigarReadsJob.INPUT_BAM_FILES);
            lastJobId = "splitNCigarReads";
            lastJobVarKey = GATKSplitNCigarReadsJob.OUTPUT_BAM_FILES;
        }
        template.addTask("BQSR");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"BQSR");
        template.addMapping(lastJobId, lastJobVarKey, "BQSR", BaseScoreQualityRecalibrationJob.INPUT_BAM_FILES);
        if (rnaseq) {
            template.addMapping("splitNCigarReads", VariantAnaylsisVariableBag.INPUT_REF_FASTA, "BQSR", VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        }
        template.addTask("haplotypeCaller");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"haplotypeCaller");
        template.addMapping("BQSR", BaseScoreQualityRecalibrationJob.OUTPUT_BAM_FILES, "haplotypeCaller", GATKHaplotypeCallerJob.INPUT_BAM_FILES);
        template.addMapping("BQSR", VariantAnaylsisVariableBag.INPUT_REF_FASTA, "haplotypeCaller", VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        template.setCustomVariableValue("haplotypeCaller", "EMIT_REF_CONFIDENCE", "NONE", true);
        return template;
    }

    public static WorkflowTemplate createWorkflow_Preprocessing_Mapping_GE_GenotypingGermlineSomaticVariants(String[] prepocessingModules, int mapperIndex, boolean paired) {
        int pipelineID = 13000000;
        if (paired) {
            ++pipelineID;
        }
        pipelineID += mapperIndex * 100;
        if (--mapperIndex < 0) {
            mapperIndex = 0;
        }
        if (mapperIndex >= mappersId.length) {
            mapperIndex = 1;
        }
        String mapperJobId = mappersId[mapperIndex];
        String[] mapperKeys = VariantPipelinesCreatorHelper.getMapperInputOutputKeys((String)mapperJobId);
        String inputFastqVarKey = mapperKeys[0];
        String outputBAMVarKey = mapperKeys[1];
        WorkflowTemplate template = new WorkflowTemplate();
        template.setTemplateId(Integer.toString(pipelineID));
        WorkflowMetadata metaData = template.getMetadata();
        Object defaultWN = "PMP";
        defaultWN = (String)defaultWN + "GATKC";
        metaData.setName("Genome/exome-germline/somatic & genotyping");
        defaultWN = (String)defaultWN + Integer.toString(mapperIndex + 1);
        defaultWN = paired ? (String)defaultWN + "_PE" : (String)defaultWN + "_SE";
        template.setDefaultWorkflowName((String)defaultWN);
        String desc = "Preprocessing, mapping, Postprocessing, GATK calling and genotyping of both germline and somatic variants (" + mapperJobId + ")";
        desc = paired ? desc + " - PE" : desc + " - SE";
        metaData.setDesc(desc);
        metaData.setAuthor(sharedAuthor);
        metaData.setRef("GATK Best Practices, https://software.broadinstitute.org/gatk/best-practices/");
        metaData.addCategory(TAG_somatic);
        metaData.addCategory(TAG_germline);
        metaData.addTag(TAG_somatic);
        metaData.addTag(TAG_germline);
        metaData.addTag(TAG_GATK);
        template.addStarterTask(PipelineVariantStarter.JOB_ID, new Object[]{paired});
        String fastqc_post = SharedCatalog.createSharedPreprocessingModules((WorkflowTemplate)template, (String[])prepocessingModules, (boolean)paired);
        String mapper_jobid = VariantPipelinesCreatorHelper.addMapper((WorkflowTemplate)template, (String)mapperJobId, (String)fastqc_post, (String)inputFastqVarKey, (boolean)paired);
        template.addTask("picardAddReplaceReadGroups");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"picardAddReplaceReadGroups");
        template.addMapping(mapper_jobid, outputBAMVarKey, "picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.INPUT_BAM_FILES);
        template.addTask("picardMarkDuplicates");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"picardMarkDuplicates");
        template.addMapping("picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.OUTPUT_BAM_FILES, "picardMarkDuplicates", PicardMarkDuplicatesJob.INPUT_BAM_FILES);
        String lastJobId = "picardMarkDuplicates";
        String lastJobVarKey = PicardMarkDuplicatesJob.OUTPUT_BAM_FILES;
        template.addTask("BQSR");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"BQSR");
        template.addTask("haplotypeCaller");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"haplotypeCaller");
        template.setCustomVariableValue("haplotypeCaller", "EMIT_REF_CONFIDENCE", "GVCF");
        template.addTask("combineGVCFs");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"combineGVCFs");
        template.addTask("genotypeGVCFs");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"genotypeGVCFs");
        template.addTask("VQSR");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"VQSR");
        template.addMapping(lastJobId, lastJobVarKey, "BQSR", BaseScoreQualityRecalibrationJob.INPUT_BAM_FILES);
        template.addMapping("BQSR", BaseScoreQualityRecalibrationJob.OUTPUT_BAM_FILES, "haplotypeCaller", GATKHaplotypeCallerJob.INPUT_BAM_FILES);
        template.addMapping("BQSR", VariantAnaylsisVariableBag.INPUT_REF_FASTA, "haplotypeCaller", VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        template.addMapping("haplotypeCaller", "OUTPUT_VARIANTS_VCF", "combineGVCFs", "INPUT_VARIANTS_VCF");
        template.addMapping("haplotypeCaller", VariantAnaylsisVariableBag.INPUT_REF_FASTA, "combineGVCFs", VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        template.addMapping("combineGVCFs", "OUTPUT_VARIANTS_VCF", "genotypeGVCFs", "INPUT_VARIANTS_VCF");
        template.addMapping("combineGVCFs", VariantAnaylsisVariableBag.INPUT_REF_FASTA, "genotypeGVCFs", VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        template.addMapping("genotypeGVCFs", "OUTPUT_VARIANTS_VCF", "VQSR", "INPUT_VARIANTS_VCF");
        template.addMapping("genotypeGVCFs", VariantAnaylsisVariableBag.INPUT_REF_FASTA, "VQSR", VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        return template;
    }

    public static WorkflowTemplate createWorkflow_Preprocessing_Mapping_GE_SomaticMutect2(String[] prepocessingModules, int mapperIndex, boolean paired) {
        int pipelineID = 14010000;
        if (paired) {
            ++pipelineID;
        }
        pipelineID += mapperIndex * 100;
        if (--mapperIndex < 0) {
            mapperIndex = 0;
        }
        if (mapperIndex >= mappersId.length) {
            mapperIndex = 1;
        }
        String mapperJobId = mappersId[mapperIndex];
        String[] mapperKeys = VariantPipelinesCreatorHelper.getMapperInputOutputKeys((String)mapperJobId);
        String inputFastqVarKey = mapperKeys[0];
        String outputBAMVarKey = mapperKeys[1];
        WorkflowTemplate template = new WorkflowTemplate();
        template.setTemplateId(Integer.toString(pipelineID));
        WorkflowMetadata metaData = template.getMetadata();
        Object defaultWN = "PMP";
        defaultWN = (String)defaultWN + "MUTECT";
        metaData.setName("Genome/exome-cancer");
        defaultWN = (String)defaultWN + Integer.toString(mapperIndex + 1);
        defaultWN = paired ? (String)defaultWN + "_PE" : (String)defaultWN + "_SE";
        template.setDefaultWorkflowName((String)defaultWN);
        String desc = "Preprocessing, mapping, Postprocessing, GATK-MUTECT2 calling of cancer variants (" + mapperJobId + ")";
        desc = paired ? desc + " - PE" : desc + " - SE";
        metaData.setDesc(desc);
        metaData.setAuthor(sharedAuthor);
        metaData.setRef("GATK Best Practices, https://software.broadinstitute.org/gatk/best-practices/");
        metaData.addCategory(TAG_somatic);
        metaData.addCategory(TAG_cancer);
        metaData.addTag(TAG_somatic);
        metaData.addTag(TAG_cancer);
        metaData.addTag(TAG_GATK);
        template.addStarterTask(PipelineVariantStarter.JOB_ID, new Object[]{paired});
        String fastqc_post = SharedCatalog.createSharedPreprocessingModules((WorkflowTemplate)template, (String[])prepocessingModules, (boolean)paired);
        String mapper_jobid = VariantPipelinesCreatorHelper.addMapper((WorkflowTemplate)template, (String)mapperJobId, (String)fastqc_post, (String)inputFastqVarKey, (boolean)paired);
        template.addTask("picardAddReplaceReadGroups");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"picardAddReplaceReadGroups");
        template.addMapping(mapper_jobid, outputBAMVarKey, "picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.INPUT_BAM_FILES);
        template.addTask("picardMarkDuplicates");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"picardMarkDuplicates");
        template.addMapping("picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.OUTPUT_BAM_FILES, "picardMarkDuplicates", PicardMarkDuplicatesJob.INPUT_BAM_FILES);
        String lastJobId = "picardMarkDuplicates";
        String lastJobVarKey = PicardMarkDuplicatesJob.OUTPUT_BAM_FILES;
        template.addTask("BQSR");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"BQSR");
        template.addTask("mutect2");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"mutect2");
        template.addMapping(lastJobId, lastJobVarKey, "BQSR", BaseScoreQualityRecalibrationJob.INPUT_BAM_FILES);
        template.addMapping("BQSR", BaseScoreQualityRecalibrationJob.OUTPUT_BAM_FILES, "mutect2", "TUMOR_BAM");
        return template;
    }

    public static WorkflowTemplate createWorkflow_Preprocessing_Mapping_GermlineVariants_varscan(String[] prepocessingModules, int mapperIndex, boolean paired) {
        int pipelineID = 15000000;
        if (paired) {
            ++pipelineID;
        }
        pipelineID += mapperIndex * 100;
        if (--mapperIndex < 0) {
            mapperIndex = 0;
        }
        if (mapperIndex >= mappersId.length) {
            mapperIndex = 1;
        }
        String mapperJobId = mappersId[mapperIndex];
        String[] mapperKeys = VariantPipelinesCreatorHelper.getMapperInputOutputKeys((String)mapperJobId);
        String inputFastqVarKey = mapperKeys[0];
        String outputBAMVarKey = mapperKeys[1];
        WorkflowTemplate template = new WorkflowTemplate();
        template.setTemplateId(Integer.toString(pipelineID));
        WorkflowMetadata metaData = template.getMetadata();
        Object defaultWN = "PMP";
        if (mapperJobId.equals("hisat2") || mapperJobId.equals("Tophat") || mapperJobId.equals("STAR")) {
            defaultWN = (String)defaultWN + "VARSCANTG";
            metaData.setName("Variant Calling - Transcriptome-germline");
        } else {
            defaultWN = (String)defaultWN + "VARSCANGEG";
            metaData.setName("Variant Calling - Genome/exome-germline");
        }
        defaultWN = (String)defaultWN + Integer.toString(mapperIndex + 1);
        defaultWN = paired ? (String)defaultWN + "_PE" : (String)defaultWN + "_SE";
        template.setDefaultWorkflowName((String)defaultWN);
        String desc = "Preprocessing, mapping, Postprocessing, VARSCAN2 calling of germline variants (" + mapperJobId + ")";
        desc = paired ? desc + " - PE" : desc + " - SE";
        metaData.setDesc(desc);
        metaData.setAuthor(sharedAuthor);
        metaData.setRef(sharedRef);
        metaData.addCategory(TAG_germline);
        metaData.addTag(TAG_germline);
        metaData.addTag(TAG_VARSCAN);
        template.addStarterTask(PipelineVariantStarter.JOB_ID, new Object[]{paired});
        String fastqc_post = SharedCatalog.createSharedPreprocessingModules((WorkflowTemplate)template, (String[])prepocessingModules, (boolean)paired);
        String mapper_jobid = VariantPipelinesCreatorHelper.addMapper((WorkflowTemplate)template, (String)mapperJobId, (String)fastqc_post, (String)inputFastqVarKey, (boolean)paired);
        template.addTask("picardAddReplaceReadGroups");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"picardAddReplaceReadGroups");
        template.addMapping(mapper_jobid, outputBAMVarKey, "picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.INPUT_BAM_FILES);
        template.addTask("picardMarkDuplicates");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"picardMarkDuplicates");
        template.addMapping("picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.OUTPUT_BAM_FILES, "picardMarkDuplicates", PicardMarkDuplicatesJob.INPUT_BAM_FILES);
        String lastJobId = "picardMarkDuplicates";
        String lastJobVarKey = PicardMarkDuplicatesJob.OUTPUT_BAM_FILES;
        if (mapperJobId.equals("hisat2") || mapperJobId.equals("Tophat") || mapperJobId.equals("STAR")) {
            template.addTask("splitNCigarReads");
            VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"splitNCigarReads");
            template.addMapping(lastJobId, lastJobVarKey, "splitNCigarReads", GATKSplitNCigarReadsJob.INPUT_BAM_FILES);
            lastJobId = "splitNCigarReads";
            lastJobVarKey = GATKSplitNCigarReadsJob.OUTPUT_BAM_FILES;
        }
        template.addTask("mpileup2VarScan");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"mpileup2VarScan");
        template.addMapping(lastJobId, lastJobVarKey, "mpileup2VarScan", Varscan2GermlineVariantsJob.INPUT_BAM_FILES);
        return template;
    }

    public static WorkflowTemplate createWorkflow_Preprocessing_Mapping_SomaticVariants_varscan(String[] prepocessingModules, int mapperIndex, boolean paired) {
        int pipelineID = 16000000;
        if (paired) {
            ++pipelineID;
        }
        pipelineID += mapperIndex * 100;
        if (--mapperIndex < 0) {
            mapperIndex = 0;
        }
        if (mapperIndex >= mappersId.length) {
            mapperIndex = 1;
        }
        String mapperJobId = mappersId[mapperIndex];
        String[] mapperKeys = VariantPipelinesCreatorHelper.getMapperInputOutputKeys((String)mapperJobId);
        String inputFastqVarKey = mapperKeys[0];
        String outputBAMVarKey = mapperKeys[1];
        WorkflowTemplate template = new WorkflowTemplate();
        template.setTemplateId(Integer.toString(pipelineID));
        WorkflowMetadata metaData = template.getMetadata();
        Object defaultWN = "PMP";
        if (mapperJobId.equals("hisat2") || mapperJobId.equals("Tophat") || mapperJobId.equals("STAR")) {
            defaultWN = (String)defaultWN + "VARSCANTS";
            metaData.setName("Variant Calling - Transcriptome-Somatic");
        } else {
            defaultWN = (String)defaultWN + "VARSCANGES";
            metaData.setName("Variant Calling - Genome/exome-Somatic");
        }
        defaultWN = (String)defaultWN + Integer.toString(mapperIndex + 1);
        defaultWN = paired ? (String)defaultWN + "_PE" : (String)defaultWN + "_SE";
        template.setDefaultWorkflowName((String)defaultWN);
        String desc = "Preprocessing, mapping, Postprocessing, VARSCAN2 calling of somatic variants (" + mapperJobId + ")";
        desc = paired ? desc + " - PE" : desc + " - SE";
        metaData.setDesc(desc);
        metaData.setAuthor(sharedAuthor);
        metaData.setRef(sharedRef);
        metaData.addCategory(TAG_somatic);
        metaData.addTag(TAG_somatic);
        metaData.addTag(TAG_VARSCAN);
        template.addStarterTask(PipelineVariantStarter.JOB_ID, new Object[]{paired});
        String fastqc_post = SharedCatalog.createSharedPreprocessingModules((WorkflowTemplate)template, (String[])prepocessingModules, (boolean)paired);
        String mapper_jobid = VariantPipelinesCreatorHelper.addMapper((WorkflowTemplate)template, (String)mapperJobId, (String)fastqc_post, (String)inputFastqVarKey, (boolean)paired);
        template.addTask("picardAddReplaceReadGroups");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"picardAddReplaceReadGroups");
        template.addMapping(mapper_jobid, outputBAMVarKey, "picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.INPUT_BAM_FILES);
        template.addTask("picardMarkDuplicates");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"picardMarkDuplicates");
        template.addMapping("picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.OUTPUT_BAM_FILES, "picardMarkDuplicates", PicardMarkDuplicatesJob.INPUT_BAM_FILES);
        String lastJobId = "picardMarkDuplicates";
        String lastJobVarKey = PicardMarkDuplicatesJob.OUTPUT_BAM_FILES;
        if (mapperJobId.equals("hisat2") || mapperJobId.equals("Tophat") || mapperJobId.equals("STAR")) {
            template.addTask("splitNCigarReads");
            VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"splitNCigarReads");
            template.addMapping(lastJobId, lastJobVarKey, "splitNCigarReads", GATKSplitNCigarReadsJob.INPUT_BAM_FILES);
            lastJobId = "splitNCigarReads";
            lastJobVarKey = GATKSplitNCigarReadsJob.OUTPUT_BAM_FILES;
        }
        template.addTask("somaticVarScan");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"somaticVarScan");
        template.addMapping(lastJobId, lastJobVarKey, "somaticVarScan", "TUMOR_BAM");
        return template;
    }

    public static WorkflowTemplate createPreprocessing_PE() {
        int pipelineID = 6001;
        WorkflowTemplate template = new WorkflowTemplate();
        template.setTemplateId(Integer.toString(pipelineID));
        template.setDefaultWorkflowName("PPE_");
        WorkflowMetadata metaData = template.getMetadata();
        metaData.setDesc("Preprocessing Only - optimized for PairEnd reads");
        metaData.setName("Preprocessing PE");
        metaData.setAuthor(sharedAuthor);
        metaData.setRef(sharedRef);
        metaData.addTag("cufflink");
        metaData.addCategory(TAG_All);
        template.addStarterTask(PipelineVariantStarter.JOB_ID, new Object[]{true});
        String fastqc_post = SharedCatalog.createSharedPreprocessingModules((WorkflowTemplate)template, (String[])new String[]{"CUTADAPT"}, (boolean)true);
        return template;
    }

    public static WorkflowTemplate createSample1_SE() {
        int pipelineID = 6002;
        WorkflowTemplate template = new WorkflowTemplate();
        template.setTemplateId(Integer.toString(pipelineID));
        template.setDefaultWorkflowName("PSE");
        WorkflowMetadata metaData = template.getMetadata();
        metaData.setDesc("Preprocessing Only - optimized for Single reads ");
        metaData.setName("Preprocessing SE");
        metaData.setAuthor(sharedAuthor);
        metaData.setRef(sharedRef);
        template.addStarterTask(PipelineVariantStarter.JOB_ID, new Object[]{false});
        String fastqc_post = SharedCatalog.createSharedPreprocessingModules((WorkflowTemplate)template, (String[])new String[]{"CUTADAPT", "PRINSEQ", "trimmomatic"}, (boolean)false);
        return template;
    }

    private static WorkflowJob createSharedPreprocessingModulesPE(Workflow workflow) {
        workflow.getMetadata().addTag("pairend");
        WorkflowStartupJob setupJob = workflow.getStartupJob();
        PreProcessingFASTAQCJob fastqc = new PreProcessingFASTAQCJob();
        workflow.addJob((WorkflowJob)fastqc);
        workflow.addMapping((WorkflowJob)setupJob, "INPUT_FILES", (WorkflowJob)fastqc, "INPUT_FILES");
        PreProcessingCUTADAPTJob cutadapt = new PreProcessingCUTADAPTJob();
        workflow.addJob((WorkflowJob)cutadapt);
        workflow.addMapping((WorkflowJob)fastqc, "OUTPUT_FILES", (WorkflowJob)cutadapt, "INPUT_FILES");
        cutadapt.setValueByCMDSwitch("--minimum-length", "50");
        PreProcessingPRINSEQJob prinseq = new PreProcessingPRINSEQJob();
        workflow.addJob((WorkflowJob)prinseq);
        workflow.addMapping((WorkflowJob)cutadapt, "OUTPUT_FILES", (WorkflowJob)prinseq, "INPUT_FILES");
        prinseq.setValueByCMDSwitch("-ns_max_p", "10");
        prinseq.setValueByCMDSwitch("-trim_ns_left", "1");
        prinseq.setValueByCMDSwitch("-trim_ns_right", "1");
        prinseq.setValueByCMDSwitch("-min_qual_mean", "20");
        prinseq.setValueByCMDSwitch("-trim_qual_right", "28");
        prinseq.setValueByCMDSwitch("-ns_max_p", "15");
        PreProcessingFastqIntersectJob intersect = new PreProcessingFastqIntersectJob();
        workflow.addJob((WorkflowJob)intersect);
        workflow.addMapping((WorkflowJob)prinseq, "OUTPUT_FILES", (WorkflowJob)intersect, "INPUT_FILES");
        PreProcessingFASTAQCJob fastqc_post = new PreProcessingFASTAQCJob();
        workflow.addJob((WorkflowJob)fastqc_post);
        workflow.addMapping((WorkflowJob)intersect, "OUTPUT_FILES", (WorkflowJob)fastqc_post, "INPUT_FILES");
        return fastqc_post;
    }

    public static WorkflowTemplate createWorkflow_VQS_pipeline() {
        int pipelineID = 17000000;
        WorkflowTemplate template = new WorkflowTemplate();
        template.setTemplateId(Integer.toString(pipelineID));
        template.setDefaultWorkflowName("VQS Haplotyper");
        WorkflowMetadata metaData = template.getMetadata();
        metaData.setDesc("VQS Haplotyper");
        metaData.setName("VQS Haplotyper");
        metaData.setAuthor(sharedAuthor);
        metaData.setRef(sharedRef);
        metaData.addCategory(TAG_All);
        template.addStarterTask("checkMetadata");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"checkMetadata");
        template.addTask("QualityAnalysisPipeline");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"QualityAnalysisPipeline");
        template.addTask("VQSHaplotyper");
        VariantPipelinesCreatorHelper.addTaskMetaInfo((WorkflowTemplate)template, (String)"VQSHaplotyper");
        template.addMapping("checkMetadata", "INPUT_FASTQs_FOlDER_NAME", "QualityAnalysisPipeline", "INPUT_FASTQs_FOlDER_NAME");
        template.addMapping("checkMetadata", "INPUT_PRIMERS_NAME", "QualityAnalysisPipeline", "INPUT_PRIMERS_NAME");
        template.addMapping("checkMetadata", "INPUT_SAMPLES_NAME", "QualityAnalysisPipeline", "INPUT_AMPLES_NAME");
        template.addMapping("checkMetadata", "INPUT_AMPLICONREFSEQS_NAME", "QualityAnalysisPipeline", "INPUT_AMPLICONREFSEQS_NAME");
        template.addMapping("checkMetadata", "INPUT_PRIMERS_NAME", "VQSHaplotyper", "INPUT_PRIMERS_NAME");
        template.addMapping("checkMetadata", "INPUT_SAMPLES_NAME", "VQSHaplotyper", "INPUT_AMPLES_NAME");
        template.addMapping("checkMetadata", "INPUT_AMPLICONREFSEQS_NAME", "VQSHaplotyper", "INPUT_AMPLICONREFSEQS_NAME");
        template.addMapping("QualityAnalysisPipeline", "JOB_OUTPUT_FOLDER", "VQSHaplotyper", "INPUT_FLASH_FLIT_FOlDER_NAME");
        return template;
    }
}

