/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.vqshaplotyper;

import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.DoubleVariableDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileVariable;

public class VQSHaplotyperJob
extends ISWFJob {
    public static final String JOB_ID = "VQSHaplotyper";
    public static final String JOB_NAME = "VQS Haplotyper";
    public static final String INPUT_FLASH_FLIT_FOlDER_NAME = "INPUT_FLASH_FLIT_FOlDER_NAME";
    public static final String Parameters = "Parameters";
    public static final String INPUT_SAMPLES_NAME = "INPUT_AMPLES_NAME";
    public static final String INPUT_PRIMERS_NAME = "INPUT_PRIMERS_NAME";
    public static final String INPUT_AMPLICONREFSEQS_NAME = "INPUT_AMPLICONREFSEQS_NAME";
    public static final String SCRIPT_NAME = "02_VQS-haplotyper-v1.06.R";

    public VQSHaplotyperJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("VQS Haplotyper Overview: pipeline to obtain quasispecies present in samples after applying quality, similarity and abundance filters.");
        this.jobDesc.setRef("Guerrero-Murillo M, Gregori i Font J (2022). QSutils: Quasispecies Diversity. R package version 1.16.0.");
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFolder = VariableDescriptor.createDescriptorFor((String)INPUT_FLASH_FLIT_FOlDER_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFolder.isRequired = true;
        varReadInputFolder.setVariableName("Quality analysis pipeline folder");
        varReadInputFolder.setHelpMsg("Quality analysis pipeline foldere folder");
        varReadInputFolder.addAcceptedFileFormat("FASTQ");
        varReadInputFolder.setCommandParamater("-qa_out");
        varReadInputFolder.setCommandParamaterAlt("--prevoius-qa-out");
        this.jobDesc.addVariable(varReadInputFolder);
        VariableDescriptor varReadInputCsvFile = VariableDescriptor.createDescriptorFor((String)INPUT_SAMPLES_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputCsvFile.isRequired = true;
        varReadInputCsvFile.setVariableName("Input samples file");
        varReadInputCsvFile.setHelpMsg("samples.csv");
        varReadInputCsvFile.addAcceptedFileFormat("CSV");
        varReadInputCsvFile.setCommandParamater("-s");
        varReadInputCsvFile.setCommandParamaterAlt("--samples");
        varReadInputCsvFile.addSampleResources("samples.csv", "samples.csv");
        this.jobDesc.addVariable(varReadInputCsvFile);
        VariableDescriptor varReadInputCsvPrimersFile = VariableDescriptor.createDescriptorFor((String)INPUT_PRIMERS_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputCsvPrimersFile.isRequired = true;
        varReadInputCsvPrimersFile.setVariableName("Input Amplicon Reference Sequences file");
        varReadInputCsvPrimersFile.setHelpMsg("Amplicon Reference Sequences.fna");
        varReadInputCsvPrimersFile.addAcceptedFileFormat("FASTQ");
        varReadInputCsvPrimersFile.setCommandParamater("-a");
        varReadInputCsvPrimersFile.setCommandParamaterAlt("--amplicon");
        varReadInputCsvPrimersFile.addSampleResources("AmpliconRefSeqs.fna", "AmpliconRefSeqs.fna");
        this.jobDesc.addVariable(varReadInputCsvPrimersFile);
        VariableDescriptor varReadInputFnaFile = VariableDescriptor.createDescriptorFor((String)INPUT_AMPLICONREFSEQS_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFnaFile.isRequired = true;
        varReadInputFnaFile.setVariableName("Input primers file");
        varReadInputFnaFile.setHelpMsg("primers.csv");
        varReadInputFnaFile.addAcceptedFileFormat("FNA");
        varReadInputFnaFile.setCommandParamater("-p");
        varReadInputFnaFile.setCommandParamaterAlt("--primers");
        varReadInputFnaFile.addSampleResources("primers.csv", "primers.csv");
        this.jobDesc.addVariable(varReadInputFnaFile);
    }

    protected void createOutputs() {
    }

    protected void createOptions() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Maximum number of mismatches");
        optionalVar.setHelpMsg("Maximum number of mismatches in the specific primer. Default: 3.");
        optionalVar.setDefaultValue("3");
        optionalVar.setCommandParamater("--pmm_mx");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Minimum number of reads");
        optionalVar.setHelpMsg("Minimum number of reads by sequences after repair. Default: 1.");
        optionalVar.setDefaultValue("1");
        optionalVar.setCommandParamater("--min_reads");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Maximum numbers of admissible Ns ");
        optionalVar.setHelpMsg("Maximum numbers of admissible Ns. Default: 2.");
        optionalVar.setDefaultValue("2");
        optionalVar.setCommandParamater("--max_ns");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Maximum number of tolerated differences between a sequence and its reference");
        optionalVar.setHelpMsg("Maximum number of tolerated differences between a sequence and its reference. Default: 99..");
        optionalVar.setDefaultValue("99");
        optionalVar.setCommandParamater("--max_diffs");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Maximum number of admissible gaps");
        optionalVar.setHelpMsg("Maximum number of admissible gaps. Default: 50.");
        optionalVar.setDefaultValue("50");
        optionalVar.setCommandParamater("--max_gaps");
        this.jobDesc.addVariable(optionalVar);
        SelectionListVariableDescriptor optionalVarMultiSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVarMultiSelectionList.setVariableName("Reference type to filter reads");
        optionalVarMultiSelectionList.setHelpMsg("Reference type to filter reads. Choose between generic or consensus. Default: generic.");
        optionalVarMultiSelectionList.addOptionValue("generic ");
        optionalVarMultiSelectionList.addOptionValue("consensus)");
        optionalVarMultiSelectionList.setCommandParamater("--ref_type");
        optionalVarMultiSelectionList.setDefaultValue("generic");
        this.jobDesc.addVariable((VariableDescriptor)optionalVarMultiSelectionList);
        optionalVarMultiSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVarMultiSelectionList.setVariableName("Sum or Intersect");
        optionalVarMultiSelectionList.setHelpMsg("Sum or Intersect. Sum takes the sum of the common haplotypes reads as a distribution, while Intersect takes the intersection as a distribution. Default: Sum.");
        optionalVarMultiSelectionList.addOptionValue("Sum", "Sum", "Sum takes the sum of the common haplotypes reads as a distribution");
        optionalVarMultiSelectionList.addOptionValue("Intersect", "Intersect", "Intersect takes the intersection as a distribution. ");
        optionalVarMultiSelectionList.setCommandParamater("--method");
        optionalVarMultiSelectionList.setDefaultValue("Sum");
        this.jobDesc.addVariable((VariableDescriptor)optionalVarMultiSelectionList);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Filter haplotypes by a minimum number of reads before intersection step");
        optionalVar.setHelpMsg("Filter haplotypes by a minimum number of reads before intersection step. Default: 1.");
        optionalVar.setDefaultValue("1");
        optionalVar.setCommandParamater("--min_rd");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Filter haplotypes by abundance before intersection step (in percentage)");
        optionalVar.setHelpMsg("Filter haplotypes by abundance before intersection step (in percentage). Default: 0.0.");
        optionalVar.setDefaultValue("0.0");
        optionalVar.setCommandParamater("--a_cut");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Save haplotypes with a specific abundance or below (in percentage)");
        optionalVar.setHelpMsg("Save haplotypes with a specific abundance or below (in percentage). Default 2.");
        optionalVar.setDefaultValue("2");
        optionalVar.setCommandParamater("--ni_thr");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Accept variant with an abundance above this value");
        optionalVar.setHelpMsg("Accept variant with an abundance above this value. Default: 0.5.");
        optionalVar.setDefaultValue("0.5");
        optionalVar.setCommandParamater("--var_thr");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("FSecond abundance filter for haplotypes");
        optionalVar.setHelpMsg("FSecond abundance filter for haplotypes. Default: 0.1.");
        optionalVar.setDefaultValue("0.1");
        optionalVar.setCommandParamater("--ab_thr");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("select minimum length of sequences after trimming adapters");
        optionalVar.setHelpMsg("Value between 0 and 1, which multiplies sequence length, to select minimum length of sequences after trimming adapters. Default: 1.");
        optionalVar.setDefaultValue("1");
        optionalVar.setCommandParamater("--min_size");
        ((DoubleVariableDescriptor)optionalVar).setMinValue(0.0);
        ((DoubleVariableDescriptor)optionalVar).setMaxValue(1.0);
        this.jobDesc.addVariable(optionalVar);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String progName = "02_VQS-haplotyper-v1.06.R ";
        FileVariable inVar1 = (FileVariable)this.getVariable(INPUT_SAMPLES_NAME);
        builder.append(BashHelper.command_withTrack((String)inVar1.$(), (String)(progName + this.getOptionParamatersStrAs$() + " -out ${outputFolder} "), (String)"VQS-haplotype"));
    }
}

