/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.vqshaplotyper;

import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FolderVariable;

public class MISeqRAVQAPiplineJob
extends ISWFJob {
    public static final String JOB_ID = "QualityAnalysisPipeline";
    public static final String JOB_NAME = "Quality Analysis Pipeline";
    public static final String INPUTFASTQs_FOlDER_NAME = "INPUT_FASTQs_FOlDER_NAME";
    public static final String INPUT_SAMPLES_NAME = "INPUT_AMPLES_NAME";
    public static final String INPUT_PRIMERS_NAME = "INPUT_PRIMERS_NAME";
    public static final String INPUT_AMPLICONREFSEQS_NAME = "INPUT_AMPLICONREFSEQS_NAME";
    public static final String Parameters = "Parameters";
    public static final String SCRIPT_NAME = "01_MiSeq_RAV_QA_Pipeline-v2.2.R";

    public MISeqRAVQAPiplineJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("Sequence extension with Illumina FLASH, quality analysis on FASTQs from FLASH and on R1 and R2, and filtering of sequences by average quality.");
        this.jobDesc.setRef("Guerrero-Murillo M, Gregori i Font J (2022). QSutils: Quasispecies Diversity. R package version 1.16.0.");
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFolder = VariableDescriptor.createDescriptorFor((String)INPUTFASTQs_FOlDER_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFolder.isRequired = true;
        varReadInputFolder.setVariableName("Input folder of fatsq files");
        varReadInputFolder.setHelpMsg("folder with raw fastqs");
        varReadInputFolder.addAcceptedFileFormat("FASTQ");
        varReadInputFolder.setCommandParamater("-r");
        varReadInputFolder.setCommandParamaterAlt("--run-dir");
        this.jobDesc.addVariable(varReadInputFolder);
        VariableDescriptor varReadInputCsvFile = VariableDescriptor.createDescriptorFor((String)INPUT_SAMPLES_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputCsvFile.isRequired = true;
        varReadInputCsvFile.setVariableName("Input samples file");
        varReadInputCsvFile.setHelpMsg("samples.csv");
        varReadInputCsvFile.addAcceptedFileFormat("CSV");
        varReadInputCsvFile.setCommandParamater("-s");
        varReadInputCsvFile.setCommandParamaterAlt("--samples");
        varReadInputCsvFile.addSampleResources("samples.csv", "samples.csv");
        this.jobDesc.addVariable(varReadInputCsvFile);
        VariableDescriptor varReadInputCsvPrimersFile = VariableDescriptor.createDescriptorFor((String)INPUT_PRIMERS_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputCsvPrimersFile.isRequired = true;
        varReadInputCsvPrimersFile.setVariableName("Input Amplicon Refrence Sequences file");
        varReadInputCsvPrimersFile.setHelpMsg("AmpliconRefSeqs.fna");
        varReadInputCsvPrimersFile.addAcceptedFileFormat("CSV");
        varReadInputCsvPrimersFile.setCommandParamater("-a");
        varReadInputCsvPrimersFile.setCommandParamaterAlt("--amplicon");
        varReadInputCsvPrimersFile.addSampleResources("AmpliconRefSeqs.fna", "AmpliconRefSeqs.fna");
        this.jobDesc.addVariable(varReadInputCsvPrimersFile);
        VariableDescriptor varReadInputFnaFile = VariableDescriptor.createDescriptorFor((String)INPUT_AMPLICONREFSEQS_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFnaFile.isRequired = true;
        varReadInputFnaFile.setVariableName("Input primers file");
        varReadInputFnaFile.setHelpMsg("primers.csv");
        varReadInputFnaFile.addAcceptedFileFormat("CSV");
        varReadInputFnaFile.setCommandParamater("-p");
        varReadInputFnaFile.setCommandParamaterAlt("--primers");
        varReadInputFnaFile.addSampleResources("primers.csv", "primers.csv");
        this.jobDesc.addVariable(varReadInputFnaFile);
    }

    protected void createOutputs() {
    }

    protected void createOptions() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Minimum overlap between R1 and R2 in FLASH");
        optionalVar.setHelpMsg("Minimum overlap between R1 and R2 in FLASH. Default: 20 pb.");
        optionalVar.setDefaultValue("20");
        optionalVar.setCommandParamater("--min_ov");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Maximum overlap between R1 and R2 in FLASH");
        optionalVar.setHelpMsg("Maximum overlap between R1 and R2 in FLASH. Default: 300 pb.");
        optionalVar.setDefaultValue("300");
        optionalVar.setCommandParamater("--max_ov");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Fraction of accepted mismatches in overlap in FLASH");
        optionalVar.setHelpMsg("Fraction of accepted mismatches in overlap in FLASH. Default: 0.10.");
        optionalVar.setDefaultValue("0.10");
        optionalVar.setCommandParamater("--err_lv");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Maximum percentage of bases below Q30 accepted by read");
        optionalVar.setHelpMsg("Maximum percentage of bases below Q30 accepted by read. Default 0.05.");
        optionalVar.setDefaultValue("0.05");
        optionalVar.setCommandParamater("--thrQ30");
        this.jobDesc.addVariable(optionalVar);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String progName = "01_MiSeq_RAV_QA_Pipeline-v2.2.R ";
        FolderVariable inVar1 = (FolderVariable)this.getVariable(INPUTFASTQs_FOlDER_NAME);
        builder.append(BashHelper.command_withTrack((String)inVar1.$(), (String)(progName + this.getOptionParamatersStrAs$() + " -out ${outputFolder} "), (String)"MiSeq_RAV_QA_Pipeline"));
    }
}

