/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.vqshaplotyper;

import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FolderVariable;

public class CheckMetadataJob
extends WorkflowStartupJob {
    public static final String JOB_ID = "checkMetadata";
    public static final String JOB_NAME = "Check Metadata";
    public static final String INPUTFASTQs_FOlDER_NAME = "INPUT_FASTQs_FOlDER_NAME";
    public static final String INPUT_SAMPLES_NAME = "INPUT_SAMPLES_NAME";
    public static final String INPUT_PRIMERS_NAME = "INPUT_PRIMERS_NAME";
    public static final String INPUT_AMPLICONREFSEQS_NAME = "INPUT_AMPLICONREFSEQS_NAME";
    public static final String SCRIPT_NAME = "00_CheckMetadata-RAVs-v1.17.R";

    public CheckMetadataJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("Check that all files are in the correct format.");
        this.jobDesc.setRef("Guerrero-Murillo M, Gregori i Font J (2022). QSutils: Quasispecies Diversity. R package version 1.16.0.");
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFolder = VariableDescriptor.createDescriptorFor((String)INPUTFASTQs_FOlDER_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFolder.isRequired = true;
        varReadInputFolder.setVariableName("Input folder of fatsq files");
        varReadInputFolder.setHelpMsg("folder with raw fastqs");
        varReadInputFolder.addAcceptedFileFormat("FASTQ");
        varReadInputFolder.setCommandParamater("-r");
        varReadInputFolder.setCommandParamaterAlt("--run-dir");
        this.jobDesc.addVariable(varReadInputFolder);
        VariableDescriptor varReadInputCsvFile = VariableDescriptor.createDescriptorFor((String)INPUT_SAMPLES_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputCsvFile.isRequired = true;
        varReadInputCsvFile.setVariableName("Input samples file");
        varReadInputCsvFile.setHelpMsg("samples.csv");
        varReadInputCsvFile.addAcceptedFileFormat("CSV");
        varReadInputCsvFile.setCommandParamater("-s");
        varReadInputCsvFile.setCommandParamaterAlt("--samples");
        varReadInputCsvFile.addSampleResources("samples.csv", "samples.csv");
        this.jobDesc.addVariable(varReadInputCsvFile);
        VariableDescriptor varReadInputCsvPrimersFile = VariableDescriptor.createDescriptorFor((String)INPUT_PRIMERS_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputCsvPrimersFile.isRequired = true;
        varReadInputCsvPrimersFile.setVariableName("Input Amplicon Reference Sequences file");
        varReadInputCsvPrimersFile.setHelpMsg("AmpliconRefSeqs.fna");
        varReadInputCsvPrimersFile.addAcceptedFileFormat("FASTQ");
        varReadInputCsvPrimersFile.setCommandParamater("-a");
        varReadInputCsvPrimersFile.setCommandParamaterAlt("--amplicon");
        varReadInputCsvPrimersFile.addSampleResources("AmpliconRefSeqs.fna", "AmpliconRefSeqs.fna");
        this.jobDesc.addVariable(varReadInputCsvPrimersFile);
        VariableDescriptor varReadInputFnaFile = VariableDescriptor.createDescriptorFor((String)INPUT_AMPLICONREFSEQS_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFnaFile.isRequired = true;
        varReadInputFnaFile.setVariableName("Input primers file");
        varReadInputFnaFile.setHelpMsg("primers.csv");
        varReadInputFnaFile.addAcceptedFileFormat("FNA");
        varReadInputFnaFile.setCommandParamater("-p");
        varReadInputFnaFile.setCommandParamaterAlt("--primers");
        varReadInputFnaFile.addSampleResources("primers.csv", "primers.csv");
        this.jobDesc.addVariable(varReadInputFnaFile);
    }

    protected void createOutputs() {
    }

    protected void createOptions() {
    }

    protected void createRules() {
    }

    protected void workflowStartupJobOnGenerateCommand(StringBuilder builder) {
        String progName = "00_CheckMetadata-RAVs-v1.17.R ";
        FolderVariable inVar1 = (FolderVariable)this.getVariable(INPUTFASTQs_FOlDER_NAME);
        builder.append(BashHelper.command_withTrack((String)inVar1.$(), (String)(progName + this.getOptionParamatersStrAs$()), (String)JOB_NAME));
    }
}

