/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.trainingset;

import com.biotechvana.shared.jobs.SharedCatalog;
import com.biotechvana.utils.Constants;
import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.jobs.PicardHelper;
import com.biotechvana.variantseq.jobs.VarScanHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.CmdListMergeStrategy;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.MultiSelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class PostProcessingGenerateTrainingSetJob
extends ISWFJob {
    public static final String JOB_ID = "generateTrainingSet";
    public static final String JOB_NAME = "Generate Training Set";
    private static final String AddOrReplaceReadGroupsOptions = "AddOrReplaceReadGroups";
    private static final String MpileupOptions = "Mpileup";
    private static final String Mpileup2cnsOptions = "Mpileup2cns";
    public static final String INPUT_SAMPLE_NAME = "INPUT_SAMPLE_NAME";
    public static final String OUTPUT_VCF_FILE = "OUTPUT_VCF_FILE";
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;

    public PostProcessingGenerateTrainingSetJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("Create a training set running a pipeline based on Picard, GATK and Samtools.");
        GATKHelper.getCitation(this.jobDesc);
        this.jobDesc.addPublication(GATKHelper.getCitationNBT2514());
        this.jobDesc.addPublication(SharedCatalog.getSamtoolsCitation());
        this.jobDesc.addPublication(new Publication().setAuthors("Wysoker A, Tibbetts K, Fennell T. 2011").setTitle("PicardTools 1.5.3").setYear(2011).setUrl("http://sourceforge.net/projects/picard/files/picard-tools/"));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        varReferenceFasta.setSubProgName("samtools_mpileup");
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = GATKHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor inputVar = VariableDescriptor.createDescriptorFor((String)INPUT_SAMPLE_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        inputVar.setVariableName("Sample Name");
        this.jobDesc.addVariable(inputVar);
    }

    protected void createOutputs() {
        VariableDescriptor outputVar = VariableDescriptor.createDescriptorFor((String)OUTPUT_VCF_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputVar.setVariableName("Variant VCF File");
        this.jobDesc.addVariable(outputVar);
    }

    protected void createOptions() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Read Group platform");
        optionalVar.setHelpMsg("Read Group platform (e.g. illumina, solid)");
        optionalVar.setDefaultValue("Illumina");
        optionalVar.setCommandParamater("PL");
        optionalVar.setCommandParamaterSep("=");
        optionalVar.setSubProgName(AddOrReplaceReadGroupsOptions);
        optionalVar.setVariableGroup(AddOrReplaceReadGroupsOptions);
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.isRequired = true;
        optionalVar.setVariableName("Read Group platform unit");
        optionalVar.setHelpMsg("Read Group platform unit (eg. run barcode)");
        optionalVar.setDefaultValue("metas");
        optionalVar.setCommandParamater("PU");
        optionalVar.setCommandParamaterSep("=");
        optionalVar.setSubProgName(AddOrReplaceReadGroupsOptions);
        optionalVar.setVariableGroup(AddOrReplaceReadGroupsOptions);
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Read Group description");
        optionalVar.setHelpMsg("Read Group description");
        optionalVar.setDefaultValue("");
        optionalVar.setCommandParamater("DS");
        optionalVar.setCommandParamaterSep("=");
        optionalVar.setSubProgName(AddOrReplaceReadGroupsOptions);
        optionalVar.setVariableGroup(AddOrReplaceReadGroupsOptions);
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Do not skip anomalous read pairs in variant calling");
        optionalVar.setHelpMsg("Do not skip anomalous read pairs in variant calling");
        optionalVar.setDefaultValue("true");
        optionalVar.setCommandParamater("-A");
        optionalVar.setCommandParamaterAlt("--count-orphans");
        optionalVar.setSubProgName(MpileupOptions);
        optionalVar.setVariableGroup(MpileupOptions);
        this.jobDesc.addVariable(optionalVar);
        MultiSelectionListVariableDescriptor optionalVarMultiSelectionList = VariableDescriptor.MultiSelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVarMultiSelectionList.setVariableName("Comma-separated list of FORMAT and INFO tags to output");
        optionalVarMultiSelectionList.setHelpMsg("Comma-separated list of FORMAT and INFO tags to output (case-insensitive). Default Null");
        optionalVarMultiSelectionList.addOptionValue("AD Allelic depth", "AD", "INFO/AD (Total allelic depth, INFO)");
        optionalVarMultiSelectionList.addOptionValue("INFO/AD Total allelic depth", "INFO/AD", "AD (Allelic depth, FORMAT)");
        optionalVarMultiSelectionList.addOptionValue("ADF Forward Allelic depths ", "ADF", "ADF (Allelic depths on the forward strand, FORMAT)");
        optionalVarMultiSelectionList.addOptionValue("INFO/ADF Froward Total allelic depths", "INFO/ADF", "INFO/ADF (Total allelic depths on the forward strand, INFO)");
        optionalVarMultiSelectionList.addOptionValue("ADR", "ADR", "ADR (Allelic depths on the reverse strand, FORMAT)");
        optionalVarMultiSelectionList.addOptionValue("INFO/ADR", "INFO/ADR", "INFO/ADR (Total allelic depths on the reverse strand, INFO)");
        optionalVarMultiSelectionList.addOptionValue("DP Number of high-quality bases", "DP", "DP (Number of high-quality bases, FORMAT)");
        optionalVarMultiSelectionList.addOptionValue("DV (Deprecated)", "DV", "DV (Deprecated in favor of AD; Number of high-quality non-reference bases, FORMAT)");
        optionalVarMultiSelectionList.addOptionValue("DPR (Deprecated)", "DPR", "DPR (Deprecated in favor of AD; Number of high-quality bases for each observed allele, FORMAT)");
        optionalVarMultiSelectionList.addOptionValue("INFO/DPR", "INFO/DPR", "INFO/DPR (Number of high-quality bases for each observed allele, INFO)");
        optionalVarMultiSelectionList.addOptionValue("DP4 (Deprecated)", "DP4", "DP4 (Deprecated in favor of ADF and ADR; Number of high-quality ref-forward, ref-reverse, alt-forward and alt-reverse bases, FORMAT)");
        optionalVarMultiSelectionList.addOptionValue("SP", "SP", "SP (Phred-scaled strand bias P-value, FORMAT)");
        optionalVarMultiSelectionList.setCommandParamater("-t");
        optionalVarMultiSelectionList.setCommandParamaterAlt("--output-tags");
        optionalVarMultiSelectionList.setSubProgName(MpileupOptions);
        optionalVarMultiSelectionList.setVariableGroup(MpileupOptions);
        optionalVarMultiSelectionList.setCmdListMergeStrategy(CmdListMergeStrategy.Once);
        optionalVarMultiSelectionList.setCmdListMergerSep(",");
        this.jobDesc.addVariable((VariableDescriptor)optionalVarMultiSelectionList);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Apply (min Indel reads) and (min fraction of gapped ) thresholds per sample");
        optionalVar.setHelpMsg("Apply (min Indel reads -m ) and (min fraction of gapped -F ) thresholds per sample to increase sensitivity of calling. By default both options are applied to reads pooled from all samples.");
        optionalVar.setDefaultValue("true");
        optionalVar.setCommandParamater("-p");
        optionalVar.setCommandParamaterAlt("--per-sample-mF");
        optionalVar.setSubProgName(MpileupOptions);
        optionalVar.setVariableGroup(MpileupOptions);
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Minimum number gapped reads for indel candidates");
        optionalVar.setHelpMsg("Minimum number gapped reads for indel candidates. Default 1");
        optionalVar.setCommandParamater("-m");
        optionalVar.setCommandParamaterAlt("--min-ireads");
        optionalVar.setSubProgName(MpileupOptions);
        optionalVar.setVariableGroup(MpileupOptions);
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Minimum fraction of gapped reads");
        optionalVar.setHelpMsg("Minimum fraction of gapped reads. Default 0.002");
        optionalVar.setDefaultValue("0.001");
        optionalVar.setRecommendedValue("0.001");
        optionalVar.setCommandParamater("-F");
        optionalVar.setCommandParamaterAlt("--gap-frac");
        optionalVar.setSubProgName(MpileupOptions);
        optionalVar.setVariableGroup(MpileupOptions);
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Max read depth");
        optionalVar.setHelpMsg("At a position, read maximally INT reads per input file. Note that samtools has a minimum value of 8000/n where n is the number of input files given to mpileup. This means the default is highly likely to be increased. Once above the cross-sample minimum of 8000 the -d parameter will have an effect.");
        optionalVar.setDefaultValue("1000");
        optionalVar.setCommandParamater("-d");
        optionalVar.setCommandParamaterAlt("--max-depth");
        optionalVar.setSubProgName(MpileupOptions);
        optionalVar.setVariableGroup(MpileupOptions);
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Minimum read depth at a position to make a call");
        optionalVar.setHelpMsg("Minimum read depth at a position to make a call. Default 8.");
        optionalVar.setDefaultValue("3");
        optionalVar.setCommandParamater("--min-coverage");
        optionalVar.setSubProgName(Mpileup2cnsOptions);
        optionalVar.setVariableGroup(Mpileup2cnsOptions);
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Minimum variant allele frequency threshold");
        optionalVar.setHelpMsg("Minimum variant allele frequency threshold. Default 0.01");
        optionalVar.setDefaultValue("0.001");
        optionalVar.setCommandParamater("--min-var-freq");
        optionalVar.setSubProgName(Mpileup2cnsOptions);
        optionalVar.setVariableGroup(Mpileup2cnsOptions);
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Minimum frequency to call homozygote");
        optionalVar.setHelpMsg("Minimum frequency to call homozygote. Default 0.75");
        optionalVar.setDefaultValue("0.85");
        optionalVar.setCommandParamater("--min-freq-for-hom");
        optionalVar.setSubProgName(Mpileup2cnsOptions);
        optionalVar.setVariableGroup(Mpileup2cnsOptions);
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Default p-value threshold for calling variants");
        optionalVar.setHelpMsg("Default p-value threshold for calling variants. Default 0.99");
        optionalVar.setDefaultValue("0.99");
        optionalVar.setCommandParamater("--p-value");
        optionalVar.setSubProgName(Mpileup2cnsOptions);
        optionalVar.setVariableGroup(Mpileup2cnsOptions);
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Ignore variants with >90% support on one strand");
        optionalVar.setHelpMsg("Ignore variants with >90% support on one strand. Default 1");
        optionalVar.setDefaultValue("0");
        optionalVar.setCommandParamater("--strand-filter");
        optionalVar.setSubProgName(Mpileup2cnsOptions);
        optionalVar.setVariableGroup(Mpileup2cnsOptions);
        this.jobDesc.addVariable(optionalVar);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String samtools = Constants.PIPELINE_BASE_PATH + "samtools";
        String varscan = VarScanHelper.getVarscanCmdPrefix();
        String picard = PicardHelper.getPicardCmdPrefix();
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.INPUT_BAM_FILES);
        FileVariable outputVcfFile = (FileVariable)this.getVariable(OUTPUT_VCF_FILE);
        String mergeBamsInputStr = "mergeBamIn";
        builder.append(PostProcessingGenerateTrainingSetJob.st((String)BashHelper.assign((String)"sampleName", (String)this.getVariable(INPUT_SAMPLE_NAME).$())));
        builder.append(PostProcessingGenerateTrainingSetJob.st((String)BashHelper.assign((String)mergeBamsInputStr, (String)"")));
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputBamFilesVar, (String)PostProcessingGenerateTrainingSetJob.st((String)BashHelper.strAppend((String)mergeBamsInputStr, (String)" I=${_inputFile}")), (boolean)true));
        builder.append(PostProcessingGenerateTrainingSetJob.st((String)BashHelper.assign((JobVariable)outputVcfFile, (String)"${outputFolder}/${sampleName}.vcf")));
        builder.append(BashHelper.command_withTrack((String)BashHelper.$((String)mergeBamsInputStr), (String)(picard + " MergeSamFiles  VALIDATION_STRINGENCY=LENIENT " + PostProcessingGenerateTrainingSetJob.$((String)mergeBamsInputStr) + " O=${outputFolder}/${sampleName}.merged.bam"), (String)"Picard MergeSamFiles"));
        builder.append(BashHelper.command_withTrack((String)"${outputFolder}/${sampleName}.merged.bam", (String)(picard + " AddOrReplaceReadGroups VALIDATION_STRINGENCY=LENIENT  I=${outputFolder}/${sampleName}.merged.bam  SO=coordinate CREATE_INDEX=true ID=${sampleName} LB=${sampleName}   SM=${sampleName}  O=${outputFolder}/${sampleName}.RG.bam" + this.getOptionParamatersStrAs$(AddOrReplaceReadGroupsOptions)), (String)"Picard AddOrReplaceReadGroups"));
        builder.append(BashHelper.command_withTrack((String)"${outputFolder}/${sampleName}.RG.bam", (String)(picard + " MarkDuplicates VALIDATION_STRINGENCY=LENIENT  I=${outputFolder}/${sampleName}.RG.bam O=${outputFolder}/${sampleName}.noDup.bam M=${outputFolder}/${sampleName}.metrics.txt"), (String)"picard MarkDuplicates"));
        builder.append(BashHelper.command_withTrack((String)"${outputFolder}/${sampleName}.RG.bam", (String)(samtools + " mpileup   ${outputFolder}/${sampleName}.noDup.bam  -f " + this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA).$() + this.getOptionParamatersStrAs$(MpileupOptions) + "  > ${outputFolder}/${sampleName}.pileup "), (String)"Samtools mpileup"));
        builder.append(BashHelper.command_withTrack((String)"${outputFolder}/${sampleName}.pileup", (String)(varscan + " mpileup2cns     ${outputFolder}/${sampleName}.pileup  " + this.getOptionParamatersStrAs$(Mpileup2cnsOptions) + " --output-vcf > ${outputFolder}/${sampleName}.vcf "), (String)"VarScan2 mpileup2cns"));
    }
}

