/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.samtools;

import com.biotechvana.shared.jobs.SharedCatalog;
import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.jobs.SamtoolsHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;

public class SAMToolsMpileupJob
extends ISWFJob {
    public static final String JOB_ID = "samtools_mpileup";
    public static final String JOB_NAME = "samtools : mpileup";
    public static final String INPUT_SAMPLES_GROUP = "INPUT_SAMPLES_GROUP";
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    public static final String OUTPUT_MPILEUP_FILES = "OUTPUT_MPILEUP_FILES";

    public SAMToolsMpileupJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.addPublication(SharedCatalog.getSamtoolsCitation());
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = SamtoolsHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = GATKHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor varInput = VariableDescriptor.createDescriptorFor((String)INPUT_SAMPLES_GROUP, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.setVariableName("Samples groups");
        varInput.setHelpMsg("Samples groups.");
        this.jobDesc.addVariable(varInput);
    }

    protected void createOutputs() {
        VariableDescriptor variantOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_MPILEUP_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        variantOutputFile.setVariableName("mpileup files");
        variantOutputFile.setHelpMsg("mpileup files");
        this.jobDesc.addVariable(variantOutputFile);
    }

    protected void createOptions() {
    }

    protected void createRules() {
    }
}

