/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GATKSplitNCigarReadsJob
extends ISWFJob {
    public static final String JOB_ID = "splitNCigarReads";
    public static final String JOB_NAME = "SplitNCigarReads";
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    public static final String OUTPUT_BAM_FILES = VariantAnaylsisVariableBag.OUTPUT_BAM_FILES;

    public GATKSplitNCigarReadsJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("SplitNCigarReads tool splits reads that contain Ns in their cigar string (e.g. spanning splicing events in RNAseq data). Identifies all N cigar elements and creates k+1 new reads (where k is the number of N cigar elements). The first read includes the bases that are to the left of the first N element, while the part of the read that is to the right of the N (including the Ns) is hard clipped and so on for the rest of the new reads. Used for post-processing RNA reads aligned against the full reference. ");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage(JOB_NAME, "org_broadinstitute_hellbender_tools_walkers_rnaseq_SplitNCigarReads.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = GATKHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
    }

    protected void createOutputs() {
        VariableDescriptor bamOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        bamOutputFile.isRequired = true;
        bamOutputFile.setVariableName("Post processed BAM Files");
        bamOutputFile.setHelpMsg("Post processed BAM Files");
        this.jobDesc.addVariable(bamOutputFile);
    }

    protected void createOptions() {
        VariableDescriptor optionalVar = null;
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Max number of bases allowed in the overhang");
        optionalVar.setHelpMsg("If there are more than this many bases in the overhang, we won't try to hard-clip them out. Default 40");
        optionalVar.setCommandParamater("--max-bases-in-overhang");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Max number of mismatches allowed in the overhang");
        optionalVar.setHelpMsg("If there are more than this many mismatches within the overhang regions, the whole overhang will get hard-clipped out. It is still possible in some cases that the overhang could get clipped if the number of mismatches do not exceed this value, e.g. if most of the overhang mismatches. Default 1");
        optionalVar.setCommandParamater("--max-mismatches-in-overhang");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Process secondary alignments");
        optionalVar.setHelpMsg("Have the walker split secondary alignments (will still repair MC tag without it)");
        optionalVar.setCommandParamater("--process-secondary-alignments");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Refactor cigar string");
        optionalVar.setHelpMsg("Refactor cigar string with NDN elements to one element. It intended primarily for use in a RNAseq pipeline since the problem might come up when using RNAseq aligner such as Tophat2 with provided transcriptomes. You should only use this if you know that your reads have that problem.");
        optionalVar.setCommandParamater("--refactor-cigar-string");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("--skip-mapping-quality-transform");
        optionalVar.setHelpMsg("Skip the 255 -> 60 MQ read transform");
        optionalVar.setCommandParamater("--skip-mapping-quality-transform");
        optionalVar.setCommandParamaterAlt("-skip-mq-transform");
        this.jobDesc.addVariable(optionalVar);
        GATKHelper.createSharedOptions(this.jobDesc, new String[]{GATKHelper.GATK_OPTION_SWITCH_INTERVALS_MERGING_RULE, GATKHelper.GATK_OPTION_SWITCH_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_CREATE_BAM_INDEX, GATKHelper.GATK_OPTION_SWITCH_CREATE_BAM_MD5, GATKHelper.GATK_OPTION_SWITCH_CREATE_VCF_INDEX, GATKHelper.GATK_OPTION_SWITCH_CREATE_VCF_MD5, GATKHelper.GATK_OPTION_SWITCH_EXCLUDE_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_EXCLUSION_PADDING, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_PADDING, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_SET_RULE, GATKHelper.GATK_OPTION_SWITCH_LENIENT, GATKHelper.GATK_OPTION_SWITCH_READ_FILTER, GATKHelper.GATK_OPTION_SWITCH_READ_VALIDATION_STRINGENCY, GATKHelper.GATK_OPTION_SWITCH_ARGUMENTS_FILE});
    }

    protected void createRules() {
        GATKHelper.addRules((WorkflowJob)this);
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        return valid;
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = GATKHelper.getGATKCmdPrefix(JOB_NAME) + GATKHelper.getTmpOption();
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.INPUT_BAM_FILES);
        FilesVariable outBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.OUTPUT_BAM_FILES);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputBamFilesVar, (String)GATKSplitNCigarReadsJob.st((String)BashHelper.arrayAdd((JobVariable)outBamFilesVar, (String)"${outputFolder}/${inputFileBaseName}.bam")), (boolean)true));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)"", (String)(cmdPrefix + this.getOptionParamatersStrAs$() + "-I ${_inputFile}   -O " + outBamFilesVar.$("${_i}")), (String)JOB_NAME));
    }
}

