/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.filtering.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GATKFilterMutectCallsJob
extends ISWFJob {
    public static final String JOB_ID = "filterMutectCalls";
    public static final String JOB_NAME = "GATK - FilterMutectCalls";
    public static final String INPUT_VCF_FILES = "INPUT_VARIANTS_VCF";
    public static final String OPTIONAL_CONT_FILES = "CONTAMINATION_TABLE_FILE";
    public static final String OUTPUT_VCF_FILES = "OUTPUT_VARIANTS_VCF";
    public static final String INPUT_REF_FASTA = VariantAnaylsisVariableBag.INPUT_REF_FASTA;

    public GATKFilterMutectCallsJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Filter somatic SNVs and indels called by Mutect2");
        GATKHelper.getCitation(this.jobDesc);
        this.jobDesc.addPublication(GATKHelper.getCitationNBT2514());
        this.jobDesc.addLink(GATKHelper.getManualLink("FilterMutectCalls", "org_broadinstitute_hellbender_tools_walkers_mutect_FilterMutectCalls.php"));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_VCF_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input somatic VCF Files");
        varReadInputFile.setHelpMsg("Input somatic VCF Files.");
        varReadInputFile.addAcceptedFileFormat("VCF");
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor varOptContFile = VariableDescriptor.createDescriptorFor((String)OPTIONAL_CONT_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varOptContFile.setVariableName("Contamination table Files");
        varOptContFile.setHelpMsg("contamination table");
        this.jobDesc.addVariable(varOptContFile);
    }

    protected void createOutputs() {
        VariableDescriptor variantOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_VCF_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        variantOutputFile.setVariableName("Filtered Variants vcf");
        variantOutputFile.setHelpMsg("variant calls output vcf files");
        this.jobDesc.addVariable(variantOutputFile);
    }

    protected void createOptions() {
        GATKHelper.createSharedOptions(this.jobDesc);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String filterMutectCallsCmdPrefix = GATKHelper.getGATKCmdPrefix() + " FilterMutectCalls " + GATKHelper.getTmpOption();
        FilesVariable inputVCFFilesVar = (FilesVariable)this.getVariable(INPUT_VCF_FILES);
        FilesVariable optionalContFiles = (FilesVariable)this.getVariable(OPTIONAL_CONT_FILES);
        FilesVariable outFilesVar = (FilesVariable)this.getVariable(OUTPUT_VCF_FILES);
        JobVariable refFileVar = this.getVariable(INPUT_REF_FASTA);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputVCFFilesVar, (String)(BashHelper.arrayAdd((JobVariable)outFilesVar, (String)"${outputFolder}/${inputFileBaseName}.vcf") + String.valueOf(BashHelper.If((String)BashConditions.notEmptyStr((String)optionalContFiles.$("${_i}"))).Then(GATKFilterMutectCallsJob.st((String)BashHelper.assign((String)"contOptions", (String)("--contamination-table   " + optionalContFiles.$("${_i}"))))))), (String)(filterMutectCallsCmdPrefix + this.getOptionParamatersStrAs$() + "-V ${_inputFile}  ${contOptions} -O " + outFilesVar.$("${_i}")), (String)"FilterMutectCalls"));
    }
}

