/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.filtering.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.workflow.CmdListMergeStrategy;
import com.biotechvana.workflow.IListVariableDescriptor;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.descriptors.CheckedVariableDescriptor;
import com.biotechvana.workflow.descriptors.DoubleVariableDescriptor;
import com.biotechvana.workflow.descriptors.IntVariableDescriptor;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class CrossSampleContaminationJob
extends ISWFJob {
    public static final String JOB_ID = "calculateContamination";
    public static final String JOB_NAME = "GATK - Cross-Sample Contamination";
    public static final String INPUT_NORMAL_BAM_FILES = "NORMAL_BAM";
    public static final String INPUT_TUMOR_BAM_FILES = "TUMOR_BAM";
    public static final String OPTION_TUMOR_ONLY_MODE = "TUMOR_ONLY_MODE";
    public static final String OUTPUT_CONTAMINATION_TABLES = "contaminationTables";
    static final String GetPileupSummaries = "GetPileupSummaries";
    static final String CalculateContamination = "CalculateContamination";

    public CrossSampleContaminationJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
    }

    protected void initJobDescriptor() {
        super.initJobDescriptor();
        this.jobDesc.setDesc("Cross-Sample Contamination : a pipeline based on the GATK commands GetPilupSummaries and CalculateContamination to estimate and create contamination table");
        GATKHelper.getCitation(this.jobDesc);
        this.jobDesc.addCLITool(new JobDescriptor.CLIToolInfo().setId(GetPileupSummaries).setName(GetPileupSummaries).setBaseCLI("gatk").setBaseCLISubtool(GetPileupSummaries));
        this.jobDesc.addCLITool(new JobDescriptor.CLIToolInfo().setId(CalculateContamination).setName(CalculateContamination).setBaseCLI("gatk").setBaseCLISubtool(CalculateContamination));
        this.jobDesc.addLink(GATKHelper.getManualLink(GetPileupSummaries, "org_broadinstitute_hellbender_tools_walkers_contamination_GetPileupSummaries.php"));
        this.jobDesc.addLink(GATKHelper.getManualLink(CalculateContamination, "org_broadinstitute_hellbender_tools_walkers_contamination_CalculateContamination.php"));
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFile = GATKHelper.createInputTumorBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        varReadInputFile = GATKHelper.createInputNormalBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor onlyTumor = VariableDescriptor.createDescriptorFor((String)OPTION_TUMOR_ONLY_MODE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        onlyTumor.setVariableName("Tumor only Mode");
        onlyTumor.setHelpMsg("This mode runs on a single sample.");
        this.jobDesc.addVariable(onlyTumor);
        VariableDescriptor vcfInputVariants = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        vcfInputVariants.setVariableName("One or more VCF files containing variants");
        vcfInputVariants.setCommandParamater("-V");
        ((IListVariableDescriptor)vcfInputVariants).setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        vcfInputVariants.setHelpMsg("Common germline variant sites VCF, e.g. derived from the gnomAD resource, with population allele frequencies (AF) in the INFO field. This resource must contain only biallelic SNPs");
        vcfInputVariants.setSubProgName(GetPileupSummaries);
        this.jobDesc.addVariable(vcfInputVariants);
    }

    protected void createOutputs() {
        VariableDescriptor outputFiles = VariableDescriptor.createDescriptorFor((String)OUTPUT_CONTAMINATION_TABLES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputFiles.isRequired = true;
        outputFiles.setVariableName("contamination tables");
        outputFiles.setHelpMsg("contamination tables");
        this.jobDesc.addVariable(outputFiles);
    }

    protected void createOptions() {
        GATKHelper.createSharedOptions(this.jobDesc);
        VariableDescriptor varDesc = GATKHelper.createOptionInterval();
        varDesc.setVariableGroup(GetPileupSummaries);
        varDesc.setSubProgName(GetPileupSummaries);
        this.jobDesc.addVariable(varDesc);
        varDesc = GATKHelper.createOptionIntervalMergingRule();
        varDesc.setVariableGroup(GetPileupSummaries);
        varDesc.setSubProgName(GetPileupSummaries);
        this.jobDesc.addVariable(varDesc);
        IntVariableDescriptor intVar = VariableDescriptor.Int((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Max depth per sample");
        intVar.setHelpMsg("Maximum number of reads to retain per sample per locus. Reads above this threshold will be downsampled. Set to 0 to disable. Default 0");
        intVar.setVariableGroup(GetPileupSummaries);
        intVar.setSubProgName(GetPileupSummaries);
        intVar.setCommandParamater("-max-depth-per-sample");
        intVar.setCommandParamaterAlt("--max-depth-per-sample");
        this.jobDesc.addVariable((VariableDescriptor)intVar);
        DoubleVariableDescriptor doubleVar = VariableDescriptor.Double((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        doubleVar.setVariableName("Maximum population allele frequency");
        doubleVar.setHelpMsg("Maximum population allele frequency of sites to consider. Default 0.2");
        doubleVar.setVariableGroup(GetPileupSummaries);
        doubleVar.setSubProgName(GetPileupSummaries);
        doubleVar.setCommandParamater("-max-af");
        doubleVar.setCommandParamaterAlt("--maximum-population-allele-frequency");
        this.jobDesc.addVariable((VariableDescriptor)doubleVar);
        intVar = VariableDescriptor.Int((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Minimum read mapping quality");
        intVar.setHelpMsg("Minimum read mapping quality. Default 50");
        intVar.setVariableGroup(GetPileupSummaries);
        intVar.setSubProgName(GetPileupSummaries);
        intVar.setCommandParamater("-mmq");
        intVar.setCommandParamaterAlt("--min-mapping-quality");
        this.jobDesc.addVariable((VariableDescriptor)intVar);
        CheckedVariableDescriptor boolVar = VariableDescriptor.Checked((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        boolVar.setVariableName("Sites only vcf");
        boolVar.setHelpMsg("If true, don't emit genotype fields when writing vcf file output. Default false");
        boolVar.setVariableGroup(GetPileupSummaries);
        boolVar.setSubProgName(GetPileupSummaries);
        boolVar.setCommandParamater("-sites-only-vcf-output");
        this.jobDesc.addVariable((VariableDescriptor)boolVar);
        doubleVar = VariableDescriptor.Double((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        doubleVar.setVariableName("High coverage ratio Threshold");
        doubleVar.setHelpMsg("The maximum coverage relative to the mean. Default 3.0");
        doubleVar.setVariableGroup(CalculateContamination);
        doubleVar.setSubProgName(CalculateContamination);
        doubleVar.setCommandParamater("--high-coverage-ratio-Threshold");
        this.jobDesc.addVariable((VariableDescriptor)doubleVar);
        doubleVar = VariableDescriptor.Double((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        doubleVar.setVariableName("low coverage ratio Threshold");
        doubleVar.setHelpMsg("The minimum coverage relative to the median. Default 0.5");
        doubleVar.setVariableGroup(CalculateContamination);
        doubleVar.setSubProgName(CalculateContamination);
        doubleVar.setCommandParamater("--low-coverage-ratio-threshold");
        this.jobDesc.addVariable((VariableDescriptor)doubleVar);
    }

    protected void createRules() {
        new VariablesRule(this.getVariable(OPTION_TUMOR_ONLY_MODE), this.getVariable(INPUT_TUMOR_BAM_FILES), VariablesRule.Condition.True, VariablesRule.Action.Enable);
        new VariablesRule(this.getVariable(OPTION_TUMOR_ONLY_MODE), this.getVariable(INPUT_TUMOR_BAM_FILES), VariablesRule.Condition.False, VariablesRule.Action.Enable);
        new VariablesRule(this.getVariable(OPTION_TUMOR_ONLY_MODE), this.getVariable(INPUT_NORMAL_BAM_FILES), VariablesRule.Condition.False, VariablesRule.Action.Enable, true);
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        if (!this.getValue(OPTION_TUMOR_ONLY_MODE).equals("true")) {
            valid &= this.validateEqualNumberOfFiles(INPUT_TUMOR_BAM_FILES, INPUT_NORMAL_BAM_FILES);
        }
        return valid;
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdGetPileupSummariesPrefix = GATKHelper.getGATKCmdPrefix() + " GetPileupSummaries " + GATKHelper.getTmpOption();
        String cmdCalculateContaminationPrefix = GATKHelper.getGATKCmdPrefix() + " CalculateContamination " + GATKHelper.getTmpOption();
        FilesVariable inputTumorFilesVar = (FilesVariable)this.getVariable(INPUT_TUMOR_BAM_FILES);
        FilesVariable inputNormalFilesVar = (FilesVariable)this.getVariable(INPUT_NORMAL_BAM_FILES);
        FilesVariable outFilesVar = (FilesVariable)this.getVariable(OUTPUT_CONTAMINATION_TABLES);
        JobVariable modeVar = this.getVariable(OPTION_TUMOR_ONLY_MODE);
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputTumorFilesVar, (String)(CrossSampleContaminationJob.st((String)BashHelper.assign((String)"sampleTumorName", (String)"$(getSamRG ${_inputFile} )")) + BashHelper.arrayAdd((JobVariable)outFilesVar, (String)"${outputFolder}/${sampleTumorName}.contamination.table")), (String)(CrossSampleContaminationJob.st((String)(cmdGetPileupSummariesPrefix + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(GetPileupSummaries) + "-I ${_inputFile} -O ${outputFolder}/${sampleTumorName}.pileups.table  ")) + String.valueOf(BashHelper.If((String)BashConditions.False((JobVariable)modeVar)).Then(CrossSampleContaminationJob.st((String)BashHelper.assign((String)"sampleNormalName", (String)("$(getSamRG " + inputNormalFilesVar.$("${_i}") + " )"))) + CrossSampleContaminationJob.st((String)BashHelper.assign((String)"normalOptions", (String)"-matched ${outputFolder}/${sampleNormalName}.pileups.table")) + CrossSampleContaminationJob.st((String)(cmdGetPileupSummariesPrefix + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(GetPileupSummaries) + "-O ${outputFolder}/${sampleNormalName}.pileups.table   -I " + inputNormalFilesVar.$("${_i}"))))) + CrossSampleContaminationJob.st((String)(cmdCalculateContaminationPrefix + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(CalculateContamination) + "-I ${outputFolder}/${sampleTumorName}.pileups.table   ${normalOptions} -O " + outFilesVar.$("${_i}")))), (String)"GetPileupSummaries/CalculateContamination"));
    }
}

