/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.calling.varscan2;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.jobs.SamtoolsHelper;
import com.biotechvana.variantseq.jobs.VarScanHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class VarScanTrioJob
extends ISWFJob {
    public static final String JOB_ID = "trioVarScan";
    public static final String JOB_NAME = "VarScan2 trio calling";
    public static final String INPUT_FATHER_BAM_FILES = "FATHER_BAM";
    public static final String INPUT_MOTHER_BAM_FILES = "MOTHER_BAM";
    public static final String INPUT_CHILD_BAM_FILES = "CHILD_BAM";
    static final String INTER_FAM_FILES = "FAM_FILES";
    public static final String OUTPUT_VARIANTS_SNP_VCF = "OUTPUT_SNP_VCF";
    public static final String OUTPUT_VARIANTS_INDEL_VCF = "OUTPUT_INDEL_VCF";

    public VarScanTrioJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("Trio calling with VarScan2 and samtools");
        this.jobDesc.addPublication(VarScanHelper.getCitation());
        this.jobDesc.addLink(VarScanHelper.getManualLink(JOB_ID));
    }

    protected void createInputs() {
        VariableDescriptor refVar = VarScanHelper.createReferenceVar();
        this.jobDesc.addVariable(refVar);
        VariableDescriptor inputVar = VarScanHelper.createFatherBamFilesVar();
        this.jobDesc.addVariable(inputVar);
        inputVar = VarScanHelper.createMotherBamFilesVar();
        this.jobDesc.addVariable(inputVar);
        inputVar = VarScanHelper.createChildBamFilesVar();
        this.jobDesc.addVariable(inputVar);
    }

    protected void createOutputs() {
        VariableDescriptor output = VarScanHelper.createOutputSNPVCFFilesVar();
        this.jobDesc.addVariable(output);
        output = VarScanHelper.createOutputIndelVCFFilesVar();
        this.jobDesc.addVariable(output);
        VariableDescriptor internalFam = VariableDescriptor.createDescriptorFor((String)INTER_FAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        this.jobDesc.addVariable(internalFam);
    }

    protected void createOptions() {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum read depth");
        optionVar.setHelpMsg("Minimum read depth at a position to make a call. Default is 20");
        optionVar.setCommandParamater("--min-coverage");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum supporting reads");
        optionVar.setHelpMsg("Minimum supporting reads at a position to call variants. Default is 2");
        optionVar.setCommandParamater("--min-reads2");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum base quality at a position to count a read");
        optionVar.setHelpMsg("Minimum base quality at a position to count a read. Default is 15");
        optionVar.setCommandParamater("--min-avg-qual");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum variant allele frequency threshold");
        optionVar.setHelpMsg("Minimum variant allele frequency threshold. Default is 0.02 ");
        optionVar.setCommandParamater("--min-var-freq");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum frequency to call homozygote");
        optionVar.setHelpMsg("Minimum frequency to call homozygote. Default is 0.75");
        optionVar.setCommandParamater("--min-freq-for-hom");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Default p-value threshold for calling variants");
        optionVar.setHelpMsg("Default p-value threshold for calling variants. Default is 0.05 ");
        optionVar.setCommandParamater("--p-value");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Adjusted minimum VAF when recalling at variant site");
        optionVar.setHelpMsg("Adjusted minimum VAF when recalling at variant site. Default is 0.05 ");
        optionVar.setCommandParamater("--adj-var-freq");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Adjusted p-value when recalling at variant site");
        optionVar.setHelpMsg("Adjusted p-value when recalling at variant site. Default is 0.10 ");
        optionVar.setCommandParamater("--adj-p-value");
        this.jobDesc.addVariable(optionVar);
        SamtoolsHelper.createMpileupOptions(this.jobDesc);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String mpileup = SamtoolsHelper.getSamtoolsCmdPrefix() + " mpileup ";
        String varscan = VarScanHelper.getVarscanCmdPrefix() + " trio ";
        FilesVariable inputFatherBamFilesVar = (FilesVariable)this.getVariable(INPUT_FATHER_BAM_FILES);
        FilesVariable inputMotherBamFilesVar = (FilesVariable)this.getVariable(INPUT_MOTHER_BAM_FILES);
        FilesVariable inputChildBamFilesVar = (FilesVariable)this.getVariable(INPUT_CHILD_BAM_FILES);
        FilesVariable outSnpFilesVar = (FilesVariable)this.getVariable(OUTPUT_VARIANTS_SNP_VCF);
        FilesVariable outIndelFilesVar = (FilesVariable)this.getVariable(OUTPUT_VARIANTS_INDEL_VCF);
        FilesVariable internalFamNames = (FilesVariable)this.getVariable(INTER_FAM_FILES);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputFatherBamFilesVar, (String)(VarScanTrioJob.st((String)BashHelper.arrayAdd((JobVariable)internalFamNames, (String)(inputFatherBamFilesVar.$("${_i}") + "," + inputMotherBamFilesVar.$("${_i}") + "," + inputChildBamFilesVar.$("${_i}")))) + VarScanTrioJob.st((String)BashHelper.assign((String)"fatherBaseName", (String)BashHelper.getBaseName((JobVariable)inputFatherBamFilesVar, (String)"${_i}"))) + VarScanTrioJob.st((String)BashHelper.assign((String)"motherBaseName", (String)BashHelper.getBaseName((JobVariable)inputMotherBamFilesVar, (String)"${_i}"))) + VarScanTrioJob.st((String)BashHelper.assign((String)"childBaseName", (String)BashHelper.getBaseName((JobVariable)inputChildBamFilesVar, (String)"${_i}"))) + VarScanTrioJob.st((String)BashHelper.assign((String)"tempNames", (String)"( $fatherBaseName $motherBaseName $childBaseName )", (boolean)true)) + VarScanTrioJob.st((String)BashHelper.assign((String)"tempName", (String)"$(hlp_lncNamesArr tempNames[@])")) + String.valueOf(BashHelper.If((String)BashConditions.emptyStr((String)"$tempName")).Then(VarScanTrioJob.st((String)BashHelper.arrayAdd((JobVariable)outSnpFilesVar, (String)"${outputFolder}/${fatherBaseName}_${motherBaseName}_${childBaseName}.snp.vcf")) + VarScanTrioJob.st((String)BashHelper.arrayAdd((JobVariable)outIndelFilesVar, (String)"${outputFolder}/${fatherBaseName}_${motherBaseName}_${childBaseName}.indel.vcf"))).Else(VarScanTrioJob.st((String)BashHelper.arrayAdd((JobVariable)outSnpFilesVar, (String)"${outputFolder}/${tempName}.snp.vcf")) + VarScanTrioJob.st((String)BashHelper.arrayAdd((JobVariable)outIndelFilesVar, (String)"${outputFolder}/${tempName}.indel.vcf"))))), (boolean)true));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)internalFamNames, (String)("echo \" final name @ $_i = " + outSnpFilesVar.$("${_i}") + "\""), (String)(VarScanTrioJob.st((String)BashHelper.assign((String)"outputPrefix", (String)BashHelper.getBaseName((String)outSnpFilesVar.getBashVarName("${_i}"), (String)".snp.vcf"))) + mpileup + this.getOptionParamatersStrAs$("Mpileup") + " -q 1 -B " + inputFatherBamFilesVar.$("${_i}") + " " + inputMotherBamFilesVar.$("${_i}") + " " + inputChildBamFilesVar.$("${_i}") + " | " + varscan + "--output-name   ${outputFolder}/${outputPrefix} " + this.getOptionParamatersStrAs$() + "   --output-vcf 1 "), (String)"Varscan"));
    }
}

