/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.calling.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.jobs.calling.gatk.GATKHaplotypeCallerJob;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GermlineVariantsHaplotypeCallerJob
extends ISWFJob {
    public static final String JOB_ID = "gvHC";
    public static final String JOB_NAME = "Calling Germline Variants with GATK";
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    public static final String OUTPUT_VARIANTS_VCF = "OUTPUT_VARIANTS_VCF";
    public static final String INTER_VARIANTS_GVCF = "INTER_VARIANTS_GVCF";
    public static final String INTER_VARIANTS_MERGED_GVCF = "INTER_VARIANTS_COMBINED_GVCF";
    public static final String OPTION_BAM_OUT = "OPTION_BAM_OUT";
    public static final String OPTION_ALLELE_SPECIFIC_ANNOTATIONS = "ALLELE_SPECIFIC_ANNOTATIONS";
    public static final String OPTION_EMIT_REF_CONFIDENCE = "EMIT_REF_CONFIDENCE";
    public static final String ERC_MODE_NONE = "NONE";
    public static final String ERC_MODE_BP_RESOLUTION = "BP_RESOLUTION";
    public static final String ERC_MODE_GVCF = "GVCF";
    static final String haplotypeCaller = "HaplotypeCaller";
    static final String combineGVCFs = "CombineGVCFs";
    static final String genotypeGVCFs = "GenotypeGVCFs";

    public GermlineVariantsHaplotypeCallerJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Call germline SNPs and indels via local re-assembly of haplotypes using GATK tools (HaplotypeCaller, CombineGVCFs and GenotypeGVCFs  )");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage(haplotypeCaller, "org_broadinstitute_hellbender_tools_walkers_haplotypecaller_HaplotypeCaller.php") + "\n" + GATKHelper.getManualPage(combineGVCFs, "org_broadinstitute_hellbender_tools_walkers_CombineGVCFs.php") + "\n" + GATKHelper.getManualPage(genotypeGVCFs, "org_broadinstitute_hellbender_tools_walkers_GenotypeGVCFs.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = GATKHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor optionaVar = VariableDescriptor.createDescriptorFor((String)OPTION_BAM_OUT, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        optionaVar.setVariableName("Generate Realignmed reads Bam File");
        optionaVar.setHelpMsg("Output the new realigned reads as the HaplotypeCaller performs a local reassembly and realignment on the orginal.");
        this.jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)OPTION_ALLELE_SPECIFIC_ANNOTATIONS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        optionaVar.setVariableName("Allele-specific annotations");
        optionaVar.setHelpMsg("Allele-specific annotations");
        this.jobDesc.addVariable(optionaVar);
        SelectionListVariableDescriptor optionaVarSelectionList = VariableDescriptor.SelectionList((String)OPTION_EMIT_REF_CONFIDENCE, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        optionaVarSelectionList.setVariableName("Mode for emitting reference confidence scores");
        optionaVarSelectionList.setHelpMsg("The reference confidence mode makes it possible to emit a per-bp or summarized confidence estimate for a site being strictly homozygous-reference.");
        optionaVarSelectionList.addOptionValue(ERC_MODE_NONE, ERC_MODE_NONE, "Regular calling without emitting reference confidence calls.");
        optionaVarSelectionList.addOptionValue(ERC_MODE_BP_RESOLUTION, ERC_MODE_BP_RESOLUTION, "Reference model emitted site by site");
        optionaVarSelectionList.addOptionValue(ERC_MODE_GVCF, ERC_MODE_GVCF, "Reference model emitted with condensed non-variant blocks, i.e. the GVCF format.");
        optionaVarSelectionList.setDefaultIndexValue(2);
        optionaVarSelectionList.setCommandParamater("-ERC");
        optionaVarSelectionList.setCommandParamaterAlt("--emit-ref-confidence");
        optionaVarSelectionList.setSubProgName(haplotypeCaller);
        this.jobDesc.addVariable((VariableDescriptor)optionaVarSelectionList);
    }

    protected void createOutputs() {
        VariableDescriptor outputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_VARIANTS_VCF, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputFile.setVariableName("Variants vcf");
        outputFile.setHelpMsg("variant calls output vcf files");
        this.jobDesc.addVariable(outputFile);
        outputFile = VariableDescriptor.createDescriptorFor((String)INTER_VARIANTS_GVCF, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        outputFile.setVariableName("Variants gvcf");
        outputFile.setHelpMsg("gvcf files");
        this.jobDesc.addVariable(outputFile);
        outputFile = VariableDescriptor.createDescriptorFor((String)INTER_VARIANTS_MERGED_GVCF, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        outputFile.setVariableName("merged gvcf");
        outputFile.setHelpMsg("merged gvcf files");
        this.jobDesc.addVariable(outputFile);
    }

    protected void createOptions() {
        GATKHaplotypeCallerJob.creareOptionHC(this.jobDesc);
        GATKHelper.createSharedOptions(this.jobDesc, new String[]{GATKHelper.GATK_OPTION_SWITCH_CREATE_BAM_MD5, GATKHelper.GATK_OPTION_SWITCH_CREATE_VCF_MD5, GATKHelper.GATK_OPTION_SWITCH_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_PADDING, GATKHelper.GATK_OPTION_SWITCH_EXCLUDE_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_EXCLUSION_PADDING, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_MERGING_RULE, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_SET_RULE, GATKHelper.GATK_OPTION_SWITCH_LENIENT, GATKHelper.GATK_OPTION_SWITCH_READ_VALIDATION_STRINGENCY});
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String haplotypeCallerPrefix = GATKHelper.getGATKCmdPrefix() + " HaplotypeCaller " + GATKHelper.getTmpOption();
        String combineGVCFsPrefix = GATKHelper.getGATKCmdPrefix() + " CombineGVCFs " + GATKHelper.getTmpOption();
        String genotypeGVCFsPrefix = GATKHelper.getGATKCmdPrefix() + " GenotypeGVCFs " + GATKHelper.getTmpOption();
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(INPUT_BAM_FILES);
        FilesVariable outFilesVar = (FilesVariable)this.getVariable(OUTPUT_VARIANTS_VCF);
        FilesVariable gvcfFilesVar = (FilesVariable)this.getVariable(INTER_VARIANTS_GVCF);
        FilesVariable mergedGVCFFilesVar = (FilesVariable)this.getVariable(INTER_VARIANTS_MERGED_GVCF);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        JobVariable ercMode = this.getVariable(OPTION_EMIT_REF_CONFIDENCE);
        String outputExt = ".g.vcf";
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(GermlineVariantsHaplotypeCallerJob.st((String)BashHelper.assign((String)"sampleName", (String)"allSamples")));
        builder.append(BashHelper.If((String)BashConditions.or((String)BashConditions.Equal((JobVariable)ercMode, (String)ERC_MODE_GVCF), (String)BashConditions.Equal((JobVariable)ercMode, (String)ERC_MODE_BP_RESOLUTION))).Then(GermlineVariantsHaplotypeCallerJob.st((String)BashHelper.arrayAdd((JobVariable)outFilesVar, (String)"${outputFolder}/jointCalling.vcf")) + GermlineVariantsHaplotypeCallerJob.st((String)BashHelper.arrayAdd((JobVariable)mergedGVCFFilesVar, (String)"${outputFolder}/${sampleName}.merged.g.vcf")) + BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)GermlineVariantsHaplotypeCallerJob.st((String)BashHelper.arrayAdd((JobVariable)gvcfFilesVar, (String)"${outputFolder}/${inputFileBaseName}.g.vcf")), (String)(haplotypeCallerPrefix + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(haplotypeCaller) + "-I ${_inputFile}  -O " + gvcfFilesVar.$("${_i}")), (String)haplotypeCaller) + BashHelper.command_withTrack((String)BashHelper.hlpArrAppend((JobVariable)gvcfFilesVar, (String)","), (String)(combineGVCFsPrefix + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(combineGVCFs) + BashHelper.hlpCmdSwitchAppend((JobVariable)gvcfFilesVar, (String)"-V", (String)" ") + " -O ${outputFolder}/${sampleName}.merged.g.vcf"), (String)combineGVCFs) + BashHelper.BatcherParallelSingleton((FilesVariable)mergedGVCFFilesVar, (String)"", (String)(genotypeGVCFsPrefix + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(genotypeGVCFs) + " -V ${_inputFile}  -O " + outFilesVar.$("${_i}")), (String)genotypeGVCFs)).Else(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)GermlineVariantsHaplotypeCallerJob.st((String)BashHelper.arrayAdd((JobVariable)outFilesVar, (String)"${outputFolder}/${inputFileBaseName}.vcf")), (String)(haplotypeCallerPrefix + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(haplotypeCaller) + "-I ${_inputFile}  -O " + outFilesVar.$("${_i}")), (String)haplotypeCaller)));
    }
}

