/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.calling.gatk;

import com.biotechvana.utils.Constants;
import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;

public class GATKGermlineCNVCallerJob
extends ISWFJob {
    public static final String JOB_ID = "germlineCNVCaller";
    public static final String JOB_NAME = "Call CNVs with Germline CNV Caller";
    static String cmdPrefix = Constants.PIPELINE_BASE_PATH + "gatk --java-options \"-Xmx4g\" GermlineCNVCaller ";

    public GATKGermlineCNVCallerJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("GermlineCNVCaller : Calls copy-number variants in germline samples");
        this.jobDesc.setRef(GATKHelper.getCitation("GermlineCNVCaller : <a href=\"https://software.broadinstitute.org/gatk/documentation/tooldocs/current/org_broadinstitute_hellbender_tools_copynumber_GermlineCNVCaller.php\">Manual Page</a>"));
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"INPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Count Files");
        varReadInputFile.setHelpMsg("Input Count Files.");
        this.jobDesc.addVariable(varReadInputFile);
    }

    protected void createOutputs() {
        VariableDescriptor variantOutputFile = VariableDescriptor.createDescriptorFor((String)"OUTPUT_VARIANTS_VCF", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        variantOutputFile.setVariableName("Variants vcf");
        variantOutputFile.setHelpMsg("variant calls output vcf files");
        this.jobDesc.addVariable(variantOutputFile);
    }

    protected void createOptions() {
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
    }
}

