/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.calling.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GATKCombineGVCFsJob
extends ISWFJob {
    public static final String JOB_ID = "combineGVCFs";
    public static final String JOB_NAME = "GATK - CombineGVCFs";
    public static final String INPUT_GVCF_FILES = "INPUT_VARIANTS_VCF";
    public static final String OUTPUT_VARIANTS_VCF = "OUTPUT_VARIANTS_VCF";
    public static final String INPUT_REF_FASTA = VariantAnaylsisVariableBag.INPUT_REF_FASTA;
    private static final String INPUT_SAMPLES_GROUP = "INPUT_SAMPLES_GROUP";

    public GATKCombineGVCFsJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Merges HaplotypeCaller GVCF files into a single GVCF with appropriate annotations");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage("CombineGVCFs", "org_broadinstitute_hellbender_tools_walkers_CombineGVCFs.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_GVCF_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input GVCF Files");
        varReadInputFile.setHelpMsg("Input GVCF Files.");
        varReadInputFile.addAcceptedFileFormat("GVCF");
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor varInput = VariableDescriptor.createDescriptorFor((String)INPUT_SAMPLES_GROUP, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.setVariableName("Samples groups");
        varInput.setHelpMsg("Samples groups.");
        this.jobDesc.addVariable(varInput);
    }

    protected void createOutputs() {
        VariableDescriptor variantOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_VARIANTS_VCF, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        variantOutputFile.setVariableName("Variants vcf");
        variantOutputFile.setHelpMsg("variant calls output vcf files");
        this.jobDesc.addVariable(variantOutputFile);
    }

    protected void createOptions() {
        GATKHelper.createSharedOptions(this.jobDesc, new String[]{GATKHelper.GATK_OPTION_SWITCH_CREATE_VCF_MD5, GATKHelper.GATK_OPTION_SWITCH_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_PADDING, GATKHelper.GATK_OPTION_SWITCH_EXCLUDE_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_EXCLUSION_PADDING, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_MERGING_RULE, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_SET_RULE, GATKHelper.GATK_OPTION_SWITCH_LENIENT, GATKHelper.GATK_OPTION_SWITCH_READ_VALIDATION_STRINGENCY});
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String combineGVCFsPrefix = GATKHelper.getGATKCmdPrefix() + " CombineGVCFs " + GATKHelper.getTmpOption();
        FilesVariable inputGVCFFilesVar = (FilesVariable)this.getVariable(INPUT_GVCF_FILES);
        FilesVariable outFilesVar = (FilesVariable)this.getVariable(OUTPUT_VARIANTS_VCF);
        JobVariable refFileVar = this.getVariable(INPUT_REF_FASTA);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(GATKCombineGVCFsJob.st((String)BashHelper.assign((String)"sampleName", (String)"allSamples")));
        builder.append(GATKCombineGVCFsJob.st((String)BashHelper.arrayAdd((JobVariable)outFilesVar, (String)"${outputFolder}/${sampleName}.merged.g.vcf")));
        builder.append(BashHelper.command_withTrack((String)BashHelper.hlpArrAppend((JobVariable)inputGVCFFilesVar, (String)","), (String)(combineGVCFsPrefix + this.getOptionParamatersStrAs$() + BashHelper.hlpCmdSwitchAppend((JobVariable)inputGVCFFilesVar, (String)"-V", (String)" ") + " -O ${outputFolder}/${sampleName}.merged.g.vcf"), (String)"CombineGVCFs"));
    }
}

