/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs;

import com.biotechvana.utils.Constants;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.CmdListMergeStrategy;
import com.biotechvana.workflow.IListVariableDescriptor;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.FilesVariableDescriptor;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.JobLink;
import com.biotechvana.workflow.descriptors.MultiSelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;
import java.util.HashMap;
import java.util.List;

public class GATKHelper {
    public static final String GATK_COMMON_OPTIONAL = "Common Optional";
    public static final String GATK_OPTION_SWITCH_OQ = "-OQ";
    public static String GATK_V4_Latest = "4.1.2.0";
    public static String GATK_V3_Latest = "3.0.8.0";
    private static HashMap<String, CreateOptionCallBack> optionToAction = new HashMap();
    public static String GATK_OPTION_SWITCH_CREATE_BAM_INDEX = "-OBI";
    public static String GATK_OPTION_SWITCH_CREATE_BAM_MD5;
    public static String GATK_OPTION_SWITCH_CREATE_VCF_INDEX;
    public static String GATK_OPTION_SWITCH_CREATE_VCF_MD5;
    public static String GATK_OPTION_SWITCH_INTERVALS;
    public static String GATK_OPTION_SWITCH_INTERVALS_PADDING;
    public static String GATK_OPTION_SWITCH_INTERVALS_MERGING_RULE;
    public static String GATK_OPTION_SWITCH_INTERVALS_SET_RULE;
    public static String GATK_OPTION_SWITCH_EXCLUDE_INTERVALS;
    public static String GATK_OPTION_SWITCH_INTERVALS_EXCLUSION_PADDING;
    public static String GATK_OPTION_SWITCH_LENIENT;
    public static String GATK_OPTION_SWITCH_DISABLE_TOOL_DEFAULT_READ_FILTERS;
    public static String GATK_OPTION_SWITCH_GATK_CONFIG_FILE;
    public static String GATK_OPTION_SWITCH_ARGUMENTS_FILE;
    public static String GATK_OPTION_SWITCH_READ_FILTER;
    public static String GATK_OPTION_SWITCH_READ_VALIDATION_STRINGENCY;
    public static String GATK_OPTION_SWITCH_ANNOTATION;

    static {
        optionToAction.put(GATK_OPTION_SWITCH_CREATE_BAM_INDEX, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionCreateBamIndex();
            }
        });
        GATK_OPTION_SWITCH_CREATE_BAM_MD5 = "-OBM";
        optionToAction.put(GATK_OPTION_SWITCH_CREATE_BAM_MD5, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionCreateBAMMD5();
            }
        });
        GATK_OPTION_SWITCH_CREATE_VCF_INDEX = "-OVI";
        optionToAction.put(GATK_OPTION_SWITCH_CREATE_VCF_INDEX, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionCreateVCFIndex();
            }
        });
        GATK_OPTION_SWITCH_CREATE_VCF_MD5 = "-OVM";
        optionToAction.put(GATK_OPTION_SWITCH_CREATE_VCF_MD5, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionCreateVCFMD5();
            }
        });
        GATK_OPTION_SWITCH_INTERVALS = "-L";
        optionToAction.put(GATK_OPTION_SWITCH_INTERVALS, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionInterval();
            }
        });
        GATK_OPTION_SWITCH_INTERVALS_PADDING = "-ip";
        optionToAction.put(GATK_OPTION_SWITCH_INTERVALS_PADDING, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionIntervalPadding();
            }
        });
        GATK_OPTION_SWITCH_INTERVALS_MERGING_RULE = "-imr";
        optionToAction.put(GATK_OPTION_SWITCH_INTERVALS_MERGING_RULE, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionIntervalMergingRule();
            }
        });
        GATK_OPTION_SWITCH_INTERVALS_SET_RULE = "-isr";
        optionToAction.put(GATK_OPTION_SWITCH_INTERVALS_SET_RULE, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionIntervalSetRule();
            }
        });
        GATK_OPTION_SWITCH_EXCLUDE_INTERVALS = "-XL";
        optionToAction.put(GATK_OPTION_SWITCH_EXCLUDE_INTERVALS, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionExcludeIntervals();
            }
        });
        GATK_OPTION_SWITCH_INTERVALS_EXCLUSION_PADDING = "-ixp";
        optionToAction.put(GATK_OPTION_SWITCH_INTERVALS_EXCLUSION_PADDING, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionIntervalExclusionPadding();
            }
        });
        GATK_OPTION_SWITCH_LENIENT = "-LE";
        optionToAction.put(GATK_OPTION_SWITCH_LENIENT, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionLenient();
            }
        });
        GATK_OPTION_SWITCH_DISABLE_TOOL_DEFAULT_READ_FILTERS = "--disable-tool-default-read-filters";
        optionToAction.put(GATK_OPTION_SWITCH_DISABLE_TOOL_DEFAULT_READ_FILTERS, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionDisableToolDefaultReadFilters();
            }
        });
        GATK_OPTION_SWITCH_GATK_CONFIG_FILE = "--gatk-config-file";
        optionToAction.put(GATK_OPTION_SWITCH_GATK_CONFIG_FILE, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionArgumentsFile();
            }
        });
        GATK_OPTION_SWITCH_ARGUMENTS_FILE = "--arguments_file";
        optionToAction.put(GATK_OPTION_SWITCH_ARGUMENTS_FILE, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionArgumentsFile();
            }
        });
        GATK_OPTION_SWITCH_READ_FILTER = "-RF";
        optionToAction.put(GATK_OPTION_SWITCH_READ_FILTER, new CreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionReadFilters();
            }

            @Override
            public void addRules(WorkflowJob job) {
                String READ_FILTER_AmbiguousBaseReadFilter = "AmbiguousBaseReadFilter";
                new VariablesRule(job.getVariableByCMDSwitch(GATK_OPTION_SWITCH_READ_FILTER), job.getVariableByCMDSwitch("--ambig-filter-bases"), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, "AmbiguousBaseReadFilter", true);
                new VariablesRule(job.getVariableByCMDSwitch(GATK_OPTION_SWITCH_READ_FILTER), job.getVariableByCMDSwitch("--ambig-filter-frac"), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, "AmbiguousBaseReadFilter", true);
                new VariablesRule(job.getVariableByCMDSwitch("--ambig-filter-bases"), job.getVariableByCMDSwitch("--ambig-filter-frac"), VariablesRule.Condition.NotEqualTo, VariablesRule.Action.Reset, "");
                new VariablesRule(job.getVariableByCMDSwitch("--ambig-filter-frac"), job.getVariableByCMDSwitch("--ambig-filter-bases"), VariablesRule.Condition.NotEqualTo, VariablesRule.Action.Reset, "");
            }
        });
        GATK_OPTION_SWITCH_READ_VALIDATION_STRINGENCY = "-VS";
        optionToAction.put(GATK_OPTION_SWITCH_READ_VALIDATION_STRINGENCY, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionReadValidationStringency();
            }
        });
        GATK_OPTION_SWITCH_ANNOTATION = "-A";
        optionToAction.put(GATK_OPTION_SWITCH_ANNOTATION, new NoRulesCreateOptionCallBack(){

            @Override
            public VariableDescriptor createOption() {
                return GATKHelper.createOptionAnnotation();
            }
        });
    }

    public static String getGATKCmdPrefix(String subTool) {
        return GATKHelper.getGATKCmdPrefix(4, subTool);
    }

    public static String getGATKCmdPrefix(int version, String subTool) {
        if (version == 3) {
            return "java -jar -Xmx4g " + Constants.PIPELINE_BASE_PATH + "GenomeAnalysisTK.3.8.1.0.jar  " + subTool + " ";
        }
        return Constants.PIPELINE_BASE_PATH + "gatk  --java-options \"-Xmx4g\"  " + subTool + " ";
    }

    public static String getTmpOption() {
        return " --tmp-dir $tmpFolder ";
    }

    public static String getGATKCmdPrefix() {
        return GATKHelper.getGATKCmdPrefix(4);
    }

    public static String getGATKCmdPrefix(int version) {
        if (version == 3) {
            return "java -jar -Xmx4g " + Constants.PIPELINE_BASE_PATH + "GenomeAnalysisTK.3.8.1.0.jar ";
        }
        return Constants.PIPELINE_BASE_PATH + "gatk  --java-options \"-Xmx4g\" ";
    }

    public static String getCitation() {
        return "* The Genome Analysis Toolkit: a MapReduce framework for analyzing next-generation DNA sequencing data McKenna A, Hanna M, Banks E, Sivachenko A, Cibulskis K, Kernytsky A, Garimella K, Altshuler D, Gabriel S, Daly M, DePristo MA, 2010 GENOME RESEARCH 20:1297-303. <a href=\"http://dx.doi.org/10.1101/gr.107524.110\">DOI: 10.1101/gr.107524.110</a>\n\n* A framework for variation discovery and genotyping using next-generation DNA sequencing data DePristo M, Banks E, Poplin R, Garimella K, Maguire J, Hartl C, Philippakis A, del Angel G, Rivas MA, Hanna M, McKenna A, Fennell T, Kernytsky A, Sivachenko A, Cibulskis K, Gabriel S, Altshuler D, Daly M, 2011 NATURE GENETICS 43:491-498. <a href=\"http://dx.doi.org/10.1038/ng.806\">DOI: 10.1038/ng.806</a>";
    }

    public static void getCitation(JobDescriptor jobDesc) {
        jobDesc.addPublication(new Publication().setAuthors("McKenna, A., Hanna, M., Banks, E., Sivachenko, A., Cibulskis, K., Kernytsky, A., Garimella, K., Altshuler, D., Gabriel, S., Daly, M. and DePristo, M.A.").setTitle("The Genome Analysis Toolkit: a MapReduce framework for analyzing next-generation DNA sequencing data").setJournal("Genome research").setVolume(20).setIssue(9).setYear(2010).setPages("1297-1303").setDOI("10.1101/gr.107524.110").setPubmed("20644199"));
        jobDesc.addPublication(new Publication().setAuthors("DePristo, M.A., Banks, E., Poplin, R., Garimella, K.V., Maguire, J.R., Hartl, C., Philippakis, A.A., Del Angel, G., Rivas, M.A., Hanna, M. and McKenna, A.").setTitle("A framework for variation discovery and genotyping using next-generation DNA sequencing data").setJournal("Nature genetics").setVolume(43).setIssue(5).setYear(2011).setPages("491-498").setDOI("10.1038/ng.806").setPubmed("21478889"));
    }

    public static Publication getCitationNBT2514() {
        return new Publication().setAuthors("Cibulskis, K., Lawrence, M.S., Carter, S.L., Sivachenko, A., Jaffe, D., Sougnez, C., Gabriel, S., Meyerson, M., Lander, E.S. and Getz, G.").setTitle("Sensitive detection of somatic point mutations in impure and heterogeneous cancer samples").setJournal("Nature biotechnology").setVolume(31).setIssue(3).setYear(2013).setPages("213-219").setDOI("10.1038/nbt.2514").setPubmed("23396013");
    }

    public static String getCitation(String extCite) {
        return GATKHelper.getCitation() + "\n\n" + extCite;
    }

    public static String getManualPage(String toolName, String page) {
        return GATKHelper.getManualPage(toolName, page, 4);
    }

    public static String getManualPage(String toolName, String page, int gatkVersion) {
        String vStr = GATK_V4_Latest;
        if (gatkVersion == 3) {
            vStr = GATK_V3_Latest;
        }
        return "Manual : <a href=\"https://software.broadinstitute.org/gatk/documentation/tooldocs/" + vStr + "/" + page + "\">" + toolName + "</a>";
    }

    public static JobLink getManualLink(String toolName, String page) {
        return GATKHelper.getManualLink(toolName, page, 4);
    }

    public static JobLink getManualLink(String toolName, String page, int gatkVersion) {
        String vStr = GATK_V4_Latest;
        if (gatkVersion == 3) {
            vStr = GATK_V3_Latest;
        }
        return new JobLink().setTitle(toolName).setUrl("https://software.broadinstitute.org/gatk/documentation/tooldocs/" + vStr + "/" + page).setType(JobLink.LinkType.Manual);
    }

    public static void addToolGroup(JobDescriptor jobDesc) {
        jobDesc.setToolGroup("gatk");
    }

    public static void checkPrepareReference(StringBuilder builder, JobVariable refFileVar) {
        builder.append(BashHelper.If((String)BashConditions.notEmptyStr((JobVariable)refFileVar)).Then(String.valueOf(BashHelper.If((String)BashConditions.fileNotExist((String)(refFileVar.$() + ".fai"))).Then(Tracking.trackLogWarning((String)("Index file " + refFileVar.$() + ".fai for the reference fasta file does not exit. Will create one")) + "\n" + BashHelper.command_withTrack((String)refFileVar.$(), (String)(Constants.PIPELINE_BASE_PATH + "samtools faidx " + refFileVar.$()), (String)"Building fasta index"))) + BashHelper.assign((String)"refDictFileName", (String)("${" + refFileVar.getBashVarName() + "%.*}.dict")) + String.valueOf(BashHelper.If((String)BashConditions.fileNotExist((String)"${refDictFileName}")).Then(Tracking.trackLogWarning((String)"Sequence Dictionary file ${refDictFileName} for the reference fasta file does not exit. Will create one") + "\n" + BashHelper.command_withTrack((String)refFileVar.$(), (String)(Constants.PIPELINE_PICARD_EXE + "  CreateSequenceDictionary R=" + refFileVar.$()), (String)"Picard  CreateSequenceDictionary")))));
    }

    public static void checkPrepareKnownSitesIndex(StringBuilder builder, FilesVariable refFileVar) {
        builder.append(BashHelper.Batcher_noLog((FilesVariable)refFileVar, (String)("vcfIndexFile=\"${_inputFile}.idx\"\n[ \"${_inputFile: -3}\" == \".gz\" ] &&  vcfIndexFile=\"${_inputFile}.tbi\"\n" + BashHelper.If((String)BashConditions.fileNotExist((String)"${vcfIndexFile}")).Then(Tracking.trackLogWarning((String)"Index file for the VCF file ${_inputFile}.tbi, does not exit. Will create one") + "\n" + BashHelper.command_withTrack((String)"${_inputFile}", (String)(GATKHelper.getGATKCmdPrefix("IndexFeatureFile") + GATKHelper.getTmpOption() + " -F ${_inputFile}"), (String)"gatk IndexFeatureFile")).toString()), (boolean)true));
    }

    public static VariableDescriptor createReferenceVar() {
        VariableDescriptor varReferenceFasta = VariableDescriptor.createDescriptorFor((String)VariantAnaylsisVariableBag.INPUT_REF_FASTA, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReferenceFasta.isRequired = true;
        varReferenceFasta.setVariableName("Input Reference fasta file");
        varReferenceFasta.setShortHelpMsg("Drag an Reference fasta file");
        varReferenceFasta.setHelpMsg("Reference fasta file.");
        varReferenceFasta.setCommandParamater("-R");
        return varReferenceFasta;
    }

    public static VariableDescriptor createInputBamFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)VariantAnaylsisVariableBag.INPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Bam Files");
        varReadInputFile.setHelpMsg("Input Bam Files.");
        varReadInputFile.addAcceptedFileFormat("BAM");
        return varReadInputFile;
    }

    public static VariableDescriptor createInputTumorBamFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"TUMOR_BAM", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Tumor Bam Files");
        varReadInputFile.setHelpMsg("Input Tumor Bam Files.");
        varReadInputFile.addAcceptedFileFormat("BAM");
        return varReadInputFile;
    }

    public static VariableDescriptor createInputNormalBamFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"NORMAL_BAM", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.setVariableName("Input Normal Bam Files");
        varReadInputFile.setHelpMsg("Input Normal Bam Files.");
        varReadInputFile.addAcceptedFileFormat("BAM");
        return varReadInputFile;
    }

    public static VariableDescriptor createKnownSitesVar() {
        FilesVariableDescriptor varKnownSites = VariableDescriptor.Files((String)"INPUT_KNOWN_SITES", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varKnownSites.isRequired = true;
        varKnownSites.setVariableName("Known sites files");
        varKnownSites.setHelpMsg("An optional known sites vcf files");
        varKnownSites.setCommandParamater("--known-sites");
        varKnownSites.setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        varKnownSites.addAcceptedFileFormat("VCF");
        varKnownSites.addAcceptedFileFormat("VCF.GZ");
        return varKnownSites;
    }

    public static void createSharedOptions(JobDescriptor jobDesc) {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Use the base quality scores from the OQ tag");
        optionalVar.setHelpMsg("Use the base quality scores from the OQ tag");
        optionalVar.setCommandParamater(GATK_OPTION_SWITCH_OQ);
        optionalVar.setCommandParamaterAlt("--use-original-qualities");
        optionalVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        jobDesc.addVariable(optionalVar);
    }

    public static void createSharedOptions(JobDescriptor jobDesc, String key, String sharedVarGroup) {
        GATKHelper.createSharedOptions(jobDesc, new String[]{key}, sharedVarGroup);
    }

    public static void createSharedOptions(JobDescriptor jobDesc, String key) {
        GATKHelper.createSharedOptions(jobDesc, new String[]{key}, GATK_COMMON_OPTIONAL);
    }

    public static void createSharedOptions(JobDescriptor jobDesc, String[] keys) {
        GATKHelper.createSharedOptions(jobDesc, keys, GATK_COMMON_OPTIONAL);
    }

    public static void createSharedOptions(JobDescriptor jobDesc, String[] keys, String sharedVarGroup) {
        VariableDescriptor optionalVar = null;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            optionalVar = null;
            if (optionToAction.containsKey(key)) {
                optionalVar = optionToAction.get(key).createOption();
                optionalVar.setVariableGroup(sharedVarGroup);
            }
            if (optionalVar != null) {
                jobDesc.addVariable(optionalVar);
                if (key.equals(GATK_OPTION_SWITCH_READ_FILTER)) {
                    GATKHelper.addAllReadFilterParameters(jobDesc, sharedVarGroup);
                }
            }
            ++n2;
        }
    }

    public static void addRules(WorkflowJob job) {
        for (String key : optionToAction.keySet()) {
            if (job.getVariableByCMDSwitch(key) == null) continue;
            optionToAction.get(key).addRules(job);
        }
    }

    public static VariableDescriptor createOptionCreateBamIndex() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Create a BAM/CRAM index when writing a coordinate-sorted BAM/CRAM file");
        optionalVar.setHelpMsg("Create a BAM/CRAM index when writing a coordinate-sorted BAM/CRAM file");
        optionalVar.setCommandParamater(GATK_OPTION_SWITCH_CREATE_BAM_INDEX);
        optionalVar.setCommandParamaterAlt("--create-output-bam-index");
        optionalVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static VariableDescriptor createOptionCreateBAMMD5() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Create a MD5 digest for any BAM/SAM/CRAM file created");
        optionalVar.setHelpMsg("Create a MD5 digest for any BAM/SAM/CRAM file created");
        optionalVar.setCommandParamater(GATK_OPTION_SWITCH_CREATE_VCF_MD5);
        optionalVar.setCommandParamaterAlt("--create-output-bam-md5");
        optionalVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static VariableDescriptor createOptionCreateVCFIndex() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("If true, create a VCF index when writing a coordinate-sorted VCF file");
        optionalVar.setHelpMsg("If true, create a VCF index when writing a coordinate-sorted VCF file");
        optionalVar.setCommandParamater(GATK_OPTION_SWITCH_CREATE_VCF_INDEX);
        optionalVar.setCommandParamaterAlt("--create-output-variant-index");
        optionalVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static VariableDescriptor createOptionCreateVCFMD5() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("If true, create a a MD5 digest any VCF file created");
        optionalVar.setHelpMsg("If true, create a a MD5 digest any VCF file created");
        optionalVar.setCommandParamater(GATK_OPTION_SWITCH_CREATE_VCF_MD5);
        optionalVar.setCommandParamaterAlt("--create-output-variant-md5");
        optionalVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static VariableDescriptor createOptionInterval() {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Intervals");
        optionVar.setHelpMsg("One or more genomic intervals over which to operate");
        optionVar.setCommandParamater(GATK_OPTION_SWITCH_INTERVALS);
        optionVar.setCommandParamaterAlt("--intervals");
        ((IListVariableDescriptor)optionVar).setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        optionVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionVar;
    }

    public static VariableDescriptor createOptionIntervalPadding() {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Interval Padding");
        optionVar.setHelpMsg("Amount of padding (in bp) to add to each interval you are includingUse this to add padding to the intervals specified using -L. For example, '-L 1:100' with a padding value of 20 would turn into '-L 1:80-120'. This is typically used to add padding around targets when analyzing exomes.");
        optionVar.setCommandParamater(GATK_OPTION_SWITCH_INTERVALS_PADDING);
        optionVar.setCommandParamaterAlt("--interval-padding");
        optionVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionVar;
    }

    public static VariableDescriptor createOptionIntervalMergingRule() {
        SelectionListVariableDescriptor optionVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Interval Merging Rule");
        optionVar.setShortHelpMsg("Interval merging rule for abutting intervals");
        optionVar.setHelpMsg("Interval merging rule for abutting intervalsBy default, the program merges abutting intervals (i.e. intervals that are directly side-by-side but do not actually overlap) into a single continuous interval. However you can change this behavior if you want them to be treated as separate intervals instead. ");
        optionVar.addOptionValue("ALL");
        optionVar.addOptionValue("OVERLAPPING_ONLY");
        optionVar.setCommandParamater(GATK_OPTION_SWITCH_INTERVALS_MERGING_RULE);
        optionVar.setCommandParamaterAlt("--interval-merging-rule");
        optionVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionVar;
    }

    public static VariableDescriptor createOptionIntervalSetRule() {
        SelectionListVariableDescriptor optionVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Interval Set Rule");
        optionVar.setShortHelpMsg("Set merging approach to use for combining interval inputs");
        optionVar.setHelpMsg("Set merging approach to use for combining interval inputs By default, the program will take the UNION of all intervals specified using -L and/or -XL. However, you can change this setting for -L, for example if you want to take the INTERSECTION of the sets instead. E.g. to perform the analysis only on chromosome 1 exomes, you could specify -L exomes.intervals -L 1 --interval-set-rule INTERSECTION. However, it is not possible to modify the merging approach for intervals passed using -XL (they will always be merged using UNION). Note that if you specify both -L and -XL, the -XL interval set will be subtracted from the -L interval set.");
        optionVar.addOptionValue("UNION");
        optionVar.addOptionValue("INTERSECTION");
        optionVar.setCommandParamater(GATK_OPTION_SWITCH_INTERVALS_SET_RULE);
        optionVar.setCommandParamaterAlt("--interval-set-rule");
        optionVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionVar;
    }

    public static VariableDescriptor createOptionExcludeIntervals() {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Exclude Intervals");
        optionVar.setHelpMsg("One or more genomic intervals to exclude from processing");
        optionVar.setCommandParamater(GATK_OPTION_SWITCH_EXCLUDE_INTERVALS);
        optionVar.setCommandParamaterAlt("--exclude-intervals");
        ((IListVariableDescriptor)optionVar).setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        optionVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionVar;
    }

    public static VariableDescriptor createOptionIntervalExclusionPadding() {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Interval Exclusion Padding");
        optionVar.setHelpMsg("Amount of padding (in bp) to add to each interval you are excluding.");
        optionVar.setCommandParamater(GATK_OPTION_SWITCH_INTERVALS_EXCLUSION_PADDING);
        optionVar.setCommandParamaterAlt("--interval-exclusion-padding");
        optionVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionVar;
    }

    public static VariableDescriptor createOptionLenient() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Lenient processing of VCF files");
        optionalVar.setHelpMsg("Lenient processing of VCF files");
        optionalVar.setCommandParamater(GATK_OPTION_SWITCH_LENIENT);
        optionalVar.setCommandParamaterAlt("--lenient");
        optionalVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static VariableDescriptor createOptionDisableToolDefaultReadFilters() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Disable all tool default read filters");
        optionalVar.setHelpMsg("Disable all tool default read filters (WARNING: many tools will not function correctly without their default read filters on)");
        optionalVar.setCommandParamater(GATK_OPTION_SWITCH_DISABLE_TOOL_DEFAULT_READ_FILTERS);
        optionalVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static VariableDescriptor createOptionGatkConfigFile() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("A configuration file to use with the GATK");
        optionalVar.setHelpMsg("A configuration file to use with the GATK");
        optionalVar.setCommandParamater(GATK_OPTION_SWITCH_GATK_CONFIG_FILE);
        optionalVar.setCommandParamaterAlt("--gatk-config-file");
        optionalVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static VariableDescriptor createOptionArgumentsFile() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Arguments file to add to the command line");
        optionalVar.setHelpMsg("Arguments file to add to the command line");
        optionalVar.setCommandParamater(GATK_OPTION_SWITCH_ARGUMENTS_FILE);
        optionalVar.setCommandParamaterAlt("--arguments_file");
        optionalVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static VariableDescriptor createOptionReadFilters() {
        MultiSelectionListVariableDescriptor optionalVar = VariableDescriptor.MultiSelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Read filters to be applied before analysis");
        optionalVar.setHelpMsg("Read filters to be applied before analysis");
        List lines = WorkflowJob.loadJobResource((String)"gatk", (String)"readFiltersList", (ClassLoader)GATKHelper.class.getClassLoader());
        for (String line : lines) {
            if (line.isEmpty()) continue;
            String[] tokens = line.split("\t");
            if (tokens.length >= 3) {
                optionalVar.addOptionValue(tokens[0], tokens[1], tokens[2]);
                continue;
            }
            optionalVar.addOptionValue(line.trim());
        }
        optionalVar.setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        optionalVar.setCommandParamater(GATK_OPTION_SWITCH_READ_FILTER);
        optionalVar.setCommandParamaterAlt("--read-filter");
        optionalVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionalVar;
    }

    static void addAllReadFilterParameters(JobDescriptor jobDesc, String sharedVarsGroup) {
        VariableDescriptor varOptions = null;
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Threshold number of ambiguous bases [AmbiguousBaseReadFilter parameter]");
        varOptions.setHelpMsg("Threshold number of ambiguous bases [AmbiguousBaseReadFilter parameter]. If null, uses threshold fraction; otherwise, overrides threshold fraction. This argument cannot be used at the same time as ambig-filter-frac. Default null");
        varOptions.setVariableGroup(GATK_COMMON_OPTIONAL);
        varOptions.setCommandParamater("--ambig-filter-bases");
        jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Threshold fraction of ambiguous bases [AmbiguousBaseReadFilter]");
        varOptions.setHelpMsg("Threshold fraction of ambiguous bases [AmbiguousBaseReadFilter parameter]. This argument cannot be used at the same time as ambig-filter-bases. Default 0.05");
        varOptions.setVariableGroup(GATK_COMMON_OPTIONAL);
        varOptions.setCommandParamater("--ambig-filter-frac");
        jobDesc.addVariable(varOptions);
    }

    public static VariableDescriptor createOptionReadValidationStringency() {
        SelectionListVariableDescriptor optionalVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Validation stringency for all SAM/BAM/CRAM/SRA files");
        optionalVar.setHelpMsg("Validation stringency for all SAM/BAM/CRAM/SRA files read by this program. The default stringency value SILENT can improve performance when processing a BAM file in which variable-length data (read, qualities, tags) do not otherwise need to be decoded.");
        optionalVar.addOptionValue("STRICT");
        optionalVar.addOptionValue("LENIENT");
        optionalVar.addOptionValue("SILENT");
        optionalVar.setCommandParamater(GATK_OPTION_SWITCH_READ_VALIDATION_STRINGENCY);
        optionalVar.setCommandParamaterAlt("--read-validation-stringency");
        optionalVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionalVar;
    }

    public static VariableDescriptor createOptionAnnotation() {
        MultiSelectionListVariableDescriptor optionalVar = VariableDescriptor.MultiSelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("One or more specific annotations to add to variant calls");
        optionalVar.setHelpMsg("Which annotations to include in variant calls in the output. These supplement annotations provided by annotation groups");
        List lines = WorkflowJob.loadJobResource((String)"gatk", (String)"annotationList", (ClassLoader)GATKHelper.class.getClassLoader());
        for (String line : lines) {
            String[] tokens = line.split("\t");
            if (tokens.length >= 3) {
                optionalVar.addOptionValue(tokens[0], tokens[1], tokens[2]);
                continue;
            }
            optionalVar.addOptionValue(line.trim());
        }
        optionalVar.setCommandParamater(GATK_OPTION_SWITCH_ANNOTATION);
        optionalVar.setCommandParamaterAlt("--annotation");
        optionalVar.setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        optionalVar.setVariableGroup(GATK_COMMON_OPTIONAL);
        return optionalVar;
    }

    static interface CreateOptionCallBack {
        public VariableDescriptor createOption();

        public void addRules(WorkflowJob var1);
    }

    static abstract class NoRulesCreateOptionCallBack
    implements CreateOptionCallBack {
        NoRulesCreateOptionCallBack() {
        }

        @Override
        public void addRules(WorkflowJob job) {
        }
    }
}

