/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing.fastxtools;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;

public class FastxtoolkitFastxStatisticsJob
extends WorkflowJob {
    private static final String TITLE = "FASTXTOOLKIT: FASTX Statistics";
    private static final String HELP = "FASTX Statistics: Generate statistics from FASTA/FASTQ files. If FASTA file is given, only nucleotide distribution is calculated (there's no quality info)";
    private static final String LINK = "Online docs: <a href=\"http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastq_statistics_usage\">http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastq_statistics_usage</a>";
    public static final String JOB_ID = "FASTX_Stats";
    public static final String JOB_NAME = "FASTXTOOLKIT: FASTX Statistics";
    private static final String INPUT_FASTA_FILE = "INPUT_FASTA_FILE";

    public FastxtoolkitFastxStatisticsJob() {
        this.jobName = "FASTXTOOLKIT: FASTX Statistics";
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc(HELP);
        this.jobDesc.setRef(LINK);
        VariableDescriptor varFasta = VariableDescriptor.createDescriptorFor((String)INPUT_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFasta.isRequired = true;
        varFasta.setVariableName("FASTA/FASTQ");
        this.jobDesc.addVariable(varFasta);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
    }

    public void generateCommand(StringBuilder command) {
        String progName = String.valueOf(Constants.PIPELINE_FASXTOOLKIT_FASTX_STATISTICS_EXE) + " -Q33 ";
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "inptFileBaseName=$(basename $_File | cut -d. -f1);\ninptFileExt=`rev <<< \"$_File\" | cut -d. -f1 | rev`;\n" + progName + " -i $_File  -o \"$inptFileBaseName\"\"_stats.txt\" " + this.getOptionParamaters();
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTA_FILE).$("@"), (String)forBody));
    }
}

