/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing.fastxtools;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;

public class FastxtoolkitFastqQualityFilterJob
extends WorkflowJob {
    private static final String TITLE = "FASTXTOOLKIT: FASTQ Quality Filter";
    private static final String HELP = "FASTQ Quality Filter: Filter FASTQ files";
    private static final String LINK = "Online docs: <a href=\"http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastq_quality_filter_usage\">http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastq_quality_filter_usage</a>";
    public static final String JOB_ID = "FASTX_Quality_Filter";
    public static final String JOB_NAME = "FASTXTOOLKIT: FASTQ Quality Filter";
    private static final String INPUT_FASTA_FILE = "INPUT_FASTA_FILE";

    public FastxtoolkitFastqQualityFilterJob() {
        this.jobName = "FASTXTOOLKIT: FASTQ Quality Filter";
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc(HELP);
        this.jobDesc.setRef(LINK);
        VariableDescriptor varFasta = VariableDescriptor.createDescriptorFor((String)INPUT_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFasta.isRequired = true;
        varFasta.setVariableName("FASTQ");
        this.jobDesc.addVariable(varFasta);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Minimum quality score");
        varOption.setCommandParamater("-q");
        varOption.setHelpMsg("Minimum quality score to keep");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Minimum percent of bases that must have the Minimum quality score");
        varOption.setCommandParamater("-p");
        varOption.setHelpMsg("Minimum percent of bases that must have [-q] quality");
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
    }

    public void generateCommand(StringBuilder command) {
        String progName = String.valueOf(Constants.PIPELINE_FASXTOOLKIT_FASTQ_QUALITY_FILTER_EXE) + " -Q33 ";
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "inptFileBaseName=$(basename $_File | cut -d. -f1);\ninptFileExt=`rev <<< \"$_File\" | cut -d. -f1 | rev`;\n" + progName + " -i $_File  -o $inptFileBaseName.$inptFileExt " + this.getOptionParamaters();
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTA_FILE).$("@"), (String)forBody));
    }
}

