/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing;

import com.biotechvana.shared.jobs.PreprocessingFilters;
import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.JobLink;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.ListJobVariable;

public class PreProcessingPRINSEQJob
extends WorkflowJob {
    public static final String JOB_ID = "PRINSEQ";
    public static final String JOB_NAME = "PRINSEQ";
    public static final String INPUT_FILES = "INPUT_FILES";
    public static final String INPUT_OUTPUT_FOTMAT = "INPUT_OUTPUT_FOTMAT";
    public static final String OUTPUT_GOOD_FILES = "OUTPUT_FILES";
    public static final String OUTPUT_BAD_FILES = "OUTPUT_BAD_FILES";
    public static final String OPTION_PR_FILTER = "OPTION_PR_FILTER";

    public PreProcessingPRINSEQJob() {
        this.jobName = "PRINSEQ";
        this.jobDesc = new JobDescriptor("PRINSEQ");
        this.jobDesc.setDesc("PRINSEQ is a tool that generates summary statistics of sequence and quality data and that is used to filter, reformat and trim next-generation sequence data. It is particular designed for 454/Roche data, but can also be used for other types of sequence data.");
        this.jobDesc.setDesc("PRINSEQ can be used to filter, reformat, or trim your genomic and metagenomic sequence data.");
        this.jobDesc.addPublication(new Publication().setAuthors("Schmieder, R. and Edwards, R.").setTitle("Quality control and preprocessing of metagenomic datasets").setJournal("Bioinformatics").setVolume(27).setIssue(6).setYear(2011).setPages("863-864").setDOI("10.1093/bioinformatics/btr026").setPubmed("21278185"));
        this.jobDesc.addLink(new JobLink().setTitle("PRINSEQ").setUrl("http://prinseq.sourceforge.net/manual.html").setType(JobLink.LinkType.Manual));
        this.jobDesc.setVersion("0.20.4");
        VariableDescriptor varInputFiles = VariableDescriptor.createDescriptorFor((String)INPUT_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInputFiles.isRequired = true;
        varInputFiles.setVariableName("Input Files");
        varInputFiles.addAcceptedFileFormat("FASTQ", false, true, "FASTQ1", "FASTQ2");
        varInputFiles.addAcceptedFileFormat("FASTA", false, true);
        varInputFiles.addAcceptedFileFormat("FASTA and QUAL", true, "FASTA", "QUAL");
        this.jobDesc.addVariable(varInputFiles);
        SelectionListVariableDescriptor varOutputFormat = VariableDescriptor.SelectionList((String)INPUT_OUTPUT_FOTMAT, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOutputFormat.setVariableName("Output Format");
        varOutputFormat.addOptionValue("FASTA", "1", "FASTA only");
        varOutputFormat.addOptionValue("FASTA and QUAL", "2", "FASTA and QUAL");
        varOutputFormat.addOptionValue("FASTQ", "3", "FASTQ");
        varOutputFormat.addOptionValue("FASTA and FASTQ", "4", "FASTQ and FASTA");
        varOutputFormat.addOptionValue("FASTA, QUAL and FASTQ", "5", "FASTQ, FASTA and QUAL");
        varOutputFormat.setHelpMsg("Output format. Default same as input");
        varOutputFormat.setCommandParamater("-out_format");
        this.jobDesc.addVariable((VariableDescriptor)varOutputFormat);
        String filterGroup = "Filter options";
        String trimGroup = "Trim options";
        String reformatGroup = "Reformat options";
        String summaryGroup = "Summary statistic options";
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Min length");
        varOption.setCommandParamater("-min_len");
        varOption.setHelpMsg("Filter sequence shorter than Min length");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Max length");
        varOption.setCommandParamater("-max_len");
        varOption.setHelpMsg("Filter sequence longer than Max length");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Length Range");
        varOption.setCommandParamater("-range_len");
        varOption.setHelpMsg("Filter sequence by length range. Multiple range values should be separated by comma without spaces. Examples: 50-100,250-300");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Min GC content");
        varOption.setCommandParamater("-min_gc");
        varOption.setHelpMsg("Filter sequence with GC content below min_gc");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Max GC content");
        varOption.setCommandParamater("-max_gc");
        varOption.setHelpMsg("Filter sequence with GC content above max_gc");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Range GC content");
        varOption.setCommandParamater("-range_gc");
        varOption.setHelpMsg("Filter sequence by GC content range.  Multiple range values should be separated by comma without spaces");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Min quality score");
        varOption.setCommandParamater("-min_qual_score");
        varOption.setHelpMsg("Filter sequence with at least one quality score below min_qual_score");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Max quality score");
        varOption.setCommandParamater("-max_qual_score");
        varOption.setHelpMsg("Filter sequence with at least one quality score above max_qual_score");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Min quality score mean");
        varOption.setCommandParamater("-min_qual_mean");
        varOption.setHelpMsg("Filter sequence with quality score mean below min_qual_mean");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Max quality score mean");
        varOption.setCommandParamater("-max_qual_mean");
        varOption.setHelpMsg("Filter sequence with quality score mean above max_qual_mean");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Max Ns percentage");
        varOption.setCommandParamater("-ns_max_p");
        varOption.setHelpMsg("Filter sequence with more than ns_max_p percentage of Ns");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Max Ns count");
        varOption.setCommandParamater("-ns_max_n");
        varOption.setHelpMsg("Filter sequence with more than ns_max_n Ns");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Number of sequences to keep");
        varOption.setCommandParamater("-seq_num");
        varOption.setHelpMsg("Only keep the first seq_num number of sequences (that pass all other filters)");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Filter duplicates");
        varOption.setCommandParamater("-derep");
        varOption.setHelpMsg("Filter duplicates. Type of duplicates to filter. Example: 124 to use type 1, 2 and 4. The order does not matter. Option 2 and 3 will set 1 and option 5 will set 4 as these are subsets of the other option. 1 (exact duplicate), 2 (5 duplicate), 3 (3 duplicae), 4 (reverse complement exact duplicate), 5 (reverse complement 5`/3` duplicate)");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("-derep_min");
        varOption.setCommandParamater("-derep_min");
        varOption.setHelpMsg("This option specifies the number of allowed duplicates. If you want to remove sequence duplicates that occur more than x times, then you would specify x+1 as the -derep_min values. For examples, to remove sequences that occur more than 5 times, you would specify -derep_min 6. This option can only be used in combination with -derep 1 and/or 4 (forward and/or reverse exact duplicates). Default is 2");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        SelectionListVariableDescriptor varOptionSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionSelectionList.setVariableName("Method to filter low complexity sequences");
        varOptionSelectionList.setCommandParamater("-lc_method");
        varOptionSelectionList.addOptionValue("dust");
        varOptionSelectionList.addOptionValue("entropy");
        varOptionSelectionList.setHelpMsg("Method to filter low complexity sequences \"dust\",\"entropy\"");
        varOptionSelectionList.setVariableGroup(filterGroup);
        this.jobDesc.addVariable((VariableDescriptor)varOptionSelectionList);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Threshold value used to filter sequences by sequence complexity");
        varOption.setCommandParamater("-lc_threshold");
        varOption.setHelpMsg("The threshold value used to filter sequences by sequence complexity. The dust method uses this as maximum allowed score and the entropy method as minimum allowed value. Integer [0..100]");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Custom params");
        varOption.setCommandParamater("-custom_params");
        varOption.setHelpMsg("Can be used to specify additional filters. The current set of possible rules is limited and has to follow the specifications below. The custom parameters have to be specified within quotes (either ` or \"). Please separate parameter values with a space and separate new parameter sets with semicolon (;). Parameters are defined by two values: (1) the pattern (any combination of the letters \"ACGTN\"), (2) the number of repeats or percentage of occurence Percentage values are defined by a number followed by the %-sign (without space). If no %-sign is given, it is assumed that the given number specifies the number of repeats of the pattern.Examples: \"AAT 10\" (filters out sequences containing AATAATAATAATAATAATAATAATAATAAT anywhere in the sequence), \"T 70%\" (filters out sequences with more than 70% Ts in the sequence), \"A 15\" (filters out sequences containing AAAAAAAAAAAAAAA anywhere in the sequence), \"AAT 10;T 70%;A 15\" (apply all three filters)");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Filter sequence with characters other than A, C, G, T or N");
        varOption.setCommandParamater("-noniupac");
        varOption.setHelpMsg("Filter sequence with characters other than A, C, G, T or N");
        varOption.setVariableGroup(filterGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim to length");
        varOption.setCommandParamater("-trim_to_len");
        varOption.setHelpMsg("Trim all sequence from the 3`-end to result in sequence with this length");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim sequence at the 5`-end by trim_left positions");
        varOption.setCommandParamater("-trim_left");
        varOption.setHelpMsg("Trim sequence at the 5`-end by trim_left positions");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim sequence at the 3`-end by trim_right positions");
        varOption.setCommandParamater("-trim_right");
        varOption.setHelpMsg("Trim sequence at the 3`-end by trim_right positions");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim sequence at the 5`-end by percentage");
        varOption.setCommandParamater("-trim_left_p");
        varOption.setHelpMsg("Trim sequence at the 5`-end by trim_left_p percentage of read length. The trim length is rounded towards the lower integer (e.g. 143.6 is rounded to 143 positions). Use an integer between 1 and 100 for the percentage value.");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim sequence at the 3`-end by percentage");
        varOption.setCommandParamater("-trim_right_p");
        varOption.setHelpMsg("Trim sequence at the 3`-end by trim_right_p percentage of read length. The trim length is rounded towards the lower integer (e.g. 143.6 is rounded to 143 positions). Use an integer between 1 and 100 for the percentage value.");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim poly-A/T tail with a minimum length at the 5`-end");
        varOption.setCommandParamater("-trim_tail_left");
        varOption.setHelpMsg("Trim poly-A/T tail with a minimum length of trim_tail_left at the 5`-end");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim poly-A/T tail with a minimum length at the 3`-end");
        varOption.setCommandParamater("-trim_tail_right");
        varOption.setHelpMsg("Trim poly-A/T tail with a minimum length of trim_tail_right at the 3`-end");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim poly-N tail with a minimum length at the 5`-end");
        varOption.setCommandParamater("-trim_ns_left");
        varOption.setHelpMsg("Trim poly-N tail with a minimum length of trim_ns_left at the 5`-end");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim poly-N tail with a minimum length at the 3`-end");
        varOption.setCommandParamater("-trim_ns_right");
        varOption.setHelpMsg("Trim poly-N tail with a minimum length of trim_ns_right at the 3`-end");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim sequence by quality score from the 5`-end with this threshold score");
        varOption.setCommandParamater("-trim_qual_left");
        varOption.setHelpMsg("Trim sequence by quality score from the 5`-end with this threshold score");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim sequence by quality score from the 3`-end with this threshold score");
        varOption.setCommandParamater("-trim_qual_right");
        varOption.setHelpMsg("Trim sequence by quality score from the 3`-end with this threshold score");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOptionSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionSelectionList.setVariableName("Type of quality score calculation");
        varOptionSelectionList.setCommandParamater("-trim_qual_type");
        varOptionSelectionList.addOptionValue("min");
        varOptionSelectionList.addOptionValue("mean");
        varOptionSelectionList.addOptionValue("max");
        varOptionSelectionList.addOptionValue("sum");
        varOptionSelectionList.setHelpMsg("Type of quality score calculation to use (default min): \"min\", \"mean\", \"max\", \"sum\"");
        varOptionSelectionList.setVariableGroup(trimGroup);
        this.jobDesc.addVariable((VariableDescriptor)varOptionSelectionList);
        varOptionSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionSelectionList.setVariableName("Rule to use to compare quality score");
        varOptionSelectionList.setCommandParamater("-trim_qual_rule");
        varOptionSelectionList.addOptionValue("lt");
        varOptionSelectionList.addOptionValue("gt");
        varOptionSelectionList.addOptionValue("et");
        varOptionSelectionList.setHelpMsg("Rule to use to compare quality score to calculated value (default lt): \"lt\", \"gt\", \"et\"");
        varOptionSelectionList.setVariableGroup(trimGroup);
        this.jobDesc.addVariable((VariableDescriptor)varOptionSelectionList);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Sliding window size used to calculate quality score");
        varOption.setCommandParamater("-trim_qual_window");
        varOption.setHelpMsg("The sliding window size used to calculate quality score by type. To stop at the first base that fails the rule defined, use a window size of 1");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Step size used to move the sliding window");
        varOption.setCommandParamater("-trim_qual_step");
        varOption.setHelpMsg("Step size used to move the sliding window. To move the window over all quality scores without missing any, the step size should be less or equal to the window size");
        varOption.setVariableGroup(trimGroup);
        this.jobDesc.addVariable(varOption);
        varOptionSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionSelectionList.setVariableName("Changes sequence character case");
        varOptionSelectionList.setCommandParamater("-seq_case");
        varOptionSelectionList.addOptionValue("upper");
        varOptionSelectionList.addOptionValue("lower");
        varOptionSelectionList.setHelpMsg("Changes sequence character case to \"upper\" or \"lower\" case");
        varOptionSelectionList.setVariableGroup(reformatGroup);
        this.jobDesc.addVariable((VariableDescriptor)varOptionSelectionList);
        varOptionSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionSelectionList.setVariableName("Convert sequence between DNA and RNA");
        varOptionSelectionList.setCommandParamater("-dna_rna");
        varOptionSelectionList.addOptionValue("dna");
        varOptionSelectionList.addOptionValue("rna");
        varOptionSelectionList.setHelpMsg("Convert sequence between DNA and RNA: \"dna\", \"rna\"");
        varOptionSelectionList.setVariableGroup(reformatGroup);
        this.jobDesc.addVariable((VariableDescriptor)varOptionSelectionList);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Sequence characters per line");
        varOption.setCommandParamater("-line_width");
        varOption.setHelpMsg("Sequence characters per line. This option only applies to FASTA output files");
        varOption.setVariableGroup(reformatGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Rename the sequence identifier");
        varOption.setCommandParamater("-seq_id");
        varOption.setHelpMsg("Rename the sequence identifier. A counter is added to each identifier to assure its uniqueness");
        varOption.setVariableGroup(reformatGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Outputs basic information");
        varOption.setCommandParamater("-stats_info");
        varOption.setHelpMsg("Outputs basic information such as number of reads (reads) and total bases (bases)");
        varOption.setVariableGroup(summaryGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Outputs statistics for read length");
        varOption.setCommandParamater("-stats_len");
        varOption.setHelpMsg("Outputs minimum (min), maximum (max), range (range), mean (mean), standard deviation (stddev), mode (mode) and mode value (modeval), and median (median) for read length");
        varOption.setVariableGroup(summaryGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Outputs the dinucleotide odds ratio");
        varOption.setCommandParamater("-stats_dinuc");
        varOption.setHelpMsg("Outputs the dinucleotide odds ratio for AA/TT (aatt), AC/GT (acgt), AG/CT (agct), AT (at), CA/TG (catg), CC/GG (ccgg), CG (cg), GA/TC (gatc), GC (gc) and TA (ta)");
        varOption.setVariableGroup(summaryGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Outputs the probability of a tag sequence");
        varOption.setCommandParamater("-stats_tag");
        varOption.setHelpMsg("Outputs the probability of a tag sequence at the 5`- end (prob5) and 3`-end (prob3) in percentage. Provides the number of predefined MIDs (midnum) and the MID sequences (midseq, separated by comma, only provided if midnum > 0) that occur in more than 34/100 (approx. 3%) of the reads");
        varOption.setVariableGroup(summaryGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Outputs the number of exact duplicates");
        varOption.setCommandParamater("-stats_dupl");
        varOption.setHelpMsg("Outputs the number of exact duplicates (exact), 5` duplicates (5), 3` duplicates (3), exact duplicates with reverse complements (exactrevcom) and 5`/3` duplicates with reverse complements (revcomp), and total number of duplicates (total). The maximum number of duplicates is given under the value namewith an additional \"maxd\" (e.g. exactmaxd or 5maxd)");
        varOption.setVariableGroup(summaryGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Outputs Info of reads with ambiguous base N");
        varOption.setCommandParamater("-stats_ns");
        varOption.setHelpMsg("Outputs the number of reads with ambiguous base N (seqswithn), the maximum number of Ns per read (maxn) and the maximum percentage of Ns per read (maxp). The maxn and maxp value are not necessary from the same sequence");
        varOption.setVariableGroup(summaryGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Outputs all available summary statistics");
        varOption.setCommandParamater("-stats_all");
        varOption.setHelpMsg("Outputs all available summary statistics");
        varOption.setVariableGroup(summaryGroup);
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)OPTION_PR_FILTER, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Good sequences percet after filtering");
        varOption.setHelpMsg("Min Good sequences percet of the total sequences input before preprocessing  to consider the preprocessing as succesfull. Has no effect on the bahavoiur of prinseq. Used only for managment pipeline and tracking. Default 80");
        this.jobDesc.addVariable(varOption);
        VariableDescriptor varOutputFiles = VariableDescriptor.createDescriptorFor((String)OUTPUT_GOOD_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varOutputFiles.setVariableName("Output Files");
        varOutputFiles.isRequired = true;
        varOutputFiles.addAcceptedFileFormat("FASTQ", true, true, "FASTQ1", "FASTQ2");
        varOutputFiles.addAcceptedFileFormat("FASTA", false, false);
        varOutputFiles.addAcceptedFileFormat("FASTA and QUAL", true, "FASTA", "QUAL");
        this.jobDesc.addVariable(varOutputFiles);
        VariableDescriptor varOutputFolder = PreProcessingPRINSEQJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(varOutputFolder);
        PreprocessingFilters.addPrepresoccesingFilter(this.jobDesc, varOutputFiles);
        PreprocessingFilters.addPrepresoccesingPRFilter(this.jobDesc, varOutputFiles, varOption);
        this.initJobFromDesc(this.jobDesc);
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        return valid &= this.customValidateOutputFormat();
    }

    boolean customValidateOutputFormat() {
        String value;
        block6: {
            String inputFormat;
            block5: {
                value = this.getValue(INPUT_OUTPUT_FOTMAT);
                inputFormat = ((FileVariable)this.getVariable(INPUT_FILES)).getFileFormat();
                if (!value.isEmpty()) break block5;
                return true;
            }
            if (!inputFormat.equals("FASTA") || value.equals("FASTA")) break block6;
            this.getVariable(INPUT_OUTPUT_FOTMAT).setExternalErrMsg("Only Fasta output format can be used with Fasta input files.");
            return false;
        }
        try {
            if (((FileVariable)this.getVariable(INPUT_FILES)).getIsPairedFiles() && !((FileVariable)this.getVariable(INPUT_FILES)).getFileFormat().equals("FASTA and QUAL") && (value.equals("FASTA and QUAL") || value.equals("FASTA and FASTQ") || value.equals("FASTA, QUAL and FASTQ"))) {
                this.getVariable(INPUT_OUTPUT_FOTMAT).setExternalErrMsg("Can not use this format with pair end mode.");
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected void generateCommand(StringBuilder command) {
        String parsedOptions = this.getOptionParamatersStrAs$();
        String fileFormat = ((FileVariable)this.getVariable(INPUT_FILES)).getFormatAsBashVarName();
        command.append("cmdPart1=\"" + Constants.PIPELINE_PRINSEQ_PATH + " " + parsedOptions + " \"\n");
        command.append("outputFolder=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
        command.append(" [ -d \"${outputFolder}/summary\" ] || mkdir \"${outputFolder}/summary\" \n");
        command.append("# to cause fail of pipe - tee \n");
        command.append("set -o pipefail \n");
        command.append("formatExt=\"fastq\"\n");
        command.append(BashHelper.IF((String)("[ \"" + fileFormat + "\" = \"" + "FASTQ" + "\" ]"), (String)"selector1=\"-fastq\"\nselector2=\"-fastq2\"\n"));
        command.append(BashHelper.IF((String)("[ \"" + fileFormat + "\" = \"" + "FASTA" + "\" ]"), (String)"selector1=\"-fasta\"\nselector2=\"-fasta2\"\nformatExt=\"fasta\"\n"));
        command.append(BashHelper.IF((String)("[ \"" + fileFormat + "\" = \"" + "FASTA and QUAL" + "\" ]"), (String)"selector1=\"-fasta\"\nselector2=\"-qual\"\nformatExt=\"fasta\"\n"));
        ListJobVariable inputOutputFormat = (ListJobVariable)this.getVariable(INPUT_OUTPUT_FOTMAT);
        command.append(BashHelper.IF((String)("[ \"" + this.getVariable(INPUT_OUTPUT_FOTMAT).$() + "\" = \"" + inputOutputFormat.getpValueCmdParamValue("FASTQ") + "\" ]"), (String)"formatExt=\"fastq\"\n"));
        command.append(BashHelper.IF((String)("[ \"" + this.getVariable(INPUT_OUTPUT_FOTMAT).$() + "\" = \"" + inputOutputFormat.getpValueCmdParamValue("FASTA") + "\" ]"), (String)"formatExt=\"fasta\"\n"));
        command.append(BashHelper.IF((String)("[ \"" + this.getVariable(INPUT_OUTPUT_FOTMAT).$() + "\" = \"" + inputOutputFormat.getpValueCmdParamValue("FASTA and QUAL") + "\" ]"), (String)"formatExt=\"fasta\"\n"));
        command.append(BashHelper.IF((String)("[ \"" + this.getVariable(INPUT_OUTPUT_FOTMAT).$() + "\" = \"" + inputOutputFormat.getpValueCmdParamValue("FASTA and FASTQ") + "\" ]"), (String)"formatExt=\"fastq\"\n"));
        command.append(BashHelper.IF((String)("[ \"" + this.getVariable(INPUT_OUTPUT_FOTMAT).$() + "\" = \"" + inputOutputFormat.getpValueCmdParamValue("FASTA, QUAL and FASTQ") + "\" ]"), (String)"formatExt=\"fastq\"\n"));
        command.append(BashHelper.BatcherParallelSingleton((FileListVariable)((FileListVariable)this.getVariable(INPUT_FILES)), (String)"cmdPart2=\" -out_good ${outputFolder}/${inputFile1BaseName} -out_bad ${outputFolder}/${inputFile1BaseName}_bad \"\n", (String)"$cmdPart1 $cmdPart2 ${selector1} ${_inputFile1} |& tee \"${outputFolder}/summary/${inputFile1BaseName}_summary.txt\"  \n", (String)("summaryFileName=\"${inputFile1BaseName}_${inputFile2BaseName}_summary.txt\"\n[ \"" + fileFormat + "\" = \"" + "FASTA and QUAL" + "\" ] && summaryFileName=\"${inputFile1BaseName}_summary.txt\" \n" + "$cmdPart1 $cmdPart2 ${selector1} ${_inputFile1} ${selector2} ${_inputFile2} |& tee \"${outputFolder}/summary/${summaryFileName}\"")));
        command.append("set +o pipefail \n");
        String prinseq_fastq_fasta = BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable(INPUT_FILES)), (String)"", (String)"", (String)"", (String)(String.valueOf(this.getVariable(OUTPUT_GOOD_FILES).getBashVarName("0,$_i")) + "=\"${outputFolder}/${inputFile1BaseName}.${formatExt}\" \n" + BashHelper.IF((String)("[ \"" + fileFormat + "\" != \"" + "FASTA and QUAL" + "\" ]"), (String)BashHelper.IF((String)"[ -n ${_inputFile2} ]", (String)(String.valueOf(BashHelper.moveWithWarning((String)"${outputFolder}/${inputFile1BaseName}_1_singletons.${formatExt}", (String)"${outputFolder}/${inputFile1BaseName}_singletons.${formatExt}")) + BashHelper.moveWithWarning((String)"${outputFolder}/${inputFile1BaseName}_1.${formatExt}", (String)"${outputFolder}/${inputFile1BaseName}.${formatExt}") + BashHelper.moveWithWarning((String)"${outputFolder}/${inputFile1BaseName}_1_bad.${formatExt}", (String)"${outputFolder}/${inputFile1BaseName}_bad.${formatExt}") + BashHelper.moveWithWarning((String)"${outputFolder}/${inputFile1BaseName}_2_singletons.${formatExt}", (String)"${outputFolder}/${inputFile2BaseName}_singletons.${formatExt}") + BashHelper.moveWithWarning((String)"${outputFolder}/${inputFile1BaseName}_2.${formatExt}", (String)"${outputFolder}/${inputFile2BaseName}.${formatExt}") + BashHelper.moveWithWarning((String)"${outputFolder}/${inputFile1BaseName}_2_bad.${formatExt}", (String)"${outputFolder}/${inputFile2BaseName}_bad.${formatExt}") + this.getVariable(OUTPUT_GOOD_FILES).getBashVarName("1,$_i") + "=\"${outputFolder}/${inputFile2BaseName}.${formatExt}\" \n")))), (boolean)true);
        command.append(prinseq_fastq_fasta);
    }

    protected String getFilterCheckCommand() {
        String checkLevel = Tracking.TrackCheckLevels.Fail.toString();
        if (this.getParent() == null) {
            checkLevel = Tracking.TrackCheckLevels.Warning.toString();
        }
        String filterName = "PR";
        String statusVar = "_g_filter_status";
        String cmdCheck = "";
        cmdCheck = String.valueOf(cmdCheck) + "dARate=\"" + this.getVariable(OPTION_PR_FILTER).$() + "\"\n";
        cmdCheck = String.valueOf(cmdCheck) + "[ -n \"${dARate}\" ] ||  dARate=\"80\" \n";
        cmdCheck = String.valueOf(cmdCheck) + BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable(INPUT_FILES)), (String)"", (String)("wRes=$(grep  \"Bad sequences\" \"${outputFolder}/summary/${inputFile1BaseName}_summary.txt\")\nwRes=${wRes// /}\nwRes=${wRes%\\%*}\nwRes=${wRes#*(}\n[ -n \"${wRes}\" ] || wRes=\"100\"\nwRes=$(echo \"100-\"$wRes | bc -l)\ncom=$(echo $wRes\">=\"$dARate | bc -l)\n" + BashHelper.IF((String)"[ com -eq 0 ]", (String)("echo \"Total good reads=$wRes% should be more that the defined threshold $dARate% : Fail.\"\n" + Tracking.trackLogCheck((String)"${_inputFile1}", (String)filterName, (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (String)checkLevel, (String)"Fail") + BashHelper.assign((String)statusVar, (String)checkLevel)), (String)("echo \"Total good reads=$wRes% are more that the defined threshold $dARate% : OK.\"\n" + Tracking.trackLogCheck((String)"${_inputFile1}", (String)filterName, (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (Tracking.TrackCheckLevels)Tracking.TrackCheckLevels.Pass, (String)"Pass")))), (String)("summaryFileName=\"${outputFolder}/summary/${inputFile1BaseName}_${inputFile2BaseName}_summary.txt\"\n[ \"" + ((FileVariable)this.getVariable(INPUT_FILES)).getFormatAsBashVarName() + "\" = \"" + "FASTA and QUAL" + "\" ] && summaryFileName=\"${outputFolder}/summary/${inputFile1BaseName}_summary.txt\" && wRes=$(grep  \"Bad sequences\" \"${summaryFileName}\") ||" + "wRes=$(grep  \"Bad sequences.*1)\" \"${summaryFileName}\")\n" + "wRes=${wRes// /}\n" + "wRes=${wRes//(f/}\n" + "wRes=${wRes%\\%*}\n" + "wRes=${wRes#*(}\n" + "[ -n \"${wRes}\" ] || wRes=\"100\"\n" + "echo \"${wRes[@]}\"\n" + "wRes=$(echo \"100-\"$wRes | bc -l)\n" + "com=$(echo $wRes\">=\"$dARate | bc -l)\n" + BashHelper.IF((String)"[ com -eq 0 ]", (String)("echo \"Total good reads=$wRes% should be more that the defined threshold $dARate% : Fail.\"\n" + Tracking.trackLogCheck((String)"${_inputFile1}", (String)filterName, (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (String)checkLevel, (String)"Fail") + BashHelper.assign((String)statusVar, (String)checkLevel)), (String)("echo \"Total good reads=$wRes% are more that the defined threshold $dARate% : OK.\"\n" + Tracking.trackLogCheck((String)"${_inputFile1}", (String)filterName, (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (Tracking.TrackCheckLevels)Tracking.TrackCheckLevels.Pass, (String)"Pass"))) + "[ \"" + ((FileVariable)this.getVariable(INPUT_FILES)).getFormatAsBashVarName() + "\" = \"" + "FASTA and QUAL" + "\" ]  && continue \n" + "wRes=$(grep  \"Bad sequences.*2)\" \"${summaryFileName}\")\n" + "wRes=${wRes// /}\n" + "wRes=${wRes//(f/}\n" + "wRes=${wRes%\\%*}\n" + "wRes=${wRes#*(}\n" + "[ -n \"${wRes}\" ] || wRes=\"100\"\n" + "wRes=$(echo \"100-\"$wRes | bc -l)\n" + "com=$(echo $wRes\">=\"$dARate | bc -l)\n" + BashHelper.IF((String)"[ com -eq 0 ]", (String)("echo \"Total good reads=$wRes% should be more that the defined threshold $dARate% : Fail.\"\n" + Tracking.trackLogCheck((String)"${_inputFile2}", (String)filterName, (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (String)checkLevel, (String)"Fail") + BashHelper.assign((String)statusVar, (String)checkLevel)), (String)("echo \"Total good reads=$wRes% are more that the defined threshold $dARate% : OK.\"\n" + Tracking.trackLogCheck((String)"${_inputFile2}", (String)filterName, (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (Tracking.TrackCheckLevels)Tracking.TrackCheckLevels.Pass, (String)"Pass")))), (String)"");
        cmdCheck = String.valueOf(cmdCheck) + BashHelper.IF((String)("${" + statusVar + "} = true"), (String)(String.valueOf(Tracking.trackLog((Tracking.TrackEventType)Tracking.TrackEventType.Failed, (String)this.getJobID(), (String)"Job Filter Fail .... terminate execution.")) + "exit -1"));
        return cmdCheck;
    }

    protected void generateCommandWrapUp(StringBuilder builder) {
        builder.append(((FileVariable)this.getVariable(OUTPUT_GOOD_FILES)).getFileFormatAsBashVar(this.getVariable(INPUT_FILES)));
    }
}

