/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.IntVariableDescriptor;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class PreProcessingFastqCollapserJob
extends WorkflowJob {
    public static final String JOB_ID = "FastqCollapser";
    public static final String JOB_NAME = "FastqCollapser";
    private static final String INPUT_FASTQ_FILE = "INPUT_FILES";
    private static final String JAVA_MAX_HEAP_SIZE = "JAVA_MAX_HEAP_SIZE";

    public PreProcessingFastqCollapserJob() {
        this.jobName = "FastqCollapser";
        this.jobDesc = new JobDescriptor("FastqCollapser");
        this.jobDesc.setDesc("FastqCollapser is a biotechvana script to remove duplicate reads from fastq files (Based on sequences' content)");
        VariableDescriptor varFastaQ = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFastaQ.isRequired = true;
        varFastaQ.setVariableName("FASTQ");
        varFastaQ.addAcceptedFileFormat("FASTQ", false, true);
        this.jobDesc.addVariable(varFastaQ);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)JAVA_MAX_HEAP_SIZE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Maximum Java Heap Size - GB");
        varOption.setHelpMsg("Maximum Memory allocated to Java Virtual Machine of unit GB, default value is 4GB");
        varOption.setCommandParamater("-Xmx");
        varOption.setVariableGroup("Java");
        varOption.setSubProgName("Java");
        varOption.setDefaultValue("4");
        ((IntVariableDescriptor)varOption).setMaxValue(128.0);
        ((IntVariableDescriptor)varOption).setMinValue(1.0);
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        VariableDescriptor varOutputFiles = VariableDescriptor.createDescriptorFor((String)"OUTPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varOutputFiles.setVariableName("Output Files");
        varOutputFiles.addAcceptedFileFormat("FASTQ", true, false);
        this.jobDesc.addVariable(varOutputFiles);
        this.initJobFromDesc(this.jobDesc);
    }

    protected void generateCommand(StringBuilder command) {
        command.append(BashHelper.If((String)BashConditions.emptyStr((JobVariable)this.getVariable(JAVA_MAX_HEAP_SIZE))).Then(BashHelper.assign((JobVariable)this.getVariable(JAVA_MAX_HEAP_SIZE), (String)"4")));
        String maxHeapSize = this.getVariable(JAVA_MAX_HEAP_SIZE).$();
        String progName = "java  -Xmx" + maxHeapSize + "g -jar " + Constants.PIPELINE_BASE_PATH + "FastqCollapser.jar ";
        StringBuilder bodyBuilder = new StringBuilder();
        bodyBuilder.append("_inputFiles=\" -i1 " + this.getVariable(INPUT_FASTQ_FILE).$("0,$_i") + "  \"\n");
        bodyBuilder.append("inptFileExt=`rev <<< \"" + this.getVariable(INPUT_FASTQ_FILE).$("0,$_i") + "\" | cut -d. -f1 | rev`;\n");
        bodyBuilder.append("_inputFileName=$(basename " + this.getVariable(INPUT_FASTQ_FILE).$("0,$_i") + " );\n");
        bodyBuilder.append(String.valueOf(this.getVariable("OUTPUT_FILES").getBashVarName("0,$_i")) + "=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "/${_inputFileName} \"\n");
        bodyBuilder.append(BashHelper.IF((String)("-n \"" + this.getVariable(INPUT_FASTQ_FILE).$("1,$_i") + "\""), (String)("_inputFiles=\"${_inputFiles} -i2 " + this.getVariable(INPUT_FASTQ_FILE).$("1,$_i") + "\"\n" + "_inputFileName=$(basename " + this.getVariable(INPUT_FASTQ_FILE).$("1,$_i") + " );\n" + this.getVariable("OUTPUT_FILES").getBashVarName("1,$_i") + "=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "/${_inputFileName} \"\n")));
        bodyBuilder.append(String.valueOf(progName) + " -o " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "  ${_inputFiles} \n");
        command.append(BashHelper.forIndex((String)"_i", (String)((FileVariable)this.getVariable(INPUT_FASTQ_FILE)).getCountAsBashVarName(), (String)"_i++", (String)bodyBuilder.toString()));
        bodyBuilder = new StringBuilder();
        bodyBuilder.append("_inptFileExt=`rev <<< \"" + this.getVariable(INPUT_FASTQ_FILE).$("0,$_i") + "\" | cut -d. -f1 | rev`;\n");
        bodyBuilder.append("_inputFileBaseName=$(basename " + this.getVariable(INPUT_FASTQ_FILE).$("0,$_i") + " | cut -d. -f1);\n");
        bodyBuilder.append("mv " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "/${_inputFileBaseName}_collapsed.${_inptFileExt}  " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "/${_inputFileBaseName}.${_inptFileExt} \n");
        bodyBuilder.append(BashHelper.IF((String)("-n \"" + this.getVariable(INPUT_FASTQ_FILE).$("1,$_i") + "\""), (String)("_inptFileExt=`rev <<< \"" + this.getVariable(INPUT_FASTQ_FILE).$("1,$_i") + "\" | cut -d. -f1 | rev`;\n" + "_inputFileBaseName=$(basename " + this.getVariable(INPUT_FASTQ_FILE).$("1,$_i") + " | cut -d. -f1);\n" + "mv " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "/${_inputFileBaseName}_collapsed.${_inptFileExt}  " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "/${_inputFileBaseName}.${_inptFileExt} \n")));
        command.append(BashHelper.forIndex((String)"_i", (String)((FileVariable)this.getVariable(INPUT_FASTQ_FILE)).getCountAsBashVarName(), (String)"_i++", (String)bodyBuilder.toString()));
    }

    protected void generateCommandWrapUp(StringBuilder command) {
        ((FileVariable)this.getVariable("OUTPUT_FILES")).setFileFormat("FASTQ");
        command.append(((FileVariable)this.getVariable("OUTPUT_FILES")).getFileFormatAsBashVar(this.getVariable(INPUT_FASTQ_FILE)));
    }
}

